<?php
  require_once 'browser_common.php';

  // load session
  $dispparam = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks    = $_SESSION['browser']['tracks'][$s][$r];

  $tracknum  = $_GET['tracknum'];
  $track     = $tracks[$tracknum];
  $trackname = $track['name'];
  $optparam  = $track['optparam'];
  $optattr   = $track['optattr'];

  assert( is_numeric($tracknum) );
  assert( isset($track) );
  assert( $optattr );

  // map pair of ubound/lbound to 'ulbound' operation
  for( $i=0 ; $i<count($optattr) ; $i++ ) {
    if( $optattr[$i]['type'] == 'real' ) {
      if( in_array( 'ubound', $optattr[$i]['operation'] ) && in_array( 'lbound', $optattr[$i]['operation'] ) ) {
        $ubpos = array_search( 'ubound', $optattr[$i]['operation'] );
        array_splice( $optattr[$i]['operation'], $ubpos, 1, array('ulbound') );
        $lbpos = array_search( 'lbound', $optattr[$i]['operation'] );
        array_splice( $optattr[$i]['operation'], $lbpos, 1 );
      }
    }
  }

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Script-Type" content="text/javascript">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>Config - [<?php print $trackname; ?>]</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<?php

	if ( isset($_POST['apply-optattr'])) {
    print "<SCRIPT type=\"text/javascript\"> reloadParentWindow(); </SCRIPT>";
	}
?>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>
<CENTER>
<FORM action="JavaScript: void(0);" name="track_info">
<?php
	if ( !empty($_SESSION['login']) ) {
		$user_id   = $_SESSION['login']['user_id'];
	}
	
	$msg = "";
	$sql = "";
	$res = "";	
	$hDB_trackinformation = pg_connect($trackinformation_connection_string);
	
	if ( isset($hDB_trackinformation) ) {
		if ( isset($user_id) ) {
			exc_sql_1($hDB_trackinformation,$res,$trackname,$s,$r,$user_id);
			if ( pg_num_rows($res) == 1 ) {
				$val = get_val( $res );
			}
			else if ( pg_num_rows($res) == 0 ) {
				exec_sql_2($hDB_trackinformation,$res,$trackname,$s,$r);
				if ( pg_num_rows($res) == 1 ) {
					$val = get_val( $res );
				}
				else {
					$f_disable_modify = 1;
					$row_num = pg_num_rows( $res );
					$msg = $row_num."record exists in trackinformation table. Must be just 1 record exists.";
				}
			}
			else {
				$f_disable_modify = 1;
				$row_num = pg_num_rows( $res );
				$msg = $row_num."record exists in trackinformation table. Must be just 1 record exists.";
			}
		}
		else {
			exec_sql_2($hDB_trackinformation,$res,$trackname,$s,$r);
			if ( pg_num_rows($res) == 1 ) {
				$val = get_val( $res );
			}
			else {
				$f_disable_modify = 1;
				$row_num = pg_num_rows( $res );
//				$msg = $row_num."record exists in trackinformation table. Must be just 1 record exists.";
			}
		}
	}

	function exc_sql_1 ( &$hDB, &$res,$trackname,$s,$r,$user_id ) {
		$trackname = pg_escape_string($trackname);
		$sql = "SELECT * 
				FROM TRACK 
				WHERE NAME='$trackname' AND SPECIES='$s' AND REVISION='$r' AND UID=$user_id";
		$res = pg_query( $hDB, $sql);
	}

	function exec_sql_2 ( &$hDB, &$res, $trackname, $s, $r ) {
		$trackname = pg_escape_string($trackname);
		$sql = "SELECT * 
				FROM TRACK 
				WHERE NAME='$trackname' AND SPECIES='$s' AND REVISION='$r' AND EXHIBIT='public'";
		$res = pg_query( $hDB, $sql);
	}

	function get_val( &$res ) {
		$val['description_url']  = pg_fetch_result( $res, 0, 'description_url');
		$val['comment']          = pg_fetch_result( $res, 0, 'comment');
		$val['color_r']          = pg_fetch_result( $res, 0, 'color_r');
		$val['color_g']          = pg_fetch_result( $res, 0, 'color_g');
		$val['color_b']          = pg_fetch_result( $res, 0, 'color_b');
		$val['species_url']      = pg_fetch_result( $res, 0, 'species_url');
		return $val;
	}
?>

<TABLE border="0">
<TR><TH colspan="2">Config - [<?php print $trackname ; ?>]
<INPUT type="submit" value="Close" onClick="JavaScript: window.close();"></TH>

<?php


if ( $disable_modify[$trackname] ) {
}
else {
	print "<TR><TH>Name</TH><TD><INPUT TYPE=text NAME=\"track_name\" VALUE=\"$trackname\" SIZE=75 readonly></TD></TR>";
	print "<TR><TH>Comment</TH><TD><INPUT TYPE=text NAME=\"comment\" VALUE=\"".$val['comment']."\" SIZE=75 readonly></TD></TR>";
	print "<TR><TH>URL</TH><TD><INPUT TYPE=text NAME=\"description_url\" VALUE=\"".$val['description_url']."\" SIZE=75 readonly></TD></TR>";
	print "<TR><TH>Color</TH><TD>";
	$color_str = "(".$val['color_r'].",".$val['color_g'].",".$val['color_b'].")";
	print_color_selecter("",$color_str,"","disabled");
	print "</TD></TR>";
	print "<TR><TH>Species URL</TH><TD><INPUT TYPE=text NAME=\"species_url\" VALUE=\"".$val['species_url']."\" SIZE=75 readonly></TD></TR>";
	print "<TR><TD class=\"noclor\"></TD>";
	if ( !isset($f_disable_modify) ) {
    $htmlSID = htmlspecialchars(SID);
	  print "<TD align='right' class=\"noclor\"><INPUT type=\"button\" name=\"$tracknum-modify\" value=\"Modify\" onClick=\"JavaScript: openUserAuthWindow('".$htmlSID."','$tracknum','','edit_track');\"></TD>";
	}
	else {
		print "<TD align='center' class=\"nocolr\">".show_error_message($msg)."</TD>";
	}
	print "<?TR>";
}
?>
</FORM>
<FORM action="JavaScript: void(0);" name="tracks">

<TR>
<?php
  $labelid = 0;
  $color_opers = array();
  foreach( $optattr as $oa ) {
    $tp = $oa['type'];
    foreach( $oa['operation'] as $op ) {
      $nm  = urlencode( urlencode( $oa['name'] ) );
      print "<TR><TH>".$oa['name']." $op setting</TH><TD width=\"$width\">";
      if( $tp == 'select' && $op == 'disp' ) {
        foreach( $oa['candidates'] as $ca ) {
          $c = urlencode( urlencode($ca) );
          if( $optparam["disp-$nm-$c"] == 'off' ) {
            print "<INPUT type=\"checkbox\" name=\"disp-$nm-$c\" id=\"$labelid\"> <LABEL for=\"$labelid\">$ca</LABEL> ";
          }
          else {
            print "<INPUT type=\"checkbox\" name=\"disp-$nm-$c\" id=\"$labelid\" checked> <LABEL for=\"$labelid\">$ca</LABEL> ";
          }
          $labelid++;
        }
      }
      elseif( $tp == 'select' && $op == 'color' ) {
        foreach( $oa['candidates'] as $ca ) {
          $c = urlencode( urlencode($ca) );
          print "<LABEL for=\"$labelid\">$ca:</LABEL> ";
          print_color_selecter( "color-$nm-$c", $optparam["color-$nm-$c"], $labelid );
          $labelid++;
          print " ";
        }
        $co = $oa['name'].'-'.$op;
        if( $optparam['usecolor'] == $co ) {
          print "<INPUT type=\"radio\" name=\"usecolor\" value=\"$co\" id=\"$labelid\" checked> <LABEL for=\"$labelid\">use this color</LABEL> ";
        }
        else {
          print "<INPUT type=\"radio\" name=\"usecolor\" value=\"$co\" id=\"$labelid\"> <LABEL for=\"$labelid\">use this color</LABEL> ";
        }
        $labelid++;
      }
      elseif( $tp == 'real' && $op == 'gradation' ) {
        $min = $oa['range'][0];
        $max = $oa['range'][1];
        print "<LABEL for=\"$labelid\">min[$min] color:</LABEL> ";
        print_color_selecter( "gradation-$nm-min", $optparam["gradation-$nm-min"], $label );
        $labelid++;
        print " <LABEL for=\"$labelid\">max[$max] color:</LABEL> ";
        print_color_selecter( "gradation-$nm-max", $optparam["gradation-$nm-max"], $labelid );
        $labelid++;
        print " ";
        $co = $oa['name'].'-'.$op;
        if( $optparam['usecolor'] == $co ) {
          print "<INPUT type=\"radio\" name=\"usecolor\" value=\"$co\" id=\"$labelid\" checked> <LABEL for=\"$labelid\">use this color</LABEL> ";
        }
        else {
          print "<INPUT type=\"radio\" name=\"usecolor\" value=\"$co\" id=\"$labelid\"> <LABEL for=\"$labelid\">use this color</LABEL> ";
        }
        $labelid++;
      }
      elseif( $tp == 'real' && $op == 'ubound' ) {
        $bound = $optparam["ubound-$nm"];
        print $oa['name'] . ' must be: ' . $oa['name'] . ' <= ';
        print "<INPUT type=\"text\" size=\"10\" name=\"ubound-$nm\" value=\"$bound\"> ";
      }
      elseif( $tp == 'real' && $op == 'lbound' ) {
        $bound = $optparam["lbound-$nm"];
        print $oa['name'] . ' must be: ';
        print "<INPUT type=\"text\" size=\"10\" name=\"lbound-$nm\" value=\"$bound\"> ";
        print ' <= ' . $oa['name'];
      }
      elseif( $tp == 'real' && $op == 'ulbound' ) {
        $ubound = $optparam["ubound-$nm"];
        $lbound = $optparam["lbound-$nm"];
        print $oa['name'] . ' must be: ';
        print "<INPUT type=\"text\" size=\"10\" name=\"lbound-$nm\" value=\"$lbound\"> ";
        print ' <= ' . $oa['name'] . ' <= ';
        print "<INPUT type=\"text\" size=\"10\" name=\"ubound-$nm\" value=\"$ubound\"> ";
      }
      elseif( $tp == 'select' && $op == 'select' ) {
        foreach( $oa['candidates'] as $ca ) {
          $c = urlencode( urlencode($ca) );
          if( $optparam["select-$nm"] == $ca ) {
            print "<INPUT type=\"radio\" name=\"select-$nm\" value=\"$c\" id=\"$labelid\" checked> <LABEL for=\"$labelid\">$ca</LABEL> ";
          }
          else {
            print "<INPUT type=\"radio\" name=\"select-$nm\" value=\"$c\" id=\"$labelid\"> <LABEL for=\"$labelid\">$ca</LABEL> ";
          }
          $labelid++;
        }
      }
      $htmlSID = htmlspecialchars(SID);
      print "<INPUT type=\"submit\" name=\"apply-optattr\" value=\"Apply\" onClick=\"JavaScript: applyOptAttrConfig('".$htmlSID."','$tracknum',tracks);\">";
      print "</TD></TR>";
    }
  }
?>
</TABLE>
</FORM>
</BODY>
</HTML>
