<?php
	////////////////////////////////////////////////////////////////////////
	//  PROJECT : UTGB Genome Browser
	//	FILE    : browser_manage_edit_track.php
	//	written by t.shishiki 2005.3.8
	////////////////////////////////////////////////////////////////////////

  require_once 'browser_common.php';
  require_once 'browser_manage_common.php';

  // load session
  $dispparam = $_SESSION['browser']['dispparam'];
  $s = $dispparam['species'];
  $r = $dispparam['revision'];
  $tracks    = $_SESSION['browser']['tracks'][$s][$r];

  $tracknum  = $_GET['tracknum'];
  $track     = $tracks[$tracknum];
  $trackname = pg_escape_string($track['name']);
  $optparam  = $track['optparam'];
  $optattr   = $track['optattr'];
  $reedit    = 0;

  if ( isset($_SESSION['login']) ) {
    $user_name = $_SESSION['login']['user_name'];
    $user_id   = $_SESSION['login']['user_id'];
  }
	$hDB_trackinformation = pg_connect($trackinformation_connection_string);

	//////////////////////////////////////////////////////////////////////////
	// 		apply
	//////////////////////////////////////////////////////////////////////////
	if (isset( $_POST['apply']) ) {

		$post_tid                     = $_POST['tid'];
		$post_track_kind              = $_POST['track_kind'];
		$post_track_description_url   = $_POST['track_description_url'];
		$post_track_comment           = $_POST['track_comment'];
		$post_track_color             = $_POST['track_color'];
		$post_track_species_url       = $_POST['track_species_url'];
		$post_track_data_location     = $_POST['track_data_location'];
		$post_edit_comment           = $_POST['edit_comment'];

		$post_track_description_url   = htmlspecialchars($post_track_description_url);
		$post_track_comment           = htmlspecialchars($post_track_comment);
		$post_track_species_url       = htmlspecialchars($post_track_species_url);
		$post_track_data_location     = htmlspecialchars($post_track_data_location);
		$post_track_description_url   = pg_escape_string($post_track_description_url);
		$post_track_comment           = pg_escape_string($post_track_comment);
		$post_track_species_url       = pg_escape_string($post_track_species_url);
		$post_edit_comment            = pg_escape_string($post_edit_comment);

		if ( preg_match( '/^\((\d+)\,(\d+)\,(\d+)\)$/', $post_track_color, $match ) ) {
			$post_track_color_r = $match[1];
			$post_track_color_g = $match[2];
			$post_track_color_b = $match[3];
		}
		else {
			$post_track_color = "";
		}
		if ( isset($hDB_trackinformation) ) {
			if ( !is_null($_POST['reedit']) ) { //update
				pg_query( $hDB_trackinformation,"BEGIN" );
				$sql_1 = "UPDATE TRACK SET 
						DESCRIPTION_URL='$post_track_description_url',
						COMMENT='$post_track_comment',";
				if ( $post_track_color_r != ""  && $post_track_color_g != "" && $post_track_color_b != "") {
					$sql_1 = $sql_1."COLOR_R=$post_track_color_r,
									COLOR_G=$post_track_color_g,
									COLOR_B=$post_track_color_b,";
				}
					$sql_1 = $sql_1."SPECIES_URL='$post_track_species_url' 
									WHERE TID=$post_tid";

				$res_1 = pg_query($hDB_trackinformation, $sql_1);

				if ( pg_result_status($res_1) == PGSQL_COMMAND_OK ) {
					$sql_2 = "SELECT * FROM TRACK WHERE SPECIES='$s' AND REVISION='$r' AND NAME='$trackname' AND UID=$user_id";
					$res_2 = pg_query( $hDB_trackinformation,$sql_2 );
					if ( pg_num_rows( $res_2 ) == 1 ) {
						$tid = pg_fetch_result($res_2, 0, 'tid');
						add_history( $tid, $user_id,"modify",$post_edit_comment );
					}
					$msg = "Updated.";
					$reedit = 0;
				}
				else {
					$msg = "Cannot update...";
					pg_query( $hDB_trackinformation,"ROLLBACK" );
				}
				pg_query( $hDB_trackinformation,"COMMIT" );
			}
			else { // insert
				pg_query( $hDB_trackinformation,'BEGIN' );
				if ( isset($post_track_color_r) && isset($post_track_color_r) && isset($post_track_color_r) ) {
					$sql_3 ="INSERT INTO TRACK 
					(SPECIES,REVISION,NAME,KIND,EXHIBIT,UID,DATA_LOCATION,DESCRIPTION_URL,COMMENT,COLOR_R,COLOR_G,COLOR_B,SPECIES_URL) 
					VALUES 
					('$s','$r','$trackname','$post_track_kind','private',$user_id,'$post_track_data_location','$post_track_description_url','$post_track_comment',$post_track_color_r,$post_track_color_g,$post_track_color_b,'$post_track_species_url')";
				}
				else {
					$sql_3 ="INSERT INTO TRACK 
					(SPECIES,REVISION,NAME,KIND,EXHIBIT,UID,DATA_LOCATION,DESCRIPTION_URL,COMMENT,SPECIES_URL) 
					VALUES 
					('$s','$r','$trackname','$post_track_kind','private',$user_id,'$post_track_data_location','$post_track_description_url','$post_track_comment','$post_track_species_url')";
				}
				$res_3 = pg_query($hDB_trackinformation, $sql_3);
				if ( pg_result_status($res_3) == PGSQL_COMMAND_OK ) {
					$sql_4 = "SELECT * FROM TRACK WHERE SPECIES='$s' AND REVISION='$r' AND NAME='$trackname' AND UID=$user_id";

					$res_4 = pg_query( $hDB_trackinformation,$sql_4 );
					if ( pg_num_rows( $res_4 ) == 1 ) {
						$tid = pg_fetch_result($res_4, 0, 'tid');
						add_history( $tid, $user_id, "create",$post_edit_comment );
					}
					$msg = "Inserted.";
					$reedit = 0;
				}
				else {
					$msg = "Cannot Inserted...";
					pg_query( $hDB_trackinformation,'ROLLBACK' );
				}
				pg_query( $hDB_trackinformation,'COMMIT' );
			}
		}
		$msg = "Can not connect trackinformation DB...";

		// update session
		foreach ( $tracks as $j => $track ) {
			if ( $track['name'] == $trackname ) {
				$track['description_url'] = $post_track_description_url;
				$track['comment'] = $post_track_comment;
				$track['color'] = $post_track_color;
				$track['species_url'] = $post_track_species_url;
			}
		}
		$_SESSION['browser']['tracks'][$s][$r] = $tracks;
	}

	///////////////////////////////////////////////////////////////
	//  display
	//////////////////////////////////////////////////////////////
	if ( isset($hDB_trackinformation) ) {
		$msg = "";
		$tid = "";
		$track_kind = "";
		$track_comment = "";
		$track_description_url = "";
		$track_color_r = "";
		$track_color_g = "";
		$track_color_b = "";
		$track_species_url = "";
		$sql_5 = "SELECT * 
				FROM TRACK t,USERS u 
				WHERE t.UID=u.UID AND u.UID=$user_id
				AND t.NAME='$trackname' AND t.SPECIES='$s' AND t.REVISION='$r'";
		$res_5 = pg_query($hDB_trackinformation, $sql_5);
		if ( pg_num_rows($res_5) == 0 ) {			// new edit
			$sql_6 = "SELECT * 
					FROM TRACK 
					WHERE NAME='$trackname' AND SPECIES='$s' AND REVISION='$r' AND EXHIBIT='public'";
			$res_6 = pg_query( $hDB_trackinformation, $sql_6 );
			if ( pg_num_rows($res_6) == 1 ) {
				$tid                   = pg_fetch_result($res_6, 0, 'tid');
				$track_kind            = pg_fetch_result($res_6, 0, 'kind');
				$track_data_location   = pg_fetch_result($res_6, 0, 'data_location');
				$track_description_url = pg_fetch_result($res_6, 0, 'description_url');
				$track_comment         = pg_fetch_result($res_6, 0, 'comment');
				$track_color_r         = pg_fetch_result($res_6, 0, 'color_r');
				$track_color_g         = pg_fetch_result($res_6, 0, 'color_g');
				$track_color_b         = pg_fetch_result($res_6, 0, 'color_b');
				$track_species_url     = pg_fetch_result($res_6, 0, 'species_url');
			}
		}
		else if ( pg_num_rows($res_5) == 1 ) {								// reedit
			$reedit = 1;
			$tid                   = pg_fetch_result($res_5, 0, 'tid');
			$track_kind            = pg_fetch_result($res_5, 0, 'kind');
			$track_data_location   = pg_fetch_result($res_6, 0, 'data_location');
			$track_description_url = pg_fetch_result($res_5, 0, 'description_url');
			$track_comment         = pg_fetch_result($res_5, 0, 'comment');
			$track_color_r         = pg_fetch_result($res_5, 0, 'color_r');
			$track_color_g         = pg_fetch_result($res_5, 0, 'color_g');
			$track_color_b         = pg_fetch_result($res_5, 0, 'color_b');
			$track_species_url     = pg_fetch_result($res_5, 0, 'species_url');	
		}
		else {
			$row_no = pg_num_rows( $res_5 );
			$msg = "$row_no record exists in trackinformation table. Must be just 1 record exists.You can't excute 'Apply'.";
			$f_disable_modify  = 1;
		}
	}
	else {
		$msg = "Can not connect trackinformation DB...";
	}
	
	/////////////////////////////////////////////////////////////////////////////
	//	add_history
	/////////////////////////////////////////////////////////////////////////////
	function add_history ($tid,$uid,$operation,$comment) {
		global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
		$date_now = date("Y-m-d H:i:s");		# 'NOW'
		$sql_7 = "INSERT INTO HISTORY (TID,UID,TIME,OPERATION,COMMENT) VALUES ($tid,$uid,'$date_now','$operation','$comment')";
		$res_7 = pg_query( $hDB_trackinformation, $sql_7 );
		if ( pg_result_status( $res_7 ) != PGSQL_COMMAND_OK ) {
		}
	}
?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Script-Type" content="text/javascript">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>Edit track information</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<?php
	if ( isset($_POST['apply']) ) {
    print "<SCRIPT type=\"text/javascript\"> reloadParentWindow(); </SCRIPT>";
	}
?>
</SCRIPT>
<SCRIPT language="JavaScript">
<!--
	function windowResize () {
		window.resizeTo(620,450); 
	}
-->
</SCRIPT>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY onLoad="JavaScript:windowResize(); ">
<H3>Edit track information</H3>
<CENTER>
<TABLE border="0"><TBODY>
<TR><TH>Track name</TH><TH>Species</TH><TH>Revision</TH></TR>
<TR><TD><?php print $track['name']; ?></TD><TD><?php print $s; ?></TD><TD><?php print $r; ?></TD></TR>
</TBODY></TABLE>
<BR>
<FORM method="post">
<TABLE border="0"><TBODY>
<TR><TH>Parameter</TH><TH>Value</TH></TR>
<TR><TD>Name</TD><TD><INPUT TYPE="text" NAME="track_name" VALUE="<?php print $track['name']; ?>" SIZE="70" readonly></TD></TR>
<TR><TD>Comment</TD><TD><INPUT TYPE="text" NAME="track_comment" VALUE="<?php print $track_comment; ?>" SIZE=70></TD></TR>
<TR><TD>URL</TD><TD><INPUT TYPE="text" NAME="track_description_url" VALUE="<?php print $track_description_url; ?>" SIZE=70></TD></TR>
<TR><TD>Color</TD><TD>
<?php
	$color = "(".$track_color_r.",".$track_color_g.",".$track_color_b.")";
	print_color_selecter("track_color",$color,"track_color"); 
?></TD></TR>
<TR><TD>Species URL</TD><TD><INPUT TYPE="text" NAME="track_species_url" VALUE="<?php print $track_species_url; ?>" SIZE=70></TD></TR>
</TBODY>
</TABLE>
<BR>

<INPUT TYPE="hidden" NAME="tid" VALUE=<?php print $tid ?>>
<INPUT TYPE="hidden" NAME="track_kind" VALUE=<?php print $track_kind ?>>
<INPUT TYPE="hidden" NAME="track_data_location" VALUE="<?php print $track_data_location ?>">
<?php
	if ( $reedit == 1 ) {
		print "<INPUT TYPE='hidden' NAME='reedit' VALUE=1>";
	}
	if ( $tid != "" ) {
		print "Comment <INPUT TYPE='text' NAME='edit_comment' SIZE='50'>";
		print "<INPUT TYPE='submit' NAME='apply' VALUE='Apply'>";
	}
?>
</FORM>
</CENTER>
<?php
	print $msg;
?>
</BODY>
</HTML>
