<?php
  // debug version
#ini_set('html_errors', 1);
#ini_set('display_errors', 'On');

// logout
//if ( $_GET['cmd'] == "logout" ) {
//	exec_logout ();
//}

// Limit 2GB
// s
//ini_set('upload_max_filesize', '2097152');

require_once( 'browser_config.php' );

  ///////////////////////////////////////////////////////////////////////////////
  // [print_track_history]
  ///////////////////////////////////////////////////////////////////////////////
function print_track_history($tid) {

	global $trackinformation_connection_string;
	$tid = pg_escape_string($tid);
	
	print("<CENTER><TABLE border=\"0\"><TBODY><TR><TH>user</TH><TH>time</TH><TH>operation</TH><TH>comment</TD></TR>");

	$hDB = pg_connect($trackinformation_connection_string);
	$sql = "SELECT * FROM history WHERE tid=$tid order by time";
	$res_history = pg_query($hDB, $sql);
	
	if ( pg_num_rows($res_history ) >= 1 ) {

		for ( $history_row = 0; $history_row < pg_num_rows($res_history); $history_row++ ) {
			$history_user_id   = pg_fetch_result($res_history, $history_row, 'uid');
			$history_time      = pg_fetch_result($res_history, $history_row, 'time');
			$history_operation = pg_fetch_result($res_history, $history_row, 'operation');
			$history_comment   = pg_fetch_result($res_history, $history_row, 'comment');
			$history_user = "";
			if ( isset($history_user_id) ) {
				$sql = "SELECT name FROM users WHERE uid=$history_user_id;";
				$res_users = pg_query($hDB, $sql);

				if (pg_result_status($res_users) == PGSQL_TUPLES_OK) {
					$history_user = pg_fetch_result($res_users, 0, 'name');
				}
			}
			print "<TR>";
			print "<TD>$history_user</TD>";
			print "<TD>$history_time</TD>";
			print "<TD>$history_operation</TD>";
			print "<TD>$history_comment</TD>";
			print "</TR>";
		}
	}
		print("</TBODY></TABLE></CENTER>");
}
  ///////////////////////////////////////////////////////////////////////////////
  // [is_easytrack]
  ///////////////////////////////////////////////////////////////////////////////
  function is_easytrack($fileurl)
  {
    $fp_track = fopen($fileurl, "r");

    $track_type = NULL;
    while (!feof($fp_track)) {
      $line = fgets($fp_track);
      # comment line
      if (preg_match("/^#/", $line, $matches) >= 1) {
        continue;
      }
      # Track line
      $track_type = get_tracktype($line);
      break;
    }
    
    fclose($fp_track);
    return $track_type;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [get_tracktype]
  ///////////////////////////////////////////////////////////////////////////////
  function get_tracktype($line)
  {
    if (preg_match("/^geneTrack/i", $line, $matches) >= 1) {
      # EasyGeneTrack
      $track_type = "gene";
    } elseif (preg_match("/^graphTrack/i", $line, $matches) >= 1) {
      # EasyGraphTrack
      $track_type = "graph";
    } elseif (preg_match("/^colorTrack/i", $line, $matches) >= 1) {
      # EasyColorTrack
      $track_type = "color";
    } else {
      # Not EasyTrack
      $track_type = NULL;
    }
    return $track_type;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [get_trackdescription_from_url]
  ///////////////////////////////////////////////////////////////////////////////
  function get_trackdescription_from_url($easytrack_fileurl)
  {
    $fp_track = fopen($easytrack_fileurl, "r");

    $ret = array();
    while (!feof($fp_track)) {
      $line = fgets($fp_track);
      // comment line
      if (preg_match("/^#/", $line, $matches) >= 1) {
        continue;
      }
      // parse track line
      $parse_result = parse_easytrack_trackline($line);
      
      $ret['track_type'] = $parse_result['Track_type'];
      
      $track_name = $parse_result['Track_name'];
      $track_species = $parse_result['Track_species'];
      $track_revision = $parse_result['Track_revision'];
      
      $ret['name'] = $track_name;
      $ret['comment'] = $parse_result['Track_comment'];
      $ret['description_url'] = $parse_result['Track_description_url'];
      $ret['optattr'] = $parse_result['Track_optattr'];
      
      $RENDERER_RELATIVE_PATH = "renderer";
      $renderer_URL = get_urlpath( $RENDERER_RELATIVE_PATH );
      $param = "?fileurl=$easytrack_fileurl";
	  
      $ret['layers'] = array();
      $layer['kind'] = "graphic";
      $layer['url'] = $renderer_URL."/gene_test.php".$param;
      $ret['layers'][$layer['kind']] = $layer;
      $layer['kind'] = "index";
      $layer['url'] = $renderer_URL."/gene_test_index.php".$param;
      $ret['layers'][$layer['kind']] = $layer;
      $layer['kind'] = "operation";
      $layer['url'] = $renderer_URL."/gene_test_op.php".$param;
      $ret['layers'][$layer['kind']] = $layer;
      $layer['kind'] = "indexoperation";
      $layer['url'] = $renderer_URL."/gene_test_index_op.php".$param;
      $ret['layers'][$layer['kind']] = $layer;

      $ret['species'] = array();
      $species =  array();
      $species['name'] = $track_species;
      $species['revisions'] = array();
      $species['revisions'][] = $track_revision;
      $ret['species'][] = $species;
      
      $ret['track_species'] = $track_species;
      $ret['track_revision'] = $track_revision;
      
      break;
    }
    
    fclose($fp_track);
    return $ret;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [get_trackdescription_from_trackid]
  ///////////////////////////////////////////////////////////////////////////////
  function get_trackdescription_from_trackid($tid)
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);

    $sql = "SELECT * FROM TRACK WHERE TID=$tid";
    $res = pg_query( $hDB_trackinformation, $sql);

    $track_species= pg_fetch_result($res, 0, 'species');
    $track_revision = pg_fetch_result($res, 0, 'revision');
    
    $ret = array();
      
    $ret['track_type'] = pg_fetch_result($res, 0, 'kind');
    $ret['name'] = pg_fetch_result($res, 0, 'name');
    $ret['comment'] = pg_fetch_result($res, 0, 'comment');
    $ret['description_url'] = pg_fetch_result($res, 0, 'description_url');
    $ret['optattr'] = pg_fetch_result($res, 0, 'optattr_str');
    
    $RENDERER_RELATIVE_PATH = "renderer";
    $renderer_URL = get_urlpath( $RENDERER_RELATIVE_PATH );
    $param = "?tid=$tid";
  
    $ret['layers'] = array();
    $layer['kind'] = "graphic";
    $layer['url'] = $renderer_URL."/gene_test.php".$param;
    $ret['layers'][$layer['kind']] = $layer;
    $layer['kind'] = "index";
    $layer['url'] = $renderer_URL."/gene_test_index.php".$param;
    $ret['layers'][$layer['kind']] = $layer;
    $layer['kind'] = "operation";
    $layer['url'] = $renderer_URL."/gene_test_op.php".$param;
    $ret['layers'][$layer['kind']] = $layer;
    $layer['kind'] = "indexoperation";
    $layer['url'] = $renderer_URL."/gene_test_index_op.php".$param;
    $ret['layers'][$layer['kind']] = $layer;

    $ret['species'] = array();
    $species =  array();
    $species['name'] = $track_species;
    $species['revisions'] = array();
    $species['revisions'][] = $track_revision;
    $ret['species'][] = $species;
    
    $ret['track_species'] = $track_species;
    $ret['track_revision'] = $track_revision;
    
    return $ret;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [get_urlpath]
  ///////////////////////////////////////////////////////////////////////////////
  function get_urlpath( $relative_path ) 
  {
    global $base_url;
    $htmlpath = $base_url . $relative_path;

    return $htmlpath;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [parse_easytrack_trackline_url]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_easytrack_trackline_url($url)
  {
    $fp_track = fopen($url, "r");
    while (!feof($fp_track)) {
      $line = fgets($fp_track);
      // comment line
      if (preg_match("/^#/", $line, $matches) >= 1) {
        continue;
      }
      // parse track line
      $parse_result = parse_easytrack_trackline($line);
      break;
    }
    fclose($fp_track);
    return $parse_result;
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [parse_easytrack_trackline]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_easytrack_trackline($line)
  {
    $ret = array();
    // Track type
    $ret['Track_type'] = get_tracktype($line);
    // parse track line
    $ret['Track_name']             = parse_with_term($line, "name");
    $ret['Track_species']          = parse_with_term($line, "species");
    $ret['Track_revision']         = parse_with_term($line, "revision");
    $ret['Track_species_url']      = parse_with_term($line, "species_url");
    $ret['Track_description_url']  = parse_with_term($line, "description_url");
    $ret['Track_color']            = parse_with_term($line, "color");
    $ret['Track_date']             = parse_with_term($line, "date");
    $ret['Track_comment']          = parse_with_term($line, "comment");
    $ret['Track_optattr']          = parse_with_term($line, "optattr");
    $ret['Track_max']              = parse_with_term($line, "max"); // only Graph
    $ret['Track_min']              = parse_with_term($line, "min"); // only Graph
    $ret['Track_blend']            = parse_with_term($line, "blend"); // only Graph and Color
    
    return $ret;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [parse_with_term]
  ///////////////////////////////////////////////////////////////////////////////
  function parse_with_term($line, $term)
  {
    $str ="";
    if ((preg_match("/[\s]$term=\"([^\"]+)\"/", $line, $matches)) ||
        (preg_match("/[\s]$term=([^\s]+)/", $line, $matches))) {
      $str = $matches[1];
      $str = trim($str);
      $str = str_replace("'", "\'", $str);
    }
    return $str;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [get_form]
  ///////////////////////////////////////////////////////////////////////////////
  function get_form($str) 
  {
    $str = pg_escape_string(htmlspecialchars($str));
    $str = ereg_replace("\n|\r|\r\n", "<br>", $str);
    return $str;
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [is_registered_trackinformation]
  ///////////////////////////////////////////////////////////////////////////////
  function is_registered_trackinformation($track_name, $species, $revision,$uid )
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);
    $track_name = pg_escape_string($track_name);
    $species = pg_escape_string($species);
    $revision = pg_escape_string($revision);
    $sql = "SELECT * FROM track WHERE name='$track_name' AND species='$species' AND revision='$revision' AND UID=$uid";
    $res_trackinformation = pg_query($hDB_trackinformation, $sql);
    if (pg_num_rows($res_trackinformation) == 1) {
      return TRUE;
    } else {
      return FALSE;
    }
  }
  
  ///////////////////////////////////////////////////////////////////////////////
  // [add_track_trackinformation]
  ///////////////////////////////////////////////////////////////////////////////
  function add_track_trackinformation
	($species, $revision, $name, $kind, $exhibit, $uid, $data_location,
	 $description_url, $comment, $color_r, $color_g, $color_b, $species_url, $optattr_str,$optparam=null)
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);		

    if ( is_null($color_r)) { $color_r = "null"; }
    if ( is_null($color_g)) { $color_g = "null"; }
    if ( is_null($color_b)) { $color_b = "null"; }
	  if ( is_null($uid))     { $uid = "null";     }
	
    $species = pg_escape_string($species);
    $revision = pg_escape_string($revision);
    $name = pg_escape_string($name);
    $kind = pg_escape_string($kind);
    $uid = pg_escape_string($uid);
    $data_location = pg_escape_string($data_location);
    $description_url = pg_escape_string($description_url);
    $comment = pg_escape_string($comment);
    $species_url = pg_escape_string($species_url);
    $optattr_str = pg_escape_string($optattr_str);
    $optparam = pg_escape_string($optparam);
	
    $sql = 
      "INSERT INTO TRACK (SPECIES,REVISION,NAME,KIND,EXHIBIT,UID,DATA_LOCATION,
      description_url, comment, color_r, color_g, color_b, species_url, optattr_str,optparam) 
      VALUES 
      ('$species','$revision','$name','$kind','$exhibit',$uid,'$data_location',
      '$description_url', '$comment', $color_r, $color_g, $color_b, '$species_url', '$optattr_str' ,'$optparam')";

    $res_trackinformation = pg_query($hDB_trackinformation, $sql);
    return pg_result_error($res_trackinformation);
  }

  ///////////////////////////////////////////////////////////////////////////////
  // [add_history_trackinformation] 
  ///////////////////////////////////////////////////////////////////////////////
  function add_history_trackinformation($track_name, $species, $revision, $user_id, $operation, $comment)
  {
    global $trackinformation_connection_string;
    $hDB_trackinformation = pg_connect($trackinformation_connection_string);
    assert($hDB_trackinformation);
    $track_name = pg_escape_string($track_name);
    $species = pg_escape_string($species);
    $revision = pg_escape_string($revision);
    $user_id = pg_escape_string($user_id);
    $operation = pg_escape_string($operation);
    $comment = pg_escape_string($comment);
    $date_now = date("Y-m-d H:i:s"); # 'NOW'

	  if ( $user_id == "" )     {
	    $sql = 
	      "INSERT INTO history (tid, time, operation, comment) VALUES (
	      (SELECT tid FROM track WHERE name='$track_name' AND species='$species' AND revision='$revision' AND uid is null), 
	      '$date_now', '$operation', '$comment')";
		}
		else {
	    $sql = 
	      "INSERT INTO history (tid, uid, time, operation, comment) VALUES (
	      (SELECT tid FROM track WHERE name='$track_name' AND species='$species' AND revision='$revision' AND uid=$user_id), 
	      $user_id, '$date_now', '$operation', '$comment')";
		}
    $res_trackinformation = pg_query($hDB_trackinformation, $sql);
	
    return pg_result_error($res_trackinformation);
  }

/////////////////////////////////////////////////////////////////////////////////
//	[exec_regist_track_from_url]
/////////////////////////////////////////////////////////////////////////////////
function exec_regist_track_from_url($track_url,$tracks,$s,$r,$optparam=null,$admin=null){

	global $trackinformation_connection_string;
	$xmlstr = http_get( $track_url );
	if( !is_null($xmlstr) ) {
		$parsed_track = parse_track_xml( $xmlstr );
	}
	if ( is_easytrack($track_url) ) {
		$f_easytrack = TRUE;
		$parsed_track = get_trackdescription_from_url($track_url);
	}
	else {
		$f_easytrack = FALSE;
	}
	if( is_null($parsed_track) ) {
		$msg = "Failed to parse track URL: $track_url";
		show_error_message($msg);
	}
	else {
		//**************************************
		//	check
		//**************************************
		$f_species_revision = TRUE;
		$f_already_exist = FALSE;
		// revision & species check
		if ( is_null($xmlstr) ) {
			if ($parsed_track['track_species'] != $s || $parsed_track['track_revision'] != $r ) {
				$f_species_revision = FALSE;
				$msg = "Species(".$parsed_track['track_species'].") and Revision(".$parsed_track['track_revision'].") is differnet from curresnt species($s) and revision($r)...";
				show_error_message($msg);
			}
		}
		if ( $admin != 1 ) {
			// already exist check
			foreach( $tracks as $i => $trk ) {
			if ( $trk['name'] == $parsed_track['name'] ) {
					$f_already_exist = TRUE;
					$msg =  "'".$parsed_track['name']."' is already exists. Change the track name '".$parsed_track['name']."'.";
					show_error_message($msg);
					break 1;
				}
			}
		}
		else {
	    // already exist check
			$hDB_trackinformation = pg_connect($trackinformation_connection_string);
			assert($hDB_trackinformation);
			$sql = "SELECT * FROM TRACK WHERE SPECIES='$s' AND REVISION ='$r' AND NAME='".$parsed_track['name']."' AND UID IS NULL";
			$res = pg_query($hDB_trackinformation,$sql);
			if ( pg_num_rows($res) != 0 ) {
				$msg =  "'".$parsed_track['name']."' is already exists. Change the track name '".$parsed_track['name']."'.";
				show_error_message($msg);
				$f_already_exist = TRUE;
			}
		}
	}
	if ( $f_species_revision == TRUE && $f_already_exist == FALSE )  {
		$track = array();
		$track['url']             = $track_url;
		$track['name']            = $parsed_track['name'];
		$track['description_url'] = $parsed_track['description_url'];
		$track['comment']         = $parsed_track['comment'];
		$track['layers']          = $parsed_track['layers'];
		$track['track_species']   = array_key_exists('track_species' , $parsed_track) ? $parsed_track['track_species'] : NULL;
		$track['track_revision']  = array_key_exists('track_revision' , $parsed_track) ? $parsed_track['track_revision'] : NULL;
		$track['kind']            = $parsed_track['track_type'];
		if ($f_easytrack && ($parsed_track['track_type'] == 'gene')) {
			$parsed_track['optattr'] = "style/select[full,pack,small,dense](select)," . $parsed_track['optattr'];
		}
		$track['optattr']         = parse_optattr( $parsed_track['optattr'] );

		if ($f_easytrack && ($parsed_track['track_type'] == 'gene')) {
			$track['optparam']['select-style'] = 'pack';
		}
		// 2005.5.16 shishiski add -----------------------------------------------------
		if ( !empty( $optparam ) ) {
			$optparam_str = "";
			foreach ( $optparam as $key => $val ) {
				if ( $optparam_str == "" ) {
					$optparam_str = $key."=".$val;
				}
				else {
					$optparam_str = $optparam_str.":".$key."=".$val;
				}
			}
		}
		//------------------------------------------------------------------------------
		
		if ( $admin != 1 ) {
			add_track_trackinformation($s,$r,$track['name'],$track['kind'],"private",$_SESSION['login']['user_id'],$track_url,$track['desciption_url'],$track['comment'],$color_r,$color_g,$color_b,"",$track['optattr'],$optparam_str);
			add_history_trackinformation($track['name'],$s,$r,$_SESSION['login']['user_id'],"create","");
			add_trackorder_oder_str($s,$r,$track['name'],$_SESSION['login']['user_id']);
			$track['tid'] = get_tid($s,$r,$track['name'],$_SESSION['login']['user_id']);
			$track['exhibit'] = "private";
		}
		else {
			add_track_trackinformation($s,$r,$track['name'],$track['kind'],"public",$uid,$track_url,$track['desciption_url'],$track['comment'],$color_r,$color_g,$color_b,"",$track['optattr'],$optparam_str);
			add_history_trackinformation($track['name'],$s,$r,$uid,"create","");
			add_trackorder_oder_str($s,$r,$track['name']);
			$track['tid'] = get_tid($s,$r,$track['name']);
			$track['exhibit'] = "public";
		}
		
		$tracks[] = $track;
		$_SESSION['browser']['tracks'][$s][$r] = $tracks;
		
		$msg = "Complete add track [".$track['name']."]";
		show_message($msg);
	}
	else {
		$msg = "Can not add track...";
		show_error_message($msg);
	}
	return $tracks;
}

/////////////////////////////////////////////////////////////////////////////////
//	[exec_regist_track_from_uploadfile]
/////////////////////////////////////////////////////////////////////////////////
function exec_regist_track_from_uploadfile ( $uploadfile, $tracks,$s,$r,$admin=null ) {
  global $trackinformation_connection_string;
  global $utgb_DB_user;

  $parsed_track = NULL;
  $uploadfile_realpath = realpath($uploadfile);

  if (is_easytrack($uploadfile_realpath)) {
    $f_easytrack = TRUE;
    $parsed_track = get_trackdescription_from_url($uploadfile_realpath);
  } 
  else {
    $f_easytrack = FALSE;
  }
  if( is_null($parsed_track) ) {
    $msg =  "Failed to parse EasyTrackFile: $uploadfile_realpath";
	show_error_message($msg);
  }
  $track = array();
  $track['url']             = $uploadfile_realpath;
  $track['name']            = $parsed_track['name'];
  $track['description_url'] = $parsed_track['description_url'];
  $track['comment']         = $parsed_track['comment'];
  $track['layers']          = $parsed_track['layers'];
  $track['track_species']   = array_key_exists('track_species' , $parsed_track) ? $parsed_track['track_species'] : NULL;
  $track['track_revision']  = array_key_exists('track_revision' , $parsed_track) ? $parsed_track['track_revision'] : NULL;
  $track['kind']             = $parsed_track['track_type'];


 //******************************************************
 //	check
 //******************************************************
	$f_species_revision = TRUE;
	$f_already_exist = FALSE;
 
	// revision & species check
	if ( $parsed_track['track_species'] != $s || $parsed_track['track_revision'] != $r ) {
		$f_species_revision = FALSE;
		$msg = "Species(".$parsed_track['track_species'].") and Revision(".$parsed_track['track_revision'].") is differnet from curresnt species($s) and revision($r)...";
		show_error_message($msg);
	}

	if ( $admin != 1 ) {
	  // already exist check
		foreach( $tracks as $i => $trk ) {
			if ( $trk['name'] == $parsed_track['name'] ) {
				$hDB_trackinformation = pg_connect($trackinformation_connection_string);
				assert($hDB_trackinformation);
				$sql = "SELECT * FROM TRACK WHERE SPECIES='$s' AND REVISION='$r' AND NAME='".$parsed_track['name']."' AND UID=".$_SESSION['login']['user_id'];
				$res = pg_query( $hDB_trackinformation,$sql );
				if (pg_num_rows($res) == 1 ) {
					$data_location = pg_fetch_result($res,0,"data_location");
					if ( $data_location != "cache" ) {
						$f_already_exist = TRUE;
						$msg =  "'".$parsed_track['name']."' is already exists. Change the track name '".$parsed_track['name']."'.";
						show_error_message($msg);
						break 1;
					}
					else {
						break 1;
					}
				}
				else {
						break 1;
				}
			}
		}
	}	
	else {
	  // already exist check
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);
		$sql = "SELECT * FROM TRACK WHERE SPECIES='$s' AND REVISION ='$r' AND NAME='".$parsed_track['name']."' AND UID IS NULL";
		$res = pg_query($hDB_trackinformation,$sql);
		if ( pg_num_rows($res) == 1 ) {
			if ( pg_fetch_result($res,0,'data_location') == "cache" ) {		// cache
			}
			else {				// other
				$msg =  "'".$parsed_track['name']."' is already exists. Change the track name '".$parsed_track['name']."'.";
				show_error_message($msg);
				$f_already_exist = TRUE;
			}
		}
	}

	if ( $f_easytrack == TRUE  && $f_same_track == FALSE && $f_species_revision == TRUE && $f_already_exist == FALSE ) {
	if ( $parsed_track['track_type'] == 'gene'  ) {
		$parsed_track['optattr'] = "style/select[full,pack,small,dense](select)," . $parsed_track['optattr'];
	}
    $track['optattr'] = parse_optattr( $parsed_track['optattr'] );
    //$track['optparam']        = $trk['optparams']; // ?
    if ( $parsed_track['track_type'] == 'gene' ) {
      $track['optparam']['select-style'] = 'pack';
    }
    //	Search cache
    switch ($track['kind']) {
     case "gene":
       $DB_NAME = "cachegene_".$track['name']."_".$track['track_species']."_".$track['track_revision'];
       break;
     case "graph":
       $DB_NAME = "cachegraph_".$track['name']."_".$track['track_species']."_".$track['track_revision'];
       break;
     case "color":
       $DB_NAME = "cachecolor_".$track['name']."_".$track['track_species']."_".$track['track_revision'];
       break;
     default:
    }
    $hDB_cache = pg_connect("dbname=$DB_NAME user=$utgb_DB_user");

    if ( empty($hDB_cache)) {
		$exec_upload_easytrack = 1;
    }
    else {
      $hDB_trackinformation = pg_connect($trackinformation_connection_string);
      assert($hDB_trackinformation);
			if ( $admin != 1 ) {
	  		$sql = "SELECT * FROM TRACK WHERE SPECIES='".$track['track_species']."' AND REVISION='".$track['track_revision']."' AND NAME='".$track['name']."' AND UID=".$_SESSION['login']['user_id'];
			}
			else {
	  		$sql = "SELECT * FROM TRACK WHERE SPECIES='".$track['track_species']."' AND REVISION='".$track['track_revision']."' AND NAME='".$track['name']."' AND UID is null";
			}
      $res = pg_query($hDB_trackinformation,$sql);
      if ( pg_num_rows($res) == 1 ) {
		  	$exec_upload_easytrack = 1;
      }
      else if ( pg_num_rows($res) == 0 ){
        $msg =  "'".$DB_NAME."' is already created by other user. Change the track name '".$track['name']."'.";
        show_error_message($msg);
      }
    }
	
	if ( $exec_upload_easytrack ) {
		$ret = exec_upload_easytrack( $track['url'],$admin );
		switch ($ret) {
			case "SUCCESS_INSERT":
				$track['tid'] = get_tid($s,$r,$track['name'],$_SESSION['login']['user_id']);
				$track['exhibit'] = "private";
				$tracks[] = $track;
				$msg =  "Complete upload track [".$track['name']."].";
				show_message($msg);
				break;
			case "SUCCESS_UPDATE";
				$msg =  "Complete upload track [".$track['name']."].";
				show_message($msg);
				break;
			default:
				$msg = "Fail to upload.";
				show_error_message($msg);		  
				break;
		}
	}
	else {
		$msg = "Can not add track...";
		show_error_message($msg);
	}
  }
  else {
		$msg = "Can not add track...";
		show_error_message($msg);
  }

	$_SESSION['browser']['tracks'][$s][$r] = $tracks;
	
  return $tracks;
}

/////////////////////////////////////////////////////////////////////////////////
//	[exec_upload_easytrack]
/////////////////////////////////////////////////////////////////////////////////
function exec_upload_easytrack ( $track_url, $f_already_exist) {

	require_once './cache/browser_CreateCacheDB.php';

  // CacheDB 쐬
  $result_value = CreateCacheDB($track_url);
  
	$res_track_name = $result_value['track_name'];
	$res_species = $result_value['species'];
	$res_revision = $result_value['revision'];
	$res_kind = $result_value['kind'];
	
	switch ($res_kind) 
	{
	  case "gene":
	  {
      // cachegene_ DB
	  }
	  break;
	  
	  case "graph":
	  {
      // oCit@C쐬
      global $utgb_cache_add_track_file;
			global $utgb_cache_binary_dir;
			$pwd_dir = getcwd();
			chdir($utgb_cache_binary_dir);
	    $command = "$utgb_cache_add_track_file $track_url";
	    $result = shell_exec(escapeshellcmd($command));
			chdir($pwd_dir);
	  }
	  break;
	  
	  case "color":
	  {
      // oCit@C쐬
      global $utgb_cache_add_track_file;
			global $utgb_cache_binary_dir;
			$pwd_dir = getcwd();
			chdir($utgb_cache_binary_dir);
	    $command = "$utgb_cache_add_track_file $track_url";
	    $result = shell_exec(escapeshellcmd($command));
			chdir($pwd_dir);
	  }
	  break;

	  default:
	  break;
	}
	
  // VKgbN
  if ($result_value['status'] == "SUCCESS_INSERT" || 
      ($result_value['status'] == "GRAPH_COLOR" && $f_already_exist == FALSE)) {
    // trackinformation ɒǉ
    $ret=add_track_trackinformation(
      $result_value['species'], 
      $result_value['revision'], 
      $result_value['track_name'], 
      $result_value['kind'], 
      "private", 
      $_SESSION['login']['user_id'], 
      "cache",
      $result_value['description_url'], 
      $result_value['comment'], 
      $result_value['color_r'], 
      $result_value['color_g'], 
      $result_value['color_b'], 
      $result_value['species_url'], 
      $result_value['optattr_str']
      );
    // ǉ
    $ret=add_history_trackinformation(
      $result_value['track_name'], 
      $result_value['species'], 
      $result_value['revision'], 
      $_SESSION['login']['user_id'], 
      "create", 
      "");
			// gbN\ɒǉ
			$ret = add_trackorder_oder_str($result_value['species'],$result_value['revision'],$result_value['track_name'],$_SESSION['login']['user_id']);

    // Graph/Color ̃tOύX
    $result_value['status'] = "SUCCESS_INSERT";
	}
  // gbNUpdate
	else if ($result_value['status'] == "SUCCESS_UPDATE" ||
      ($result_value['status'] == "GRAPH_COLOR" && $f_already_exist == TRUE)) {
    $ret=add_history_trackinformation(
      $result_value['track_name'], 
      $result_value['species'], 
      $result_value['revision'], 
      $_SESSION['login']['user_id'], 
      "modify", 
      "");
    // Graph/Color ̃tOύX
    $result_value['status'] = "SUCCESS_UPDATE";
  }
  
	return $result_value['status'];
}

/////////////////////////////////////////////////////////////////////////////////
//	[show_error_message]
/////////////////////////////////////////////////////////////////////////////////
function show_error_message($msg){
	print "<CENTER><FONT color=\"#ff0000\"><B>$msg</B></FONT><BR></CENTER>";
}

/////////////////////////////////////////////////////////////////////////////////
//	[show_message]
/////////////////////////////////////////////////////////////////////////////////
function show_message($msg){
	print "<CENTER><B>$msg</B><BR></CENTER>";
}

/////////////////////////////////////////////////////////////////////////////////
//  [exec_login_logout]
/////////////////////////////////////////////////////////////////////////////////
function exec_login_logout ($auth_mode,$s,$r,$param=null) {
	$htmlSID = htmlspecialchars(SID);
	switch ($auth_mode) {
		case "only_login":
			$_SESSION['login']['user_name'] = $param['user_name'];
			$_SESSION['login']['user_id']   = $param['user_id'];
			break;
		case "only_logout":
			unset( $_SESSION['login'] );
			break;
		case 'edit_track':
			$_SESSION['login']['user_name'] = $param['user_name'];
			$_SESSION['login']['user_id']   = $param['user_id'];
			header("Location: browser_manage_edit_track.php?".$htmlSID."&tracknum=".$param['tracknum']);
			break;
		case 'add_track':
			$_SESSION['login']['user_name'] = $param['user_name'];
			$_SESSION['login']['user_id']   = $param['user_id'];
			header("Location: browser_tracklist.php?".$htmlSID."&trackurl=".$param['val1']);
			break;
		case 'upload_easytrack':
			$_SESSION['login']['user_name'] = $param['user_name'];
			$_SESSION['login']['user_id']   = $param['user_id'];
			header("Location: browser_tracklist.php?".$htmlSID."&uploadfile=".$param['val1']);
			break;
		default:
			break;
	}
	recompose_tracks($s,$r);
	return;
}

/////////////////////////////////////////////////////////////////////////////////
//  [save_optparam_to_trackinformationDB]
/////////////////////////////////////////////////////////////////////////////////
function save_optparam_to_trackinformationDB ( $s,$r,$track, $optparam ) {

	$name = $track['name'];
	$tid  = $track['tid'];
	$kind = $track['kind'];
	
	$optparam_str = "";
	if ( !is_null($optparam) ) {
		foreach ( $optparam as $key => $val ) {
			if ( $key == "track_name" || $key == "description_url" || $key == "species_url" || $key == "comment" ) {
				continue;
			}
			$str = $key."=".$val;
			if ( $optparam_str == "" ) {
				$optparam_str = $str;
			}
			else {
				$optparam_str = $optparam_str.":".$str;
			}
		}
	}

	global $trackinformation_connection_string;
	$hDB_trackinformation = pg_connect($trackinformation_connection_string);
	$sql = "SELECT UID FROM TRACK WHERE TID=$tid";
	$res = pg_query( $hDB_trackinformation , $sql );
	$uid = pg_fetch_result( $res, 0, 'uid');

	if ( is_null($uid)) {
		$sql = "INSERT INTO TRACK 
						(NAME,SPECIES,REVISION,UID,KIND,EXHIBIT,DATA_LOCATION,OPTPARAM) 
						VALUES 
						('$name','$s','$r',".$_SESSION['login']['user_id'].",'$kind','private','".$track['url']."','$optparam_str')";
	}
	else {
		$sql = "UPDATE TRACK SET OPTPARAM='$optparam_str' WHERE TID=$tid";
	}
	pg_query( $hDB_trackinformation,'BEGIN' );
	$res = pg_query( $hDB_trackinformation,$sql );
	if ( pg_result_status($res) == PGSQL_COMMAND_OK ) {
		pg_query( $hDB_trackinformation,'COMMIT' );
	}
	else {
		pg_query( $hDB_trackinformation,'ROLLBACK' );
	}
	return;
}

/////////////////////////////////////////////////////////////////////////////////
//  [parse_optparam_str]
/////////////////////////////////////////////////////////////////////////////////
function parse_optparam_str ( $optparam_str ) {

	$ret_ary = array();
	if ( !is_null($optparam_str) ) {
		$optparam_ary = explode(":",$optparam_str );
		foreach ( $optparam_ary as $i => $str ) {
			$tmp_ary = explode("=",$str );
			$key = $tmp_ary[0];
			$val = $tmp_ary[1];
			$ret_ary[$key] = $val;
		}
	}
	return $ret_ary;
}
//*************************************************************
//	[convertExceptTrackName]
//  trackɁu vu'vĂꍇ́u_vɕϊ
//*************************************************************
 function convertExceptTrackName($track_name) {
 
	$converted_track_name = preg_replace("/ /","@",$track_name);
	$converted_track_name = preg_replace("/'/","_",$converted_track_name);

	return $converted_track_name;
 }

//*************************************************************
//	[unonvertExceptTrackName]
//  convertExceptTrackName̋tϊ
//*************************************************************
 function unconvertExceptTrackName( $converted_track_name ) {
 
	$track_name = preg_replace("/@/"," ",$converted_track_name);
	$track_name = preg_replace("/_/","'",$track_name);

	return $track_name;
 }

//*************************************************************
//  [get_tid]
//*************************************************************
function get_tid ( $s,$r,$trackname,$uid=null) {

	global $trackinformation_connection_string;
	$hDB_trackinformation = pg_connect($trackinformation_connection_string);
	assert($hDB_trackinformation);
	
	if ( is_null($uid) ) {
		$sql =  "SELECT TID FROM TRACK WHERE SPECIES='$s' AND REVISION='$r' AND NAME='$trackname' AND UID IS NULL";
	}
	else {
		$sql =  "SELECT TID FROM TRACK WHERE SPECIES='$s' AND REVISION='$r' AND NAME='$trackname' AND UID=$uid";
	}
	$res = pg_query( $hDB_trackinformation, $sql );
	$tid = pg_fetch_result($res,0,'tid');

	return $tid;
}

  ///////////////////////////////////////////////////////////////////////////////
  // [load_tracks_from_trackinformation]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function load_tracks_from_trackinformation ($s,$r,$uid=null) {
		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);

		//***********************
		//  get public tracks
		//***********************
		$sql_public = "SELECT * FROM TRACK WHERE EXHIBIT='public' AND SPECIES='".$s."' AND REVISION='".$r."'";
		$res_public = pg_query( $hDB_trackinformation, $sql_public );
		$tracks = array();
		for ( $i = 0; $i < pg_num_rows($res_public); $i++ ) {
			$track_public = array();
			$track_public['name']             = pg_fetch_result( $res_public, $i, 'name');
			$track_public['tid']              = pg_fetch_result( $res_public, $i, 'tid');
			$track_public['kind']             = pg_fetch_result( $res_public, $i, 'kind');
			$track_public['exhibit']          = pg_fetch_result( $res_public, $i, 'exhibit');
			$track_public['url']              = pg_fetch_result( $res_public, $i, 'data_location');
			$track_public['description_url']  = pg_fetch_result( $res_public, $i, 'description_url');
			$track_public['comment']          = pg_fetch_result( $res_public, $i, 'comment');
			$track_public['color_r']          = pg_fetch_result( $res_public, $i, 'color_r');
			$track_public['color_g']          = pg_fetch_result( $res_public, $i, 'color_g');
			$track_public['color_b']          = pg_fetch_result( $res_public, $i, 'color_b');
			$track_public['species_url']      = pg_fetch_result( $res_public, $i, 'species_url');
			$track_public['optparam']         = parse_optparam_str(pg_fetch_result( $res_public, $i, 'optparam'));
			$tracks[] = $track_public;
		}
		if ( !is_null($uid) ) {
			//***********************
			//  get private tracks
			//***********************
			$sql_private = "SELECT * FROM TRACK WHERE UID=".$uid." AND EXHIBIT='private' AND SPECIES='".$s."' AND REVISION='".$r."'";
		
			$res_private = pg_query( $hDB_trackinformation, $sql_private );
			for ( $j = 0; $j < pg_num_rows($res_private); $j++ ) {
				$track_private = array();
				$track_private_name  = pg_fetch_result( $res_private, $j, 'name');
				foreach ( $tracks as $i => $track ) {
					if ( $track['name'] == $track_private_name ) {
					array_splice( $tracks, $i, 1 );
					}
				}
				$track_private = array();
				$track_private['name']             = pg_fetch_result( $res_private, $j, 'name');
				$track_private['tid']              = pg_fetch_result( $res_private, $j, 'tid');
				$track_private['kind']             = pg_fetch_result( $res_private, $j, 'kind');
				$track_private['exhibit']          = pg_fetch_result( $res_private, $j, 'exhibit');
				$track_private['url']              = pg_fetch_result( $res_private, $j, 'data_location');
				$track_private['description_url']  = pg_fetch_result( $res_private, $j, 'description_url');
				$track_private['comment']          = pg_fetch_result( $res_private, $j, 'comment');
				$track_private['color_r']          = pg_fetch_result( $res_private, $j, 'color_r');
				$track_private['color_g']          = pg_fetch_result( $res_private, $j, 'color_g');
				$track_private['color_b']          = pg_fetch_result( $res_private, $j, 'color_b');
				$track_private['species_url']      = pg_fetch_result( $res_private, $j, 'species_url');
				$track_private['optparam']         = parse_optparam_str(pg_fetch_result( $res_private, $j, 'optparam'));
				$tracks[] = $track_private;
			}
		}

		//*****************************
		// get trackinfo (layer etc.)
		//*****************************
		$tmp_tracks = array();
		foreach ( $tracks as $i => $track ) {
			$tmp_tracks[] = get_trackinfo_from_url( $track );
		}
		$tracks = $tmp_tracks;
		
		//***************************
		// order and remove tracks
		//***************************
		$TRACKS = order_and_remove_tracks ($tracks,$s,$r,$uid);
		
		return $TRACKS;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [get_trackinfo_from_url]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function get_trackinfo_from_url ( $track ) {
		$ret_track = $track;
		if ( $track['url'] == "cache" ) {		// "cache"̏ꍇ
			$parsed_track = get_trackdescription_from_trackid( $track['tid'] );
			$f_easytrack = TRUE;
		}
		else if ( preg_match("/^http[^ ]+$/",$track['url'],$m) ) {  // "http://"̏ꍇ
			$xmlstr = http_get( $track['url'] );
			if( !is_null($xmlstr) ) {
				$f_easytrack = FALSE;
				$parsed_track = parse_track_xml( $xmlstr );
			}
			if ( is_easytrack( $track['url']) ) {
				$f_easytrack = TRUE;
				$parsed_track = get_trackdescription_from_url( $track['url'] );
			}
		}
		else if ( preg_match("/^\/tracks\/([^ ]+)\/[^ ]+/",$track['url'],$m) ) {  // "tracks"̏ꍇ
			$xml_path = "http://".$_SERVER['HTTP_HOST']."/genome_browser".$track['url'];
			$dir_name = $m[1];
			$xmlstr = http_get( $xml_path );
			if( !is_null($xmlstr) ) {
				$f_easytrack = FALSE;
				$parsed_track = parse_track_xml( $xmlstr );

				// 2005.6.3 packagełɑΉ --------------------------------------
				// graphic
				if ( isset($parsed_track['layers']['graphic']['url']) ) {
					$parsed_track['layers']['graphic']['url'] = "http://".$_SERVER['HTTP_HOST']."/genome_browser/tracks/".$dir_name."/".$parsed_track['layers']['graphic']['url'];
				}
				// index
				if ( isset($parsed_track['layers']['index']['url']) ) {
					$parsed_track['layers']['index']['url'] = "http://".$_SERVER['HTTP_HOST']."/genome_browser/tracks/".$dir_name."/".$parsed_track['layers']['index']['url'];
				}
				// operation
				if ( isset($parsed_track['layers']['operation']['url']) ) {
					$parsed_track['layers']['operation']['url'] = "http://".$_SERVER['HTTP_HOST']."/genome_browser/tracks/".$dir_name."/".$parsed_track['layers']['operation']['url'];
				}
                                // indexoperation
				if ( isset($parsed_track['layers']['indexoperation']['url']) ) {
					$parsed_track['layers']['indexoperation']['url'] = "http://".$_SERVER['HTTP_HOST']."/genome_browser/tracks/".$dir_name."/".$parsed_track['layers']['indexoperation']['url'];
				}
				//----------------------------------------------------------------
			}
			if ( is_easytrack( $track['url']) ) {
				$f_easytrack = TRUE;
				$parsed_track = get_trackdescription_from_url( $track['url'] );
			}
		}
		else {			// ȊO
			$realpath = realpath($track['url']);
			$xmlstr = http_get( $realpath );
			if( !is_null($xmlstr) ) {
				$f_easytrack = FALSE;
				$parsed_track = parse_track_xml( $xmlstr );
			}
			if ( is_easytrack( $realpath) ) {
				$f_easytrack = TRUE;
				$parsed_track = get_trackdescription_from_url( $track['url'] );
			}
		}
		if( is_null($parsed_track) ) {
			$msg = "Failed to parse track URL: ".$track['url'];
			show_error_message($msg);
		}
		else {
			$ret_track['comment']         = $parsed_track['comment'];
			$ret_track['layers']          = $parsed_track['layers'];
			$ret_track['track_species']   = $parsed_track['track_species'];
			$ret_track['track_revision']   = $parsed_track['track_revision'];

			if ( $f_easytrack && ($parsed_track['track_type'] == 'gene' ) ) {
				$parsed_track['optattr'] = "style/select[full,pack,small,dense](select)," . $parsed_track['optattr'];
			}
			$ret_track['optattr']         = parse_optattr( $parsed_track['optattr'] );
			if ( $f_easytrack && ($parsed_track['track_type'] == 'gene') ) {
				$ret_track['optparam']['select-style'] = 'pack';
			}
		}
		return $ret_track;
	}
	
  ///////////////////////////////////////////////////////////////////////////////
  // [order_and_remove_tracks]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function order_and_remove_tracks ($tracks,$s,$r,$uid=null) {
		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);
		$sql_trackorder_public = "SELECT * FROM TRACKORDER WHERE SPECIES='".$s."' AND REVISION='".$r."' AND UID IS NULL";
		$sql_trackorder_private = "SELECT * FROM TRACKORDER WHERE SPECIES='".$s."' AND REVISION='".$r."' AND UID=".$uid;
		//**************
		//    login
		//**************
		if ( isset($uid) ) {
			$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder_private );
			if ( pg_num_rows($res_trackorder) == 1 ) {
				$order_str = pg_fetch_result( $res_trackorder, 0, 'order_str');
				$tmp_tracks = execute_ordering_tracks($tracks,$order_str);
				$remove_str = pg_fetch_result( $res_trackorder, 0, 'remove_str');
				$TRACKS = execute_removing_tracks($tmp_tracks,$remove_str);
			}
			else if ( pg_num_rows($res_trackorder) == 0 ) {
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder_public );
				$order_str = pg_fetch_result( $res_trackorder, 0, 'order_str');
				$tmp_tracks = execute_ordering_tracks($tracks,$order_str);
				$remove_str = pg_fetch_result( $res_trackorder, 0, 'remove_str');
				$TRACKS = execute_removing_tracks($tmp_tracks,$remove_str);
				$sql_insert = "INSERT INTO TRACKORDER (SPECIES,REVISION,UID,ORDER_STR) VALUES ('$s','$r',$uid,'".pg_escape_string($order_str)."')";
				pg_query( $hDB_trackinformation, 'BEGIN' );
				$res_insert = pg_query( $hDB_trackinformation, $sql_insert );
				if ( pg_result_status( $res_insert ) == PGSQL_COMMAND_OK ) {
					pg_query( $hDB_trackinformation, 'COMMIT' );
				}
				else {
					pg_query( $hDB_trackinformation, 'ROLLBACK' );
				}
			}
		}
		//**************
		//    logoff
		//**************
		else {
			$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder_public );
			$order_str = pg_fetch_result( $res_trackorder, 0, 'order_str');
			$tmp_tracks = execute_ordering_tracks($tracks,$order_str);
			$remove_str = pg_fetch_result( $res_trackorder, 0, 'remove_str');
			$TRACKS = execute_removing_tracks($tmp_tracks,$remove_str);
		}
		return $TRACKS;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [execute_ordering_tracks]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function execute_ordering_tracks($tracks,$order_str) {
		$track_name_ary = explode(":", $order_str);
		$ret_tracks = array();
		
		// order_strɕבւ
		foreach ( $track_name_ary as $i => $track_name ) {
			foreach ( $tracks as $j => $track ) {
				if ( $track_name == $track['name'] ) {
					$ret_tracks[] = $track;
					break 1;
				}
			}
		}
		// order_strɂȂgbNtracks̍Ōɒǉ
		foreach ( $tracks as $k => $track ) {
			$f_exist = FALSE;
			foreach ( $track_name_ary as $i => $track_name ) {
				if ( $track_name == $track['name'] ) {
					$f_exist = TRUE;
				}
			}
			if ( $f_exist == FALSE ) {
				$ret_tracks[] = $track;
			}
		}
		return $ret_tracks;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [execute_removing_track]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function execute_removing_tracks($tracks,$remove_str) {
		$track_removedtrack_name_ary = explode(":",$remove_str);
		$ret_tracks = array();
		foreach ( $tracks as $i => $track ) {
			$f_remove = FALSE;
			foreach ( $track_removedtrack_name_ary as $j => $removedtrack_name ) {
				if ( $removedtrack_name == $track['name'] ) {
					$f_remove = TRUE;
				}
			}
			if ( $f_remove == FALSE ) {
				$ret_tracks[] = $track;
			}
			else {
				$ret_removedtracks[] = $track;
			}
		}
		$TRACKS['tracks']        = $ret_tracks;
		$TRACKS['removedtracks'] = $ret_removedtracks;
		return $TRACKS;
 }
	
  ///////////////////////////////////////////////////////////////////////////////
  // [save_tracks_order]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function save_tracks_order($tracks,$s,$r,$uid=null){
		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);
		if ( !is_null($uid) ) {
			$track_name_ary = array();
			foreach ( $tracks as $i => $track ) {
				$track_name_ary[] = $track['name'];
			}
			$order_str = implode(":", $track_name_ary);
			$sql = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($order_str)."' WHERE SPECIES='$s' AND REVISION='$r' AND UID=$uid";
			pg_query( $hDB_trackinformation, 'BEGIN' );
			$res = pg_query( $hDB_trackinformation, $sql );
			if ( pg_result_status( $res ) == PGSQL_COMMAND_OK ) {
				pg_query( $hDB_trackinformation, 'COMMIT' );
			}
			else {
				pg_query( $hDB_trackinformation, 'ROLLBACK' );
			}
		}
	}
	
  ///////////////////////////////////////////////////////////////////////////////
  // [save_tracks_remove]
	// 2005.5.16 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function save_tracks_remove($removedtracks,$s,$r,$uid=null){

		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);

		if ( !is_null($uid) ) {
			$track_name_ary = array();
			foreach ( $removedtracks as $i => $removedtrack ) {
				$track_name_ary[] = $removedtrack['name'];
			}
			$remove_str = implode(":", $track_name_ary);
			$sql = "UPDATE TRACKORDER SET REMOVE_STR='".pg_escape_string($remove_str)."' WHERE SPECIES='$s' AND REVISION='$r' AND UID=$uid";
			pg_query( $hDB_trackinformation, 'BEGIN' );
			$res = pg_query( $hDB_trackinformation, $sql );
			if ( pg_result_status( $res ) == PGSQL_COMMAND_OK ) {
				pg_query( $hDB_trackinformation, 'COMMIT' );
			}
			else {
				pg_query( $hDB_trackinformation, 'ROLLBACK' );
			}
		}
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [add_trackorder_oder_str]
	// 2005.5.18 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function add_trackorder_oder_str ( $s,$r,$trackname,$uid=null ) {
		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);
		$s = pg_escape_string($s);
		$r = pg_escape_string($r);
		$trackname = pg_escape_string($trackname);
		
		//*** SET SQL ***
		if ( is_null($uid) ) {
			$sql_select = "SELECT * FROM TRACKORDER WHERE SPECIES='$s' AND REVISION='$r' AND UID IS NULL";
			$sql_insert = "INSERT INTO TRACKORDER (SPECIES,REVISION,ORDER_STR) VALUES ('$s','$r','')";
		}
		else {
			$sql_select = "SELECT * FROM TRACKORDER WHERE SPECIES='$s' AND REVISION='$r' AND UID=".$uid;
			$sql_insert = "INSERT INTO TRACKORDER (SPECIES,REVISION,UID,ORDER_STR) VALUES ('$s','$r',".$uid.",'')";
		}
		
		//*** CHECK IF TRACKORDER EXISTS OR NOT ***
		$res = pg_query( $hDB_trackinformation, $sql_select );
		if ( pg_num_rows($res) == 1 ) {
			$toid = pg_fetch_result($res,0,'toid');
			$order_str = pg_fetch_result($res,0,'order_str');
		}
		else {
			pg_query( $hDB_trackinformation, 'BEGIN');
			pg_query( $hDB_trackinformation, $sql_insert);
			pg_query( $hDB_trackinformation, 'COMMIT');
			$res = pg_query( $hDB_trackinformation, $sql_select );
			$toid = pg_fetch_result($res,0,'toid');
			$order_str = pg_fetch_result($res,0,'order_str');
		}

		//*** CREATE ORDER_STR ***
		if ( $order_str == "" || is_null($order_str) || empty($order_str) ) {
			$new_order_str = $trackname;
		}
		else {
			$new_order_str = $order_str.":".$trackname;
		}

		//*** EXECUTE UPDATE ***
		pg_query( $hDB_trackinformation, 'BEGIN' );
		$sql_update = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($new_order_str)."' WHERE TOID=".$toid;
		$res = pg_query( $hDB_trackinformation, $sql_update );
		if ( pg_result_status( $res ) == PGSQL_COMMAND_OK ) {
			pg_query( $hDB_trackinformation, 'COMMIT' );
		}
		else {
			pg_query( $hDB_trackinformation, 'ROLLBACK' );
			$msg = "Cannot update track order...";
			show_error_message($msg);
		}

		return;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [drop_track]
	// 2005.5.23 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function drop_track ($tracks,$tracknum,$s,$r,$uid) {
		
		$track = $tracks[$tracknum];
		global $trackinformation_connection_string;

		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);

		$sql_select_track = "SELECT * FROM TRACK WHERE NAME='".pg_escape_string($track['name'])."' AND SPECIES='$s' AND REVISION='$r' AND UID IS NULL";
		$sql_select_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$s' AND REVISION='$r' AND UID=$uid";

		$res_select_track = pg_query( $hDB_trackinformation, $sql_select_track );
		$res_select_trackorder = pg_query( $hDB_trackinformation, $sql_select_trackorder );
		$order_str = pg_fetch_result( $res_select_trackorder, 0,'order_str' );
		$toid = pg_fetch_result( $res_select_trackorder, 0,'toid' );

		// UPDATE ORDER_STR -----
		if ( pg_num_rows($res_select_track) == 0 ) {
			$order_str_ary = explode( ":", $order_str );
			foreach ( $order_str_ary as $i => $track_name ) {
				if ( $track_name == $track['name'] ) {
					$del_pos = $i;
					break;
				}
			}
			array_splice( $order_str_ary, $del_pos, 1 );
			$order_str = implode(":",$order_str_ary);
			array_splice( $tracks, $tracknum, 1 );
		}
		// ----------------------

		// DROP CACHE DB -----------
		if ( $track['url'] == "cache" ) {
		  switch ($track['kind']) {
		  case "gene":
		    $DB_NAME = "cachegene_".$track['name']."_".$s."_".$r;
		    break;
		  case "graph":
		    $DB_NAME = "cachegraph_".$track['name']."_".$s."_".$r;
		    break;
		  case "color":
		    $DB_NAME = "cachecolor_".$track['name']."_".$s."_".$r;
		    break;
		  default:
				show_error_message("Cannot drop '".$track['name']." because 'Track Type' is unknown.");
				return;
				break;
			}

			$ld_path_str = "env LD_LIBRARY_PATH=$utgb_postgre_install_dir/lib $utgb_postgre_install_dir/bin/";
			# from public_host
			global $utgb_postgre_install_dir;
			global $utgb_cachedb_public_host;
			global $utgb_cachedb_insert_host;
			$command = $ld_path_str."dropdb -U postgres -h $utgb_cachedb_public_host $DB_NAME";
			$result = shell_exec(escapeshellcmd($command));
			# from insert_host
			if ( $utgb_cachedb_insert_host != "" ) {
				$command = $ld_path_str."dropdb -U postgres -h $utgb_cachedb_insert_host $DB_NAME";
				$result = shell_exec(escapeshellcmd($command));
			}
		}

		// TRANSACTION -------
		$sql_delete_history = "DELETE FROM HISTORY WHERE TID=".$track['tid'];
		$sql_update_trackorder = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($order_str)."' WHERE TOID=".$toid;
		$sql_delete_track = "DELETE FROM TRACK WHERE TID=".$track['tid'];
		pg_query( $hDB_trackinformation,'BEGIN' );
		$res_delete_history = pg_query( $hDB_trackinformation, $sql_delete_history );
		$res_update_trackorder = pg_query( $hDB_trackinformation, $sql_update_trackorder );
		$res_delete_track   = pg_query( $hDB_trackinformation, $sql_delete_track );
		
		if ( pg_result_status( $res_delete_history ) == PGSQL_COMMAND_OK && 
				pg_result_status( $res_update_trackorder ) == PGSQL_COMMAND_OK && 
				pg_result_status( $res_delete_track ) == PGSQL_COMMAND_OK ) {
				pg_query( $hDB_trackinformation,'COMMIT' );
				$msg = "Complete drop '".$track['name']."'.";
				show_message($msg);
		}
			else {
				pg_query( $hDB_trackinformation,'ROLLBACK' );
				show_error_message("Cannot drop selected track.");
		}
		// -------------------
		return $tracks;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [load_disparam]
	// 2005.5.23 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function load_disparam () {
		global $trackinformation_connection_string;
		$hDB_trackinformation = pg_connect($trackinformation_connection_string);
		assert($hDB_trackinformation);
		$sql_disparam = "SELECT * FROM DISPARAM";
		$res_disparam = pg_query( $hDB_trackinformation, $sql_disparam );
		$disparam = array();
		$disparam['species'] = pg_escape_string(pg_fetch_result( $res_disparam, 0,'species'));
		$disparam['revision'] = pg_escape_string(pg_fetch_result( $res_disparam, 0,'revision'));
		$disparam['target'] = pg_escape_string(pg_fetch_result( $res_disparam, 0,'target'));
		$disparam['start'] =pg_escape_string(pg_fetch_result( $res_disparam, 0,'start_position'));
		$disparam['end'] = pg_escape_string(pg_fetch_result( $res_disparam, 0,'end_position'));
		$disparam['width'] = pg_escape_string(pg_fetch_result( $res_disparam, 0,'width'));
		return $disparam;
	}

  ///////////////////////////////////////////////////////////////////////////////
  // [recompose_tracks]
	// 2005.5.23 t.shishiki
  ///////////////////////////////////////////////////////////////////////////////
	function recompose_tracks($s,$r) {
		$TRACKS =load_tracks_from_trackinformation($s,$r,$_SESSION['login']['user_id']);
		$tracks = $TRACKS['tracks'];
		$removedtracks = $TRACKS['removedtracks'];
		$_SESSION['browser']['tracks'][$s][$r] = $tracks;
		$_SESSION['browser']['removedtracks'][$s][$r] = $removedtracks;
		return;
	}
	