<?php

  require_once 'browser_common.php';
  require_once 'browser_manage_common.php';

  $admin=TRUE;

  $hDB_trackinformation = pg_connect($trackinformation_connection_string);
  assert($hDB_trackinformation);

?>

<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Script-Type" content="text/javascript">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>
<?php 
	if ( $auth == TRUE ) {
		print "User Certification";
	}
	else {
		print "Operation of Administration";
	}
?>
		
</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<SCRIPT language="JavaScript">
<!--
	function openHistory ( tid ) {
		var temp;
		temp = window.open( 'browser_manage_history.php?tid='+tid,'track_history','width=320,height=240,scrollbars=yes,resizable=yes' );
		temp.focus();
	}
	function changeSpecies() {
		track_list.reset_select_revision.value = 1;
		track_list.submit();
	}
	function changeRevision() {
		track_list.reset_select_revision.value = 0;
		track_list.submit();
	}
	function changeExhibit() {
		track_list.reset_select_revision.value = 0;
		track_list.submit();
	}

-->
</SCRIPT>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>
<?php

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//							P R O C E S S I N G
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

//**********************************************
//     Check Authentication
//**********************************************
if ( empty($_POST['AUTH']) ) {

	if ( isset($_POST["user_name"]) && isset($_POST["password"]) ) {

		if ( empty($_POST['user_name']) ||  empty($_POST['password']) ) {
			$msg = "'Administrator name' or 'Password' are blank.";
			show_error_message($msg);
		}
		else {
			$input_user = $_POST["user_name"];
			$input_pass = md5($_POST["password"]);

			//*******************
			//	login
			//*******************
			if ( isset($_POST['login']) ) {
				$sql = "SELECT * FROM users WHERE name='$input_user' AND password='$input_pass';";
				$res_certify = pg_query($hDB_trackinformation, $sql);
				$num_rows = pg_num_rows($res_certify);
				if ($num_rows != 1) {
					$msg = "Authentication failed. Inputed 'User' or 'Password' is incorresct";
					show_error_message($msg);
					$auth = FALSE;
				}
				else {
					$authority = pg_fetch_result ( $res_certify, 0, 'authority' );
					if ( $authority == "admin" ) {
						$auth = TRUE;
					}
					else{
						$auth = FALSE;
						$msg = "Authentication failed. Inputed 'User' does not have authority of 'administator'";
						show_error_message($msg);
					}
				}
			}
			//********************
			//	new admin
			//********************
			else if ( isset($_POST['new_admin']) ) {
				$sql = "INSERT INTO USERS (NAME,PASSWORD,AUTHORITY) VALUES ('$input_user','$input_pass','admin')";
				pg_query($hDB_trackinformation,'BEGIN');
				$res = pg_query( $hDB_trackinformation,$sql );
				if ( pg_result_status($res) == PGSQL_COMMAND_OK ) {
					pg_query($hDB_trackinformation,'COMMIT');
					$auth = TRUE;
				}
				else {
					pg_query($hDB_trackinformation,'ROLLBACK');
					$auth = FALSE;
				}
			}
		}
	}
}
else {
	$auth = TRUE;
}

//**********************************************
//   Authentication is OK.
//**********************************************
if ( $auth == TRUE ) {

		// set species
    $sql = "SELECT DISTINCT species FROM track";
    $res_temp = pg_query($hDB_trackinformation, $sql);
    unset($list_species);
    for ($i = 0; $i < pg_num_rows($res_temp); $i++) {
      $list_species[] = pg_fetch_result($res_temp, $i, 0);
    }
    if ( isset($_POST["select_species"]) ) {
      $species_selected = $_POST["select_species"];
    } else  {
      $species_selected = $list_species[0];
    }

		// set revision
    $sql = "SELECT DISTINCT revision FROM track WHERE species='$species_selected'";
    $res_temp = pg_query($hDB_trackinformation, $sql);
    unset($list_revision);
    for ($i = 0; $i < pg_num_rows($res_temp); $i++) {
      $list_revision[] = pg_fetch_result($res_temp, $i, 0);
    }
		if ( $_POST['reset_select_revision'] == 1 ) {
      $revision_selected = $list_revision[0];
		}
    else if ( isset($_POST["select_revision"]) ) {
      $revision_selected = $_POST["select_revision"];
    } else {
      $revision_selected = $list_revision[0];
    }
		// set exhibit
		if ( $_POST['select_exhibit'] ) {
			$exhibit_selected = $_POST['select_exhibit'];
		}
		else {
			$exhibit_selected = "All";
		}

		// set tracks
	if ( isset($_POST['tracks']) ) {
		$tracks = $_POST['tracks'];
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //**********************************************
  //	Add New Track
  //**********************************************
  else if ( isset( $_POST['btn_add_newtrack'] )  && strlen($_POST['newtrack']) > 0 ) {

		$track_url = $_POST['newtrack'];
		//*** set species ***
		$reg_species = $species_selected;
		if ( !empty($_POST['new_species'])) {
			$reg_species = $_POST['new_species'];
		}
		//*** set revision ***
		$reg_revision = $revision_selected;
		if ( !empty($_POST['new_revision'])) {
			$reg_revision = $_POST['new_revision'];
		}
		//*** set optparam ***
		$optparam="";
		if ( !empty($_SESSION['optparam']) ) {
			$optparam = $_SESSION['optparam'];
		}
		$tracks = array();
	  exec_regist_track_from_url( $track_url,$tracks,$reg_species,$reg_revision,$optparam,$admin);
		unset($_SESSION['optparam']);
		$auth = TRUE;
  }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //*********************************************
  //		Upload Track
  //*********************************************
  else if ( isset($_POST['upload_easytrackfile_btn']) ) {
		$htmlSID = htmlspecialchars(SID);
		$uploadfile = "";
		$uploadfile = $utgb_uploaded_easytrack_dir."/".$_FILES['upload_easytrackfile_path']['name'];
		if (move_uploaded_file($_FILES['upload_easytrackfile_path']['tmp_name'], $uploadfile)) {
			$cmd = "chmod 644 $uploadfile";
			shell_exec(escapeshellcmd($cmd));
		     $tracks = array();
			 exec_regist_track_from_uploadfile( $uploadfile,$tracks,$species_selected,$revision_selected,$admin );
		}
		else {
			$msg  = "Fail to move uoloaded file to 'uploaded_easytrack' directory.";
			show_error_message($msg);
		}
		$auth = TRUE;
  }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  //************************************************
  // 	Delete / Modify on user list
  //************************************************
  else if ( isset($_POST['tracklist']) ) {
		foreach ( $_POST as $key => $val ) {
			if( preg_match( '/^(\d+)-delete$/', $key, $match ) ) {
				$delete_uid = $match[1];
				break 1;
			}
			else if( preg_match( '/^(\d+)-modify$/', $key, $match ) ) {
				$modify_uid = $match[1];
				break 1;
			}
			else if( preg_match( '/^(\d+)-apply$/', $key, $match ) ) {
				$apply_uid = $match[1];
				break 1;
			}
		}
		// delete
		if ( isset($delete_uid) ) {
			$sql = "SELECT NAME FROM USERS WHERE UID=".$delete_uid;
			$res = pg_query( $hDB_trackinformation, $sql );
			$name = pg_fetch_result( $res, 0, 'name' );
			pg_query( $hDB_trackinformation,'BEGIN' );
			$sql_history  = "DELETE FROM HISTORY WHERE UID=".$delete_uid;
			$sql_track    = "DELETE FROM TRACK WHERE UID=".$delete_uid;
			$sql_track    = "DELETE FROM TRACKORDER WHERE UID=".$delete_uid;
			$sql_users    = "DELETE FROM USERS WHERE UID=".$delete_uid;
			$res_history  = pg_query( $hDB_trackinformation, $sql_history );
			$res_track    = pg_query( $hDB_trackinformation, $sql_track );
			$res_users    = pg_query( $hDB_trackinformation, $sql_users );
			if ( pg_result_status($res_history) == PGSQL_COMMAND_OK &&  pg_result_status($res_track) == PGSQL_COMMAND_OK &&  pg_result_status($res_users) == PGSQL_COMMAND_OK ) {
				pg_query( $hDB_trackinformation, 'COMMIT');
				show_message("Deleted user '$name' and $name's tracks.");
			}
			else {
				pg_query( $hDB_trackinformation, 'ROLLBACK');
				show_error_message("Can not delete user '$name'.");
			}
		}
		// modify  apply
		else if ( isset($apply_uid) ) {
			$sql = "SELECT NAME FROM USERS WHERE UID=".$apply_uid;
			$res = pg_query( $hDB_trackinformation, $sql );
			$name = pg_fetch_result( $res, 0, 'name' );
			$e_mail = $_POST['edit_e_mail'];
			$authority = $_POST['edit_authority'];
			$sql = "UPDATE USERS SET E_MAIL='$e_mail',AUTHORITY='$authority' WHERE UID=$apply_uid";
			$res = pg_query( $hDB_trackinformation, $sql);
			if ( pg_result_status($res) == PGSQL_COMMAND_OK ) {
				pg_query( $hDB_trackinformation, 'COMMIT');
				show_message("Modified user '$name'.");
			}
			else {
				pg_query( $hDB_trackinformation, 'ROLLBACK');
				show_error_message("Can not modify user '$name'.");
			}
		}
	}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

  //************************************************
  // 	Change Public/Private of Track List
  //************************************************
	else if (isset( $_POST["btn_tracklist_apply"]) ) {
		$species  = $_POST['select_species'];
		$revision = $_POST['select_revision'];
		$sql_1 = "SELECT DISTINCT NAME FROM TRACK WHERE SPECIES='$species' AND REVISION='$revision'";
		$res_1 = pg_query($hDB_trackinformation, $sql_1);
		pg_query( $hDB_trackinformation, 'BEGIN' );
		
		//*** Public  Private ***
		for ( $i = 0; $i < pg_num_rows($res_1) ; $i++ ) {
			$track_name = pg_fetch_result( $res_1, $i, 'name' );
			$chk_name = "chk_".convertExceptTrackName($track_name);
			$radio_name = "radio_".convertExceptTrackName($track_name);
			$order_str = "";
			if ( isset($_POST[$chk_name]) ) {			
				$sql_2 = "SELECT TID,UID FROM TRACK WHERE SPECIES='$species' AND REVISION='$revision' AND NAME='".pg_escape_string($track_name)."'";
				$res_2 = pg_query($hDB_trackinformation, $sql_2);
				for ( $j = 0; $j < pg_num_rows($res_2) ; $j++ ) {
					$tid = pg_fetch_result( $res_2, $j, 'tid' );
					if ( isset($_POST[$radio_name]) ) {
						if ( $_POST[$radio_name] == $tid ) {
							$sql_3 = "UPDATE TRACK SET EXHIBIT='public' WHERE TID=".$_POST[$radio_name];
						}
						else {
							$sql_3 = "UPDATE TRACK SET EXHIBIT='private' WHERE TID=$tid";
						}
					}
					$res_3 = pg_query($hDB_trackinformation, $sql_3);
					if ( pg_result_status($res_3) == PGSQL_COMMAND_OK ) {
					}
					else {
						pg_query( $hDB_trackinformation, 'ROLLBACK');
						$msg = "Cannot change public/private....";
						show_error_message($msg);
						break 1;
					}
				}
			}
			else {
				$sql_4 = "SELECT TID FROM TRACK WHERE SPECIES='$species' AND REVISION='$revision' AND NAME='".pg_escape_string($track_name)."'";
				$res_4 = pg_query($hDB_trackinformation, $sql_4);
				for ( $j = 0; $j < pg_num_rows($res_4) ; $j++ ) {
					$tid = pg_fetch_result( $res_4, $j, 'tid' );
					$sql_5 = "UPDATE TRACK SET EXHIBIT='private' WHERE TID=".$tid;
					$res_5 = pg_query($hDB_trackinformation, $sql_5);
					if ( pg_result_status($res_5) == PGSQL_COMMAND_OK ) {
					}
					else {
						pg_query( $hDB_trackinformation, 'ROLLBACK');
						$msg = "Cannot change public/private....";
						show_error_message($msg);
						break;
					}
				}
			}
		}
		pg_query( $hDB_trackinformation, 'COMMIT' );

		//--------------------------------------------------------------------------
		// 2005.5.18 t.shishiki add
		$order_str_ary = array();
		foreach ( $_POST as $key => $value ) {
			if( preg_match( '/^chk_([^ ]+)/', $key, $match ) ) {
				 $trackname = $match[1];
				 $order_str_ary[] = $trackname;
			}
		}
		$order_str = pg_escape_string(join(':',unconvertExceptTrackName($order_str_ary)) );
		$sql_update = "UPDATE TRACKORDER SET ORDER_STR='$order_str' WHERE SPECIES='$species' AND REVISION='$revision' AND UID IS NULL";
		pg_query( $hDB_trackinformation, 'BEGIN');
		$res_update = pg_query( $hDB_trackinformation, $sql_update );
		if ( pg_result_status( $res_update ) == PGSQL_COMMAND_OK ) {
			pg_query( $hDB_trackinformation, 'COMMIT');
		}
		else {
			pg_query( $hDB_trackinformation, 'ROLLBACK');
		}
		//--------------------------------------------------------------------------
		$auth = TRUE;
	}

//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
	//******************************
	// Add option attribute
	//******************************
	else if (isset( $_POST["btn_optparam_add"]) ) {
	
		// Empty Check
		if ( empty($_POST['optparam_key']) || empty($_POST['optparam_val']) ) {
			$msg = "Cannnot add option attribute because 'key' or 'value' is empty...";
			show_error_message($msg);
		}
		else {
			$key   = $_POST['optparam_key'];
			$value = $_POST['optparam_val'];
			$_SESSION['optparam'][$key] = $value;
		}
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//***********************************
	//	remove option attribute element
	//***********************************
	else if( $_POST['btn_optparam_remove'] ) {
	
		foreach ( $_POST as $key => $val ) {
			if( preg_match( '/^chk_optparam_([^ ]+)/', $key, $match ) ) {
				$optparam_key =  $match[1];
				unset($_SESSION['optparam'][$optparam_key]);
			}
		}
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//********************************
	// reset option attribute element
	//********************************
	else if ( $_POST['btn_optparam_reset'] ) {
		unset($_SESSION['optparam']);
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

	//********************************
	// modify display parameter
	//********************************
	else if ( $_POST['btn_disparam_apply'] ) {
		$disparam = array();
		$disparam['species']  = $_POST['disparam_species'];
		$disparam['revision'] = $_POST['disparam_revision'];
		$disparam['target']   = $_POST['disparam_target'];
		$disparam['start']    = $_POST['disparam_start'];
		$disparam['end']      = $_POST['disparam_end'];
		$disparam['width']      = $_POST['disparam_width'];
		$sql_update = "UPDATE DISPARAM 
									SET SPECIES='".$disparam['species']."',
									REVISION='".$disparam['revision']."',
									TARGET='".$disparam['target']."',
									START_POSITION='".$disparam['start']."',
									END_POSITION='".$disparam['end']."',
									WIDTH='".$disparam['width']."' 
									WHERE DID=1";
		pg_query( $hDB_trackinformation, 'BEGIN' );
		$res_update = pg_query( $hDB_trackinformation, $sql_update );
		if ( pg_result_status($res_update) == PGSQL_COMMAND_OK ) {
			pg_query( $hDB_trackinformation, 'COMMIT' );
		}
		else {
			pg_query( $hDB_trackinformation, 'ROLLBACK' );
		}
	}
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



	//********************************
	//		OTHERS
	//********************************
	else {
		foreach ( $_POST as $key => $value ) {
			//********************************
			//						up
			//********************************
			if( preg_match( '/^btn_up_([^ ]+)/', $key, $match ) ) {
				$track_name = unconvertExceptTrackName($match[1]);
				$sql_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder );
				if ( pg_num_rows($res_trackorder) == 1 ) {
					$order_str = pg_fetch_result( $res_trackorder, 0, 'order_str' );
					$toid = pg_fetch_result( $res_trackorder, 0, 'toid' );
					$order_str_ary = explode( ':', $order_str );
					foreach ( $order_str_ary as $i => $order_track_name ) {
						if ( $order_track_name == $track_name ) {
							$pos = $i;
							break;
						}
					}
					if ( $pos != 0 ) {
						$tmp_track_name = $order_str_ary[$pos-1];
						$order_str_ary[$pos-1] = $track_name;
						$order_str_ary[$pos] = $tmp_track_name;
						$new_order_str = join(":",$order_str_ary);
						$sql_update = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($new_order_str)."' WHERE TOID=$toid";
						pg_query( $hDB_trackinformation, 'BEGIN');
						$res_update = pg_query( $hDB_trackinformation, $sql_update );
						if ( pg_result_status($res_update) == PGSQL_COMMAND_OK ) {
							pg_query( $hDB_trackinformation, 'COMMIT');
						}
						else {
							pg_query( $hDB_trackinformation, 'ROLLBACK');
						}
					}
				}
				else {
					$msg = "Cannot 'up' $track_name...";
					show_error_message($msg);
				}
			}
			//********************************
			//						down
			//********************************
			if( preg_match( '/^btn_down_([^ ]+)/', $key, $match ) ) {
				$track_name = unconvertExceptTrackName($match[1]);
				$sql_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder );
				if ( pg_num_rows($res_trackorder) == 1 ) {
					$order_str = pg_fetch_result( $res_trackorder, 0, 'order_str' );
					$toid = pg_fetch_result( $res_trackorder, 0, 'toid' );
					$order_str_ary = explode( ':', $order_str );
					foreach ( $order_str_ary as $i => $order_track_name ) {
						if ( $order_track_name == $track_name ) {
							$pos = $i;
							break;
						}
					}
					if ( $pos != (count($order_str_ary)-1) ) {
						$tmp_track_name = $order_str_ary[$pos+1];
						$order_str_ary[$pos+1] = $track_name;
						$order_str_ary[$pos] = $tmp_track_name;
						$new_order_str = join(":",$order_str_ary);
						$sql_update = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($new_order_str)."' WHERE TOID=$toid";
						pg_query( $hDB_trackinformation, 'BEGIN');
						$res_update = pg_query( $hDB_trackinformation, $sql_update );
						if ( pg_result_status($res_update) == PGSQL_COMMAND_OK ) {
							pg_query( $hDB_trackinformation, 'COMMIT');
						}
						else {
							pg_query( $hDB_trackinformation, 'ROLLBACK');
						}
					}
				}
				else {
					$msg = "Cannot 'up' $track_name...";
					show_error_message($msg);
				}
			}
			
			//********************************
			//					drop
			//********************************
			if( preg_match( '/^btn_drop_([^ ]+)/', $key, $match ) ) {

				$tid = $match[1];
				$sql_select_track = "SELECT * FROM TRACK WHERE TID=".$tid;
				$res_track = pg_query( $hDB_trackinformation, $sql_select_track );
				$track = array();
				$track['name'] = pg_fetch_result( $res_track, 0, 'name' );
				$track['kind'] = pg_fetch_result( $res_track, 0, 'kind' );
				$track['url'] = pg_fetch_result( $res_track, 0, 'data_location' );
				$track['uid'] = pg_fetch_result( $res_track, 0, 'uid' );

				// DROP CACHE DB 
				if ( $track['url'] == "cache" ) {
				  switch ($track['kind']) {
				  case "gene":
				    $DB_NAME = "cachegene_".$track['name']."_".$species_selected."_".$revision_selected;
				    break;
				  case "graph":
				    $DB_NAME = "cachegraph_".$track['name']."_".$species_selected."_".$revision_selected;
				    break;
				  case "color":
				    $DB_NAME = "cachecolor_".$track['name']."_".$species_selected."_".$revision_selected;
				    break;
				  default:
						show_error_message("Cannot drop '".$track['name']." because 'Track Type' is unknown.");
						break;
					}

					global $utgb_postgre_install_dir;
					global $utgb_cachedb_public_host;
					global $utgb_cachedb_insert_host;
					global $ld_path_str;
					# from public_host
					$command = $ld_path_str."dropdb -U postgres -h $utgb_cachedb_public_host $DB_NAME";
					$result = shell_exec(escapeshellcmd($command));

					# from insert_host
					if ( $utgb_cachedb_insert_host != "" ) {
						$command = $ld_path_str."dropdb -U postgres -h $utgb_cachedb_insert_host $DB_NAME";
						$result = shell_exec(escapeshellcmd($command));
					}
				}

				//*********** UPDATE TRACKINOFORMATION  START ***************
				pg_query( $hDB_trackinformation, 'BEGIN');

				// delete from history
				$sql_delete_history = "DELETE FROM HISTORY WHERE TID=".$tid;
				$res_delete_history = pg_query( $hDB_trackinformation, $sql_delete_history );

				// delete from trackorder
				$sql_select_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_select_trackorder );
				if ( pg_num_rows($res_trackorder) == 1 ) {
					$toid = pg_fetch_result($res_trackorder,0,'toid');
					$order_str_ary = explode(":",pg_fetch_result($res_trackorder,0,'order_str'));
					foreach ( $order_str_ary as $i => $track_name ) {
						if ( $track_name ==  $track['name'] ) {
							$remove_pos = $i;
							break;
						}
					}
					array_splice( $order_str_ary, $remove_pos, 1 );
					$order_str = implode( ":", $order_str_ary );
					$sql_update_trackorder = "UPDATE TRACKORDER SET ORDER_STR='".pg_escape_string($order_str)."' WHERE TOID=".$toid;
					$res_update_trackorder = pg_query( $hDB_trackinformation, $sql_update_trackorder );
				}
				else {
					show_error_message("Cannot drop track because 'order_str' does not exist.");
				}

				// delete from track
				$sql_delete_track = "DELETE FROM TRACK WHERE TID=".$tid;
				$res_delete_track = pg_query( $hDB_trackinformation, $sql_delete_track );
				if ( pg_result_status($res_delete_history) == PGSQL_COMMAND_OK && 
							pg_result_status($res_update_trackorder) == PGSQL_COMMAND_OK && 
							pg_result_status($res_delete_track) == PGSQL_COMMAND_OK ) {
					pg_query( $hDB_trackinformation, 'COMMIT' );
				}
				else {
					show_error_message("Cannot drop track.");
					pg_query( $hDB_trackinformation, 'ROLLBACK' );
				}
				//*********** UPDATE TRACKINOFORMATION  END ***************
			}
			
			//********************************
			//					remove
			//********************************
			if( preg_match( '/^btn_remove_([^ ]+)/', $key, $match ) ) {

				$track_name = unconvertExceptTrackName($match[1]);
				$sql_select_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_select_trackorder );
				if ( pg_num_rows($res_trackorder) == 1 ) {
					$toid = pg_fetch_result($res_trackorder,0,'toid');
					$remove_str = pg_fetch_result( $res_trackorder, 0,'remove_str');
					if ( is_null($remove_str) || empty($remove_str) ) {
						$new_remove_str = $track_name;
					}
					else {
						$remove_str_ary = explode(":",$remove_str);
						$remove_str_ary[] = $track_name;
						$new_remove_str = implode( ":", $remove_str_ary );
					}
					pg_query( $hDB_trackinformation, 'BEGIN' );
					$sql_update_trackorder = "UPDATE TRACKORDER SET REMOVE_STR='".pg_escape_string($new_remove_str)."' WHERE TOID=".$toid;
					$res_update_trackorder = pg_query( $hDB_trackinformation, $sql_update_trackorder );
					if ( pg_result_status( $res_update_trackorder ) == PGSQL_COMMAND_OK ) {
						pg_query( $hDB_trackinformation, 'COMMIT' );
					}
					else {
						pg_query( $hDB_trackinformation, 'ROLLBACK' );
					}
				}
				else {
					show_error_message("Cannot remove track because record does not exist in trackorder table.");
				}
			}
			
			//********************************
			//					unremove
			//********************************
			if( preg_match( '/^btn_unremove_([^ ]+)/', $key, $match ) ) {
				$unremove_track_name = unconvertExceptTrackName($match[1]);
				$sql_select_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				$res_trackorder = pg_query( $hDB_trackinformation, $sql_select_trackorder );
				if ( pg_num_rows($res_trackorder) == 1 ) {
					$toid = pg_fetch_result($res_trackorder,0,'toid');
					
					// modify remove_str
					$remove_str_ary = explode( ":",pg_fetch_result( $res_trackorder, 0,'remove_str') );
					foreach ( $remove_str_ary as $i => $remove_track_name ) {
						if ( $remove_track_name == $unremove_track_name ) {
							$unremove_pos = $i;
							break;
						}
					}
					array_splice( $remove_str_ary, $unremove_pos, 1 );
					$new_remove_str = implode( ":", $remove_str_ary );
					
					// modify order_str
					$order_str_ary = explode( ":",pg_fetch_result( $res_trackorder, 0,'order_str') );
					foreach ( $order_str_ary as $i => $order_track_name ) {
						if ( $order_track_name == $unremove_track_name ) {
							$unremove_pos = $i;
							break;
						}
					}
					array_splice( $order_str_ary, $unremove_pos, 1 );
					$order_str_ary[] = $unremove_track_name;
					$new_order_str = implode( ":", $order_str_ary );

					// execute update
					pg_query( $hDB_trackinformation, 'BEGIN' );
					$sql_update_trackorder = "UPDATE TRACKORDER SET REMOVE_STR='".pg_escape_string($new_remove_str)."', ORDER_STR='".pg_escape_string($new_order_str)."' WHERE TOID=".$toid;
					$res_update_trackorder = pg_query( $hDB_trackinformation, $sql_update_trackorder );
					if ( pg_result_status( $res_update_trackorder ) == PGSQL_COMMAND_OK ) {
						pg_query( $hDB_trackinformation, 'COMMIT' );
					}
					else {
						pg_query( $hDB_trackinformation, 'ROLLBACK' );
					}
				}
				else {
					show_error_message("Cannot remove track because record does not exist in trackorder table.");
				}
			}
		}
	}

	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	//
	//							O U T P U T		H T M L
	//
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	
    print("<H1>Operation of Administrator</H1>"); 

	//***********************************
	//     displar parameter
	//***********************************

	$sql_select_disparam = "SELECT * FROM DISPARAM";
	$res_select_disparam = pg_query( $hDB_trackinformation, $sql_select_disparam );
	$disparam = array();
	if ( pg_num_rows($res_select_disparam) == 1 ) {
		$disparam['species'] = pg_fetch_result( $res_select_disparam,0,'species' );
		$disparam['revision'] = pg_fetch_result( $res_select_disparam,0,'revision' );
		$disparam['target'] = pg_fetch_result( $res_select_disparam,0,'target' );
		$disparam['start'] = pg_fetch_result( $res_select_disparam,0,'start_position' );
		$disparam['end'] = pg_fetch_result( $res_select_disparam,0,'end_position' );
		$disparam['width'] = pg_fetch_result( $res_select_disparam,0,'width' );
	}
		print "<H3>display parameter</H3>";
		print "<CENTER>";
		print "<FORM METHOD=\"post\" NAME=\"disparam\">";
		print "<TABLE>";
		print "<TR><TH>species</TH><TD><INPUT TYPE='text' NAME='disparam_species' VALUE='".$disparam['species']."'></TD></TR>";
		print "<TR><TH>revision</TH><TD><INPUT TYPE='text' NAME='disparam_revision' VALUE='".$disparam['revision']."'></TD></TR>";
		print "<TR><TH>target</TH><TD><INPUT TYPE='text' NAME='disparam_target' VALUE='".$disparam['target']."'></TD></TR>";
		print "<TR><TH>start</TH><TD><INPUT TYPE='text' NAME='disparam_start' VALUE='".$disparam['start']."'></TD></TR>";
		print "<TR><TH>end</TH><TD><INPUT TYPE='text' NAME='disparam_end' VALUE='".$disparam['end']."'></TD></TR>";
		print "<TR><TH>width</TH><TD><INPUT TYPE='text' NAME='disparam_width' VALUE='".$disparam['width']."'></TD></TR>";
		print "</TABLE>";
		print "<br>";
		print "<INPUT TYPE='submit' NAME='btn_disparam_apply' VALUE='Apply'>";
		print "</CENTER>";
		print("<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>");
		print "</FORM>";
	
		//***********************************
		//     track list
		//***********************************
	  print("<H3>track list</H3>");
    // Select Species,Revision
    print("<FORM METHOD=\"post\" NAME=\"track_list\">");
    print("<CENTER>");
    print("<TABLE CELLSPACING=8>");
    print("<TR>");
    print("<TH>species</TH>");
    print("<TD>");
    print "<SELECT name=\"select_species\" onChange=\"JavaScript:changeSpecies(); \">";
    foreach( $list_species as $tmp ) {
      if( $tmp == $species_selected ) {
        print "<OPTION value=\"$tmp\" selected>$tmp</OPTION>";
      }
      else {
        print "<OPTION value=\"$tmp\">$tmp</OPTION>";
      }
    }
    print "</SELECT>";
		print ("<INPUT TYPE=\"hidden\" NAME=\"reset_select_revision\">");
    print("</TD>");
    print("<TH>revision</TH>");
    print("<TD>");
    print("<SELECT name=\"select_revision\" onChange=\"JavaScript:changeRevision(); \">");
    foreach( $list_revision as $tmp ) {
      if( $tmp == $revision_selected ) {
        print "<OPTION value=\"$tmp\" selected>$tmp</OPTION>";
      }
      else {
        print "<OPTION value=\"$tmp\">$tmp</OPTION>";
      }
    }
    print("</SELECT>");
    print("</TD>");
		// 2005.5.18 add & modify by t.shishiki --------------------------------------------------
		print "<TH>exhibit</TH>";
		print "<TD>";
		print "<SELECT NAME='select_exhibit' onChange='JavaScript:changeExhibit(); '>";
		if ( $exhibit_selected ) {
			switch ( $exhibit_selected ) {
				case "All":
					print "<OPTION VALUE='All'>All<OPTION VALUE='Public'>Public<OPTION VALUE='Private'>Private";
					break;
				case "Public":
					print "<OPTION VALUE='All'>All<OPTION VALUE='Public' SELECTED>Public<OPTION VALUE='Private'>Private";
					break;
				case "Private":
					print "<OPTION VALUE='All'>All<OPTION VALUE='Public'>Public<OPTION VALUE='Private' SELECTED>Private";
					break;
				default:
					print "<OPTION VALUE='All'>All<OPTION VALUE='Public'>Public<OPTION VALUE='Private'>Private";
					break;
			}
		}
		else {
			print "<OPTION VALUE='All'>All<OPTION VALUE='Public'>Public<OPTION VALUE='Private'>Private";
		}
		print "</SELECT>";
		print "</TD>";
		print("<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>");
		print("</TR>");
		print("</TABLE>");

		//*********************
		//	Make track list 
		//*********************
		switch ( $exhibit_selected ) {
			case "All":
				$sql_track = "SELECT * FROM TRACK WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' ORDER BY TID";
				break;
			case "Public":
				$sql_track = "SELECT * FROM TRACK WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND EXHIBIT='public' ORDER BY TID";
				$sql_trackorder = "SELECT * FROM TRACKORDER WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND UID IS NULL";
				break;
			case "Private":
				$sql_track = "SELECT * FROM TRACK WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' AND EXHIBIT='private' ORDER BY TID";
				break;
			default:
				$sql_track = "SELECT * FROM TRACK WHERE SPECIES='$species_selected' AND REVISION='$revision_selected' ORDER BY TID";
				break;
		}
    $res_track_list = pg_query($hDB_trackinformation, $sql_track);
    $track_list_hash = array();
    for ( $i = 0; $i < pg_num_rows($res_track_list); $i++ ) {
			$tid             = pg_fetch_result($res_track_list, $i, 'tid');
			$track_name      = pg_fetch_result($res_track_list, $i, 'name');
			$track_exhibit   = pg_fetch_result($res_track_list, $i, 'exhibit');
			$track_user_id   = pg_fetch_result($res_track_list, $i, 'uid');
			$track_comment   =pg_fetch_result($res_track_list, $i, 'comment');
                        if($track_user_uid == '') {
			 $track_user_name = '';
			}else {
			$sql = "SELECT * FROM users WHERE uid=$track_user_id;";
			$res_temp = pg_query($hDB_trackinformation, $sql);
			$track_user_name = pg_escape_string(pg_fetch_result($res_temp, 0, 'name'));
                        }
			$track = array();
			$track['tid'] = $tid;
			$track['exhibit'] = $track_exhibit;
			$track['user_id'] = $track_user_id;
			$track['comment'] = $track_comment;
			$track['user_name'] = $track_user_name;
			$track_list_hash[$track_name][] = $track;
		}

		//*** ordering & removing ***
		if ( $exhibit_selected == "Public" ) {
			$res_trackorder = pg_query( $hDB_trackinformation, $sql_trackorder );
			if ( pg_num_rows($res_trackorder) == 1 ) {

				// exec_ordering
				$order_str = pg_fetch_result( $res_trackorder,0,'order_str' );
				$order_str_ary = explode( ":",$order_str );
				$tmp_track_list_hash = array();
				foreach ( $order_str_ary as $i => $order_track_name ) {
					foreach ( $track_list_hash as $track_name => $i ) {
						if ( $order_track_name == $track_name ) {
							$tmp_track_list_hash[$track_name] = $i;
						}
					}
				}

				// exec_removing
				$remove_str = pg_fetch_result( $res_trackorder,0,'remove_str' );
				if ( !is_null($remove_str) || !empty($remove_str) || $remove_str != "" ) {
					$tmp_2_track_list_hash = array();
					$removedtrack_list_hash = array();
					$remove_str_ary = explode(":",$remove_str);
					foreach ( $tmp_track_list_hash as $track_name => $i ) {
						$f_remove = FALSE;
						foreach ( $remove_str_ary as $j => $remove_track_name ) {
							if ( $track_name == $remove_track_name ) {
								$f_remove = TRUE;
								break 1;
							}
						}
						if ( $f_remove == TRUE ) {
							$removedtrack_list_hash[$track_name] = $i;
						}
						else if ( $f_remove == FALSE ) {
							$tmp_2_track_list_hash[$track_name] = $i;
						}
					}
					$tmp_track_list_hash = $tmp_2_track_list_hash;
				}
			}
			$track_list_hash = $tmp_track_list_hash;
		}

    print("<TABLE BORDER=2>");
    print("<TR>");
		if ( $exhibit_selected == "All" ) {
	    print "<TH>Release</TH>";
		}
    print("<TH>Track name</TH>");
		
		if ( $exhibit_selected == "All" || $exhibit_selected == "Private" ) {
	    print("<TH>User</TH>");
		}
		
		if ( $exhibit_selected == "All" ) {
			print("<TH>Public/Private</TH>");
			print("<TH>Selection</TH>");
		}
    print("<TH>Comment</TH>");
    print("<TH>Operation</TH>");
    print("</TR>");
		foreach ( $track_list_hash as $track_name => $same_name_tracks ) {
			foreach ( $same_name_tracks as $tracknum => $track ) {
				$cnvt_track_name = convertExceptTrackName($track_name);
				print ("<TR>");
				//*** checkbox & Track name ***
				if ( $exhibit_selected == "All" ) {
					if ( count($same_name_tracks) == 1 ) {
						if ( $track['exhibit'] == "public" ) {
							print "<TD><center><INPUT TYPE=checkbox NAME='chk_$cnvt_track_name' VALUE=1 checked ></center></TD>";
							print "<TD>$track_name</TD>";
						}
						else if ( $track['exhibit'] == "private" ) {
							print "<TD><center><INPUT TYPE=checkbox NAME='chk_$cnvt_track_name' VALUE=1></center></TD>";
							print "<TD>$track_name</TD>";
						}
					}
					else if ( count($same_name_tracks) >= 1 ) {
						$f_public = FALSE;
						foreach ( $same_name_tracks as $i => $trk ) {
							if ( $trk['exhibit'] == "public" ) {
								$f_public = TRUE;
							}
						}
						if ( $f_public == TRUE && $tracknum == 0 ) {
							print "<TD rowspan=".count($same_name_tracks)."><center><INPUT TYPE=checkbox NAME='chk_$cnvt_track_name' VALUE=1 checked ></center></TD>";
							print "<TD rowspan=".count($same_name_tracks).">$track_name</TD>";
						}
						if ( $f_public == FALSE && $tracknum == 0 ) {
							print "<TD rowspan=".count($same_name_tracks)."><center><INPUT TYPE=checkbox NAME='chk_$cnvt_track_name' VALUE=1></center></TD>";
							print "<TD rowspan=".count($same_name_tracks).">$track_name</TD>";
						}
					}
				}
				else {
					print "<TD>$track_name</TD>";
				}
				//*** User ***
				if ( $exhibit_selected ==  "All" || $exhibit_selected ==  "Private" ) {
					print ("<TD>".$track['user_name']."</TD>");
				}
				//*** Public/Private ***
				if ( $exhibit_selected ==  "All" ) {
					print ("<TD>".$track['exhibit']."</TD>");
				}
				//*** Selected ***
				if ( $exhibit_selected ==  "All" ) {
					if ( $track['exhibit'] == "public" || count($same_name_tracks) == 1 ) {
						print ("<TD><CENTER><INPUT TYPE=radio NAME='radio_$cnvt_track_name' VALUE='".$track['tid']."' checked></CENTER></TD>");
					}
					else {
						print ("<TD><CENTER><INPUT TYPE=radio NAME='radio_$cnvt_track_name' VALUE='".$track['tid']."'></CENTER></TD>");
					}
				}
				//*** Comment ***
				print ("<TD>".$track['comment']."</TD>");
				//*** Operation ***
				print "<TD>";
				print "<CENTER>";
				if ( $exhibit_selected == "Public" ) {
					print " <INPUT TYPE='submit' VALUE='up' NAME='btn_up_$cnvt_track_name'>";
					print " <INPUT TYPE='submit' VALUE='down' NAME='btn_down_$cnvt_track_name'>";
					print " <INPUT TYPE='submit' VALUE='remove' NAME='btn_remove_$cnvt_track_name'>";
					if ( is_null($track['user_id']) ) {
						print " <INPUT TYPE='submit' VALUE='drop' NAME='btn_drop_".$track['tid']."'>";
					}
				}
				print " <INPUT TYPE=\"button\" VALUE=\"history\" onClick=\"JavaScript : openHistory('".$track['tid']."'); \"> ";
				print "</CENTER>";
				print "</TD>";
				print "</TR>";
			}
		}
    print("</TABLE>");
    print("<BR>");
		if ( $exhibit_selected == "All") {
	    print("<INPUT type=\"submit\" name=\"btn_tracklist_apply\" value=\"Apply\">");
		}
		print("<INPUT TYPE=\"hidden\" name=\"reset_revision\">");
    print("</FORM>");

	//***************************************************************
	//			removed track list
	//***************************************************************
	if ( !empty($removedtrack_list_hash) ) {
		print "<H3>removed track</H3>";
		print "<FORM method=\"POST\" action=\"".$_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID) ."\" name=\"addtrack\">";
		print "<TABLE border=\"0\">";
		print "<TBODY>";
    print("<TH>Track name</TH>");
    print("<TH>Comment</TH>");
    print("<TH>Operation</TH>");
		foreach ( $removedtrack_list_hash as $trackname => $i) {
			print "<TR>";
			print "<TD>".$trackname."</TD><TD>".$i['comment']."</TD>";
			print "<TD><INPUT TYPE='submit' NAME='btn_unremove_".convertExceptTrackName($trackname)."' VALUE='unremove'></TD>";
			print "</TR>";
		}
		print "</TBODY>";
		print("</TABLE>");
		print("<INPUT TYPE=\"hidden\" NAME=\"select_species\" VALUE=\"".$species_selected."\">");
		print("<INPUT TYPE=\"hidden\" NAME=\"select_revision\" VALUE=\"".$revision_selected."\">");
		print("<INPUT TYPE=\"hidden\" NAME=\"select_exhibit\" VALUE=\"".$exhibit_selected."\">");
		print("<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>");
		print "</FORM>";
	}

	//***************************************************************
	//			add track
	//***************************************************************
	print("<H3>add new track</H3>");
	print("<FORM method=\"POST\" action=\"".$_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID) ."\" name=\"addtrack\">");
	print("<TABLE border=\"0\"><TBODY>");
	print("<TR><TH>species</TH><TD> <INPUT TYPE=\"TEXT\" NAME=\"new_species\"></TD></TR>");
	print("<TR><TH>revision</TH><TD><INPUT TYPE=\"TEXT\" NAME=\"new_revision\"></TD></TR>");
	print "<tr>";
	print "<th>option parameter</TH>";
	print "<td>key:<INPUT TYPE=\"text\" NAME=\"optparam_key\">  value:<INPUT TYPE=\"text\" NAME=\"optparam_val\">";
	print " <INPUT TYPE=\"submit\" NAME=\"btn_optparam_add\" VALUE=\"Add\">";
	print "<br>";
	if ( !empty($_SESSION['optparam']) ) {
		print "<table border=1>";
		print "<tr><th>Selection</th><th>Key</th><th>Value</th></tr>";
		$optparam_list = $_SESSION['optparam'];
		foreach ( $optparam_list  as $key => $val ) {
			print "<tr><td><center><INPUT TYPE=\"checkbox\" NAME=\"chk_optparam_".$key."\"></center></td><td>".$key."</td><td>".$val."</td></tr>";
		}
		print "</table>";
		print "<INPUT TYPE=\"submit\" NAME=\"btn_optparam_remove\" VALUE=\"remove\">";
		print " ";
		print "<INPUT TYPE=\"submit\" NAME=\"btn_optparam_reset\" VALUE=\"reset\">";
	}
	print "</td>";
	print "</tr>";
	print("<TR><TH>track URL</TH><TD><INPUT size=\"80\" type=\"text\" name=\"newtrack\">");
	print("</TBODY></TABLE>");
	print("<br>");
	print("<INPUT type=\"submit\" name=\"btn_add_newtrack\" value=\"Add\"></TD></TR>");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_species\" VALUE=\"".$species_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_revision\" VALUE=\"".$revision_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_exhibit\" VALUE=\"".$exhibit_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>");
	print("</FORM>");

	//***************************************************************
	//			upload new track
	//***************************************************************
	print("<H3>upload new track</H3>");
	print("<FORM method=\"POST\" action=\"".$_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID) ."\" name=\"upload_easytrackfile\" ENCTYPE=\"multipart/form-data\">");
	print("<TABLE border=\"0\"><TBODY>");
	print("<TR><TH>Easytrack file</TH><TD><INPUT size=\"70\" type=\"file\" name=\"upload_easytrackfile_path\"> <INPUT type=\"submit\" name=\"upload_easytrackfile_btn\" value=\"Upload\"></TD></TR>");
	print("</TBODY></TABLE>");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_species\" VALUE=\"".$species_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_revision\" VALUE=\"".$revision_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"select_exhibit\" VALUE=\"".$exhibit_selected."\">");
	print("<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>");
	print("</FORM>");

	//***************************************************************
	//			users list
	//***************************************************************
	print("<H3>users list</H3>");
	print("<FORM method=\"POST\" action=\"".$_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID) ."\" name=\"userslist\">");
	print("<TABLE border=2><TBODY>");
	print("<TR><TH>Name</TH><TH>E-mail</TH><TH>Authority</TH><TH>Modify</TH><TH>Delete</TH></TR>");

	$sql = "SELECT * FROM USERS";
	$res = pg_query( $hDB_trackinformation, $sql );
	for ( $i = 0; $i < pg_num_rows($res); $i++ ) {
		$uid       = pg_fetch_result($res,$i,'uid');
		$name      = pg_fetch_result($res,$i,'name');
		$password  = pg_fetch_result($res,$i,'password');
		$e_mail    = pg_fetch_result($res,$i,'e_mail');
		$authority = pg_fetch_result($res,$i,'authority');
		print "<TR>";
		if ( $modify_uid ==  $uid ) {
			print "<TD>$name</TD>";
			print "<TD><INPUT TYPE=\"TEXT\" NAME=\"edit_e_mail\" VALUE=\"$e_mail\"></TD>";
			print "<TD>";
			print "<SELECT NAME=\"edit_authority\">";
			print "<OPTION VALUE=\"user\">user";
			print "<OPTION VALUE=\"admin\">admin";
			print "</SELECT>";
			print "</TD>";
			print "<TD><INPUT TYPE=\"submit\" NAME=\"$uid-apply\" VALUE=\"apply\"></TD>";
			print "<TD><INPUT TYPE=\"submit\" NAME=\"$uid-delete\" VALUE=\"delete\"></TD>";
		}
		else {
			print "<TD>$name</TD><TD>$e_mail</TD><TD>$authority</TD>";
			print "<TD><INPUT TYPE=\"submit\" NAME=\"$uid-modify\" VALUE=\"modify\"></TD>";
			print "<TD><INPUT TYPE=\"submit\" NAME=\"$uid-delete\" VALUE=\"delete\"></TD>";
		}
		print "</TR>";
	}
	print "</TBODY>";
	print "</TABLE>";
	print "<INPUT TYPE=\"hidden\" NAME=\"tracklist\" VALUE=\"tracklist\">";
	print "<INPUT TYPE=\"hidden\" NAME=\"AUTH\" VALUE=1>";
	print "</FORM>";
	print("</CENTER>");
    print("</BODY>");
    print("</HTML>");
  } else {
?>

<H3>Administrator Authentication</H3>

<FORM METHOD="post">
<BR>
<TABLE>
<TR>
<TH>Administrator name</TH>
<TD><INPUT SIZE="32" TYPE="text" NAME="user_name" MAXLENGTH="32"></TD>
</TR>
<TR>
<TH>Password</TH>
<TD><INPUT SIZE="16" TYPE="password" NAME="password" MAXLENGTH="16"></TD>
</TR>
</TABLE>
<BR>
<?php

	$sql = "SELECT * FROM USERS WHERE AUTHORITY='admin'";
	$res = pg_query( $hDB_trackinformation, $sql );
	if ( pg_num_rows( $res ) == 0 ) {
		print "<INPUT TYPE=\"submit\" NAME=\"new_admin\" VALUE=\"Create New Administrator\" ALIGN=\"right\">";
	}
	else {
		print "<INPUT TYPE=\"submit\" NAME=\"login\" VALUE=\"login\" ALIGN=\"right\">";
	}
?>
</FORM>
</BODY>
</HTML>

<?php
	ob_end_flush();
  }
?>
