<?php
  require_once 'browser_common.php';
  require_once 'browser_keyword_sary.php';

  assert( isset($_POST) && is_array($_POST) );
  assert( ! array_key_exists('_keyword',$_POST) || is_string($_POST['_keyword']) );
  assert( ! array_key_exists('_species',$_POST) || is_string($_POST['_species']) );
  assert( ! array_key_exists('_revision',$_POST) || is_string($_POST['_revision']) );
  assert( ! array_key_exists('_keykinds',$_POST) || is_array($_POST['_keykinds']) );

  $searchparam = $_SESSION['browser']['searchparam'];
  if( strlen($_POST['_keyword']) > 0 )  { $searchparam['keyword']  = $_POST['_keyword']; }
  if( strlen($_POST['_species']) > 0 )  { $searchparam['species']  = $_POST['_species']; }
  if( strlen($_POST['_revision']) > 0 ) { $searchparam['revision'] = $_POST['_revision']; }
  if( array_key_exists('_clear_keykinds',$_POST) ) { $searchparam['keykinds'] = array(); }
  if( array_key_exists('_keykinds',$_POST) )       { $searchparam['keykinds'] = $_POST['_keykinds']; }
  $searchparam['keyword'] = mb_convert_kana( $searchparam['keyword'], 'as', 'SJIS' );
  $searchparam['keyword'] = mb_convert_kana( $searchparam['keyword'], 'as', 'EUC-JP' );
  $searchparam['keyword'] = mb_convert_kana( $searchparam['keyword'], 'as', 'UTF-8' );
  $searchparam['keyword'] = trim( $searchparam['keyword'] );

  // save keyword to logfile
  $keyword_logfile = $utgb_log_dir."/browser_keyword_log";
	if ( file_exists($keyword_logfile) == FALSE ) {
		touch($keyword_logfile);
	}
	
  if( strlen($keyword_logfile) > 0 && strlen($_POST['_keyword']) > 0 ) {
    $logfile = fopen( $keyword_logfile, 'a' );
    if( $logfile ) {
      $keyword = $_POST['_keyword'];
      $datestr = strftime( '%Y/%m/%d %H:%M:%S' );
      fputs( $logfile, sprintf( '%s,%s,"%s"'."\n", $datestr, $_SERVER['REMOTE_ADDR'], $keyword ) );
      fclose( $logfile );
    }
  }

  // Error Check
  $err = array();
  if( strlen($searchparam['keyword']) == 0 ) {
    $err[] = 'Keyword is blank.';
  }
  if( count($err) > 0 ) {
    $_SESSION['browser']['error'] = $err;
    header( 'Location: browser_keyword.php?' . htmlspecialchars(SID) );
    return;
  }
  else {
    unset( $_SESSION['browser']['error'] );
  }

  // Target & Position Search
  if( preg_match( '/^(\w+):(\d+)-(\d+)$/', $searchparam['keyword'], $match ) ) {
    $targetlen = get_targetlen( $searchparam['species'], $searchparam['revision'], $match[1] );
    if( isset($targetlen) ) {
      $url = "browser_frameoper_proxy.php?" . htmlspecialchars(SID)
                                            . "&setspecies="  . $searchparam['species']
                                            . "&setrevision=" . $searchparam['revision']
                                            . "&settarget="   . $match[1]
                                            . "&setstart="    . $match[2]
                                            . "&setend="      . $match[3];
      $_SESSION['browser']['searchparam'] = $searchparam;
      header( 'Location: ' . $url );
      return;
    }
  }
  elseif( preg_match( '/^(\w+)$/', $searchparam['keyword'], $match ) ) {
    $targetlen = get_targetlen( $searchparam['species'], $searchparam['revision'], $match[1] );
    if( isset($targetlen) ) {
      $url = "browser_frameoper_proxy.php?" . htmlspecialchars(SID)
                                            . "&setspecies="  . $searchparam['species']
                                            . "&setrevision=" . $searchparam['revision']
                                            . "&settarget="   . $match[1]
                                            . "&setstart="    . 1
                                            . "&setend="      . $targetlen;
      $_SESSION['browser']['searchparam'] = $searchparam;
      header( 'Location: ' . $url );
      return;
    }
  }

  // Keyword Search
  if( count($searchparam['keykinds']) > 0 ) {
    $too_many_hits = FALSE;
    $dbconn = pg_connect( $keywordsearch_connection_string );
    assert( $dbconn );
    $sql  = "SELECT kkkid FROM knownkeykind WHERE species='" . $searchparam['species'] . "' and revision='". $searchparam['revision'] ."' and ";
    $sql .= '(' . implode( ' or ', array_map( 'map_keykind2sql', $searchparam['keykinds'] ) ) . ');';
    error_log( $sql );
    $res = pg_query( $dbconn, $sql );
    $genes = array();
    while( $col = pg_fetch_assoc($res) ) {
      $keywords = browser_keyword_sary_search( (int)$col['kkkid'], $searchparam['keyword'] );
      if( is_array($keywords) ) {
        foreach( $keywords as $keyword ) {
          $rr = pg_query( $dbconn, "SELECT * FROM keyword NATURAL JOIN gene WHERE kkkid=" . $col['kkkid'] . " and keyword='" . $keyword . "';" );
          while( $cc = pg_fetch_assoc($rr) ) {
            $gene = $cc;
            $gid  = $gene['gid'];
            $locations = array();
            $r = pg_query( $dbconn, "SELECT * FROM location WHERE gid=$gid;" );
            while( $c = pg_fetch_assoc($r) ) { $locations[] = $c; }
            $gene['locations'] = $locations;
            $genes[] = $gene;
            if( count($genes) >= 1000 ) { $too_many_hits = TRUE;  break 3; }
          }
        }
      }
    }
  }

  // save session
  $_SESSION['browser']['searchparam']                   = $searchparam;
  $_SESSION['browser']['searchresult']                  = array();
  $_SESSION['browser']['searchresult']['genes']         = $genes;
  $_SESSION['browser']['searchresult']['too_many_hits'] = $too_many_hits;

  header( 'Location: browser_keyword_genes.php?' . htmlspecialchars(SID) );

  function map_keykind2sql( $val ) {
    return "keykind='$val'";
  }
?>
