<?php
  require_once 'browser_common.php';

  assert( isset($_REQUEST['gid']) && is_numeric($_REQUEST['gid']) );

  // load session
  $dispparam   = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks      = $_SESSION['browser']['tracks'][$s][$r];
  $searchparam = $_SESSION['browser']['searchparam'];
  $genes       = $_SESSION['browser']['searchresult']['genes'];

  $gid = $_REQUEST['gid'];

  // find gene that has $gid in session
  foreach( $genes as $g ) {
    if( $g['gid'] == $gid ) {
      $gene = $g;
      if( preg_match( '/\/gb=([\S]+)/', $gene['annotation'] , $match ) )  { $gb = $match[1]; }
      elseif( preg_match( '/^>([\S]+)/', $gene['annotation'] , $match ) ) { $gb = $match[1]; }
      break;
    }
  }
  assert( isset($gene) );

  $locations = $gene['locations'];
  assert( is_array($locations) );
  assert( count($locations) >= 1 );

  // set 'foundGene' optional attribute to mappedGene track if $gb is available
  if( isset($gb) ) {
    for( $i=0 ; $i<count($tracks) ; $i++ ) {
      if( $tracks[$i]['name'] == 'mappedGene' ) {
        $tracks[$i]['optparam']['foundGene'] = $gb;
        $_SESSION['browser']['tracks'][$s][$r] = $tracks;
        break;
      }
    }
  }

  // sort if needed and possible
  if( count($locations) >= 2 && array_key_exists('sortkey',$_GET) && $_GET['sortkey'] && isset($locations[0][$_GET['sortkey']]) ) {
    $sk = $_GET['sortkey'];
    if( $_GET['sortrev'] ) {
      $cmpfunc = "function gene_cmp(\$a,\$b) { if (\$a['$sk']==\$b['$sk']) { return 0; } else { return (\$a['$sk']<\$b['$sk']) ? 1 : -1; } }";
    }
    else {
      $cmpfunc = "function gene_cmp(\$a,\$b) { if (\$a['$sk']==\$b['$sk']) { return 0; } else { return (\$a['$sk']<\$b['$sk']) ? -1 : 1; } }";
    }
    eval( $cmpfunc );
    usort( $locations, 'gene_cmp' );
  }

  // jump to browser if there is only one location
  if( count($locations) == 1 ) {
    $loc = $locations[0];
    $url = "browser_frameoper_proxy.php?" . htmlspecialchars(SID)
                                          . "&setspecies="  . $searchparam['species']
                                          . "&setrevision=" . $searchparam['revision']
                                          . "&settarget="   . $loc['target']
                                          . "&setstart="    . $loc['t_start']
                                          . "&setend="      . $loc['t_end'];
    header( 'Location: ' . $url );
    return;
  }

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>UT Genome Browser Search Results</TITLE>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>
<H1>UT Genome Browser Search Results</H1>
<H3>gene [<?php print $gb; ?>] is mapped to <?php print count($locations); ?> locations</H3>
<FORM method="POST" action="browser_keyword_proxy.php?<?php print htmlspecialchars(SID); ?>">
<H4 align="center">keyword: <?php print_input_text( '_keyword', $searchparam['keyword'], 30 ); ?>
 <INPUT type="submit" name="apply" value="Search">
</H4>
</FORM>
<P align="center"><A href="browser_keyword_genes.php?<?php print htmlspecialchars(SID); ?>">(back)</A>
<A href="browser_keyword.php?<?php print htmlspecialchars(SID); ?>">(top)</A>
<A href="browser_keyword.php?<?php print htmlspecialchars(SID); ?>&clear=1">(clear)</A></P>
<?php if( count($locations) > 0 ) { ?>
<CENTER>
<TABLE>
  <TBODY>
    <TR>
      <TH>&nbsp;</TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=target&gid=<?php print $gid; ?>">Target</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=t_start&gid=<?php print $gid; ?>">Range</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=cover&gid=<?php print $gid; ?>">Cover ratio</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=match&gid=<?php print $gid; ?>">Match ratio</A></TH>
    </TR>
    <?php
      foreach( $locations as $loc ) {
        $url = "browser_frameoper_proxy.php?" . htmlspecialchars(SID)
                                              . "&setspecies="  . $searchparam['species']
                                              . "&setrevision=" . $searchparam['revision']
                                              . "&settarget="   . $loc['target']
                                              . "&setstart="    . $loc['t_start']
                                              . "&setend="      . $loc['t_end'];
        print "<TR>";
        print "<TD><A href=\"$url\">(*)</A></TD>";
        print "<TD>" . $loc['target'] . "</TD>";
        print "<TD>" . $loc['t_start'] . " - " . $loc['t_end'] . "</TD>";
        print "<TD>" . sprintf( '%3.2f', $loc['cover'] ) . "</TD>";
        print "<TD>" . sprintf( '%3.2f', $loc['match'] ) . "</TD>";
        print "</TR>";
      }
    ?>
  </TBODY>
</TABLE>
</CENTER>
<?php } ?>
</BODY>
</HTML>
