<?php
  require_once 'browser_common.php';

  // load session
  $searchparam   = $_SESSION['browser']['searchparam'];
  $genes         = $_SESSION['browser']['searchresult']['genes'];
  $too_many_hits = $_SESSION['browser']['searchresult']['too_many_hits'];

  $accept_species = load_accept_species();

  // add additional information of genes
  for( $i=0 ; $i<count($genes) ; $i++ ) {
    if( preg_match( '/\/len=([\S]+)/',   $genes[$i]['annotation'] , $match ) ) { $genes[$i]['len']   = $match[1]; }
    if( preg_match( '/\/clone=([\S]+)/', $genes[$i]['annotation'] , $match ) ) { $genes[$i]['clone'] = $match[1]; }
    if( preg_match( '/\/gb=([\S]+)/',    $genes[$i]['annotation'] , $match ) ) { $genes[$i]['gb']    = $match[1]; }
    if( preg_match( '/\/gi=([\S]+)/',    $genes[$i]['annotation'] , $match ) ) { $genes[$i]['gi']    = $match[1]; }
    if( preg_match( '/\/ug=([\S]+)/',    $genes[$i]['annotation'] , $match ) ) { $genes[$i]['ug']    = $match[1]; }
    $genes[$i]['matchcnt'] = count( $genes[$i]['locations'] );
    if( $genes[$i]['matchcnt'] == 1 ) {
      $genes[$i]['match']    = $genes[$i]['locations'][0]['match'];
      $genes[$i]['cover']    = $genes[$i]['locations'][0]['cover'];
      $genes[$i]['target']   = $genes[$i]['locations'][0]['target'];
      $genes[$i]['range']    = $genes[$i]['locations'][0]['t_start'] . ' - ' . $genes[$i]['locations'][0]['t_end'];
    }
  }

  // sort if needed and possible
  if( count($genes) >= 2 && array_key_exists('sortkey',$_GET) && array_key_exists($_GET['sortkey'],$genes[0]) ) {
    $sk = $_GET['sortkey'];
    if( $_GET['sortrev'] ) {
      $cmpfunc = "function gene_cmp(\$a,\$b) { if (\$a['$sk']==\$b['$sk']) { return 0; } else { return (\$a['$sk']<\$b['$sk']) ? 1 : -1; } }";
    }
    else {
      $cmpfunc = "function gene_cmp(\$a,\$b) { if (\$a['$sk']==\$b['$sk']) { return 0; } else { return (\$a['$sk']<\$b['$sk']) ? -1 : 1; } }";
    }
    eval( $cmpfunc );
    usort( $genes, 'gene_cmp' );
  }

  // jump to location information if there is only one gene
  if( count($genes) == 1 ) {
    $gene = $genes[0];
    $url = "browser_keyword_locations.php?" . htmlspecialchars(SID) . "&gid=" . $gene['gid'];
    header( 'Location: ' . $url );
    return;
  }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>UT Genome Browser</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<SCRIPT language="JavaScript">
<!--
  <?php print_revisions_by_species_javascript_code($accept_species); ?>
// -->
</SCRIPT>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>
<H1>UT Genome Browser Search Results</H1>
<?php
  if( $too_many_hits ) {
    print "<H3> too mamy hits (only " . count($genes) . " genes are displayed).</H3>";
  }
  else {
    print "<H3>" . count($genes) . " hits.</H3>";
  }
?>
<FORM method="POST" action="browser_keyword_proxy.php?<?php print htmlspecialchars(SID); ?>"><CENTER>
keyword: <?php print_input_text( '_keyword', $searchparam['keyword'], 30 ); ?>
 species: <?php print_input_select( '_species', array_keys($accept_species), $searchparam['species'], array('onChange'=>'reloadRevisionSelect(this,this.form._revision);') ); ?>
 revision: <?php print_input_select( '_revision', $accept_species[$searchparam['species']], $searchparam['revision'] ); ?>
 <INPUT type="submit" name="apply" value="Search">
</CENTER></FORM>
<P align="center"><A href="browser_keyword.php?<?php print htmlspecialchars(SID); ?>">(back)</A>
<A href="browser_keyword.php?<?php print htmlspecialchars(SID); ?>&clear=1">(clear)</A></P>
<?php if( count($genes) > 0 ) { ?>
<CENTER>
<TABLE>
  <TBODY>
    <TR>
      <TH>&nbsp;</TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=keyword">Keyword</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=len">Length</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=matchcnt">Match Cnt</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=target">Target</A></TH>
      <TH>Match Range</TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=match">Match Ratio</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=cover">Cover Ratio</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=clone">Clone</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=gi">Genbank Acc</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=gb">GI Number</A></TH>
      <TH><A href="?<?php print SID; print array_key_exists('sortrev',$_GET) && $_GET['sortrev'] ? '&sortrev=0' : '&sortrev=1'; ?>&sortkey=ug">Unigene Cluster ID</A></TH>
      <TH>Annotation</TH>
    </TR>
    <?php
      foreach( $genes as $gene ) {
        $url = "browser_keyword_locations.php?" . htmlspecialchars(SID) . "&gid=" . $gene['gid'];
        print "<TR>";
        print "<TD><A href=\"$url\">(*)</A></TD>";
        print "<TD>" . $gene['keyword'] . "</TD>";
        print isset($gene['len'])      ? "<TD>".$gene['len']."</TD>"      : "<TD>&nbsp;</TD>";
        print isset($gene['matchcnt']) ? "<TD>".$gene['matchcnt']."</TD>" : "<TD>&nbsp;</TD>";
        print isset($gene['target'])   ? "<TD>".$gene['target']."</TD>"   : "<TD>&nbsp;</TD>";
        print isset($gene['range'])    ? "<TD>".$gene['range']."</TD>"    : "<TD>&nbsp;</TD>";
        print isset($gene['match'])    ? "<TD>".$gene['match']."</TD>"    : "<TD>&nbsp;</TD>";
        print isset($gene['cover'])    ? "<TD>".$gene['cover']."</TD>"    : "<TD>&nbsp;</TD>";
        print isset($gene['clone'])    ? "<TD>".$gene['clone']."</TD>"    : "<TD>&nbsp;</TD>";
        print isset($gene['gb'])       ? "<TD>".$gene['gb']."</TD>"       : "<TD>&nbsp;</TD>";
        print isset($gene['gi'])       ? "<TD>".$gene['gi']."</TD>"       : "<TD>&nbsp;</TD>";
        print isset($gene['ug'])       ? "<TD>".$gene['ug']."</TD>"       : "<TD>&nbsp;</TD>";
        print "<TD nowrap>" . $gene['annotation'] . "</TD>";
        print "</TR>";
      }
    ?>
  </TBODY>
</TABLE>
</CENTER>
<?php } ?>
</BODY>
</HTML>
