<?php
  require_once 'browser_common.php';
  require_once 'browser_manage_common.php';
	
  $accept_species = load_accept_species();

  assert( isset($accept_species) );
  assert( is_array($accept_species) );
  assert( count($accept_species) > 0 );

  // load session
  $searchparam = array_key_exists('browser',$_SESSION) && array_key_exists('searchparam',$_SESSION['browser']) ? $_SESSION['browser']['searchparam'] : NULL;
  if( is_null($searchparam) || array_key_exists( 'clear', $_REQUEST ) ) {

// 2005.5.19 modify t.shishiki ---------------------------------------------------------
    $dispparam = load_disparam();
    $searchparam = array();
    $searchparam['keyword']  = '';
    $searchparam['species']  = $dispparam['species'];
    $searchparam['revision'] = $dispparam['revision'];
    $_SESSION['browser']['searchparam']   = $searchparam;
		$_SESSION['browser']['dispparam']     = $dispparam;
  }
	//*** GET ALL TRACKS ***
	foreach ( $accept_species as $species => $revisions ) {
		foreach ( $revisions as $i => $revision ) {
			$TRACKS =load_tracks_from_trackinformation($species,$revision);
			$tracks = $TRACKS['tracks'];
			$removedtracks = $TRACKS['removedtracks'];
			$_SESSION['browser']['tracks'][$species][$revision]        = $tracks;
			$_SESSION['browser']['removedtracks'][$species][$revision] = $removedtracks;
		}
	}
//--------------------------------------------------------------------------------------

  $dbconn = pg_connect( $keywordsearch_connection_string );
  assert( $dbconn );

  $keykinds = load_keyword_kinds();
  if( ! array_key_exists('keykinds',$searchparam) || is_null($searchparam['keykinds']) ) { $searchparam['keykinds'] = $keykinds[$searchparam['species']][$searchparam['revision']]; }
?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=US-ASCII">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>UT Genome Browser</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<SCRIPT language="JavaScript">
<!--
  <?php print_revisions_by_species_javascript_code($accept_species); ?>
  <?php print_keywkinds_javascript_code($keykinds); ?>
// -->
</SCRIPT>
<LINK rel="stylesheet" href="style/style.css" type="text/css">
</HEAD>
<BODY>


<P align="center"><IMG src="picture/UTGB_logo_browser.jpg" width="600" height="165" border="0" alt="University of Tokyo Genome Browser"></P>

<?php
  $err = array_key_exists( 'error', $_SESSION['browser'] ) ? $_SESSION['browser']['error'] : NULL;
  if( is_array($err) && count($err) > 0 ) {
    print "<HR>";
    print "<P align=\"center\">";
    foreach( $err as $e ) {
      print "<FONT color=\"#ff0000\"><B>$e</B></FONT><BR>";
    }
    print "</P>";
  }
?>
<H3>Keyword Search</H3>
<CENTER>
<FORM method="POST" action="browser_keyword_proxy.php?<?php print htmlspecialchars(SID); ?>">
<TABLE>
  <COL span="1" width="50%">
  <TBODY>
    <TR>
      <TD align="center" class="noclor">
      <TABLE>
        <TBODY>
          <TR>
            <TH>Keyword</TH>
            <TD><?php print_input_text( '_keyword', $searchparam['keyword'], 30 ); ?>
            <INPUT type="submit" value="Search"></TD>
          </TR>
          <TR>
            <TH>Species</TH>
            <TD><?php print_input_select( '_species', array_keys($accept_species), $searchparam['species'], array('onChange'=>"reloadRevisionSelect(this,this.form._revision); reloadKeykindSelect(this,this.form._revision,document.getElementById('keywordserach_keykinds'));") ); ?></TD>
          </TR>
          <TR>
            <TH>Revision</TH>
            <TD><?php print_input_select( '_revision', $accept_species[$searchparam['species']], $searchparam['revision'], array('onChange'=>"reloadKeykindSelect(this.form._species,this,document.getElementById('keywordserach_keykinds'));") ); ?></TD>
          </TR>
          <TR>
            <TH>Keykinds</TH>
            <TD id="keywordserach_keykinds"><?php if( array_key_exists($searchparam['species'],$keykinds) && array_key_exists($searchparam['revision'],$keykinds[$searchparam['species']]) && is_array($keykinds[$searchparam['species']][$searchparam['revision']]) ) { print_input_checkbox( '_keykinds', $keykinds[$searchparam['species']][$searchparam['revision']], $searchparam['keykinds'], '<BR>' ); } ?></TD>
          </TR>
        </TBODY>
      </TABLE>
      </TD>
    </TR>
  </TBODY>
</TABLE>
<INPUT type="hidden" name="_clear_keykinds" value="1">
</FORM>
</CENTER>
<CENTER>
<FORM method="POST" action="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID); ?>">
<TABLE border=0>
  <TBODY>
    <TR>
      <TH>Custom Track URL</TH>
      <TD>
      <?php print_input_select( 'setspecies', array_keys($accept_species), $dispparam['species'], array('onChange'=>'reloadRevisionSelect(this,this.form.setrevision);') ); ?>
      </TD>
      <TD>
      <?php print_input_select( 'setrevision', $accept_species[$dispparam['species']], $dispparam['revision'] ); ?>
      </TD>
      <TD>
      <INPUT size="40" type="text" name="addtrack"> <INPUT type="submit" name="add" value="Add"><INPUT type="hidden" name="referer" value="<?php print $_SERVER['PHP_SELF'].'?'.htmlspecialchars(SID); ?>">
      </TD>
    </TR>
  </TBODY>
</TABLE>
</FORM>
</CENTER>
</BODY>
</HTML>
