<?php
  require_once 'browser_common.php';
  require_once 'browser_manage_common.php';

  // load session
  $dispparam = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks    = $_SESSION['browser']['tracks'][$s][$r];

  $zoom = $dispparam['width'] / ( abs( $dispparam['start'] - $dispparam['end'] ) + 1 );
  $referer = array_key_exists('referer',$_REQUEST) ? $_REQUEST['referer'] : NULL;

  $species_target  = array_key_exists('setspecies', $_REQUEST)  ? $_REQUEST['setspecies']  : $dispparam['species'];
  $revision_target = array_key_exists('setrevision',$_REQUEST) ? $_REQUEST['setrevision'] : $dispparam['revision'];
  $target_target   = array_key_exists('settarget',  $_REQUEST)   ? $_REQUEST['settarget']   : $dispparam['target'];

  // process operations
  $error = array();
  foreach( $_REQUEST as $key => $val ) {
    switch($key) {
    case 'moverel':
      assert( is_numeric($val) );
      $dispparam['start'] += $val;
      $dispparam['end']   += $val;
      break;
    case 'moveabs':
      assert( is_numeric($val) );
      $start = $dispparam['start'];
      $end   = $dispparam['end'];
      if( $dispparam['start'] < $dispparam['end'] ) {
        $dispparam['start'] = $val - abs($start-$end) / 2;
        $dispparam['end']   = $val + abs($start-$end) / 2;
      }
      else {
        $dispparam['start'] = $val + abs($start-$end) / 2;
        $dispparam['end']   = $val - abs($start-$end) / 2;
      }
      break;
    case 'zoomrel':
      assert( is_numeric($val) );
      $zoom *= $val;
      $start = $dispparam['start'];
      $end   = $dispparam['end'];
      if( $dispparam['start'] < $dispparam['end'] ) {
        $dispparam['start'] = ($start+$end) / 2 - $dispparam['width'] / $zoom / 2;
        $dispparam['end']   = ($start+$end) / 2 + $dispparam['width'] / $zoom / 2;
      }
      else {
        $dispparam['start'] = ($start+$end) / 2 + $dispparam['width'] / $zoom / 2;
        $dispparam['end']   = ($start+$end) / 2 - $dispparam['width'] / $zoom / 2;
      }
      break;
    case 'zoomabs':
      assert( is_numeric($val) );
      $zoom  = $val;
      $start = $dispparam['start'];
      $end   = $dispparam['end'];
      if( $dispparam['start'] < $dispparam['end'] ) {
        $dispparam['start'] = ($start+$end) / 2 - $dispparam['width'] / $zoom / 2;
        $dispparam['end']   = ($start+$end) / 2 + $dispparam['width'] / $zoom / 2;
      }
      else {
        $dispparam['start'] = ($start+$end) / 2 + $dispparam['width'] / $zoom / 2;
        $dispparam['end']   = ($start+$end) / 2 - $dispparam['width'] / $zoom / 2;
      }
      break;
    case 'rev':
      $tmp = $dispparam['start'];
      $dispparam['start'] = $dispparam['end'];
      $dispparam['end'] = $tmp;
      break;
    case 'setspecies':
      if( is_numeric( get_targetlen($val,$revision_target,$target_target) ) ) {
        $s = $dispparam['species'] = $val;
        $tracks = $_SESSION['browser']['tracks'][$s][$r];
      }
      else {
        $error[] = "Bad species: $val,$revision_target,$target_target";
      }
      break;
    case 'setrevision':
      if( is_numeric( get_targetlen($species_target,$val,$target_target) ) ) {
        $r = $dispparam['revision'] = $val;
        $tracks = $_SESSION['browser']['tracks'][$s][$r];
      }
      else {
        $error[] = "Bad revision: $val";
      }
      break;
    case 'settarget':
      if( is_numeric( get_targetlen($species_target,$revision_target,$val) ) ) {
        $dispparam['target'] = $val;
      }
      else {
        $error[] = "No such target : $val";
      }
      break;
    case 'setstart':
      if( ! is_numeric($val) ) {
        $error[] = "Start position must be number: $val";
      }
      elseif( $val <= 0 ) {
        $error[] = "Start position must be > 0: $val";
      }
      else {
        $dispparam['start'] = $val;
      }
      break;
    case 'setend':
      if( ! is_numeric($val) ) {
        $error[] = "End position must be number: $val";
      }
      elseif( $val <= 0 ) {
        $error[] = "End position must be > 0: $val";
      }
      else {
        $dispparam['end'] = $val;
      }
      break;
    case 'clearstartend':
      $dispparam['start'] = 1;
      $dispparam['end'] = get_targetlen($species_target,$revision_target,$target_target);
      break;
    case 'setwidth':
      if( ! is_numeric($val) ) {
        $error[] = "Width must be number: $val";
      }
      elseif( $val <= 0 ) {
        $error[] = "Width must be > 0: $val";
      }
      else {
        $dispparam['width'] = $val;
      }
      break;
    case 'deltrackbynum':
      if( is_numeric($val) ) {
        array_splice( $tracks, $val, 1 );
      }
      break;
    case 'restoredefaulttrack':
      $default_viewpoint = load_default_viewpoint();
      $tracks = $default_viewpoint['tracks'];
      break;
    case 'restoredefaultdispparam':
      $default_viewpoint = load_default_viewpoint();
      $dispparam = $default_viewpoint['dispparam'];
      break;
    case 'adddistincttrack':
      if( is_string($val) ) {
        foreach( $tracks as $track ) {
          if( $track['url'] == $val ) {
            break 2;
          }
        }
      }
    case 'addtrack':
      if( is_string($val) ) {
        $track_url = $val;

        $xmlstr = http_get( $track_url );
        if( is_null($xmlstr) ) {
          $error[] = "Failed to load track URL: $val";
          continue;
        }
        $parsed_track = parse_track_xml( $xmlstr );
        if( is_null($parsed_track) ) {
          $error[] = "Failed to parse track URL: $val";
          continue;
        }

        $track = array();
        $track['url']             = $track_url;
        $track['name']            = $parsed_track['name'];
        $track['description_url'] = $parsed_track['description_url'];
        $track['comment']         = $parsed_track['comment'];
        $track['layers']          = $parsed_track['layers'];
        $track['optattr']         = parse_optattr( $parsed_track['optattr'] );
        $track['optparam']        = $trk['optparams'];

        $tracks[] = $track;
      }
      break;
    case 'uptrack':
      if( is_numeric($val) && array_key_exists($val,$tracks) && array_key_exists($val-1,$tracks) ) {
        $tmp = $tracks[$val-1];
        $tracks[$val-1] = $tracks[$val];
        $tracks[$val] = $tmp;
				save_tracks_order($tracks,$s,$r,$_SESSION['login']['user_id']);				
      }
      break;
    case 'downtrack':
      if( is_numeric($val) && array_key_exists($val,$tracks) && array_key_exists($val+1,$tracks) ) {
        $tmp = $tracks[$val+1];
        $tracks[$val+1] = $tracks[$val];
        $tracks[$val] = $tmp;
				save_tracks_order($tracks,$s,$r,$_SESSION['login']['user_id']);				
      }
      break;
    }
  }

  // correct display parameters
  $dispparam = correct_dispparam( $dispparam );

  // save loaded values to session
  $_SESSION['browser']['tracks'][$s][$r] = $tracks;
  $_SESSION['browser']['dispparam']      = $dispparam;
  $_SESSION['browser']['error']          = $error;

  if( strlen($referer) > 0 ) {
    header( 'Location: ' . $referer );
    return;
  }
  else {
    header( 'Location: browser.php?' . htmlspecialchars(SID) );
    return;
  }
?>
