<?php
  require_once 'browser_common.php';

  // load session
  $dispparam   = $_SESSION['browser']['dispparam'];
    $s = $dispparam['species'];
    $r = $dispparam['revision'];
  $tracks      = $_SESSION['browser']['tracks'][$s][$r];

  $species  = $dispparam['species'];
  $revision = $dispparam['revision'];
  $target   = $dispparam['target'];
  $start    = $dispparam['start'];
  $end      = $dispparam['end'];
  $width    = $dispparam['width'];

  $targetlen = get_targetlen( $species, $revision, $target );
  $seqlen    = abs($start-$end)+1;

  $fontsize  = 10;
  $fontfile  = './fonts/Abadi MT Condensed Light.ttf';

  if( $targetlen == $seqlen ) { $name = "$species-$revision-$target"; }
  else                        { $name = "$species-$revision-$target($start-$end)"; }

  header( 'Content-Type: image/png' );
  header( 'Content-Disposition: inline; filename="' . $name . '.png"' );

  $indeximages   = array();
  $graphicimages = array();
  $maxtitlewidth = 0;
  $maxindexwidth = 0;
  $totalheight = 0;
  foreach( $tracks as $tracknum => $track ) {
    $query4thistrack_str = query2string( gen_track_query( $track, $dispparam ) );
    if( $track['layers']['index'] ) {
      $index_layer_url = $track['layers']['index']['url'].'?'.$query4thistrack_str;
      $image = create_image_from_url( $index_layer_url );
      if( isset($image) ) {
        $indeximages[$tracknum] = $image;
        $maxindexwidth = max( $maxindexwidth, $image['size'][0] );
      }
    }
    if( strlen($track['name']) > 0 ) {
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $track['name'] );
      $maxtitlewidth = max( $maxtitlewidth, $strbox[2] - $strbox[0] );
    }
    $graphic_layer_url = $track['layers']['graphic']['url'].'?'.$query4thistrack_str;
    $image = create_image_from_url( $graphic_layer_url );
    if( isset($image) ) {
      $graphicimages[$tracknum] = $image;
      if( $image['size'][0] == $width ) {
        $totalheight += $image['size'][1];
      }
      else {
        $totalheight += $image['size'][1] * $width / $image['size'][0];
      }
    }
  }

  $outimg = imagecreatetruecolor( $maxtitlewidth+$maxindexwidth+$width, $totalheight );
  $bkColor = imagecolorallocate( $outimg, 0xFF, 0xFF, 0xFF );
  imagefilledrectangle( $outimg, 0, 0, $maxtitlewidth+$maxindexwidth+$width-1, $totalheight-1, $bkColor );

  $thisheight = 0;
  foreach( $graphicimages as $tracknum => $graphicimage ) {
    $thistrackheight = ( $graphicimage['size'][0] == $width ) ? ( $graphicimage['size'][1] ) : ( $graphicimage['size'][1] * $width / $graphicimage['size'][0] );
    if( isset($indeximages[$tracknum]) ) {
      $indeximage = $indeximages[$tracknum];
      imagecopy( $outimg, $indeximage['image'], $maxtitlewidth, $thisheight, 0, 0, $indeximage['size'][0], $indeximage['size'][1] );
    }
    if( strlen($tracks[$tracknum]['name']) > 0 ) {
      $strbox = imagettfbbox( $fontsize, 0, $fontfile, $tracks[$tracknum]['name'] );
      $thistitlewidth = $strbox[2] - $strbox[0];
      imagettftext( $outimg, $fontsize, 0, $maxtitlewidth/2-$thistitlewidth/2, $thisheight+$thistrackheight/2-$strbox[7]/2, $charColor, $fontfile, $tracks[$tracknum]['name'] );
    }
    if( $graphicimage['size'][0] == $width ) {
      imagecopy( $outimg, $graphicimage['image'], $maxtitlewidth+$maxindexwidth, $thisheight, 0, 0, $graphicimage['size'][0], $graphicimage['size'][1] );
    }
    else {
      imagecopyresized( $outimg, $graphicimage['image'], $maxtitlewidth+$maxindexwidth, $thisheight, 0, 0, $width, $thistrackheight, $graphicimage['size'][0], $graphicimage['size'][1] );
    }
    $thisheight += $thistrackheight;
  }

  imagepng( $outimg );
?>
