<?php
  require_once 'browser_common.php';

  // load session
  $dispparam = $_SESSION['browser']['dispparam'];

  $species  = $dispparam['species'];
  $revision = $dispparam['revision'];
  $target   = $dispparam['target'];
  $start    = $dispparam['start'];
  $end      = $dispparam['end'];
  $width    = $dispparam['width'];

  $seq = get_targetseq( $species, $revision, $target );
  assert( $seq );
  assert( preg_match( '/^[ATGCN]*$/', $seq ) );
  $targetlen = strlen($seq);
  $seqlen    = abs($start-$end)+1;

  if( $targetlen == $seqlen ) {
    $name = "$species-$revision-$target";
  }
  else {
    $name = "$species-$revision-$target($start-$end)";
  }

  header( 'Content-Type: text/plain' );
  header( 'Content-Disposition: inline; filename="' . $name . '.fasta"' );

  print ">$name /len=$seqlen\n";
  if( $start <= $end ) {
    $seq = substr( $seq, $start-1, abs($start-$end)+1 );
  }
  else {
    $seq = inv_nseq( substr( $seq, $end-1, abs($start-$end)+1 ) );
  }
  $seq = preg_replace( '/([ATGCN]{1,73})/', "$1\n", $seq );
  print $seq;
?>
