function openOptAttrConfigWindow( sid, name ) {
  window.open( 'browser_optattr_configwin.php?'+sid+'&tracknum='+name, 'config_'+name, 'width=640,height=480,scrollbars=yes,resizable=yes' );
}

function applyOptAttrConfig( sid, tracknum, form ) {
  var reqstr = form2getstr( form );
  window.opener.location.replace( 'browser_optattr_proxy.php?' + sid + '&tracknum=' + tracknum + '&' + reqstr );
}

function openTrackListWindow( sid ) {
  var temp;
  temp = window.open( 'browser_tracklist.php?'+sid, 'tracklist', 'width=760,height=530,scrollbars=yes,resizable=yes' );
  temp.focus();
}

function openTrackHistoryWindow( sid, tid ) {

  var temp;
  temp = window.open( 'browser_manage_history.php?'+sid+'&tid='+tid, 'track_history', 'width=320,height=240,scrollbars=yes,resizable=yes' );
  temp.focus();
}

function openUserAuthWindow( sid, tracknum,forward,auth_mode  ) {
  var temp;
  temp = window.open( 'browser_manage_user_auth.php?'+sid+'&tracknum='+tracknum+'&auth_mode='+auth_mode, 'user_auth', 'width=380,height=250,scrollbars=yes,resizable=yes' );
  temp.focus();
}

function openUserModifyWindow( sid, uid ) {
  var temp;
  temp = window.open( 'browser_manage_translate_modify_user.php?'+sid+'&uid='+uid, 'user_modification', 'width=380,height=250,scrollbars=yes,resizable=yes' );
  temp.focus();
}

function reloadParentWindow() {
  window.opener.location.reload();
}

function close_and_parent_reload() {
    window.opener.location.reload();
    window.close();
}

///////////////////////////////////////////////////////////////////////////////
// [form2getstr]
///////////////////////////////////////////////////////////////////////////////
function form2getstr( form ) {
  var inputs = form.elements;
  var reqstr = '';
  for( var i=0 ; i<inputs.length ; i++ ) {
    if( inputs[i].type == 'checkbox' ) {
      reqstr += inputs[i].name + '=' + ( inputs[i].checked ? 'on' : 'off' ) + '&';
    }
    else if( inputs[i].type == 'radio' ) {
      if( inputs[i].checked ) {
        reqstr += inputs[i].name + '=' + inputs[i].value + '&';
      }
    }
    else if( inputs[i].value.length > 0 ) {
      reqstr += inputs[i].name + '=' + inputs[i].value + '&';
    }
    else {
      reqstr += inputs[i].name + '&';
    }
  }
  reqstr = reqstr.substr( 0, reqstr.length-1 );
  return reqstr;
}

///////////////////////////////////////////////////////////////////////////////
// [reloadRevisionSelect]
///////////////////////////////////////////////////////////////////////////////
function reloadRevisionSelect( species_select, revision_select ) {
  var target_species   = species_select.options[species_select.selectedIndex].value;
  var target_revisions = revisionsBySpecies[target_species];
  revision_select.options.length = 0;
  for( var i=0 ; i < target_revisions.length ; i++ ) {
    revision_select.options[revision_select.options.length] = new Option( target_revisions[i], target_revisions[i], false, false );
  }
}

///////////////////////////////////////////////////////////////////////////////
// [reloadKeykindSelect]
///////////////////////////////////////////////////////////////////////////////
function reloadKeykindSelect( species_select, revision_select, keykind_area ) {
  var target_species   = species_select.options[species_select.selectedIndex].value;
  var target_revisions = revision_select.options[revision_select.selectedIndex].value;
  while( keykind_area.childNodes.length > 0 ) { keykind_area.removeChild( keykind_area.firstChild ); }
  if( keywkinds != null && keywkinds[target_species] != null && keywkinds[target_species][target_revisions] != null ) {
    var target_keykinds = keywkinds[target_species][target_revisions];
    for( var i=0 ; i < target_keykinds.length ; i++ ) {
      var input = document.createElement('INPUT');
      input.setAttribute( 'type', 'checkbox' );
      input.setAttribute( 'name', '_keykinds[]' );
      input.setAttribute( 'value', target_keykinds[i] );
      input.setAttribute( 'checked', null );
      keykind_area.appendChild( input );
      keykind_area.appendChild( document.createTextNode( ' '+target_keykinds[i] ) );
      keykind_area.appendChild( document.createElement('BR') );
    }
    for( var i=0 ; i < keykind_area.childNodes.length ; i++ ) {
      if( keykind_area.childNodes[i].type == 'checkbox' ) {
        keykind_area.childNodes[i].checked = true;
      }
    }
  }
}



