<?php
require_once 'browser_common.php';
require 'browser_manage_common.php';

// load session
$dispparam   = $_SESSION['browser']['dispparam'];
$s = $dispparam['species'];
$r = $dispparam['revision'];

if ( isset($_SESSION['login']) ) {
	recompose_tracks($s,$r);
}
$tracks  = $_SESSION['browser']['tracks'][$s][$r];
$removedtracks = $_SESSION['browser']['removedtracks'][$s][$r];

$searchparam = $_SESSION['browser']['searchparam'];
$error       = (is_array($_SESSION['browser']))&& array_key_exists('error',$_SESSION['browser']) ? $_SESSION['browser']['error'] : NULL;

if( is_null($tracks) || is_null($dispparam) ) {
	header( 'Location: browser_clear.php?' . htmlspecialchars(SID) );
}
$accept_species = load_accept_species();

$species  = $dispparam['species'];
$revision = $dispparam['revision'];
$target   = $dispparam['target'];
$start    = $dispparam['start'];
$end      = $dispparam['end'];
$width    = $dispparam['width'];
$zoom     = $width / ( abs( $start - $end ) + 1 );
$thislen  = get_targetlen( $species, $revision, $target );
$rev      = ! ($start < $end);

?>
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<HTML>
<HEAD>
<META http-equiv="Content-Type" content="text/html; charset=UTF-8">
<META http-equiv="Content-Script-Type" content="text/javascript">
<META http-equiv="Content-Style-Type" content="text/css">
<TITLE>UT Genome Browser</TITLE>
<SCRIPT language="JavaScript" src="browser_common.js"></SCRIPT>
<SCRIPT language="JavaScript">
<!--
  <?php print_revisions_by_species_javascript_code($accept_species); ?>
// -->
</SCRIPT>
<SCRIPT language="JavaScript">
<!--
  var ie4 = ( document.all ) ? true : false;
  var nn4 = ( document.layers ) ? true : false;
  var nn6 = ( ! document.all && document.getElementById ) ? true : false;
  var mac = ( navigator.userAgent.indexOf( 'Mac' ) != -1 ) ? true : false;
  var startpos = <?php print $start; ?>;
  var endpos   = <?php print $end;   ?>;
  var width    = <?php print $width; ?>;
  var sid      = '<?php print htmlspecialchars(SID); ?>';
  var x_slip = 0, y_slip = 0;
  if( nn6 || nn4) { x_slip = -17; }
  if( ie4 )       { x_slip = -18; }
  var isvlinefixed = false;
  var isoffsetposavailable = ie4;
  var vlinebasepos;
// -->
</SCRIPT>
<LINK rel="stylesheet" href="style/style_browser.css" type="text/css">
</HEAD>
<BODY>
<DIV style="top: 0px; left: -1000px; position:absolute; z-index: 1;" id="vline"><IMG src="picture/red.png" width="1" height="3000" border="0"></DIV>
<DIV style="top: 0px; left: -1000px; position:absolute; z-index: 1;" id="vline2"><IMG src="picture/red.png" width="1" height="3000" border="0"></DIV>
<SCRIPT language="JavaScript">
<!--
  function onRulerMouseMove( e ) {
    var vline = isvlinefixed ? document.getElementById( 'vline2' ) : document.getElementById( 'vline' );
    var pos_disp = document.getElementById( 'pos_disp' );
    var x = 0, y = 0;
    if( nn6 || nn4 ) { x = e.pageX;  y = e.pageY; }
    if( ie4 )        { x = document.body.scrollLeft + event.clientX;  y = document.body.scrollTop + event.clientY; }
    vline.style.left = x + x_slip;
    vline.style.top  = y + y_slip - 1500;
    if( isoffsetposavailable ) {
      var ruler_x = e.offsetX;
      pos_disp.value = Math.round( startpos + ( ruler_x / width ) * ( endpos - startpos ) );
    }
  }
  function onRulerMouseOut( e ) {
    var vline = isvlinefixed ? document.getElementById( 'vline2' ) : document.getElementById( 'vline' );
    vline.style.left = -1000;
  }
  function onRulerClick( e ) {
    if( isoffsetposavailable ) {
      if( isvlinefixed ) {
        var ruler_x = e.offsetX;
        var vline2basepos = Math.round( startpos + ( ruler_x / width ) * ( endpos - startpos ) );
        var nexturl = 'browser_frameoper_proxy.php?' + sid + '&setstart=' + vlinebasepos + '&setend=' + vline2basepos;
        location = nexturl;
      }
      else {
        var ruler_x = e.offsetX;
        vlinebasepos = Math.round( startpos + ( ruler_x / width ) * ( endpos - startpos ) );
        onRulerMouseMove( e );
        isvlinefixed = true;
      }
    }
  }

  var mouseX = 0;
  var mouseY = 0;

  function documentMouseMove( e ) {
    if( nn4 ) {
      mouseX = e.pageX;
      mouseY = e.pageY;
    }
    else if( ie4 ) {
      mouseX = event.x + document.body.scrollLeft;
      mouseY = event.y + document.body.scrollTop;
    }
    else if( nn6 ) {
      mouseX = e.clientX + window.pageXOffset;
      mouseY = e.clientY + window.pageYOffset;
    }
  }

  document.onmousemove = documentMouseMove;

  function menuPopup( id ) {
    var menu = document.getElementById( id );
    menu.style.left = mouseX;
    menu.style.top  = mouseY;
    menu.style.display = 'block';
  }
	function execLogout() {
		location.href = "browser_manage_logout_exec.php?<?php print htmlspecialchars(SID); ?>";
	}
// -->
</SCRIPT>
<CENTER>
<TABLE>
  <TBODY>
    <TR>
      <TD><IMG src="picture/UTGB_logo_browser_300.jpg" width="300" height="83" border="0" alt="University of Tokyo Genome Browser"></TD>
      <TD width="100%">
      <TABLE>
        <TBODY>
          <FORM method="POST" action="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID); ?>" name="frameoper">
          <TR>
            <TD>species:</TD>
            <TD><?php print_input_select( 'setspecies', array_keys($accept_species), $dispparam['species'], array('onChange'=>'reloadRevisionSelect(this,this.form.setrevision);') ); ?></TD>
            <TD>revision:</TD>
            <TD><?php print_input_select( 'setrevision', $accept_species[$dispparam['species']], $dispparam['revision'] ); ?></TD>
            <TD>target:</TD>
            <TD><?php print_input_text( 'settarget', $dispparam['target'], 15 ); ?></TD>
            <TD><INPUT type="submit" name="go" value="Go"></TD>
          </TR>
          <INPUT type="hidden" name="clearstartend" value="1">
          </FORM>
          <FORM method="POST" action="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID); ?>" name="frameoper">
          <TR>
            <TD>start:</TD>
            <TD><?php print_input_text( 'setstart', $dispparam['start'], 10 ); ?></TD>
            <TD>end:</TD>
            <TD><?php print_input_text( 'setend', $dispparam['end'], 10 ); ?></TD>
            <TD>width:</TD>
            <TD><?php print_input_text( 'setwidth', $dispparam['width'], 10 ); ?></TD>
            <TD><INPUT type="submit" name="apply" value="Apply"></TD>
          </TR>
          </FORM>
          <TR>
            <TD colspan="7"><?php if( ! is_null($thislen) ) { print "($species-$revision-$target length: $thislen bp)"; } ?>
			<?php print '('.round(1.0/$zoom,2).'bp/pixel)';  ?>
			<SCRIPT language="JavaScript">
			<!--
				if( isoffsetposavailable ) {
					document.write('<INPUT id="pos_disp" name="pos_disp" size="10" readonly>');
				}
			-->
            </SCRIPT>
            </TD>
          </TR>
        </TBODY>
      </TABLE>
   </TD>
    </TR>
    <?php if( isset($error) && is_array($error) && count($error) > 0 ) { ?>
    <TR>
		<TD colspan="2" align="center"><B><FONT color="#ff0000"><?php print implode( '<BR>', $error ); ?></FONT></B></TD>
    </TR>
    <?php } ?>
    <?php unset( $error ); ?>
    <?php unset( $_SESSION['browser']['error'] ); ?>
	  <TR>
      <TD colspan="2" align="center">
      <FORM method="POST" action="browser_keyword_proxy.php?<?php print htmlspecialchars(SID); ?>">keyword:
      <?php print_input_text( '_keyword', $searchparam['keyword'], 30 ); ?>
      species:
      <?php print_input_select( '_species', array_keys($accept_species), $searchparam['species'], array('onChange'=>'reloadRevisionSelect(this,this.form._revision);') ); ?>
      revision:
      <?php print_input_select( '_revision', $accept_species[$searchparam['species']], $searchparam['revision'] ); ?>
      <INPUT type="submit" name="apply" value="Search"></FORM>
      </TD>
    </TR>
    <TR>
		<TD colspan="2" align="center">
	  <DIV ALIGN=left>&nbsp;&nbsp;&nbsp;
<?php
	if ( isset($_SESSION['login']) ) {
		print "<INPUT TYPE='text' SIZE='15' NAME='USER_NAME' VALUE='".$_SESSION['login']['user_name']."' readonly>";
		print "<INPUT TYPE='button' NAME='LOGIN' VALUE='logout' onClick=\"JavaScript: execLogout(); \">";
	}
	else {
		print "<INPUT TYPE='text' SIZE='15' NAME='login' VALUE='Guest' readonly>";
    $htmlSID = htmlspecialchars(SID);
		print "<INPUT TYPE='button' NAME='LOGIN' VALUE='login' onClick=\"JavaScript: openUserAuthWindow('".$htmlSID."','','','only_login'); \">";
	}
?>
	  </DIV>	  
	  <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&moverel='.(-($rev?-1:1)*abs($start-$end)); ?>"><IMG src="picture/rr.png" border="0" width="24" height="16" alt="bwd2"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&moverel='.(-($rev?-1:1)*abs($start-$end)/2); ?>"><IMG src="picture/r.png" border="0" width="16" height="16" alt="bwd"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomrel=2'; ?>"><IMG src="picture/zoomin.png" border="0" width="16" height="16" alt="zoomin"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomabs=10'; ?>"><IMG src="picture/zoom10x.png" border="0" width="24" height="16" alt="zoom 10/1"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomabs=1'; ?>"><IMG src="picture/zoom1x.png" border="0" width="24" height="16" alt="zoom 1/1"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomabs=0.1'; ?>"><IMG src="picture/zoom01x.png" border="0" width="24" height="16" alt="zoom 1/10"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomabs=0.01'; ?>"><IMG src="picture/zoom001x.png" border="0" width="24" height="16" alt="zoom 1/100"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomabs=0.001'; ?>"><IMG src="picture/zoom0001x.png" border="0" width="24" height="16" alt="zoom 1/1000"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&zoomrel=0.5'; ?>"><IMG src="picture/zoomout.png" border="0" width="16" height="16" alt="zoomout"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&moverel='.(($rev?-1:1)*abs($start-$end)/2); ?>"><IMG src="picture/f.png" border="0" width="16" height="16" alt="fwd"></A> <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&moverel='.(($rev?-1:1)*abs($start-$end)); ?>"><IMG src="picture/ff.png" border="0" width="24" height="16" alt="fwd2"></A><BR>
      <A href="browser_frameoper_proxy.php?<?php print htmlspecialchars(SID).'&rev' ?>">(rev)</A> <A href="browser_keyword.php?<?php print htmlspecialchars(SID) ?>">(top)</A> <A href="browser_clear.php?<?php print htmlspecialchars(SID) ?>">(clear)</A> <A href="JavaScript: openTrackListWindow('<?php print htmlspecialchars(SID) ?>');">(track)</A> <A href="browser_export_fasta.php?<?php print htmlspecialchars(SID) ?>">(fasta)</A> <A href="browser_export_png.php?<?php print htmlspecialchars(SID) ?>">(png)</A> <A href="browser_synteny.php?<?php print htmlspecialchars(SID) ?>">(synteny)</A>
	  </TD>
    </TR>
  </TBODY>
</TABLE>
</CENTER>
<CENTER>
<TABLE border="0" cellpadding="1" cellspacing="0">
  <THEAD>
    <TR>
      <TD colspan="2">&nbsp;</TD>
      <TH width="<?php print $width; ?>"><IMG src="picture/blue.png" width="<?php print $width; ?>" height="10" border="0" alt="" onDblClick="onRulerClick(event);" onMouseMove="onRulerMouseMove(event);" onMouseOut="onRulerMouseOut(event);" id="top_ruler"></TH>
    </TR>
  </THEAD>
    <?php
  $labelid = 0;
  $picked_menus_list = array();

	foreach( $tracks as $tracknum => $track ) {
		$name            = $track['name'];
		$description_url = $track['description_url'];
		$comment         = $track['comment'];
		$optattr         = $track['optattr'];
		$query4thistrack_str = query2string( gen_track_query( $track, $dispparam ) );
		
		// printing title
		print "<TR><TH nowrap valign=\"middle\">";
		if( strlen($description_url) > 0 ) {
			print "<A href=\"$description_url\" target=\"_blank\">";
		}
		print "<IMG src=\"fontout.php?text=$name\" border=\"0\" align=\"middle\" alt=\"$name\">";
		if( strlen($description_url) > 0 ) {
			print "</A>";
		}
		if( $optattr ) {
			$tnm = urlencode( $name );
			print "<A href=\"JavaScript: openOptAttrConfigWindow('".SID."','$tracknum');\"><IMG src=\"picture/cfg.png\" width=\"9\" height=\"9\" border=\"0\" alt=\"config\"></A>";
		}
		if( $tracknum - 1 >= 0 ) {
			print '<A href="browser_frameoper_proxy.php?'.htmlspecialchars(SID).'&uptrack='.$tracknum.'"><IMG src="picture/u.png" width="5" height="9" border="0" alt="up this track"></A>';
		}
		if( $tracknum + 1 < count($tracks) ) {
			print '<A href="browser_frameoper_proxy.php?'.htmlspecialchars(SID).'&downtrack='.$tracknum.'"><IMG src="picture/d.png" width="5" height="9" border="0" alt="down this track"></A>';
		}
		print "</TH>\n";

		// processing Operation Layer
		$oper_flags = array();
		if( array_key_exists('operation',$track['layers']) && $track['layers']['operation'] ) {
			//$operation_layer_url    = $track['layers']['operation']['url'].'?'.$query4thistrack_str;
			$operation_layer_url    = $track['layers']['operation']['url'];
			if (preg_match("/\?fileurl=/", $operation_layer_url)) { $operation_layer_url .= "&"; }
			else if (preg_match("/\?tid=/", $operation_layer_url)) { $operation_layer_url .= "&"; }
			else { $operation_layer_url .= "?"; }
			$operation_layer_url .= $query4thistrack_str;
			$operation_layer_xmlstr = http_get( $operation_layer_url, 30 );
			$operation              = parse_operation_xml( $operation_layer_xmlstr );
			$picked_menus_list[]    = pick_menuoper( $operation, $name );
			if( $operation ) {
				assert( $operation['type'] == 'operation_layer' );
				if( count($operation['areas']) > 0 ) {
					print "<MAP name=\"map-$name\">";
					foreach( $operation['areas'] as $area ) {
						if( $area['type'] == 'rect_area' ) {
							$rect = substr( $area['rect'], 1, -1);
							foreach( $area['events'] as $event ) {
								foreach( $event['operations'] as $oper ) {
									if( $event['type'] == 'mouseclick_event' && $oper['type'] == 'link_operation' ) {
										$url = $oper['url'];
										$target = $oper['target'];
										if( strlen($target) > 0 ) {
											print "<AREA shape=\"rect\" coords=\"$rect\" target=\"$target\" href=\"$url\">";
										}
										else {
											print "<AREA shape=\"rect\" coords=\"$rect\" target=\"_blank\" href=\"$url\">";
										}
										$oper_flags['mouseclick_link'] = TRUE;
									}
									 elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'frame_operation' ) {
									 	$url =  'browser_frameoper_proxy.php?' . htmlspecialchars(SID) . '&' . framecommand_2_querystr($oper['commands']);
									 	print "<AREA shape=\"rect\" coords=\"$rect\"  href=\"$url\">";
									 	$oper_flags['mouseclick_link'] = TRUE;
									 }
									elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'menu_operation' ) {
										$id = $oper['__id'];
										print "<AREA shape=\"rect\" coords=\"$rect\" href=\"JavaScript: menuPopup('$id'); void(0);\">";
										$oper_flags['mouseclick_link'] = TRUE;
									}
									elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'suboperation' ) {
										$oper_flags['mouseclick_subop'] = TRUE;
										$oper_flags['mouseclick_subop_url'] = $oper['url'];
									}
								}
							}
						}
					}
					print "</MAP>";
				}
			}
		}

		// processing Index Operation Layer
		$indexoper_flags = array();
		if( array_key_exists('indexoperation',$track['layers']) && $track['layers']['indexoperation'] ) {
			//$operation_layer_url    = $track['layers']['indexoperation']['url'].'?'.$query4thistrack_str;
			$operation_layer_url    = $track['layers']['indexoperation']['url'];
			if (preg_match("/\?fileurl=/", $operation_layer_url)) { $operation_layer_url .= "&"; }
			else if (preg_match("/\?tid=/", $operation_layer_url)) { $operation_layer_url .= "&"; }
			else { $operation_layer_url .= "?"; }
			$operation_layer_url .= $query4thistrack_str;
			$operation_layer_xmlstr = http_get( $operation_layer_url, 30 );
			$operation              = parse_operation_xml( $operation_layer_xmlstr );
			$picked_menus_list[]    = pick_menuoper( $operation, $name.'i' );
			if( $operation ) {
				assert( $operation['type'] == 'operation_layer' );
				if( count($operation['areas']) > 0 ) {
					print "<MAP name=\"mapindex-$name\">";
					foreach( $operation['areas'] as $area ) {
						if( $area['type'] == 'rect_area' ) {
							$rect = substr( $area['rect'], 1, -1);
							foreach( $area['events'] as $event ) {
								foreach( $event['operations'] as $oper ) {
									if( $event['type'] == 'mouseclick_event' && $oper['type'] == 'link_operation' ) {
										$url = $oper['url'];
										$target = $oper['target'];
										if( strlen($target) > 0 ) {
											print "<AREA shape=\"rect\" coords=\"$rect\" target=\"$target\" href=\"$url\">";
										}
										else {
											print "<AREA shape=\"rect\" coords=\"$rect\" target=\"_blank\" href=\"$url\">";
										}
										$indexoper_flags['mouseclick_link'] = TRUE;
									}
									elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'frame_operation' ) {
									 	$url =  'browser_frameoper_proxy.php?' . htmlspecialchars(SID) . '&' . framecommand_2_querystr($oper['commands']);
									 	print "<AREA shape=\"rect\" coords=\"$rect\"  href=\"$url\">";
									 	$indexoper_flags['mouseclick_link'] = TRUE;
									}
									elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'menu_operation' ) {
										$id = $oper['__id'];
										print "<AREA shape=\"rect\" coords=\"$rect\" href=\"JavaScript: menuPopup('$id'); void(0);\">";
										$indexoper_flags['mouseclick_link'] = TRUE;
									}
									elseif( $event['type'] == 'mouseclick_event' && $oper['type'] == 'suboperation' ) {
										$indexoper_flags['mouseclick_subop'] = TRUE;
										$indexoper_flags['mouseclick_subop_url'] = $oper['url'];
									}
								}
							}
						}
					}
					print "</MAP>";
				}
			}
		}

		// printing images
		$ismap_oper  = array_key_exists('mouseclick_subop',$oper_flags) && $oper_flags['mouseclick_subop'] ? ' ismap' : '';
		$ismap_index = array_key_exists('mouseclick_subop',$indexoper_flags) && $indexoper_flags['mouseclick_subop'] ? ' ismap' : '';
		if( array_key_exists('index',$track['layers']) && $track['layers']['index'] ) {
			$index_layer_url = $track['layers']['index']['url'];
			if (preg_match("/\?fileurl=/", $index_layer_url)) { $index_layer_url .= "&"; }
			else if (preg_match("/\?tid=/", $index_layer_url)) { $index_layer_url .= "&"; }
			else { $index_layer_url .= "?"; }
			print "<TD align=\"right\">";
			if( array_key_exists('mouseclick_subop',$indexoper_flags) && $indexoper_flags['mouseclick_subop'] ) { ; }  // not implemented
			if( array_key_exists('mouseclick_link',$indexoper_flags) && $indexoper_flags['mouseclick_link'] ) {
				print "<IMG src=\"$index_layer_url".$query4thistrack_str."\" alt=\"$name (index)\" border=\"0\" usemap=\"#mapindex-$name\"$ismap_index>";
			}
			else {
				print "<IMG src=\"$index_layer_url".$query4thistrack_str."\" alt=\"$name (index)\" border=\"0\"$ismap_index>";
			}
			if( array_key_exists('mouseclick_subop',$indexoper_flags) && $indexoper_flags['mouseclick_subop'] ) { ; }  // not implemented
			print "</TD>";
		}
		else {
			print "<TD></TD>";
		}
		$graphic_layer_url = $track['layers']['graphic']['url'];
		if (preg_match("/\?fileurl=/", $graphic_layer_url)) { $graphic_layer_url .= "&"; }
		else if (preg_match("/\?tid=/", $graphic_layer_url)) { $graphic_layer_url .= "&"; }
		else { $graphic_layer_url .= "?"; }
		print "<TD width=\"$width\">";
		if( array_key_exists('mouseclick_subop',$oper_flags) && $oper_flags['mouseclick_subop'] ) {
			print "<A href=\"browser_subop_proxy.php?".SID."&tracknum=$tracknum&subop=".urlencode($oper_flags['mouseclick_subop_url'])."&pos=\">";
		}
		if( array_key_exists('mouseclick_link',$oper_flags) && $oper_flags['mouseclick_link']) {
			print "<IMG src=\"$graphic_layer_url".$query4thistrack_str."\" alt=\"$name\" border=\"0\" width=\"$width\" usemap=\"#map-$name\"$ismap_oper>";
		}
		else {
			print "<IMG src=\"$graphic_layer_url".$query4thistrack_str."\" alt=\"$name\" border=\"0\" width=\"$width\"$ismap_oper>";
			print "</TD>";
		}
		if( array_key_exists('mouseclick_subop',$oper_flags) && $oper_flags['mouseclick_subop'] ) {
			print "</A>";
		}
		print "</TR>\n";
	}
    ?>
  </TBODY>
  <THEAD>
    <TR>
      <TD colspan="2">&nbsp;</TD>
      <TH width="<?php print $width; ?>"><IMG src="picture/blue.png" width="<?php print $width; ?>" height="10" border="0" alt="" onDblClick="onRulerClick(event);" onMouseMove="onRulerMouseMove(event);" onMouseOut="onRulerMouseOut(event);" id="btm_ruler"></TH>
    </TR>
  </THEAD>
</TABLE>
<?php
	foreach( $picked_menus_list as $picked_menus ) {
		print_picked_menus_html( $picked_menus );
	}
?>
<FORM method="POST" action="browser_saveview.php?<?php print htmlspecialchars(SID); ?>"><INPUT type="submit" name="saveview" value="save this view"></FORM>
</CENTER>
</BODY>
</HTML>
