﻿' table/CaptionFieldProvider.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Class CCaptionFieldProvider
    Inherits CFieldProvider

    Private _Setting As UTable.CSetting = Nothing
    Private draggingRecord As UTable.CRecord = Nothing
    Private WithEvents table As UTable

    Public UserSortable As UTable.EAllow = UTable.EAllow.DEFAULT
    Public Draggable As Boolean

    Public Sub New()
        Me.New(Nothing, False)
    End Sub

    Public Sub New(ByVal caption As String)
        Me.New(caption, False)
    End Sub

    Public Sub New(ByVal caption As String, ByVal draggable As Boolean)
        MyBase.New(caption)
        Me.Draggable = draggable
    End Sub

    Friend Sub New(ByVal fieldDesc As UTable.CRecordProvider.CFieldDesc)
        Me.New(fieldDesc.Provider.Caption)
        Me.UserSortable = fieldDesc.UserSortable
        If TypeOf fieldDesc.Provider Is CFieldProvider Then
            Me.BorderLine = CType(fieldDesc.Provider, CFieldProvider).BorderLine
        End If
        If fieldDesc.HasSetting Then
            Me._Setting = fieldDesc.Setting.Clone
        End If
    End Sub

    Public Overrides Function Setting() As UTable.CSetting
        Return Me._Setting
    End Function

    Public Overrides Sub FieldInitialize(ByVal field As UTable.CField)
        Me.table = field.Table
        field.Value = Me.Caption
        AddHandler field.DoubleClick, AddressOf Me._DoubleClick
    End Sub

    Public Overrides Function CreateEditor() As IEditor
        Return Nothing
    End Function

    Protected Overrides Sub renderBackground(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        Dim drag As Boolean = field.Record Is Me.draggingRecord
        RenderCaptionBackgroudRect(g, rect, CaptionBackColor(field, s, drag), s.CaptionStyle)
        RenderCaptionBorder(g, rect, Me.BorderLine, field.Table.Setting.CaptionBorderColor)
    End Sub

    Protected Overrides Sub renderForeGround(ByVal g As Graphics, ByVal field As UTable.CField, ByVal s As UTable.CDynamicSetting, ByVal rect As System.Drawing.Rectangle, ByVal alter As Boolean)
        RenderCaptionValue(g, field, field.Table.SortState, rect, formatValue(field.Value), s.CaptionForeColor, s.CaptionFont, s.GetStringFormat)
    End Sub

    Private Sub _DoubleClick(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs)
        If field.TopLevelContent Is field.Table.HeaderContent Then
            Dim _sortable As UTable.EAllow = field.Table.Setting.UserSortable
            With CType(field.Desc.Provider, CCaptionFieldProvider)
                If .UserSortable <> UTable.EAllow.DEFAULT Then
                    _sortable = .UserSortable
                End If
            End With
            If _sortable = UTable.EAllow.ALLOW Then
                Using field.Table.RenderBlock
                    Dim _order As UTable.CSortState.EOrder = UTable.CSortState.EOrder.ASCEND
                    If field.Table.SortState.Field Is field And field.Table.SortState.Order = UTable.CSortState.EOrder.ASCEND Then
                        _order = UTable.CSortState.EOrder.DESCEND
                    End If
                    Dim key As Object = field.Key
                    If TypeOf key Is UTable.CCaptionKey Then
                        key = CType(key, UTable.CCaptionKey).key
                    End If
                    field.Table.Content.Sort(key, _order)
                    With field.Table.SortState
                        .Field = field
                        .Order = _order
                    End With
                End Using
            End If
        End If
    End Sub

    Public Overrides Function Focusable() As Boolean
        Return False
    End Function

    Public Overrides Function GetAdjustSize(ByVal g As Graphics, ByVal field As UTable.CField) As Size
        With field.DynamicSetting
            Return g.MeasureString(Me.formatValue(field.Value), .CaptionFont, 100000, .GetStringFormat).ToSize
        End With
    End Function

    Private Sub table_FieldMouseDown(ByVal field As UTable.CField, ByVal location As Point, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.FieldMouseDown
        If field.TopLevelContent Is field.Table.Content AndAlso _
           Me.Draggable AndAlso _
           e.Button = Windows.Forms.MouseButtons.Left Then
            If field.Desc.Provider Is Me Then
                Me.draggingRecord = field.Record
                field.Table.Render()
            End If
        End If
    End Sub

    Private Sub table_MouseMove(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.MouseMove
        If Me.draggingRecord IsNot Nothing Then
            Dim f As UTable.CRenderCache.CField = Me.table.RenderCache.FindField(e.Location)
            If f IsNot Nothing Then
                Me.recordMove(f.Field)
            ElseIf e.Location.Y < 0 Then
                table.SetVScrollValue(table.VScrollBar.Value - table.VScrollBar.SmallChange)
            ElseIf e.Location.Y > table.Height Then
                table.SetVScrollValue(table.VScrollBar.Value + table.VScrollBar.SmallChange)
            End If
        End If
    End Sub

    Private Sub recordMove(ByVal field As UTable.CField)
        If Me.draggingRecord.Content Is field.Content AndAlso Me.draggingRecord IsNot field.Record Then
            Using Me.table.RenderBlock
                With Me.draggingRecord.Content
                    Dim i1 As Integer = .Records.IndexOf(Me.draggingRecord)
                    Dim i2 As Integer = .Records.IndexOf(field.Record)
                    If i2 >= 0 AndAlso i1 <> i2 Then
                        .MoveRecord(Me.draggingRecord, i2)
                    End If
                End With
                Me.draggingRecord.TopLevelContent.LayoutCacheInvalid = True
            End Using
        End If
    End Sub

    Private Sub UTable_MouseUp(ByVal sender As Object, ByVal e As System.Windows.Forms.MouseEventArgs) Handles table.MouseUp
        If e.Button = Windows.Forms.MouseButtons.Left Then
            If Me.draggingRecord IsNot Nothing Then
                Me.draggingRecord = Nothing
                CType(sender, UTable).Render()
            End If
        End If
    End Sub

    Public Overrides Function RenderOrder() As Integer
        Return 1
    End Function

End Class