' table/Edit.vb
'
' Copyright (c) 2009, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Private _EditorContainer As CEditorContainer = Nothing

    Private Function edit_KeyPress(ByVal e As System.Windows.Forms.KeyPressEventArgs) As Boolean
        e.Handled = True
        If Not Char.IsControl(e.KeyChar) Then            
            Me._StartEdit(e.KeyChar, False)
            Return True
        End If
        Return False
    End Function

    Private Function edit_KeyDown(ByVal e As System.Windows.Forms.KeyEventArgs) As Boolean
        If e.KeyCode = Keys.ProcessKey Then
            Dim h As Integer = MAPI.ImmGetContext(Me.Handle)
            Try
                If h <> 0 Then
                    If MAPI.ImmGetCompositionString(h, &H8, vbNullString, 0) > 0 Then
                        Me.ScrollTo(Me.FocusField)
                        Me._StartEdit(Nothing, True)
                        Return True
                    End If
                End If
            Finally
                If h <> 0 Then
                    MAPI.ImmReleaseContext(Me.Handle, h)
                End If
            End Try
        End If
        Return False
    End Function

    Private Function edit_MouseDoubleClick(ByVal e As System.Windows.Forms.MouseEventArgs) As Boolean
        If Me.RenderCache.FocusField IsNot Nothing AndAlso _
           Me.RenderCache.FocusField.Rect.Contains(e.Location) Then
            Dim handled As Boolean = False
            If Me.FocusField IsNot Nothing Then
                Me.RaiseFieldSelected(Me.FocusField, handled)
            End If
            If handled Then
                Return True
            Else
                Return Me.StartEdit() IsNot Nothing
            End If
        End If
        Return False
    End Function

    Public Function StartEdit() As IEditor
        Return Me._StartEdit(Nothing, False)
    End Function

    Private Function _StartEdit(ByVal key As Char, ByVal clear As Boolean) As IEditor
        If Me.Editor IsNot Nothing Then
            Return Me.Editor
        End If
        If Me.FocusField IsNot Nothing Then
            Using Me.RenderBlock
                Dim editable As EAllow = Me.FocusField.Editable
                Me.FocusField.raiseEditStarting(editable)
                RaiseEvent EditStarting(Me.FocusField, editable)
                If editable = EAllow.ALLOW Then
                    Me.ScrollTo(Me.FocusField)
                    Me.Render()
                    If Me.RenderCache.FocusField IsNot Nothing Then
                        Dim editor As IEditor = Me.FocusField.Desc.Provider.CreateEditor
                        If editor IsNot Nothing Then
                            editor.Initialize(Me.FocusField)
                            Me.FocusField.Desc.Provider.EditorInitialize(Me.FocusField, editor)
                            RaiseEvent InitializeEditor(Me.FocusField, editor)
                            With Me.RenderCache.FocusField.Rect
                                editor.Control.Size = New Size(.Width - 1, .Height - 1)
                                Dim dy As Integer = .Height - editor.Control.Size.Height
                                Dim y As Integer = 0
                                Select Case Me.FocusField.DynamicSetting.VerticalAlignment
                                    Case EVAlign.TOP
                                        y = .Top
                                    Case EVAlign.MIDDLE
                                        y = .Top + (dy / 2)
                                    Case EVAlign.BOTTOM
                                        y = .Top + dy
                                End Select
                                If y = .Top Then
                                    y += 1
                                End If
                                editor.Control.Location = New Point(.Left + 1, y)
                            End With
                            Me.Controls.Add(editor)
                            If Not clear Then
                                editor.Value = Me.FocusField.CommittedValue
                            End If
                            Me._EditorContainer = New CEditorContainer(Me, editor)
                            Me.VScrollBar.Enabled = False
                            Me.HScrollBar.Enabled = False
                        End If
                    End If
                End If
            End Using
        End If
        If Me.Editor IsNot Nothing Then
            Dim h As Integer = MAPI.ImmGetContext(Me.Handle)
            Try
                Me.Editor.Control.Focus()
                Me.Editor.EditEnter(key, h)
            Finally
                If h <> 0 Then
                    MAPI.ImmReleaseContext(Me.Handle, h)
                End If
            End Try
            Me.FocusField.raiseEditStart(Me.Editor)
            RaiseEvent EditStart(Me.FocusField, Me.Editor)
        Else
            Me.ime_CreateContext()
        End If
        Return Me.Editor
    End Function

    Public Sub FinishEdit()
        Me.FinishEdit(False)
    End Sub

    Private endedit_flg As Boolean = False
    Public Sub FinishEdit(ByVal valueCommit As Boolean)
        Try
            If Me.endedit_flg Then
                Exit Sub
            End If
            Me.endedit_flg = True
            Using Me.RenderBlock
                If Me.Editor IsNot Nothing Then
                    Dim v As Object = Me.Editor.Value
                    Me.Controls.Remove(Me.Editor)
                    Me.Editor.Control.Dispose()
                    Me._EditorContainer = Nothing
                    If valueCommit Then
                        Me.FocusField.ValueCommit(v)
                    End If
                    Me.VScrollBar.Enabled = True
                    Me.HScrollBar.Enabled = True
                    Me.FocusField.raiseEditFinished()
                    RaiseEvent EditFinished(Me.FocusField)
                End If
            End Using
        Finally
            Me.endedit_flg = False
        End Try
    End Sub

    Public Function LeaveEdit() As Boolean
        Return Me.LeaveEdit(Nothing)
    End Function

    Public Function LeaveEdit(ByVal direction As String) As Boolean
        Using Me.RenderBlock
            If Me.Editor IsNot Nothing Then
                Me.Editor.EditLeave()
                Dim e As New System.ComponentModel.CancelEventArgs
                Me.raiseFieldValidating(Me.FocusField, e)
                If Not e.Cancel Then
                    Me.raiseFieldValidated(Me.FocusField)
                    Me.FinishEdit(True)
                    Me.Focus()
                    If direction IsNot Nothing Then
                        Me.KeyboardOperation.LeaveEdit(direction, Me)
                    End If
                End If
            End If
        End Using
        Return (Me.Editor Is Nothing)
    End Function

    Public Function Editor() As IEditor
        If Me._EditorContainer IsNot Nothing Then
            Return Me._EditorContainer.Editor
        Else
            Return Nothing
        End If
    End Function

    Class CEditorContainer
        Public Table As UTable
        Public WithEvents Editor As IEditor
        Public WithEvents Control As Control

        Public Sub New(ByVal table As UTable, ByVal editor As IEditor)
            Me.Table = table
            Me.Editor = editor
            Me.Control = editor.Control
        End Sub

        Private Sub Editor_Leave(ByVal sender As Object, ByVal direction As String) Handles Editor.Leave
            Me.Table.LeaveEdit(direction)
        End Sub

        Private Sub _Editor_ValueChanged(ByVal sender As Object) Handles Editor.ValueChanged
            Me.Table.raiseEditorValueChanged(Me.Table.FocusField)
        End Sub

        Private editor_validating_flg As Boolean = False
        Private Sub Editor_Validating(ByVal sender As Object, ByVal e As System.ComponentModel.CancelEventArgs) Handles Control.Validating
            Try
                If Me.editor_validating_flg Then
                    Exit Sub
                End If
                Me.editor_validating_flg = True
                Me.Table.raiseFieldValidating(Me.Table.FocusField, e)
            Finally
                Me.editor_validating_flg = False
            End Try
        End Sub

        Private editor_validated_flg As Boolean = False
        Private Sub Editor_Validated(ByVal sender As Object, ByVal e As System.EventArgs) Handles Control.Validated
            Try
                If Me.editor_validated_flg Then
                    Exit Sub
                End If
                Me.editor_validated_flg = True
                Me.Table.raiseFieldValidated(Me.Table.FocusField)
                Me.Table.FinishEdit(True)
            Finally
                Me.editor_validated_flg = False
            End Try
        End Sub

    End Class

End Class
