﻿' table/Ime.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright 
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright 
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Partial Public Class UTable

    Private hIMC As Integer = 0

    Private Sub ime_CreateContext()
        Me.ime_ReleaseContext()
        Me.hIMC = MAPI.ImmCreateContext()
    End Sub

    Private Sub ime_ReleaseContext()
        If Me.hIMC <> 0 Then
            MAPI.ImmAssociateContext(Me.Handle, 0)
            MAPI.ImmDestroyContext(Me.hIMC)
            Me.hIMC = 0
        End If
    End Sub

    Private Sub ime_AssociateContext(ByVal field As CField)
        If field Is Nothing Then
            Exit Sub
        End If
        If Me.hIMC = 0 Then
            Me.ime_CreateContext()
        End If
        Dim m As ImeMode = field.Desc.Provider.ImeMode
        If field.DynamicSetting.Editable = CSetting.EEditable.DISABLE Then
            m = Windows.Forms.ImeMode.Disable
        End If
        Select Case m
            Case Windows.Forms.ImeMode.On, Windows.Forms.ImeMode.Hiragana, Windows.Forms.ImeMode.HangulFull
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H19, &H8)
            Case Windows.Forms.ImeMode.Katakana
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H1B, &H8)
            Case Windows.Forms.ImeMode.KatakanaHalf
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H13, &H8)
            Case Windows.Forms.ImeMode.AlphaFull
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H18, &H8)
            Case Windows.Forms.ImeMode.Alpha
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H10, &H8)
            Case Windows.Forms.ImeMode.Hangul
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 1)
                MAPI.ImmSetConversionStatus(Me.hIMC, &H11, &H8)
            Case Windows.Forms.ImeMode.Disable
                MAPI.ImmAssociateContext(Me.Handle, 0)
            Case Else
                MAPI.ImmAssociateContext(Me.Handle, Me.hIMC)
                MAPI.ImmSetOpenStatus(Me.hIMC, 0)
        End Select
    End Sub

    Public Shared Sub ImmAssociateContext(ByVal control As Control, ByVal hIMC As Integer)
        MAPI.ImmAssociateContext(control.Handle, hIMC)
        If hIMC = 0 Then
            control.ImeMode = Windows.Forms.ImeMode.Disable
        Else
            control.ImeMode = Windows.Forms.ImeMode.NoControl
        End If
    End Sub

End Class
