' table/Grid.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright 
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright 
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Partial Class UTable

    Public Class CGrid

        Public Class CPoint
            Public Row As Integer
            Public Col As Integer
            Public Sub New(Optional ByVal row As Integer = 0, Optional ByVal col As Integer = 0)
                Me.Row = row
                Me.Col = col
            End Sub
        End Class

        Public Class CSize
            Public Row As Integer
            Public Col As Integer
            Public Sub New(Optional ByVal row As Integer = 0, Optional ByVal col As Integer = 0)
                Me.Row = row
                Me.Col = col
            End Sub
        End Class

        Public Class CRegion
            Public Row As Integer
            Public Col As Integer
            Public Rows As Integer
            Public Cols As Integer

            Public Sub New(Optional ByVal row As Integer = 0, _
                           Optional ByVal col As Integer = 0, _
                           Optional ByVal rows As Integer = 1, _
                           Optional ByVal cols As Integer = 1)
                Me.Row = row
                Me.Col = col
                Me.Rows = rows
                Me.Cols = cols
            End Sub

            Public Function Contains(ByVal point As CPoint) As Boolean
                Return point.Row >= Me.Row And point.Row <= Me.EndRow And _
                       point.Col >= Me.Col And point.Col <= Me.EndCol
            End Function

            Public Function EndRow() As Integer
                Return Me.Row + Me.Rows - 1
            End Function

            Public Function EndCol() As Integer
                Return Me.Col + Me.Cols - 1
            End Function

            Public Function Union(ByVal r As CRegion) As CRegion
                Dim row As Integer = 0
                Dim col As Integer = 0
                Dim rows As Integer = 0
                Dim cols As Integer = 0
                If Me.Row < r.Row Then row = Me.Row Else row = r.Row
                If Me.Col < r.Col Then col = Me.Col Else col = r.Col
                If Me.Row + Me.Rows > r.Row + r.Rows Then
                    rows = Me.Row + Me.Rows - row
                Else
                    rows = r.Row + r.Rows - row
                End If
                If Me.Col + Me.Cols > r.Col + r.Cols Then
                    cols = Me.Col + Me.Cols - col
                Else
                    cols = r.Col + r.Cols - col
                End If
                Return New CRegion(row, col, rows, cols)
            End Function

        End Class

        Public Table As UTable = Nothing
        Public Content As UTable.CContent = Nothing
        Public SizeMax As Integer = 0
        Public SizeMin As Integer = 0
        Public Resizable As Boolean = True
        Public UserResizable As Boolean = True
        Public UserAdjustable As Boolean = True

        Private _Visible As Boolean = True
        Private _Size As Integer = 0

        Public Sub New()
        End Sub

        Public Sub New(ByVal table As UTable)
            Me.Table = table
        End Sub

        Public Sub New(ByVal content As UTable.CContent)
            Me.Table = Nothing
            Me.Content = content
        End Sub

        Public Sub New(ByVal i As CGrid, ByVal content As CContent)
            Me.SizeMin = i.SizeMin
            Me.SizeMax = i.SizeMax
            Me.Resizable = i.Resizable
            Me.UserResizable = i.UserResizable
            Me.UserAdjustable = i.UserAdjustable
            Me.Visible = i.Visible
            Me.Size = i.Size
            Me.Content = content
        End Sub

        Public Shared Function GetRectangle(ByVal cols As CGrids, _
                                            ByVal rows As CGrids, _
                                            ByVal region As CRegion, _
                                            ByVal top_row As Integer, _
                                            ByVal top_col As Integer) As Rectangle
            Dim row_pos As Integer
            Dim row_size As Integer
            Dim col_pos As Integer
            Dim col_size As Integer

            row_size = rows.GetSize(region.Row, region.Rows)

            If row_size = 0 Then
                Return Nothing
            End If

            col_size = cols.GetSize(region.Col, region.Cols)

            If col_size = 0 Then
                Return Nothing
            End If

            row_pos = top_row + rows.GetLocation(region.Row)
            col_pos = top_col + cols.GetLocation(region.Col)

            Return New Rectangle(col_pos, row_pos, col_size, row_size)

        End Function

        Public Property Size() As Integer
            Get
                If Me._Size = 0 Then
                    If Me.Table IsNot Nothing Then
                        Return Me.Table.DefaultGridSize.Col
                    ElseIf Me.Content IsNot Nothing Then
                        Return Me.Content.Table.DefaultGridSize.Row
                    Else
                        Return 0
                    End If
                Else
                    Return Me._Size
                End If
            End Get
            Set(ByVal value As Integer)
                If Me.Resizable Then
                    If Me.SizeMin > 0 AndAlso value < Me.SizeMin Then
                        Me._Size = Me.SizeMin
                    ElseIf Me.SizeMax > 0 AndAlso value > Me.SizeMax Then
                        Me._Size = Me.SizeMax
                    ElseIf value >= 0 Then
                        Me._Size = value
                    End If
                    Me.update()
                End If
            End Set
        End Property

        Public Property Visible() As Boolean
            Get
                Return Me._Visible
            End Get
            Set(ByVal value As Boolean)
                Me._Visible = value
                Me.update()
            End Set
        End Property

        Private Sub update()
            If Me.Table IsNot Nothing Then
                Using Me.Table.UpdateBufferBlock
                    Me.Table.NeetUpdateCache = True
                End Using                
            ElseIf Me.Content IsNot Nothing Then
                Using Me.Content.Table.UpdateBufferBlock
                    Me.Content.NeedUpdateCache = True
                End Using
            End If
        End Sub

        Public Shared Function GetSizeFromEntireSize(ByVal grids As CGrids, _
                                                     ByVal region_start As Integer, _
                                                     ByVal region_size As Integer, _
                                                     ByVal point As Integer, _
                                                     ByVal entireSize As Integer) As Integer
            Return entireSize + 2 - (grids.GetSize(region_start, region_size) - grids.GetSize(point, 1))
        End Function

    End Class

    Public Class CGrids
        Inherits List(Of CGrid)

        Public Sub New()
        End Sub

        Public Sub New(ByVal grids As CGrids, ByVal content As CContent)
            For Each grid As CGrid In grids
                Me.Add(New CGrid(grid, content))
            Next
        End Sub

        Public Function GetLocation(ByVal pos As Integer) As Integer
            Dim ret As Integer = 0
            For i As Integer = 0 To pos - 1
                If Me(i).Visible Then
                    ret += Me(i).Size
                End If
            Next
            Return ret
        End Function

        Public Function GetSize(ByVal pos As Integer, ByVal size As Integer) As Integer
            Dim ret As Integer = 0
            For i As Integer = 0 To size - 1                
                If Me(pos + i).Visible Then
                    ret += Me(pos + i).Size
                End If                
            Next
            Return ret
        End Function

        Public Sub SetSize(ByVal ParamArray v() As Integer)
            For i As Integer = 0 To v.Length - 1
                If i < Me.Count Then
                    Me(i).Size = v(i)
                End If
            Next
        End Sub

    End Class

End Class