' table/Editor.vb
'
' Copyright (c) 2008, SystemBase Co.,Ltd.
' All rights reserved.
'
' Redistribution and use in source and binary forms, with or without 
' modification, are permitted provided that the following conditions are met:
'
'    1. Redistributions of source code must retain the above copyright 
'       notice, this list of conditions and the following disclaimer.
'    2. Redistributions in binary form must reproduce the above copyright 
'       notice, this list of conditions and the following disclaimer in the
'       documentation and/or other materials provided with the distribution.
'
' THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
' IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
' ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
' LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
' CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
' SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
' INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
' CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
' ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
' POSSIBILITY OF SUCH DAMAGE.

Imports System.Drawing

Public Interface IEditor
    Sub Initialize(ByVal field As UTable.CField)
    Sub Enter(ByVal key As Char, ByVal hIMC As Integer, ByVal clear As Boolean)
    Property Value() As Object
    Function RaiseValidate() As Boolean
    Function Control() As Control
    Event ProcessDialogKey(ByVal sender As Object, ByVal keyData As System.Windows.Forms.Keys, ByRef handled As Boolean)
    Event Leave(ByVal sender As Object, ByVal direction As String)    
    Event ValueChanged(ByVal sender As Object)
End Interface

Public Class CTextBoxEditor
    Inherits TextBox
    Implements IEditor

    Public Event _Leave(ByVal sender As Object, ByVal direction As String) Implements IEditor.Leave
    Public Event _ValueChanged(ByVal sender As Object) Implements IEditor.ValueChanged
    Public Event _ProcessDialogKey(ByVal sender As Object, ByVal keyData As System.Windows.Forms.Keys, ByRef handled As Boolean) Implements IEditor.ProcessDialogKey

    Public Sub Initialize(ByVal field As UTable.CField) Implements IEditor.Initialize
        With field.DynamicSetting
            Me.Font = .Font
            Select Case .HorizontalAlignment
                Case UTable.CSetting.EHAlign.LEFT
                    Me.TextAlign = HorizontalAlignment.Left
                Case UTable.CSetting.EHAlign.MIDDLE
                    Me.TextAlign = HorizontalAlignment.Center
                Case UTable.CSetting.EHAlign.RIGHT
                    Me.TextAlign = HorizontalAlignment.Right
            End Select
        End With
    End Sub

    Public Property Value() As Object Implements IEditor.Value
        Get
            Return Me.Text
        End Get
        Set(ByVal value As Object)
            Me.Text = value
        End Set
    End Property

    Protected Overrides Function IsInputKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        Select Case keyData
            Case Keys.Up
                RaiseEvent _Leave(Me, "UP")
                Return True
            Case Keys.Down
                RaiseEvent _Leave(Me, "DOWN")
                Return True
            Case Keys.Left
                If Me.SelectionLength = 0 And Me.SelectionStart = 0 Then
                    RaiseEvent _Leave(Me, "LEFT")
                    Return True
                End If
            Case Keys.Right
                If Me.SelectionLength = 0 And Me.SelectionStart = Me.Text.Length Then
                    RaiseEvent _Leave(Me, "RIGHT")
                    Return True
                End If
        End Select
        Return MyBase.IsInputKey(keyData)
    End Function

    Protected Overrides Function ProcessDialogKey(ByVal keyData As System.Windows.Forms.Keys) As Boolean
        Dim handled As Boolean = False
        RaiseEvent _ProcessDialogKey(Me, keyData, handled)
        If handled Then
            Return True
        Else
            Return MyBase.ProcessDialogKey(keyData)
        End If
    End Function

    Public Function RaiseValidate() As Boolean Implements IEditor.RaiseValidate
        Dim e As New System.ComponentModel.CancelEventArgs
        Me.OnValidating(e)
        If Not e.Cancel Then
            Me.OnValidated(System.EventArgs.Empty)
            Return True
        End If
        Return False
    End Function

    Private Sub CTextBoxEditor_TextChanged(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.TextChanged
        RaiseEvent _ValueChanged(Me)
    End Sub

    Public Sub EditorEnter(ByVal key As Char, ByVal hIMC As Integer, ByVal clear As Boolean) Implements IEditor.Enter
        If clear Then
            Me.Text = Nothing
        End If
        UTable.ImmAssociateContext(Me, hIMC)
        Me.Focus()
        If key <> Nothing Then
            Me.Text = key
            Me.SelectionStart = 1
        End If
    End Sub

    Public Function Control() As System.Windows.Forms.Control Implements IEditor.Control
        Return Me
    End Function

End Class
