/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util.hydrogen.v1_0;

import java.util.Comparator;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;

public class HNumber {
    public static int trim(int value, int min, int max) {
        if (min > max) {
            return HNumber.trim(value, max, min);
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static double trim(double value, double min, double max) {
        if (min > max) {
            return HNumber.trim(value, max, min);
        }
        if (value < min) {
            return min;
        }
        if (value > max) {
            return max;
        }
        return value;
    }

    public static int torus(int value, int min, int max) {
        if (min > max) {
            return HNumber.torus(value, max, min);
        }
        int n = max - min + 1;
        if (value < 0) {
            return n - 1 - (-value - 1) % n + min;
        }
        return value % n + min;
    }

    public static int contains(int value, int min, int max) {
        if (min > max) {
            return HNumber.contains(value, max, min);
        }
        if (value == min) {
            return 1;
        }
        if (value == max) {
            return 1;
        }
        if (value > min && value < max) {
            return 1;
        }
        return 0;
    }

    public static int contains(double value, double min, double max) {
        if (min > max) {
            return HNumber.contains(value, max, min);
        }
        if (value == min) {
            return 1;
        }
        if (value == max) {
            return 1;
        }
        if (value > min && value < max) {
            return 1;
        }
        return 0;
    }

    public static int contains(int valueX, int valueY, int minX, int maxX, int minY, int maxY) {
        if (minX > maxX) {
            return HNumber.contains(valueX, valueY, maxX, minX, minY, maxY);
        }
        if (minY > maxY) {
            return HNumber.contains(valueX, valueY, minX, maxX, maxY, minY);
        }
        return Math.min(HNumber.contains(valueX, minX, maxX), HNumber.contains(valueY, minY, maxY));
    }

    public static int contains(double valueX, double valueY, double minX, double maxX, double minY, double maxY) {
        if (minX > maxX) {
            return HNumber.contains(valueX, valueY, maxX, minX, minY, maxY);
        }
        if (minY > maxY) {
            return HNumber.contains(valueX, valueY, minX, maxX, maxY, minY);
        }
        return Math.min(HNumber.contains(valueX, minX, maxX), HNumber.contains(valueY, minY, maxY));
    }

    public static int compare(double a, double b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static <T> Comparator<T> createComparator(ToIntFunction<T> function) {
        return (a, b) -> HNumber.compare(function.applyAsInt(a), function.applyAsInt(b));
    }

    public static <T> Comparator<T> createComparator(ToDoubleFunction<T> function) {
        return (a, b) -> HNumber.compare(function.applyAsDouble(a), function.applyAsDouble(b));
    }

    public static <T> Comparator<T> createComparatorNegate(ToIntFunction<T> function) {
        return (a, b) -> -HNumber.compare(function.applyAsInt(a), function.applyAsInt(b));
    }

    public static <T> Comparator<T> createComparatorNegate(ToDoubleFunction<T> function) {
        return (a, b) -> -HNumber.compare(function.applyAsDouble(a), function.applyAsDouble(b));
    }
}

