/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util.hydrogen.v1_0;

import java.util.Random;

public class HMath {
    public static final double LOG_10 = Math.log(10.0);
    public static final double LOG_10_2 = Math.log(2.0) / LOG_10;
    public static final double LOG_10_5 = Math.log(5.0) / LOG_10;

    public static int randomBetween(Random random, int min, int max) {
        return (int)(random.nextDouble() * (double)(max - min + 1) + (double)min);
    }

    public static int randomBetween(int min, int max) {
        return (int)(Math.random() * (double)(max - min + 1) + (double)min);
    }

    public static double nice(double mspace) {
        double integerNumber;
        double log10 = Math.log10(mspace);
        double mod = log10 - (integerNumber = Math.floor(log10));
        mod = mod > LOG_10_5 ? LOG_10_5 : (mod > LOG_10_2 ? LOG_10_2 : 0.0);
        return Math.pow(10.0, integerNumber + mod);
    }

    public static double magnitude2(double re, double im) {
        return Math.pow(re, 2.0) + Math.pow(im, 2.0);
    }

    public static double magnitude(double re, double im) {
        return Math.sqrt(HMath.magnitude2(re, im));
    }

    public static boolean isPrime(long a) {
        if (a <= 1L) {
            return false;
        }
        if (a == 2L) {
            return true;
        }
        double limit = Math.sqrt(a) + 1.0;
        long i = 2L;
        while ((double)i < limit) {
            if (a % i == 0L) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static double sigmoid(double x, double a) {
        return 1.0 / (1.0 + Math.exp(-a * x));
    }

    public static double sigmoid(double x) {
        return 1.0 / (1.0 + Math.exp(-x));
    }

    public static double logit(double x, double a) {
        return Math.log(x / (1.0 - x)) / a;
    }

    public static double logit(double x) {
        return Math.log(x / (1.0 - x));
    }
}

