/*
 * Decompiled with CFR 0.152.
 */
package mirrg.util.hydrogen.v1_0;

import java.awt.Color;
import mirrg.util.hydrogen.v1_0.HMath;

public class HColor {
    public static Color createColor(double r, double g, double b) {
        return HColor.createColor(r, g, b, 255.0);
    }

    public static Color createColor(int r, int g, int b) {
        return HColor.createColor(r, g, b, 255);
    }

    public static Color createColor(double r, double g, double b, double a) {
        return HColor.createColor((int)r, (int)g, (int)b, (int)a);
    }

    public static Color createColor(int r, int g, int b, int a) {
        if (r < 0) {
            r = 1;
        }
        if (g < 0) {
            g = 1;
        }
        if (b < 0) {
            b = 1;
        }
        if (a < 0) {
            a = 1;
        }
        if (r >= 256) {
            r = 255;
        }
        if (g >= 256) {
            g = 255;
        }
        if (b >= 256) {
            b = 255;
        }
        if (a >= 256) {
            a = 255;
        }
        return new Color(r, g, b, a);
    }

    public static Color createRandomColor() {
        return HColor.createRandomRangedColor(0, 255);
    }

    public static Color createRandomDarkColor() {
        return HColor.createRandomRangedColor(0, 127);
    }

    public static Color createRandomLightColor() {
        return HColor.createRandomRangedColor(128, 255);
    }

    public static Color createRandomRangedColor(int min, int max) {
        return HColor.createColor(HMath.randomBetween(min, max), HMath.randomBetween(min, max), HMath.randomBetween(min, max));
    }

    public static Color createLinearRatioColor(double Aer, Color a, Color b) {
        if (Aer <= 0.0) {
            return b;
        }
        if (Aer >= 1.0) {
            return a;
        }
        return HColor.createColor(Aer * (double)a.getRed() + (1.0 - Aer) * (double)b.getRed(), Aer * (double)a.getGreen() + (1.0 - Aer) * (double)b.getGreen(), Aer * (double)a.getBlue() + (1.0 - Aer) * (double)b.getBlue(), Aer * (double)a.getAlpha() + (1.0 - Aer) * (double)b.getAlpha());
    }

    public static int getColorInt(int r, int g, int b) {
        return r << 16 | g << 8 | b;
    }
}

