/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.neon.v1_1.artifacts.web;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.URL;
import javax.swing.JEditorPane;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.html.HTMLDocument;
import mirrg.struct.hydrogen.v1_0.Struct1;
import mirrg.struct.hydrogen.v1_0.Tuple;
import mirrg.swing.neon.v1_1.artifacts.logging.HLog;
import mirrg.swing.neon.v1_1.artifacts.web.IListenerWebViewer;
import mirrg.swing.neon.v1_1.artifacts.web.WebViewer;

public class WebViewerTextPane
extends WebViewer {
    private JEditorPane editorPane1;
    private JScrollPane scrollPane1;

    @Override
    public void setPage(URL url) {
        try {
            this.editorPane1.setPage(url);
        }
        catch (IOException e) {
            HLog.processExceptionWarning(e);
            return;
        }
    }

    @Override
    public void setPage(String url) {
        try {
            this.editorPane1.setPage(url);
        }
        catch (IOException e) {
            HLog.processExceptionWarning(e);
            return;
        }
    }

    @Override
    protected void setPositionImpl(int position) {
        Struct1 listener = new Struct1();
        listener.x = e -> {
            this.editorPane1.removePropertyChangeListener("page", (PropertyChangeListener)listener.x);
            this.scrollPane1.getVerticalScrollBar().setValue(position);
        };
        this.editorPane1.addPropertyChangeListener("page", (PropertyChangeListener)listener.x);
        this.scrollPane1.getVerticalScrollBar().setValue(position);
    }

    @Override
    public void init(final IListenerWebViewer listenerWebViewer) {
        this.editorPane1 = new JEditorPane();
        this.editorPane1.setEditable(false);
        this.editorPane1.addHyperlinkListener(e -> {
            if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                listenerWebViewer.activateHyperlink(e.getURL());
            }
        });
        this.editorPane1.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                listenerWebViewer.keyPressed(e.getKeyCode());
            }
        });
        this.scrollPane1 = new JScrollPane(this.editorPane1);
        this.scrollPane1.setPreferredSize(new Dimension(800, 800));
    }

    @Override
    public URL getPage() {
        return this.editorPane1.getPage();
    }

    @Override
    public int getPosition() {
        return this.scrollPane1.getVerticalScrollBar().getValue();
    }

    @Override
    public Component getComponent() {
        return this.scrollPane1;
    }

    @Override
    public void refresh() {
        Tuple<URL, Integer> now = this.getNow();
        ((HTMLDocument)this.editorPane1.getDocument()).getDocumentProperties().remove("stream");
        if (now != null) {
            this.setPageFromURL(now);
        }
    }
}

