/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.neon.v1_1.artifacts.web;

import java.awt.Component;
import java.net.URL;
import java.util.LinkedList;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import mirrg.struct.hydrogen.v1_0.Tuple;
import mirrg.swing.neon.v1_1.FrameNeon;
import mirrg.swing.neon.v1_1.artifacts.logging.EnumTypeLog;
import mirrg.swing.neon.v1_1.artifacts.logging.HLog;
import mirrg.swing.neon.v1_1.artifacts.web.IListenerWebViewer;
import mirrg.swing.neon.v1_1.artifacts.web.WebViewer;
import mirrg.swing.neon.v1_1.artifacts.web.WebViewerTextPane;
import mirrg.swing.neon.v1_1.util.GroupBuilder;
import mirrg.swing.neon.v1_1.util.HSwing;

public class FrameHTML
extends FrameNeon {
    private LinkedList<Tuple<URL, Integer>> historyLeft = new LinkedList();
    private LinkedList<Tuple<URL, Integer>> historyRight = new LinkedList();
    private JButton button1;
    private JButton button2;
    private JTextField textField1;
    private WebViewer webViewer;

    public FrameHTML() {
        this(new WebViewerTextPane());
    }

    public FrameHTML(WebViewer webViewer) {
        this.webViewer = webViewer;
        this.setTitle("HTML\u30d3\u30e5\u30fc\u30ef");
        this.button1 = new JButton("\u623b\u308b");
        this.button1.setToolTipText("\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d7\u30eb\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\u8868\u793a");
        this.button1.addActionListener(e -> {
            if (!this.historyLeft.isEmpty()) {
                this.travelLeft(1);
            }
        });
        HSwing.hookPopup(this.button1, e -> {
            if (!this.historyLeft.isEmpty()) {
                JPopupMenu popupMenu = new JPopupMenu();
                for (int i = this.historyLeft.size() - 1; i >= 0; --i) {
                    Tuple<URL, Integer> entry = this.historyLeft.get(i);
                    JMenuItem menuItem = new JMenuItem(entry.getY().toString() + ": " + entry.getX().toString());
                    popupMenu.add(menuItem);
                    int i2 = i + 1;
                    menuItem.addActionListener(e2 -> this.travelLeft(i2));
                }
                popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                return true;
            }
            return false;
        });
        this.button2 = new JButton("\u9032\u3080");
        this.button2.setToolTipText("\u53f3\u30af\u30ea\u30c3\u30af\uff1a\u30d7\u30eb\u30c0\u30a6\u30f3\u30e1\u30cb\u30e5\u30fc\u306e\u8868\u793a");
        this.button2.addActionListener(e -> {
            if (!this.historyRight.isEmpty()) {
                this.travelRight(1);
            }
        });
        HSwing.hookPopup(this.button2, e -> {
            if (!this.historyRight.isEmpty()) {
                JPopupMenu popupMenu = new JPopupMenu();
                for (int i = 0; i < this.historyRight.size(); ++i) {
                    Tuple<URL, Integer> entry = this.historyRight.get(i);
                    JMenuItem menuItem = new JMenuItem(entry.getY().toString() + ": " + entry.getX().toString());
                    popupMenu.add(menuItem);
                    int i2 = i + 1;
                    menuItem.addActionListener(e2 -> this.travelRight(i2));
                }
                popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
                return true;
            }
            return false;
        });
        this.textField1 = new JTextField();
        this.textField1.addActionListener(e -> this.navigate(this.textField1.getText()));
        JButton button3 = new JButton("\u79fb\u52d5");
        button3.addActionListener(e -> this.navigate(this.textField1.getText()));
        JButton button4 = new JButton("\u66f4\u65b0");
        button4.addActionListener(e -> this.refresh());
        webViewer.init(new IListenerWebViewer(){

            @Override
            public void activateHyperlink(URL url) {
                FrameHTML.this.navigate(url);
            }

            @Override
            public void keyPressed(int keyCode) {
                if (keyCode == 116) {
                    FrameHTML.this.refresh();
                    return;
                }
                if (keyCode == 8) {
                    if (!FrameHTML.this.historyLeft.isEmpty()) {
                        FrameHTML.this.travelLeft(1);
                    }
                    return;
                }
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.setLayout(layout);
        layout.setAutoCreateGaps(true);
        layout.setAutoCreateContainerGaps(false);
        GroupBuilder.group(GroupBuilder.group(this.button1, this.button2, new JLabel("\u30a2\u30c9\u30ec\u30b9:"), this.textField1, button3, button4).align(GroupLayout.Alignment.CENTER), webViewer.getComponent()).apply(layout);
        this.historyChanged();
        HLog.log(EnumTypeLog.FINE, "HTML\u30d3\u30e5\u30fc\u30ef\u3092\u8d77\u52d5\u3057\u307e\u3057\u305f");
        this.neon.prepareFrame();
    }

    private void refresh() {
        this.webViewer.refresh();
    }

    private void travelLeft(int times) {
        Tuple<URL, Integer> now = this.webViewer.getNow();
        for (int i = 0; i < times; ++i) {
            this.historyRight.addFirst(now);
            now = this.historyLeft.removeLast();
        }
        this.historyChanged();
        this.setPage(now);
    }

    private void travelRight(int times) {
        Tuple<URL, Integer> now = this.webViewer.getNow();
        for (int i = 0; i < times; ++i) {
            this.historyLeft.addLast(now);
            now = this.historyRight.removeFirst();
        }
        this.historyChanged();
        this.setPage(now);
    }

    private void pushHistory() {
        Tuple<URL, Integer> now = this.webViewer.getNow();
        if (now != null) {
            this.historyLeft.addLast(now);
            this.historyChanged();
        }
    }

    private void historyChanged() {
        this.button1.setEnabled(!this.historyLeft.isEmpty());
        this.button2.setEnabled(!this.historyRight.isEmpty());
    }

    private void setPage(Tuple<URL, Integer> url) {
        this.webViewer.setPageFromURL(url);
        this.textField1.setText(url.getX().toString());
    }

    public void navigate(String url) {
        this.pushHistory();
        this.webViewer.setPage(url);
        this.textField1.setText(url);
    }

    public void navigate(URL url) {
        this.pushHistory();
        this.webViewer.setPage(url);
        this.textField1.setText(url.toString());
    }
}

