/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.neon.v1_1.artifacts.logging;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Dimension;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import mirrg.struct.hydrogen.v1_0.Tuple;
import mirrg.swing.neon.v1_1.FrameNeon;
import mirrg.swing.neon.v1_1.NitrogenEventNeon;
import mirrg.swing.neon.v1_1.artifacts.MenuLookAndFeel;
import mirrg.swing.neon.v1_1.artifacts.logging.EnumTypeLog;
import mirrg.swing.neon.v1_1.artifacts.logging.HLog;
import mirrg.swing.neon.v1_1.artifacts.logging.LoggerMirrg;

public class FrameLog
extends FrameNeon {
    private JCheckBox checkBoxAutoScroll;
    private JScrollPane scrollPaneMessages;
    private DefaultStyledDocument document;
    private transient boolean disabled = false;

    public static void main(String[] args) {
        HLog.error("Error!");
        HLog.warning("Warning!");
        new FrameLog(300).setVisible(true);
        HLog.fine("Fine!");
        HLog.info("Info!");
        new FrameLog(300).setVisible(true);
        HLog.info().println("Print Info!");
        new RuntimeException("Exception!").printStackTrace(HLog.warning());
        Thread thread = new Thread(() -> {
            while (true) {
                HLog.info().println("Info!");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception e) {
                    return;
                }
            }
        });
        thread.setDaemon(true);
        thread.start();
        LoggerMirrg logger = new LoggerMirrg();
        for (int i = 0; i < 1000; ++i) {
            logger.info("abc");
        }
        new FrameLog(logger, 300).setVisible(true);
    }

    public FrameLog(int loadedMessages) {
        this(HLog.logger, loadedMessages);
    }

    public FrameLog(LoggerMirrg loggerMirrg, int loadedMessages) {
        super("\u30ed\u30b0\u30a6\u30a3\u30f3\u30c9\u30a6");
        int skipMessages = loggerMirrg.getMessageCount() - loadedMessages;
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30e1\u30cb\u30e5\u30fc(M)");
        menuBar.add(menu);
        menu.setMnemonic('M');
        MenuLookAndFeel menu2 = new MenuLookAndFeel();
        menu.add(menu2);
        JMenuItem menuItem = new JMenuItem("\u30ed\u30b0\u30a6\u30a3\u30f3\u30c9\u30a6\u306e\u30af\u30ea\u30a2(C)");
        menu.add(menuItem);
        menuItem.setMnemonic('C');
        menuItem.addActionListener(e -> {
            try {
                this.document.remove(0, this.document.getLength());
            }
            catch (BadLocationException e1) {
                HLog.processExceptionUnexpected(e1);
            }
        });
        this.checkBoxAutoScroll = new JCheckBox("\u30aa\u30fc\u30c8\u30b9\u30af\u30ed\u30fc\u30eb(A)", true);
        menuBar.add(this.checkBoxAutoScroll);
        this.checkBoxAutoScroll.setMnemonic('A');
        this.document = new DefaultStyledDocument();
        Style styleDefault = StyleContext.getDefaultStyleContext().getStyle("default");
        Style info = this.document.addStyle("INFO", styleDefault);
        StyleConstants.setForeground(info, Color.BLACK);
        Style fine = this.document.addStyle("FINE", styleDefault);
        StyleConstants.setForeground(fine, new Color(35071));
        Style warning = this.document.addStyle("WARNING", styleDefault);
        StyleConstants.setForeground(warning, new Color(0xFF8800));
        Style error = this.document.addStyle("ERROR", styleDefault);
        StyleConstants.setForeground(error, Color.RED);
        Style unexpected = this.document.addStyle("UNEXPECTED", styleDefault);
        StyleConstants.setForeground(unexpected, new Color(0x8800FF));
        JTextPane textPane = new JTextPane(this.document);
        textPane.setEditable(false);
        this.scrollPaneMessages = new JScrollPane(textPane);
        this.scrollPaneMessages.setPreferredSize(new Dimension(400, 400));
        this.add(this.scrollPaneMessages);
        this.setLayout(new CardLayout());
        this.neon.getEventManager().register(NitrogenEventNeon.Initialized.class, e -> {
            int start = Math.max(0, skipMessages);
            if (start > 0) {
                this.addMessage(new Tuple<EnumTypeLog, String>(EnumTypeLog.INFO, "\u7701\u7565\u3055\u308c\u305f" + start + "\u4ef6\u306e\u30e1\u30c3\u30bb\u30fc\u30b8"));
            }
            for (int i = start; i < loggerMirrg.getMessageCount(); ++i) {
                this.addMessage(loggerMirrg.getMessage(i));
            }
            loggerMirrg.registerListener(message -> {
                if (this.disabled || this.neon.isDisposed()) {
                    return true;
                }
                SwingUtilities.invokeLater(() -> this.addMessage((Tuple<EnumTypeLog, String>)message));
                return false;
            });
        });
        this.neon.prepareFrame();
    }

    public void disableAcceptMessage() {
        this.disabled = true;
        this.addMessage(new Tuple<EnumTypeLog, String>(EnumTypeLog.INFO, "Log window has been disabled."));
    }

    private void addMessage(Tuple<EnumTypeLog, String> message) {
        try {
            this.document.insertString(this.document.getLength(), message.getY() + "\n", this.document.getStyle(message.getX().name()));
            if (this.checkBoxAutoScroll.isSelected()) {
                this.scrollPaneMessages.validate();
                JScrollBar scrollBar = this.scrollPaneMessages.getVerticalScrollBar();
                try {
                    scrollBar.setValue(scrollBar.getMaximum() - scrollBar.getVisibleAmount());
                }
                catch (NullPointerException e) {
                    HLog.processExceptionUnexpected(e);
                }
            }
        }
        catch (BadLocationException e) {
            HLog.processExceptionUnexpected(e);
        }
    }
}

