/*
 * Decompiled with CFR 0.152.
 */
package mirrg.swing.neon.v1_1;

import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import mirrg.event.nitrogen.api.v1_0.INitrogenEventManager;
import mirrg.event.nitrogen.v2_1.HNitrogenEvent;
import mirrg.swing.neon.v1_1.NitrogenEventNeon;
import mirrg.swing.neon.v1_1.artifacts.logging.HLog;

public class Neon {
    private INitrogenEventManager eventManager;
    private Window window;
    private volatile boolean isInitialized = false;
    private boolean visible = false;
    private volatile boolean isDisposed = false;

    public Neon(JFrame window) {
        this(window, HNitrogenEvent.createInstance());
    }

    public Neon(JDialog window) {
        this(window, HNitrogenEvent.createInstance());
    }

    public Neon(JFrame window, INitrogenEventManager eventManager) {
        this((Window)window, eventManager);
    }

    public Neon(JDialog window, INitrogenEventManager eventManager) {
        this((Window)window, eventManager);
    }

    private Neon(Window window, INitrogenEventManager eventManager) {
        this.window = window;
        this.eventManager = eventManager;
        this.init();
    }

    public INitrogenEventManager getEventManager() {
        return this.eventManager;
    }

    public void init() {
        this.window.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
                Neon.this.visible = true;
                if (!Neon.this.isInitialized) {
                    Neon.this.isInitialized = true;
                    Neon.this.eventManager.post(new NitrogenEventNeon.Initialized(Neon.this.window, Neon.this, e));
                }
                Neon.this.eventManager.post(new NitrogenEventNeon.Shown(Neon.this.window, Neon.this, e));
            }

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                Neon.this.visible = false;
                Neon.this.eventManager.post(new NitrogenEventNeon.Hidden(Neon.this.window, Neon.this, e));
            }
        });
        this.window.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
                Neon.this.isDisposed = true;
                if (Neon.this.visible) {
                    Neon.this.eventManager.post(new NitrogenEventNeon.Hidden(Neon.this.window, Neon.this, e));
                }
                Neon.this.eventManager.post(new NitrogenEventNeon.Disposed(Neon.this.window, Neon.this, e));
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    public void prepareFrame(int defaultCloseOperation) {
        if (this.window instanceof JFrame) {
            ((JFrame)this.window).setDefaultCloseOperation(defaultCloseOperation);
        } else if (this.window instanceof JDialog) {
            ((JDialog)this.window).setDefaultCloseOperation(defaultCloseOperation);
        } else {
            HLog.processExceptionWarning(new ClassCastException(this.window.toString() + " is not a JFrame or JDialog."));
        }
        this.window.pack();
        this.window.setLocationByPlatform(true);
    }

    public void prepareFrame() {
        this.prepareFrame(2);
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }
}

