/*
 * Decompiled with CFR 0.152.
 */
package mirrg.game.math.wulfenite.v0_1;

import java.awt.CardLayout;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import mirrg.event.nitrogen.api.v1_0.INitrogenEventRegistry;
import mirrg.game.math.wulfenite.v0_1.FrameBase;
import mirrg.game.math.wulfenite.v0_1.events.NitrogenEventWulfenite;
import mirrg.game.math.wulfenite.v0_1.events.NitrogenEventWulfeniteFrameFormula;
import mirrg.game.math.wulfenite.v0_1.script2.ArgumentsValidate;
import mirrg.game.math.wulfenite.v0_1.script2.HWulfeniteScript2;
import mirrg.game.math.wulfenite.v0_1.script2.ResponseCompile;
import mirrg.game.math.wulfenite.v0_1.script2.tnode.ITNodeRoot;
import mirrg.struct.hydrogen.v1_0.Struct1;

public class FrameFormula
extends FrameBase {
    private static final long serialVersionUID = -69686069227706495L;
    protected INitrogenEventRegistry eventRegistry;
    protected JTextArea textAreaSource;
    protected JTextArea textAreaShow;
    protected String titleBase = this.getTitle();
    protected boolean running = false;
    protected File file = null;
    protected boolean dirty = false;
    protected Thread threadCompile = null;

    public FrameFormula(INitrogenEventRegistry eventRegistry) {
        super("Wulfenite\u5f0f");
        this.eventRegistry = eventRegistry;
    }

    public void updateTitle() {
        this.setTitle(this.titleBase + (this.running ? " [\u30b3\u30f3\u30d1\u30a4\u30eb\u4e2d]" : "") + (this.file != null ? " - " + this.file.getName() : "") + (this.dirty ? " *" : ""));
    }

    @Override
    protected void initContents() {
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu menu = new JMenu("\u30d5\u30a1\u30a4\u30eb(F)");
        menu.setMnemonic('F');
        menuBar.add(menu);
        Struct1<Consumer<File>> handlerFile = new Struct1<Consumer<File>>(file2 -> {
            this.file = file2;
        });
        JMenuItem menuItem = new JMenuItem("\u958b\u304f(O)");
        menuItem.setMnemonic('O');
        menu.add(menuItem);
        menuItem.addActionListener(event -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Wulfenite \u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb(*.wul)", "wul"));
            fileChooser.setAcceptAllFileFilterUsed(true);
            int res = fileChooser.showOpenDialog(this);
            if (res == 1) {
                this.textAreaShow.setText("\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            } else if (res == -1) {
                this.textAreaShow.setText("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            }
            try (BufferedReader in = new BufferedReader(new InputStreamReader(new FileInputStream(fileChooser.getSelectedFile())));){
                String data = in.lines().collect(Collectors.joining("\n"));
                this.textAreaSource.setText(data);
                this.update();
                this.dirty = false;
                ((Consumer)handlerFile.x).accept(fileChooser.getSelectedFile());
                this.updateTitle();
            }
            catch (Exception e) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(out));
                this.textAreaShow.setText(out.toString());
            }
        });
        menuItem = new JMenuItem("\u5225\u540d\u3067\u4fdd\u5b58(A)");
        menuItem.setMnemonic('A');
        menu.add(menuItem);
        menuItem.addActionListener(event -> {
            JFileChooser fileChooser = new JFileChooser();
            fileChooser.addChoosableFileFilter(new FileNameExtensionFilter("Wulfenite \u30b9\u30af\u30ea\u30d7\u30c8\u30d5\u30a1\u30a4\u30eb(*.wul)", "wul"));
            fileChooser.setAcceptAllFileFilterUsed(true);
            int res = fileChooser.showSaveDialog(this);
            if (res == 1) {
                this.textAreaShow.setText("\u30c0\u30a4\u30a2\u30ed\u30b0\u304c\u30ad\u30e3\u30f3\u30bb\u30eb\u3055\u308c\u307e\u3057\u305f\u3002");
            } else if (res == -1) {
                this.textAreaShow.setText("\u30c0\u30a4\u30a2\u30ed\u30b0\u4e0a\u3067\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f\u3002");
            }
            try (PrintStream out = new PrintStream(new FileOutputStream(fileChooser.getSelectedFile()));){
                out.print(this.textAreaSource.getText());
                this.dirty = false;
                ((Consumer)handlerFile.x).accept(fileChooser.getSelectedFile());
                this.updateTitle();
            }
            catch (Exception e) {
                ByteArrayOutputStream out2 = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(out2));
                this.textAreaShow.setText(out2.toString());
            }
        });
        menuItem = new JMenuItem("\u4e0a\u66f8\u304d\u4fdd\u5b58(S)");
        menuItem.setMnemonic('S');
        menu.add(menuItem);
        menuItem.setEnabled(false);
        handlerFile.x = ((Consumer)handlerFile.x).andThen(file2 -> menuItem.setEnabled(true));
        menuItem.addActionListener(event -> {
            try (PrintStream out = new PrintStream(new FileOutputStream(this.file));){
                out.print(this.textAreaSource.getText());
                this.dirty = false;
                this.updateTitle();
            }
            catch (Exception e) {
                ByteArrayOutputStream out2 = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(out2));
                this.textAreaShow.setText(out2.toString());
            }
        });
        menu = new JMenu("\u30b3\u30f3\u30d1\u30a4\u30eb(C)");
        menu.setMnemonic('C');
        menuBar.add(menu);
        JMenuItem menuItem2 = new JMenuItem("\u518d\u30b3\u30f3\u30d1\u30a4\u30eb\u958b\u59cb(C)");
        menuItem2.setMnemonic('C');
        menu.add(menuItem2);
        menuItem2.addActionListener(event -> this.update());
        menuItem2 = new JMenuItem("\u30b3\u30f3\u30d1\u30a4\u30eb\u505c\u6b62(S)");
        menuItem2.setMnemonic('S');
        menu.add(menuItem2);
        menuItem2.addActionListener(event -> this.stop());
        JSplitPane splitPane = new JSplitPane(0, false);
        this.add(splitPane);
        splitPane.setResizeWeight(0.5);
        this.textAreaSource = new JTextArea();
        splitPane.add(new JScrollPane(this.textAreaSource));
        this.textAreaSource.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                FrameFormula.this.dirty = true;
                FrameFormula.this.updateTitle();
                FrameFormula.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FrameFormula.this.dirty = true;
                FrameFormula.this.updateTitle();
                FrameFormula.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                FrameFormula.this.dirty = true;
                FrameFormula.this.updateTitle();
                FrameFormula.this.update();
            }
        });
        this.textAreaShow = new JTextArea();
        splitPane.add(new JScrollPane(this.textAreaShow));
        this.textAreaShow.setEditable(false);
        this.setLayout(new CardLayout());
    }

    @Override
    protected void initEvents() {
        this.eventRegistry.register(NitrogenEventWulfenite.Init.class, event -> this.update());
        this.eventRegistry.register(NitrogenEventWulfenite.Destroy.class, event -> this.dispose());
    }

    @Override
    protected void postInit() {
        this.setSize(500, 200);
        this.setDefaultCloseOperation(1);
    }

    protected void update() {
        this.onStopCompile();
        this.threadCompile = new Thread(() -> {
            try {
                this.compile();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
        this.threadCompile.setDaemon(true);
        this.threadCompile.setName("Compiling");
        this.threadCompile.start();
        this.running = true;
        this.updateTitle();
    }

    protected void compile() throws InterruptedException {
        ResponseCompile responseCompile = HWulfeniteScript2.compile(this.textAreaSource.getText());
        if (!responseCompile.isSuccessed()) {
            SwingUtilities.invokeLater(() -> {
                this.onStopCompile();
                this.running = false;
                this.updateTitle();
                System.out.println("Syntax Error!!");
                this.textAreaSource.setBackground(new Color(1.0f, 0.8f, 0.8f));
                if (this.textAreaShow != null) {
                    this.textAreaShow.setText(responseCompile.getMessageString());
                }
                this.getEventManager().post(new NitrogenEventWulfeniteFrameFormula.SyntaxError(responseCompile));
            });
        } else {
            ArgumentsValidate argumentsValidate = new ArgumentsValidate(responseCompile);
            if (!((ITNodeRoot)responseCompile.response.node).validate(argumentsValidate)) {
                SwingUtilities.invokeLater(() -> {
                    this.onStopCompile();
                    this.running = false;
                    this.updateTitle();
                    System.out.println("Compile Error!!");
                    this.textAreaSource.setBackground(new Color(1.0f, 1.0f, 0.8f));
                    if (this.textAreaShow != null) {
                        this.textAreaShow.setText(argumentsValidate.getMessageString());
                    }
                    this.getEventManager().post(new NitrogenEventWulfeniteFrameFormula.CompileError(responseCompile, argumentsValidate));
                });
            } else {
                SwingUtilities.invokeLater(() -> {
                    this.onStopCompile();
                    this.running = false;
                    this.updateTitle();
                    this.textAreaSource.setBackground(new Color(0.8f, 1.0f, 0.8f));
                    if (this.textAreaShow != null) {
                        this.textAreaShow.setText("");
                    }
                    this.getEventManager().post(new NitrogenEventWulfeniteFrameFormula.Success(responseCompile, argumentsValidate));
                });
            }
        }
    }

    protected void onStopCompile() {
        if (this.threadCompile != null) {
            this.threadCompile.interrupt();
            this.threadCompile = null;
        }
    }

    protected void stop() {
        if (this.threadCompile != null) {
            this.onStopCompile();
            this.running = false;
            this.updateTitle();
            this.textAreaSource.setBackground(new Color(0.8f, 0.8f, 0.8f));
            this.textAreaShow.setText("\u30b3\u30f3\u30d1\u30a4\u30eb\u304c\u4e2d\u65ad\u3055\u308c\u307e\u3057\u305f\u3002");
        }
    }
}

