/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.bromine.v1_8.syntaxes.connection;

import java.util.ArrayList;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import mirrg.compile.bromine.v1_8.Syntax;
import mirrg.compile.bromine.v1_8.syntaxes.connection.IHandleDeleteNode;
import mirrg.compile.bromine.v1_8.syntaxes.connection.IHandleSetNode;
import mirrg.compile.bromine.v1_8.syntaxes.connection.SyntaxConnectionBase;
import mirrg.compile.bromine.v1_8.syntaxes.connection.TagConnection;

public class SyntaxSerial<N>
extends SyntaxConnectionBase<N> {
    private Function<TagConnection, N> functionNode;
    private int length = 0;
    private ArrayList<Syntax<?>> syntaxes = new ArrayList();
    private ArrayList<IHandleSetNode<N, ?>> handlesSetNode = new ArrayList();
    private ArrayList<IHandleDeleteNode<N>> handlesDeleteNode = new ArrayList();

    public SyntaxSerial(UnaryOperator<N> cloner, Function<TagConnection, N> functionNode) {
        super(cloner);
        this.functionNode = functionNode;
    }

    public <C> SyntaxSerial<N> and(Syntax<C> syntax, IHandleSetNode<N, C> handleSetNode, IHandleDeleteNode<N> handleDeleteNode) {
        ++this.length;
        this.syntaxes.add(syntax);
        this.handlesSetNode.add(handleSetNode);
        this.handlesDeleteNode.add(handleDeleteNode);
        return this;
    }

    @Override
    protected boolean isLengthAllowed(int length) {
        return length == this.length;
    }

    @Override
    protected N getNode(TagConnection tag) {
        return this.functionNode.apply(tag);
    }

    @Override
    protected Syntax<?> getSyntax(int index) {
        if (index >= this.syntaxes.size()) {
            return null;
        }
        return this.syntaxes.get(index);
    }

    @Override
    protected void setNode(N node, int index, Object nodeChild) {
        this.handlesSetNode.get(index).setNode(node, index, nodeChild);
    }

    @Override
    protected void deleteNode(N node, int index) {
        this.handlesDeleteNode.get(index).deleteNode(node, index);
    }
}

