/*
 * Decompiled with CFR 0.152.
 */
package mirrg.compile.bromine.v1_8.syntaxes.connection;

import java.util.LinkedList;
import java.util.function.UnaryOperator;
import mirrg.compile.bromine.v1_8.ArgumentsParse;
import mirrg.compile.bromine.v1_8.ResponseParse;
import mirrg.compile.bromine.v1_8.Syntax;
import mirrg.compile.bromine.v1_8.syntaxes.connection.TagConnection;
import mirrg.util.NonnullIterable;
import mirrg.util.NonnullIterator;

public abstract class SyntaxConnectionBase<N>
extends Syntax<N> {
    protected UnaryOperator<N> cloner;

    public SyntaxConnectionBase(UnaryOperator<N> cloner) {
        this.cloner = cloner;
    }

    protected abstract boolean isLengthAllowed(int var1);

    protected abstract N getNode(TagConnection var1);

    protected abstract Syntax<?> getSyntax(int var1);

    protected abstract void setNode(N var1, int var2, Object var3);

    protected abstract void deleteNode(N var1, int var2);

    @Override
    protected NonnullIterable<ResponseParse<N>> parseImpl(final ArgumentsParse arguments, final int index) {
        return () -> new NonnullIterator<ResponseParse<N>>(){
            private int length;
            private boolean first;
            private Object node;
            private LinkedList iterators;
            private LinkedList offsets;
            {
                this.node = SyntaxConnectionBase.this.getNode(new TagConnection(index));
                this.iterators = new LinkedList();
                this.offsets = new LinkedList();
                this.length = 0;
                this.first = true;
                this.iterators.add(this.getIterator(arguments, index, this.length));
                this.offsets.add(0);
            }

            @Override
            public ResponseParse<N> next() {
                if (this.first) {
                    this.first = false;
                    if (SyntaxConnectionBase.this.isLengthAllowed(this.length)) {
                        return new ResponseParse(SyntaxConnectionBase.this.cloner.apply(this.node), (Integer)this.offsets.getLast(), arguments);
                    }
                }
                while (true) {
                    NonnullIterator iteratorLast;
                    ResponseParse response;
                    if ((response = (ResponseParse)(iteratorLast = (NonnullIterator)this.iterators.getLast()).next()) == null) {
                        if (this.length == 0) {
                            return null;
                        }
                        SyntaxConnectionBase.this.deleteNode(this.node, this.length - 1);
                        this.iterators.removeLast();
                        this.offsets.removeLast();
                        --this.length;
                        continue;
                    }
                    NonnullIterator<? extends ResponseParse<?>> iterator = this.getIterator(arguments, index + (Integer)this.offsets.getLast() + response.length, this.length + 1);
                    this.iterators.addLast(iterator);
                    this.offsets.addLast((Integer)this.offsets.getLast() + response.length);
                    ++this.length;
                    SyntaxConnectionBase.this.setNode(this.node, this.length - 1, response.node);
                    if (SyntaxConnectionBase.this.isLengthAllowed(this.length)) break;
                }
                return new ResponseParse(SyntaxConnectionBase.this.cloner.apply(this.node), (Integer)this.offsets.getLast(), arguments);
            }

            private NonnullIterator<? extends ResponseParse<?>> getIterator(ArgumentsParse arguments2, int index2, int length) {
                Syntax<?> syntax = SyntaxConnectionBase.this.getSyntax(length);
                if (syntax == null) {
                    return () -> null;
                }
                NonnullIterable<ResponseParse<?>> iterable = syntax.parse(arguments2, index2);
                return iterable.nonnullIterator();
            }
        };
    }
}

