/*
 * Polygon_RayTrace
 * Copylight (C) 2013 mocchi
 * mocchi_2003@yahoo.co.jp
 * License: Boost ver.1
 */

#include "rapidjson/rapidjson.h"
#include "rapidjson/document.h"
#include "rj_wrapper.h"

const char * rj_getstring (rj::Value &val, const char *default_){
	if (!val.IsString()) return default_;
	return val.GetString();
}
int rj_getint (rj::Value &val, int default_){
	if (!val.IsInt()) return default_;
	return val.GetInt();
}
unsigned int rj_getuint (rj::Value &val, unsigned int default_){
	if (!val.IsUint()) return default_;
	return val.GetUint();
}
int64_t rj_getint64 (rj::Value &val, int64_t default_){
	if (!val.IsInt64()) return default_;
	return val.GetInt64();
}
uint64_t rj_getuint64 (rj::Value &val, uint64_t default_){
	if (!val.IsUint64()) return default_;
	return val.GetUint64();
}
double rj_getdouble (rj::Value &val, double default_){
	if (!val.IsNumber()) return default_;
	return val.GetDouble();
}
rj::Value &rj_getmember (rj::Value &obj, const char *memname){
	rj::Value::MemberIterator member = obj.FindMember(memname);
	if (member != obj.MemberEnd()) return member->value;
	else{
		static rj::Value NullValue;
		return NullValue;
	}
}

rj_creator::rj_creator(rj::Document &doc) : val(&doc), alc(doc.GetAllocator()){
}
rj_creator::rj_creator(rj::Value &val_, rj::Value::AllocatorType &alc_) : val(&val_), alc(alc_){
}
void rj_creator::ChangeTarget(rj::Value &val){
	this->val = &val;
}
rj_creator &rj_creator::AddMember(const char *key, int val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, int64_t val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, unsigned int val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, uint64_t val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, double val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, const char *u8val){
	this->val->AddMember(rj::StringRef(key), rj::StringRef(u8val), alc);
	return *this;
}
rj_creator &rj_creator::AddMember(const char *key, rj::Value &val){
	this->val->AddMember(rj::StringRef(key), val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(int val){
	this->val->PushBack(val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(int64_t val){
	this->val->PushBack(val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(unsigned int val){
	this->val->PushBack(val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(uint64_t val){
	this->val->PushBack(val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(double val){
	this->val->PushBack(val, alc);
	return *this;
}
rj_creator &rj_creator::PushBack(const char *u8val){
	this->val->PushBack(rj::StringRef(u8val), alc);
	return *this;
}
rj_creator &rj_creator::PushBack(rj::Value &val){
	this->val->PushBack(val, alc);
	return *this;
}
