/*
 * PMX face information handler
 *
 * License : The MIT License
 * Copyright(c) 2015 MikuToga Partners
 */

package jp.sfjp.mikutoga.pmx.parser;

//import jp.sfjp.mikutoga.pmd.parser.*;
import jp.sfjp.mikutoga.bin.parser.LoopHandler;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;

/**
 * PMXモデルの面通知用ハンドラ.
 * <p>0から始まる. 面ID順に面は出現する.
 */
public interface PmxFaceHandler extends LoopHandler {

    /** 面抽出ループ。 */
    ParseStage FACE_LIST = new ParseStage();

    /**
     * 3つの頂点から構成される面情報の通知を受け取る。
     * <p>{@link #FACE_LIST}ループの構成要素。
     * <p>3頂点の指定順は、面カリングにおいて意味を持つ。
     * @param vertexId1 頂点IDその1
     * @param vertexId2 頂点IDその1
     * @param vertexId3 頂点IDその1
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxFaceTriangle(int vertexId1, int vertexId2, int vertexId3)
            throws MmdFormatException;

}
