/*
 * PMX bone information handler
 *
 * License : The MIT License
 * Copyright(c) 2015 MikuToga Partners
 */

package jp.sfjp.mikutoga.pmx.parser;

import jp.sfjp.mikutoga.bin.parser.LoopHandler;
import jp.sfjp.mikutoga.bin.parser.MmdFormatException;
import jp.sfjp.mikutoga.bin.parser.ParseStage;

/**
 * PMXモデルのボーンメニュー情報の通知用ハンドラ。
 */
public interface PmxMenuHandler extends LoopHandler {

    /** ボーングループ名抽出ループ。 */
    ParseStage BONEGROUP_LIST = new ParseStage();

    /** ボーングループ内訳抽出ループ。 */
    ParseStage GROUPEDBONE_LIST = new ParseStage();

    /**
     * ボーングループ名定義の通知を受け取る。
     * <p>{@link #BONEGROUP_LIST}ループの構成要素。
     * @param groupName ボーングループ名。末尾のLF(0x0a)は削除される。
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxBoneGroupInfo(String groupName) throws MmdFormatException;

    /**
     * ボーングループ内訳の通知を受け取る。
     * <p>{@link #GROUPEDBONE_LIST}ループの構成要素。
     * @param boneId グループに所属するボーンのID
     * @param groupId ボーンが所属するボーングループIDに1を足した数
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxGroupedBoneInfo(int boneId, int groupId)
            throws MmdFormatException;

}
