/*
 * PMX basic information handler
 *
 * License : The MIT License
 * Copyright(c) 2015 MikuToga Partners
 */

package jp.sfjp.mikutoga.pmx.parser;

import jp.sfjp.mikutoga.bin.parser.MmdFormatException;

/**
 * PMXモデル情報ファイルの基本情報の通知用ハンドラ。
 */
public interface PmxBasicHandler {

    /**
     * PMXファイルのパース処理開始の通知を受け取る。
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxParseStart()
            throws MmdFormatException;

    /**
     * PMXファイルのパース処理終了の通知を受け取る。
     * @param hasMoreData 入力ソースに
     * まだ読み込まれていないデータがあればtrue
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxParseEnd(boolean hasMoreData)
            throws MmdFormatException;

    /**
     * PMXファイルのヘッダ情報の通知を受け取る。
     * @param version PMXのバージョン。
     * @param encode 文字列のエンコード. 0:UTF-16, 1:UTF-8.
     * @param uv 追加UVテクスチャーの数 [0-4].
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxHeaderInfo(float version,int encode,int uv)
            throws MmdFormatException;

    /**
     * PMXファイルのモデル名前情報の通知を受け取る.
     * @param name モデル名
     * @param nameE name of the model
     * @throws MmdFormatException 不正フォーマットによる
     * パース処理の中断をパーサに指示
     */
    void pmxModelName(String name, String nameE)
            throws MmdFormatException;

    /**
     * PMXファイルのモデル説明情報の通知を受け取る.
     * @param description モデルの説明文。改行CRLFは"\n"に変換される。
     * @param descriptionE description of the model. CRLF is converted to "\n".
     * @throws MmdFormatException notics illigal format.
     * Stop the process for the parser.
     */
    void pmxModelDescription(String description, String descriptionE)
            throws MmdFormatException;
}
