/**
 * @file
 * @brief Test for @free call parameter check case.
 *
 * This is test for @free call parameter check case of @asprintf and
 * @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static char *vsnprintf2_str;

static int mock_vsnprintf2(
    char * restrict str, size_t size __attribute__((unused)),
    const char * restrict format __attribute__((unused)),
    va_list ap __attribute__((unused)))
{
    vsnprintf2_str = str;
    return -1;
}

static void *free_ptr;

static void mock_free(void *ptr)
{
    free_ptr = ptr;
    free(ptr);
}

/**
 * @brief Setup for @free call parameter check case.
 *
 * This is a setup function for @free call parameter check case.
 *
 * This function sets @c mockable_vsnprintf2 and @c mockable_free to be
 * mock function @c mock_vsnprintf2 and @c mock_free respectively, and
 * resets all save area.
 *
 * The mock function @c mock_vsnprintf2 saves its first parameter, and
 * returns @c -1.
 *
 * The mock function @c mock_free saves its parameter, and calls @free.
 */
void cut_setup(void)
{
    mockable_vsnprintf2 = mock_vsnprintf2;
    mockable_free = mock_free;
    vsnprintf2_str = "";
    free_ptr = NULL;
}

/**
 * @brief Teardown for @free call parameter check case.
 *
 * This is a teardown function for @free call parameter check case.
 *
 * This function resets @c mockable_vsnprintf2 and @c mockable_free.
 */
void cut_teardown(void)
{
    mockable_vsnprintf2 = vsnprintf;
    mockable_free = free;
}

/**
 * @brief Test for @free call parameter check case.
 *
 * This is a test for @free call parameter check case.
 */
void test_free_parameter_check_case(void)
{
    char *str;
    asprintf(&str, "%d", 123);
    cut_assert_equal_pointer(vsnprintf2_str, free_ptr);
    free(str);
}
