/**
 * @file
 * @brief Test for second @vsnprintf call parameter check case.
 *
 * This is test for second @vsnprintf call parameter check case of @asprintf
 * and @vasprintf.
 */

#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <cutter.h>

#include "asprintf.h"

static size_t malloc_size;
static void *malloc_ret;

static void *mock_malloc(size_t size)
{
    malloc_size = size;
    malloc_ret = malloc(size);
    return malloc_ret;
}

static char *vsnprintf2_str;
static size_t vsnprintf2_size;
static const char *vsnprintf2_format;
static int vsnprintf2_arg1;
static int vsnprintf2_arg2;

static int mock_vsnprintf2(
    char * restrict str, size_t size,
    const char * restrict format, va_list ap)
{
    vsnprintf2_str = str;
    vsnprintf2_size = size;
    vsnprintf2_format = format;
    va_list ap_copy;
    va_copy(ap_copy, ap);
    vsnprintf2_arg1 = va_arg(ap_copy, int);
    vsnprintf2_arg2 = va_arg(ap_copy, int);
    va_end(ap_copy);
    return vsnprintf(str, size, format, ap);
}

/**
 * @brief Setup for second @vsnprintf call parameter check case.
 *
 * This is a setup function for second @vsnprintf call parameter check case.
 *
 * This function sets @c mockable_malloc and @c mockable_vsnprintf2 to be
 * mock function @c mock_malloc and @c mock_vsnprintf2 respectively, and
 * resets all save area.
 *
 * The mock function @c mock_malloc saves its parameter, calls @malloc,
 * saves and returns @malloc return value.
 *
 * The mock function @c mock_vsnprintf2 saves its parameters, calls and
 * returns @vsnprintf return value.
 */
void cut_setup(void)
{
    mockable_malloc = mock_malloc;
    mockable_vsnprintf2 = mock_vsnprintf2;
    malloc_size = 0;
    malloc_ret = NULL;
    vsnprintf2_str = "";
    vsnprintf2_size = 0;
    vsnprintf2_format = "";
    vsnprintf2_arg1 = 0;
    vsnprintf2_arg2 = 0;
}

/**
 * @brief Teardown for second @vsnprintf call parameter check case.
 *
 * This is a teardown function for second @vsnprintf call parameter check
 * case.
 *
 * This function resets @c mockable_malloc and @c mockable_vsnprintf2.
 */
void cut_teardown(void)
{
    mockable_malloc = malloc;
    mockable_vsnprintf2 = vsnprintf;
}

/**
 * @brief Test for second @vsnprintf call parameter check case.
 *
 * This is a test for second @vsnprintf call parameter check case.
 */
void test_vsnprintf2_parameter_check_case(void)
{
    char *str;
    const char *format = "%d %d";
    int arg1 = 123;
    int arg2 = 456;
    asprintf(&str, format, arg1, arg2);
    cut_assert_equal_pointer(malloc_ret, vsnprintf2_str);
    cut_assert_equal_size(malloc_size, vsnprintf2_size);
    cut_assert_equal_pointer(format, vsnprintf2_format);
    cut_assert_equal_int(arg1, vsnprintf2_arg1);
    cut_assert_equal_int(arg2, vsnprintf2_arg2);
    free(str);
}
