﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Channels.Ipc;

namespace processArcive
{
    public class remoteContorol
    {
        /// <summary>
        /// コンストラクタ
        /// </summary>
        public remoteContorol()
        {

        }

        public RemoteObject getRemoteObject()
        {
            // クライアントチャンネルの生成
            IpcClientChannel channel = new IpcClientChannel();

            // チャンネルを登録
            ChannelServices.RegisterChannel(channel, true);

            // リモートオブジェクトを取得
            return Activator.GetObject(typeof(RemoteObject), "ipc://processContorol/main") as RemoteObject;

        }

        public void setRemoteObject(RemoteObject param)
        {
            // サーバーチャンネルの生成
            IpcServerChannel channel = new IpcServerChannel("processContorol");

            // チャンネルを登録
            ChannelServices.RegisterChannel(channel, true);

            // リモートオブジェクトを生成して公開
            RemotingServices.Marshal(param, "main", typeof(RemoteObject));

        }
    }

    public class RemoteObject : MarshalByRefObject
    {
        public Dictionary<string, TEKIYOUGYOUMU> TEKIYOUGYOUMULIST { get; set; }

    }

    public class TEKIYOUGYOUMU
    {
        public DateTime timeValue { get; set; }
        public int applID { get; set; }
        public string TEKIYOUGYOUMUID { get; set; }
        public string state { get; set; }

        public Dictionary<string,jobdata> joblist { get; set; }

        public TEKIYOUGYOUMU()
        {
        }

        public TEKIYOUGYOUMU(DateTime timeValue, int applID, string TEKIYOUGYOUMUID)
        {
            this.timeValue = timeValue;
            this.applID = applID;
            this.TEKIYOUGYOUMUID = TEKIYOUGYOUMUID;
            this.joblist = new Dictionary<string, jobdata>();
            this.state = "W"; 
        }


    }

    public class jobdata{

        public string jobname { get; set; }
        public int RCCODE { get; set; }
        public string workstationId { get; set; }
        public int opertionNumber { get; set; }

        public jobdata()
        {

        }

        public jobdata(string jobname)
        {
            this.jobname = jobname;
            this.RCCODE = 999;
            this.workstationId = "0";
            this.opertionNumber = 0;
        }
    }
}
