// {ԃNX

#include <iomanip>
#include <sstream>
#include <cstdlib>
#include <cmath>
#include "lilib.h"

using namespace std;
using namespace lilib;

// limb ̈قȂ LongInterval
void LongInterval::copy(const LongInterval &x, int size){
  int i;

  radius = x.radius;

  center.sign = x.center.sign;
  center.exponent = x.center.exponent;

  // 悪Zꍇ
  if(limbs <= size){
    for(i = 0; i < limbs; i++){
      center.limb[i] = x.center.limb[i];
    }

    // ؂̂Ă鉼𔼌aɎ荞ށB
    for(i = size - 1; i >= limbs; i--){
      radius += Radius(x.center.limb[i], LIMB_BITS * (x.center.exponent - i));
    }
  }

  // 悪ꍇ
  else{
    for(i = 0; i < size; i++){
      center.limb[i] = x.center.limb[i];
    }
    for(i = size; i < limbs; i++){
      center.limb[i] = 0;
    }
  }
}

////////////////////////////////////////////////////////////////////////////////

// *this = |a| + |b|
void LongInterval::addAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 carry;

  radius.significand = 0;
  radius.exponent = 0;

  // n ́A a  b ̏dȂĂ limb B
  n = limbs - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    center = a;
    radius = Radius(b);
    return;
  }

  // ؂̂Ă鉼𔼌aɎ荞ށB
  for(i = limbs - 1; i >= n; i--){
    radius += Radius(b.limb[i], LIMB_BITS * (b.exponent - i));
  }

  // Z
  carry = 0;
  j = n - 1;
  for(i = limbs - 1; i >= limbs - n; i--){
    work = a.limb[i];
    work += b.limb[j];
    work += carry;
    center.limb[i] = low32(work);
    carry = high32(work);
    j--;
  }

  for(i = limbs - n - 1; i >= 0; i--){
    work = a.limb[i];
    work += carry;
    center.limb[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){

    // ؂̂Ă鉼𔼌aɎ荞ށB
    radius += Radius(center.limb[limbs - 1], LIMB_BITS * (a.exponent - limbs + 1));

    for(i = limbs - 1; i > 0; i--){
      center.limb[i] = center.limb[i - 1];
    }
    center.limb[0] = carry;

    center.exponent = a.exponent + 1;
  }
  else{
    center.exponent = a.exponent;
  }
}

// *this = |a| - |b|
void LongInterval::subAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 *y, carry;

  radius.significand = 0;
  radius.exponent = 0;

  // n ́A a  b ̏dȂĂ limb B
  n = limbs - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    center = a;
    radius = Radius(b);
    return;
  }

  // SɏdȂĂꍇB
  if(n == limbs){
    carry = 0;
    for(i = limbs - 1; i >= 0; i--){
      work = 0x100000000LL;
      work += a.limb[i];
      work -= b.limb[i];
      work -= carry;
      center.limb[i] = low32(work);
      carry = 1 - high32(work);
      j--;
    }

    center.exponent = a.exponent;

    // ̐K
    center.normalize();

    return;
  }

  // a  b  limb ĂꍇA 1 limb vZB
  y = new uint32[limbs + 1];

  // ؂̂Ă鉼𔼌aɎ荞ށB
  for(i = limbs - 1; i > n; i--){
    radius += Radius(b.limb[i], LIMB_BITS * (b.exponent - i));
  }

  work = 0x100000000LL;
  work -= b.limb[n];
  y[limbs] = low32(work);
  carry = 1 - high32(work);

  // Z
  j = n - 1;
  for(i = limbs - 1; i >= limbs - n; i--){
    work = 0x100000000LL;
    work += a.limb[i];
    work -= b.limb[j];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
    j--;
  }

  // J艺
  for(i = limbs - n - 1; i >= 0; i--){
    work = 0x100000000LL;
    work += a.limb[i];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
  }

  // ̐K
  for(n = 0; n < limbs + 1; n++){
    if(y[n] != 0){
      break;
    }
  }

  center.exponent = a.exponent - n;

  // ؂̂Ă鉼𔼌aɎ荞ށB
  if(n == 0){
    radius += Radius(y[limbs], LIMB_BITS * (center.exponent - limbs));
  }

  for(i = 0; i < limbs; i++){
    if(i + n < limbs + 1){
      center.limb[i] = y[i + n];
    }
    else{
      center.limb[i] = 0;
    }
  }

  delete []y;
}

////////////////////////////////////////////////////////////////////////////////

// *this = 1 / x
void LongInterval::inverse(const LongInterval &x){
  LongInterval z, e;
  LongFloat rr, a, b;

  // z = x.mid() ^ 2 - x.rad() ^ 2
  rr.mul(x.radius, x.radius);
  z = LongInterval(x.center) * x.center - rr;

  center.inverse(z.center);

  e = z * center - 1;

  a = (z * (e - 1) + z.center).mag();
  b = (z * z.center).inf();

  // radius = a / b ւ̊ۂ߂ŌvZB
  radius.div(a, b);

  *this *= x;
}

////////////////////////////////////////////////////////////////////////////////

// *this = a * b
void LongInterval::mul(const LongFloat &a, int b){
  int i;
  uint64 work;
  uint32 carry;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b >= 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
    b = -b;
  }

  // Z
  carry = 0;
  for(i = limbs - 1; i >= 0; i--){
    work = a.limb[i];
    work *= b;
    work += carry;
    center.limb[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){

    // ؂̂Ă鉼𔼌aɎ荞ށB
    radius = Radius(center.limb[limbs - 1], LIMB_BITS * (a.exponent - limbs + 1));

    for(i = limbs - 1; i > 0; i--){
      center.limb[i] = center.limb[i - 1];
    }
    center.limb[0] = carry;

    center.exponent = a.exponent + 1;
  }
  else{
    center.exponent = a.exponent;
  }
}

// *this = a / b
void LongInterval::div(const LongFloat &a, int b){
  int i;
  uint64 work;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b >= 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
    b = -b;
  }

  // Z
  work = 0;
  for(i = 0; i < limbs; i++){
    work <<= LIMB_BITS;
    work += a.limb[i];
    center.limb[i] = work / b;
    work -= center.limb[i] * b;
  }

  // J艺
  if(center.limb[0] == 0){
    for(i = 0; i < limbs - 1; i++){
      center.limb[i] = center.limb[i + 1];
    }
    work <<= LIMB_BITS;
    center.limb[limbs - 1] = work / b;

    center.exponent = a.exponent - 1;
  }
  else{
    center.exponent = a.exponent;
  }

  // ؂̂Ă鉼𔼌aɎ荞ށB
  if(work){
    radius = Radius(1, LIMB_BITS * (center.exponent - limbs + 1));
  }
}

// *this = a + b
void LongInterval::add(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.limb[0] == 0){
    center = b;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }
  if(b.limb[0] == 0){
    center = a;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }

  if(a.sign == b.sign){
    if(a.exponent >= b.exponent){
      addAbs(a, b);
      center.sign = a.sign;
    }
    else{
      addAbs(b, a);
      center.sign = b.sign;
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      subAbs(a, b);
      center.sign = a.sign;
    }
    else{
      subAbs(b, a);
      center.sign = b.sign;
    }
  }
}

// *this = a - b
void LongInterval::sub(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.limb[0] == 0){
    center = b;
    center.sign *= -1;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }
  if(b.limb[0] == 0){
    center = a;

    radius.significand = 0;
    radius.exponent = 0;

    return;
  }

  if(a.sign != b.sign){
    if(a.exponent >= b.exponent){
      addAbs(a, b);
      center.sign = a.sign;
    }
    else{
      addAbs(b, a);
      center.sign = a.sign;
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      subAbs(a, b);
      center.sign = a.sign;
    }
    else{
      subAbs(b, a);
      center.sign = -b.sign;
    }
  }
}

// *this = a * b
void LongInterval::mul(const LongFloat &a, const LongFloat &b){
  int i, j;
  uint64 tmp;
  uint32 carry;
  uint32 *work;

  radius.significand = 0;
  radius.exponent = 0;

  // ̐ݒ
  if(b.sign > 0){
    center.sign = a.sign;
  }
  else{
    center.sign = -a.sign;
  }

  // [NXy[X̊m
  work = new uint32[2 * limbs];

  // [NXy[X̏
  for(i = 0; i < 2 * limbs; i++){
    work[i] = 0;
  }

  // MZɂZ
  for(i = limbs - 1; i >= 0; i--){
    carry = 0;
    for(j = limbs - 1; j >= 0; j--){
      tmp = a.limb[i];
      tmp *= b.limb[j];
      tmp += carry;
      tmp += work[i + j + 1];

      work[i + j + 1] = low32(tmp);
      carry = high32(tmp);
    }
    work[i] += carry;
  }

  // Zʂ̏ʔoB
  if(work[0]){
    for(i = 0; i < limbs; i++){
      center.limb[i] = work[i];
    }
    center.exponent = a.exponent + b.exponent + 1;

    // ؂̂Ă鉼𔼌aɎ荞ށB
    for(i = 2 * limbs - 1; i >= limbs; i--){
      radius += Radius(work[i], LIMB_BITS * (center.exponent - i));
    }
  }
  else{
    for(i = 0; i < limbs; i++){
      center.limb[i] = work[i + 1];
    }
    center.exponent = a.exponent + b.exponent;

    // ؂̂Ă鉼𔼌aɎ荞ށB
    for(i = 2 * limbs - 1; i >= limbs + 1; i--){
      radius += Radius(work[i], LIMB_BITS * (center.exponent - i + 1));
    }
  }

  // [NXy[X̔j
  delete []work;
}

////////////////////////////////////////////////////////////////////////////////

// [̎擾(ւ̊ۂ)
LongFloat LongInterval::infIn() const{
  LongInterval y;
  LongFloat r;

  y = center;
  r = rad();
  y -= r;

  // y ̔a 0 łȂƂ
  if(y.radius.significand){

    // y ̒Sl 0 ̂Ƃ
    if(y.center.limb[0] == 0){
      return r;
    }

    // y ̒SlƔadȂĂƂ
    if(LIMB_BITS * y.center.exponent <= y.radius.exponent){
      return y.infIn();
    }

    // y ̒SlƔadȂĂȂƂ
    if(y.center.sign > 0){
      y.center.increase();
    }
    else{
      y.center.decrease();
    }
  }

  // y ̔a 0 ̂Ƃ
  return y.center;
}

// [̎擾(ւ̊ۂ)
LongFloat LongInterval::supIn() const{
  LongInterval y;
  LongFloat r;

  y = center;
  r = rad();
  y += r;

  // y ̔a 0 łȂƂ
  if(y.radius.significand){

    // y ̒Sl 0 ̂Ƃ
    if(y.center.limb[0] == 0){
      r.sign = -1;
      return r;
    }

    // y ̒SlƔadȂĂƂ
    if(LIMB_BITS * y.center.exponent <= y.radius.exponent){
      return y.supIn();
    }

    // y ̒SlƔadȂĂȂƂ
    if(y.center.sign > 0){
      y.center.decrease();
    }
    else{
      y.center.increase();
    }
  }

  // y ̔a 0 ̂Ƃ
  return y.center;
}

////////////////////////////////////////////////////////////////////////////////

// RXgN^
LongInterval::LongInterval(){
}

// RXgN^
LongInterval::LongInterval(int x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;
}

// RXgN^
LongInterval::LongInterval(double x){
  center.setDouble(x);

  radius.significand = 0;
  radius.exponent = 0;
}

// RXgN^
LongInterval::LongInterval(const LongFloat &x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;
}

// Rs[RXgN^
LongInterval::LongInterval(const LongInterval &x){
  center = x.center;
  radius = x.radius;
}

// RXgN^
LongInterval::LongInterval(int mid, int rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(const LongFloat &mid, int rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(int mid, const LongFloat &rad){
  setMidRad(mid, rad);
}

// RXgN^
LongInterval::LongInterval(const LongFloat &mid, const LongFloat &rad){
  setMidRad(mid, rad);
}

// fXgN^
LongInterval::~LongInterval(){
}

////////////////////////////////////////////////////////////////////////////////

// double ̕ϊ
void LongInterval::setDouble(double x){
  center.setDouble(x);

  radius.significand = 0;
  radius.exponent = 0;
}

// SlƔa̐ݒ
void LongInterval::setMidRad(int mid, int rad){
  if(rad < 0){
    cerr << "[ERROR] LongInterval::setMidRad(" << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad, 0);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(const LongFloat &mid, int rad){
  if(rad < 0){
    cerr << "[ERROR] LongInterval::setMidRad(" << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad, 0);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(int mid, const LongFloat &rad){
  if(rad.sign < 0){
    cerr << "[ERROR] LongInterval::setMidRad(" << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad);
}

// SlƔa̐ݒ
void LongInterval::setMidRad(const LongFloat &mid, const LongFloat &rad){
  if(rad.sign < 0){
    cerr << "[ERROR] LongInterval::setMidRad(" << mid << ", " << rad << ") : Invalid argument." << endl;
    exit(1);
  }

  center = mid;
  radius = Radius(rad);
}

////////////////////////////////////////////////////////////////////////////////

// double ւ̕ϊ
double LongInterval::getDouble() const{
  return center.getDouble();
}

// SlƔa\̎擾
string LongInterval::getMidRad() const{
  ostringstream output;

  output << "<" << center << ", " << radius << ">";

  return output.str();
}

// [Ə[\̎擾
string LongInterval::getInfSup() const{
  ostringstream output;

  output << "[" << inf() << ", " << sup() << "]";

  return output.str();
}

// f[^\̎擾
string LongInterval::getInternalData() const{
  ostringstream output;

  output << center.getInternalData() << endl;
  output << "radius   : " << radius.getInternalData();

  return output.str();
}

////////////////////////////////////////////////////////////////////////////////

// Sl̎擾
LongFloat LongInterval::mid() const{
  return center;
}

// a̎擾
LongFloat LongInterval::rad() const{
  return LongFloat(radius);
}

// a̎擾
LongFloat LongInterval::diam() const{
  return LongFloat(Radius(radius.significand, radius.exponent + 1));
}

// [̎擾
LongFloat LongInterval::inf() const{
  LongInterval y;
  LongFloat r;

  y = center;
  r = rad();
  y -= r;

  // y ̔a 0 łȂƂ
  if(y.radius.significand){

    // y ̒Sl 0 ̂Ƃ
    if(y.center.limb[0] == 0){
      return r;
    }

    // y ̒SlƔadȂĂƂ
    if(LIMB_BITS * y.center.exponent <= y.radius.exponent){
      return y.inf();
    }

    // y ̒SlƔadȂĂȂƂ
    if(y.center.sign > 0){
      y.center.decrease();
    }
    else{
      y.center.increase();
    }
  }

  // y ̔a 0 ̂Ƃ
  return y.center;
}

// [̎擾
LongFloat LongInterval::sup() const{
  LongInterval y;
  LongFloat r;

  y = center;
  r = rad();
  y += r;

  // y ̔a 0 łȂƂ
  if(y.radius.significand){

    // y ̒Sl 0 ̂Ƃ
    if(y.center.limb[0] == 0){
      r.sign = -1;
      return r;
    }

    // y ̒SlƔadȂĂƂ
    if(LIMB_BITS * y.center.exponent <= y.radius.exponent){
      return y.sup();
    }

    // y ̒SlƔadȂĂȂƂ
    if(y.center.sign > 0){
      y.center.increase();
    }
    else{
      y.center.decrease();
    }
  }

  // y ̔a 0 ̂Ƃ
  return y.center;
}

// ŏΒl̎擾
LongFloat LongInterval::mig() const{

  // 0 ܂ޏꍇB
  if(center.compareAbs(rad()) <= 0){
    return 0;
  }

  if(center.sign > 0){
    return inf();
  }
  else{
    return -sup();
  }
}

// őΒl̎擾
LongFloat LongInterval::mag() const{
  if(center.sign > 0){
    return sup();
  }
  else{
    return -inf();
  }
}

// x ܂ނ
int LongInterval::contains(int x) const{
  if((x <= inf()) || (sup() <= x)){
    return 0;
  }

  if((infIn() < x) && (x < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(int x) const{
  if((x < inf()) || (sup() < x)){
    return 0;
  }

  if((infIn() <= x) && (x <= supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ
int LongInterval::contains(const LongFloat &x) const{
  if((x <= inf()) || (sup() <= x)){
    return 0;
  }

  if((infIn() < x) && (x < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(const LongFloat &x) const{
  if((x < inf()) || (sup() < x)){
    return 0;
  }

  if((infIn() <= x) && (x <= supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ
int LongInterval::contains(const LongInterval &x) const{
  if((x.infIn() <= inf()) || (sup() <= x.supIn())){
    return 0;
  }

  if((infIn() < x.inf()) && (x.sup() < supIn())){
    return 1;
  }

  return -1;
}

// x ܂ނ(E܂)
int LongInterval::containsEqual(const LongInterval &x) const{
  if((x.infIn() < inf()) || (sup() < x.supIn())){
    return 0;
  }

  if((infIn() <= x.inf()) && (x.sup() <= supIn())){
    return 1;
  }

  return -1;
}

// PZ
////////////////////////////////////////////////////////////////////////////////

// +LongInterval
LongInterval LongInterval::operator +() const{
  return *this;
}

// -LongInterval
LongInterval LongInterval::operator -() const{
  LongInterval result;

  result = *this;
  result.center.sign = -center.sign;

  return result;
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// LongInterval + int
LongInterval LongInterval::operator +(int x) const{
  return *this + LongFloat(x);
}

// LongInterval - int
LongInterval LongInterval::operator -(int x) const{
  return *this - LongFloat(x);
}

// LongInterval * int
LongInterval LongInterval::operator *(int x) const{
  LongInterval result;
  Radius r;

  r = radius * x;
  result.mul(center, x);
  result.radius += r;

  return result;
}

// LongInterval / int
LongInterval LongInterval::operator /(int x) const{
  LongInterval result;
  Radius r;

  if(x == 0){
    cerr << "[ERROR] LongInterval / int : Division by zero." << endl;
    exit(1);
  }

  r = radius / x;
  result.div(center, x);
  result.radius += r;

  return result;
}

// LongInterval + LongFloat
LongInterval LongInterval::operator +(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius;
  result.add(center, x);
  result.radius += r;

  return result;
}

// LongInterval - LongFloat
LongInterval LongInterval::operator -(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius;
  result.sub(center, x);
  result.radius += r;

  return result;
}

// LongInterval * LongFloat
LongInterval LongInterval::operator *(const LongFloat &x) const{
  LongInterval result;
  Radius r;

  r = radius * Radius(x);
  result.mul(center, x);
  result.radius += r;

  return result;
}

// LongInterval / LongFloat
LongInterval LongInterval::operator /(const LongFloat &x) const{
  LongInterval invX, result;

  if(x.limb[0] == 0){
    cerr << "[ERROR] LongInterval / LongFloat : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  return *this * invX;
}

// LongInterval + LongInterval
LongInterval LongInterval::operator +(const LongInterval &x) const{
  LongInterval result;
  Radius r;

  r = radius + x.radius;
  result.add(center, x.center);
  result.radius += r;

  return result;
}

// LongInterval - LongInterval
LongInterval LongInterval::operator -(const LongInterval &x) const{
  LongInterval result;
  Radius r;

  r = radius + x.radius;
  result.sub(center, x.center);
  result.radius += r;

  return result;
}

// LongInterval * LongInterval
LongInterval LongInterval::operator *(const LongInterval &x) const{
  LongInterval result;
  LongFloat rr;

  // ̋Ԃ 0 ܂܂Ȃꍇ
  if((center.compareAbs(rad()) >= 0) && (x.center.compareAbs(x.rad()) >= 0)){
    result.mul(center, x.center);
    result.center.sign = 1;

    rr.mul(radius, x.radius);
    result += rr;

    result.center.sign = center.sign * x.center.sign;

    result.radius += Radius(center) * x.radius + Radius(x.center) * radius;

    return result;
  }

  // ꎞI limb 𑝂₷B
  limbs += 2;

  LongFloat c1, c2, c1r2, c2r1;
  LongInterval y;

  c1.copy(center, limbs - 2);
  c2.copy(x.center, limbs - 2);

  c1.sign = 1;
  c2.sign = 1;

  y.mul(c1, c2);
  y.radius += radius * x.radius;

  c1r2.mul(c1, LongFloat(x.radius));
  c2r1.mul(c2, LongFloat(radius));

  if(c1r2 >= c2r1){
    y += c2r1;
    y.radius += Radius(c1) * x.radius;
  }

  else{
    y += c1r2;
    y.radius += Radius(c2) * radius;
  }

  y.center.sign = center.sign * x.center.sign;

  // limb ɖ߂B
  limbs -= 2;

  result.copy(y, limbs + 2);

  return result;
}

// LongInterval / LongInterval
LongInterval LongInterval::operator /(const LongInterval &x) const{
  LongInterval invX, result;

  if(x.center.compareAbs(x.rad()) <= 0){
    cerr << "[ERROR] LongInterval / LongInterval : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  return *this * invX;
}

// LongInterval + LongMatrix
LongIntervalMatrix LongInterval::operator +(const LongMatrix &x) const{
  return x + *this;
}

// LongInterval - LongMatrix
LongIntervalMatrix LongInterval::operator -(const LongMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongInterval * LongMatrix
LongIntervalMatrix LongInterval::operator *(const LongMatrix &x) const{
  return x * *this;
}

// LongInterval / LongMatrix
LongIntervalMatrix LongInterval::operator /(const LongMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// LongInterval + LongIntervalMatrix
LongIntervalMatrix LongInterval::operator +(const LongIntervalMatrix &x) const{
  return x + *this;
}

// LongInterval - LongIntervalMatrix
LongIntervalMatrix LongInterval::operator -(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongInterval * LongIntervalMatrix
LongIntervalMatrix LongInterval::operator *(const LongIntervalMatrix &x) const{
  return x * *this;
}

// LongInterval / LongIntervalMatrix
LongIntervalMatrix LongInterval::operator /(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// rZ
////////////////////////////////////////////////////////////////////////////////

// LongInterval < int
int LongInterval::operator <(int x) const{
  return *this < LongFloat(x);
}

// LongInterval > int
int LongInterval::operator >(int x) const{
  return *this > LongFloat(x);
}

// LongInterval <= int
int LongInterval::operator <=(int x) const{
  return *this <= LongFloat(x);
}

// LongInterval >= int
int LongInterval::operator >=(int x) const{
  return *this >= LongFloat(x);
}

// LongInterval < LongFloat
int LongInterval::operator <(const LongFloat &x) const{
  if(sup() < x){
    return 1;
  }

  if(supIn() >= x){
    return 0;
  }

  return -1;
}

// LongInterval > LongFloat
int LongInterval::operator >(const LongFloat &x) const{
  if(inf() > x){
    return 1;
  }

  if(infIn() <= x){
    return 0;
  }

  return -1;
}

// LongInterval <= LongFloat
int LongInterval::operator <=(const LongFloat &x) const{
  if(sup() <= x){
    return 1;
  }

  if(supIn() > x){
    return 0;
  }

  return -1;
}

// LongInterval >= LongFloat
int LongInterval::operator >=(const LongFloat &x) const{
  if(inf() >= x){
    return 1;
  }

  if(infIn() < x){
    return 0;
  }

  return -1;
}

// LongInterval == LongInterval
bool LongInterval::operator ==(const LongInterval &x) const{
  if(radius != x.radius){
    return false;
  }

  if(center != x.center){
    return false;
  }

  return true;
}

// LongInterval != LongInterval
bool LongInterval::operator !=(const LongInterval &x) const{
  return !(*this == x);
}

// LongInterval < LongInterval
int LongInterval::operator <(const LongInterval &x) const{
  if(sup() < x.inf()){
    return 1;
  }

  if(supIn() >= x.infIn()){
    return 0;
  }

  return -1;
}

// LongInterval > LongInterval
int LongInterval::operator >(const LongInterval &x) const{
  if(inf() > x.sup()){
    return 1;
  }

  if(infIn() <= x.supIn()){
    return 0;
  }

  return -1;
}

// LongInterval <= LongInterval
int LongInterval::operator <=(const LongInterval &x) const{
  if(sup() <= x.inf()){
    return 1;
  }

  if(supIn() > x.infIn()){
    return 0;
  }

  return -1;
}

// LongInterval >= LongInterval
int LongInterval::operator >=(const LongInterval &x) const{
  if(inf() >= x.sup()){
    return 1;
  }

  if(infIn() < x.supIn()){
    return 0;
  }

  return -1;
}

// Z
////////////////////////////////////////////////////////////////////////////////

// LongInterval = int
LongInterval &LongInterval::operator =(int x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;

  return *this;
}

// LongInterval += int
LongInterval &LongInterval::operator +=(int x){
  *this = *this + x;

  return *this;
}

// LongInterval -= int
LongInterval &LongInterval::operator -=(int x){
  *this = *this - x;

  return *this;
}

// LongInterval *= int
LongInterval &LongInterval::operator *=(int x){
  Radius r;

  r = radius * x;
  mul(center, x);
  radius += r;

  return *this;
}

// LongInterval /= int
LongInterval &LongInterval::operator /=(int x){
  Radius r;

  if(x == 0){
    cerr << "[ERROR] LongInterval /= int : Division by zero." << endl;
    exit(1);
  }

  r = radius / x;
  div(center, x);
  radius += r;

  return *this;
}

// LongInterval = LongFloat
LongInterval &LongInterval::operator =(const LongFloat &x){
  center = x;

  radius.significand = 0;
  radius.exponent = 0;

  return *this;
}

// LongInterval += LongFloat
LongInterval &LongInterval::operator +=(const LongFloat &x){
  *this = *this + x;

  return *this;
}

// LongInterval -= LongFloat
LongInterval &LongInterval::operator -=(const LongFloat &x){
  *this = *this - x;

  return *this;
}

// LongInterval *= LongFloat
LongInterval &LongInterval::operator *=(const LongFloat &x){
  Radius r;

  r = radius * Radius(x);
  mul(center, x);
  radius += r;

  return *this;
}

// LongInterval /= LongFloat
LongInterval &LongInterval::operator /=(const LongFloat &x){
  LongInterval invX;

  if(x.limb[0] == 0){
    cerr << "[ERROR] LongInterval /= LongFloat : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  *this *= invX;

  return *this;
}

// LongInterval = LongInterval
LongInterval &LongInterval::operator =(const LongInterval &x){
  center = x.center;
  radius = x.radius;

  return *this;
}

// LongInterval += LongInterval
LongInterval &LongInterval::operator +=(const LongInterval &x){
  *this = *this + x;

  return *this;
}

// LongInterval -= LongInterval
LongInterval &LongInterval::operator -=(const LongInterval &x){
  *this = *this - x;

  return *this;
}

// LongInterval *= LongInterval
LongInterval &LongInterval::operator *=(const LongInterval &x){
  *this = *this * x;

  return *this;
}

// LongInterval /= LongInterval
LongInterval &LongInterval::operator /=(const LongInterval &x){
  LongInterval invX;

  if(x.center.compareAbs(x.rad()) <= 0){
    cerr << "[ERROR] LongInterval /= LongInterval : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  *this *= invX;

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int + LongInterval
LongInterval operator +(int a, const LongInterval &b){
  return b + LongFloat(a);
}

// int - LongInterval
LongInterval operator -(int a, const LongInterval &b){
  return LongFloat(a) - b;
}

// int * LongInterval
LongInterval operator *(int a, const LongInterval &b){
  return b * a;
}

// int / LongInterval
LongInterval operator /(int a, const LongInterval &b){
  LongInterval invB, result;

  if(b.center.compareAbs(b.rad()) <= 0){
    cerr << "[ERROR] int / LongInterval : Division by zero." << endl;
    exit(1);
  }

  invB.inverse(b);

  result = a * invB;

  return result;
}

// rZith֐j
////////////////////////////////////////////////////////////////////////////////

// int < LongInterval
int operator <(int a, const LongInterval &b){
  return LongFloat(a) < b;
}

// int > LongInterval
int operator >(int a, const LongInterval &b){
  return LongFloat(a) > b;
}

// int <= LongInterval
int operator <=(int a, const LongInterval &b){
  return LongFloat(a) <= b;
}

// int >= LongInterval
int operator >=(int a, const LongInterval &b){
  return LongFloat(a) >= b;
}

////////////////////////////////////////////////////////////////////////////////

// ׂ
LongInterval pow(const LongInterval &x, int n){
  LongInterval y, a;
  bool positive;

  if(n == 0){
    return 1;
  }

  if(n > 0){
    positive = true;
  }
  else{
    n = -n;
    positive = false;
  }

  n--;
  a = x;
  y = a;

  while(n > 0){
    if(n % 2){
      y *= a;
    }

    n /= 2;
    if(n){
      a *= a;
    }
  }

  if(positive){
    return y;
  }
  else{
    return 1 / y;
  }
}

// 
LongInterval sqrt(const LongInterval &x){
  LongInterval y, e;
  LongFloat z, a, b;
  Radius r;

  if(x.center.compareAbs(x.rad()) < 0){
    cerr << "[ERROR] sqrt(LongInterval) : Complex number." << endl;
    exit(1);
  }

  // 0 ̏ꍇ
  if(x.center.limb[0] == 0){
    return 0;
  }

  z = sqrt(x.center);

  e = x.center / (LongInterval(z) * z);

  y = z * (e * e + 3) / 4;

  a = x.rad();
  b = (LongInterval(x.center.sqrtInf()) + x.inf().sqrtInf()).inf();

  // y.radius = a / b ւ̊ۂ߂ŌvZB
  r.div(a, b);

  y.radius += r;

  return y;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << Interval
ostream &operator <<(ostream &output, const LongInterval &x){
  output << x.getMidRad();

  return output;
}
