// {NX

#include <iomanip>
#include <sstream>
#include <cstdlib>
#include <cmath>
#include "lilib.h"

using namespace std;
using namespace lilib;

// ̐K
void LongFloat::normalize(){
  int i, e;

  // Vtg limb 𐔂B
  for(e = 0; e < limbs; e++){
    if(limb[e]){
      break;
    }
  }

  // 0 ̏ꍇ
  if(e == limbs){
    exponent = 0;

    return;
  }

  // e limb VtgB
  if(e > 0){
    for(i = 0; i < limbs - e; i++){
      limb[i] = limb[i + e];
    }

    for(i = limbs - e; i < limbs; i++){
      limb[i] = 0;
    }

    exponent -= e;
  }
}

// ŉʃrbg 1 
void LongFloat::increase(){
  int i;

  // 0 ̏ꍇ
  if(limb[0] == 0){
    limb[0] = 1;
    exponent = -limbs + 1;

    return;
  }

  for(i = limbs - 1; i >= 0; i--){
    if(limb[i] < 0xffffffff){
      limb[i]++;
      break;
    }
    limb[i] = 0;
  }

  if(limb[0] == 0){
    limb[0] = 1;
    exponent++;
  }
}

// ŉʃrbg 1 
void LongFloat::decrease(){
  int i;

  for(i = limbs - 1; i >= 0; i--){
    if(limb[i]){
      limb[i]--;
      break;
    }
    limb[i] = 0xffffffff;
  }

  if(limb[0] == 0){
    limb[0] = 0xffffffff;
    exponent--;
  }
}

////////////////////////////////////////////////////////////////////////////////

// limb ̈قȂ LongFloat 
void LongFloat::copy(const LongFloat &x, int size){
  int i;

  sign = x.sign;
  exponent = x.exponent;

  // 悪Zꍇ
  if(limbs <= size){
    for(i = 0; i < limbs; i++){
      limb[i] = x.limb[i];
    }
  }

  // 悪ꍇ
  else{
    for(i = 0; i < size; i++){
      limb[i] = x.limb[i];
    }
    for(i = size; i < limbs; i++){
      limb[i] = 0;
    }
  }
}

////////////////////////////////////////////////////////////////////////////////

// |*this|  |x| ̔r
int LongFloat::compareAbs(const LongFloat &x) const{
  int i;

  // 0 ̏ꍇ
  if(limb[0] == 0){
    if(x.limb[0] == 0){
      return 0;
    }
    else{
      return -1;
    }
  }
  if(x.limb[0] == 0){
    return 1;
  }

  // w̔r
  if(exponent > x.exponent){
    return 1;
  }
  if(exponent < x.exponent){
    return -1;
  }

  // ̔r
  for(i = 0; i < limbs; i++){
    if(limb[i] != x.limb[i]){
      break;
    }
  }

  if(i < limbs){
    if(limb[i] > x.limb[i]){
      return 1;
    }
    if(limb[i] < x.limb[i]){
      return -1;
    }
  }

  return 0;
}

// *this = |a| + |b|
void LongFloat::addAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 carry;

  // n ́A a  b ̏dȂĂ limb B
  n = limbs - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    *this = a;
    return;
  }

  // Z
  carry = 0;
  j = n - 1;
  for(i = limbs - 1; i >= limbs - n; i--){
    work = a.limb[i];
    work += b.limb[j];
    work += carry;
    limb[i] = low32(work);
    carry = high32(work);
    j--;
  }

  for(i = limbs - n - 1; i >= 0; i--){
    work = a.limb[i];
    work += carry;
    limb[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){
    for(i = limbs - 1; i > 0; i--){
      limb[i] = limb[i - 1];
    }
    limb[0] = carry;

    exponent = a.exponent + 1;
  }
  else{
    exponent = a.exponent;
  }
}

// *this = |a| - |b|
void LongFloat::subAbs(const LongFloat &a, const LongFloat &b){
  int i, j, n;
  uint64 work;
  uint32 *y, carry;

  // n ́A a  b ̏dȂĂ limb B
  n = limbs - a.exponent + b.exponent;

  // dȂĂȂꍇB
  if(n <= 0){
    *this = a;
    return;
  }

  // SɏdȂĂꍇB
  if(n == limbs){
    carry = 0;
    for(i = limbs - 1; i >= 0; i--){
      work = 0x100000000LL;
      work += a.limb[i];
      work -= b.limb[i];
      work -= carry;
      limb[i] = low32(work);
      carry = 1 - high32(work);
      j--;
    }

    exponent = a.exponent;

    // ̐K
    normalize();

    return;
  }

  // a  b  limb ĂꍇA 1 limb vZB
  y = new uint32[limbs + 1];

  work = 0x100000000LL;
  work -= b.limb[n];
  y[limbs] = low32(work);
  carry = 1 - high32(work);

  // Z
  j = n - 1;
  for(i = limbs - 1; i >= limbs - n; i--){
    work = 0x100000000LL;
    work += a.limb[i];
    work -= b.limb[j];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
    j--;
  }

  // J艺
  for(i = limbs - n - 1; i >= 0; i--){
    work = 0x100000000LL;
    work += a.limb[i];
    work -= carry;
    y[i] = low32(work);
    carry = 1 - high32(work);
  }

  // ̐K
  for(n = 0; n < limbs + 1; n++){
    if(y[n] != 0){
      break;
    }
  }

  exponent = a.exponent - n;

  for(i = 0; i < limbs; i++){
    if(i + n < limbs + 1){
      limb[i] = y[i + n];
    }
    else{
      limb[i] = 0;
    }
  }

  delete []y;
}

////////////////////////////////////////////////////////////////////////////////

// *this = a * b
void LongFloat::mul(const Radius &a, const Radius &b){
  uint64 x;
  uint32 x0, x1, x2;
  int i, e, n;

  sign = 1;

  // ʂ 0 ̏ꍇ
  if((a.significand == 0) || (b.significand == 0)){
    for(i = 0; i < limbs; i++){
      limb[i] = 0;
    }
    exponent = 0;

    return;
  }

  // Z
  x = a.significand;
  x *= b.significand;

  e = a.exponent + b.exponent;
  exponent = e / LIMB_BITS + 1;

  if(e > 0){
    n = (LIMB_BITS - e) % LIMB_BITS;
  }
  else{
    n = -e % LIMB_BITS;
  }

  // 64 rbg 3  32 rbgɕB
  x0 = x >> (n + LIMB_BITS);
  x1 = (x >> n) & 0xffffffff;
  x2 = (x << (LIMB_BITS - n)) & 0xffffffff;

  // 
  if(x0){
    limb[0] = x0;
    limb[1] = x1;
    limb[2] = x2;
    for(i = 3; i < limbs; i++){
      limb[i] = 0;
    }

    return;
  }

  if(x1){
    limb[0] = x1;
    limb[1] = x2;
    for(i = 2; i < limbs; i++){
      limb[i] = 0;
    }
    exponent--;

    return;
  }

  limb[0] = x2;
  for(i = 1; i < limbs; i++){
    limb[i] = 0;
  }
  exponent -= 2;
}

////////////////////////////////////////////////////////////////////////////////

// *this = 1 / x
void LongFloat::inverse(const LongFloat &x){
  LongFloat two, old;
  double d;

  d = x.limb[2];
  d /= DOUBLE_0x100000000;
  d += x.limb[1];
  d /= DOUBLE_0x100000000;
  d += x.limb[0];

  // *this  1 / x ̋ߎlB
  setDouble(1 / d);
  sign = x.sign;
  exponent -= x.exponent;

  two = 2;

  // Newton ŁA *this  1 / x ɋ߂ÂB
  old = 0;
  while(compareAbs(old)){
    old = *this;
    *this *= two - x * *this;
  }
}

////////////////////////////////////////////////////////////////////////////////

// *this = a * b
void LongFloat::mul(const LongFloat &a, int b){
  int i;
  uint64 work;
  uint32 carry;

  // ̐ݒ
  if(b >= 0){
    sign = a.sign;
  }
  else{
    sign = -a.sign;
    b = -b;
  }

  // Z
  carry = 0;
  for(i = limbs - 1; i >= 0; i--){
    work = a.limb[i];
    work *= b;
    work += carry;
    limb[i] = low32(work);
    carry = high32(work);
  }

  // Jオ
  if(carry > 0){
    for(i = limbs - 1; i > 0; i--){
      limb[i] = limb[i - 1];
    }
    limb[0] = carry;

    exponent = a.exponent + 1;
  }
  else{
    exponent = a.exponent;
  }
}

// *this = a / b
void LongFloat::div(const LongFloat &a, int b){
  int i;
  uint64 work;

  // ̐ݒ
  if(b >= 0){
    sign = a.sign;
  }
  else{
    sign = -a.sign;
    b = -b;
  }

  // Z
  work = 0;
  for(i = 0; i < limbs; i++){
    work <<= LIMB_BITS;
    work += a.limb[i];
    limb[i] = work / b;
    work -= limb[i] * b;
  }

  // J艺
  if(limb[0] == 0){
    for(i = 0; i < limbs - 1; i++){
      limb[i] = limb[i + 1];
    }
    work <<= LIMB_BITS;
    limb[limbs - 1] = work / b;

    exponent = a.exponent - 1;
  }
  else{
    exponent = a.exponent;
  }
}

// *this = a + b
void LongFloat::add(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.limb[0] == 0){
    *this = b;
    return;
  }
  if(b.limb[0] == 0){
    *this = a;
    return;
  }

  if(a.sign == b.sign){
    if(a.exponent >= b.exponent){
      addAbs(a, b);
      sign = a.sign;
    }
    else{
      addAbs(b, a);
      sign = b.sign;
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      subAbs(a, b);
      sign = a.sign;
    }
    else{
      subAbs(b, a);
      sign = b.sign;
    }
  }
}

// *this = a - b
void LongFloat::sub(const LongFloat &a, const LongFloat &b){

  // 0 ̏ꍇ
  if(a.limb[0] == 0){
    *this = b;
    sign *= -1;
    return;
  }
  if(b.limb[0] == 0){
    *this = a;
    return;
  }

  if(a.sign != b.sign){
    if(a.exponent >= b.exponent){
      addAbs(a, b);
      sign = a.sign;
    }
    else{
      addAbs(b, a);
      sign = a.sign;
    }
  }
  else{
    if(a.compareAbs(b) >= 0){
      subAbs(a, b);
      sign = a.sign;
    }
    else{
      subAbs(b, a);
      sign = -b.sign;
    }
  }
}

// *this = a * b
void LongFloat::mul(const LongFloat &a, const LongFloat &b){
  int i, j;
  uint64 tmp;
  uint32 carry;
  uint32 *work;

  // ̐ݒ
  if(b.sign > 0){
    sign = a.sign;
  }
  else{
    sign = -a.sign;
  }

  // [NXy[X̊m
  work = new uint32[2 * limbs];

  // [NXy[X̏
  for(i = 0; i < 2 * limbs; i++){
    work[i] = 0;
  }

  // MZɂZ
  for(i = limbs - 1; i >= 0; i--){
    carry = 0;
    for(j = limbs - 1; j >= 0; j--){
      tmp = a.limb[i];
      tmp *= b.limb[j];
      tmp += carry;
      tmp += work[i + j + 1];

      work[i + j + 1] = low32(tmp);
      carry = high32(tmp);
    }
    work[i] += carry;
  }

  // Zʂ̏ʔoB
  if(work[0]){
    for(i = 0; i < limbs; i++){
      limb[i] = work[i];
    }
    exponent = a.exponent + b.exponent + 1;
  }
  else{
    for(i = 0; i < limbs; i++){
      limb[i] = work[i + 1];
    }
    exponent = a.exponent + b.exponent;
  }

  // [NXy[X̔j
  delete []work;
}

////////////////////////////////////////////////////////////////////////////////

// Łiւ̊ۂ߁j
LongFloat LongFloat::sqrtInf() const{
  LongFloat result;
  int roundOld;
  double d;

  result.sign = 1;

  // ݂̊ۂߕۑB
  roundOld = getRound();

  // ւ̊ۂ߂ŌvZB
  setRound(-1);

  d = limb[2];
  d /= DOUBLE_0x100000000;
  d += limb[1];
  d /= DOUBLE_0x100000000;
  d += limb[0];

  if(exponent % 2){

    // x.exponent ̊̂Ƃ
    if(exponent >= 0){
      result.setDouble(0x10000 * sqrt(d));
      result.exponent += exponent / 2;
    }

    // x.exponent ̊̂Ƃ
    else{
      result.setDouble(0x10000 * sqrt(d));
      result.exponent += exponent / 2 - 1;
    }
  }

  // x.exponent ̂Ƃ
  else{
    result.setDouble(sqrt(d));
    result.exponent += exponent / 2;
  }

  // ۂߕɖ߂B
  setRound(roundOld);

  return result;
}

////////////////////////////////////////////////////////////////////////////////

// RXgN^
LongFloat::LongFloat(){

  // limbs ݒ̏ꍇ
  if(limbs < LIMBS_MIN){
    std::cerr << "[ERROR] LongFloat() : Precision of LongFloat is not set." << std::endl;
    exit(1);
  }

  limb = new uint32[limbs];
}

// RXgN^
LongFloat::LongFloat(int x){
  int i;

  // limbs ݒ̏ꍇ
  if(limbs < LIMBS_MIN){
    std::cerr << "[ERROR] LongFloat() : Precision of LongFloat is not set." << std::endl;
    exit(1);
  }

  if(x < 0){
    sign = -1;
    x = -x;
  }
  else{
    sign = 1;
  }

  limb = new uint32[limbs];
  limb[0] = x;
  for(i = 1; i < limbs; i++){
    limb[i] = 0;
  }

  exponent = 0;
}

// RXgN^
LongFloat::LongFloat(double x){

  // limbs ݒ̏ꍇ
  if(limbs < LIMBS_MIN){
    std::cerr << "[ERROR] LongFloat() : Precision of LongFloat is not set." << std::endl;
    exit(1);
  }

  limb = new uint32[limbs];

  setDouble(x);
}

// RXgN^
LongFloat::LongFloat(const Radius &x){
  uint64 work;
  int i;

  // limbs ݒ̏ꍇ
  if(limbs < LIMBS_MIN){
    std::cerr << "[ERROR] LongFloat() : Precision of LongFloat is not set." << std::endl;
    exit(1);
  }

  limb = new uint32[limbs];

  sign = 1;

  // ŵƂ
  if(x.exponent > 0){
    work = x.significand;
    work <<= x.exponent % LIMB_BITS;

    exponent = x.exponent / LIMB_BITS + 1;
  }

  // w 0 ܂͕̂Ƃ
  else{
    work = x.significand;
    work <<= x.exponent % LIMB_BITS + LIMB_BITS;

    exponent = x.exponent / LIMB_BITS;
  }

  limb[0] = high32(work);
  limb[1] = low32(work);
  for(i = 2; i < limbs; i++){
    limb[i] = 0;
  }
}

// Rs[RXgN^
LongFloat::LongFloat(const LongFloat &x){
  int i;

  sign = x.sign;

  limb = new uint32[limbs];
  for(i = 0; i < limbs; i++){
    limb[i] = x.limb[i];
  }

  exponent = x.exponent;
}

// fXgN^
LongFloat::~LongFloat(){
  delete []limb;
}

////////////////////////////////////////////////////////////////////////////////

// double ̕ϊ
void LongFloat::setDouble(double x){
  binary64 tmp;
  int i, e, e32;
  uint64 f;

  tmp.d = x;

  // double l̕EwEoB
  if(tmp.i & 0x8000000000000000LL){
    sign = -1;
  }
  else{
    sign = 1;
  }

  e = (tmp.i >> 52) & 0x7ff;
  f = tmp.i & 0xfffffffffffffLL;

  if(e == 2047){
    cerr << "[ERROR] LongFloat::setDouble(double) : Invalid value." << endl;
    exit(1);
  }

  // K
  if(e){
    e -= 1023;
    f = (f + 0x10000000000000LL) << 11;
    e32 = (e % LIMB_BITS + LIMB_BITS) % LIMB_BITS;

    limb[0] = f >> (63 - e32);
    limb[1] = (f >> (31 - e32)) & 0xffffffff;
    limb[2] = (f << (e32 + 1)) & 0xffffffff;

    for(i = 3; i < limbs; i++){
      limb[i] = 0;
    }

    exponent = static_cast<int>(floor(static_cast<double>(e) / LIMB_BITS));
  }

  // 񐳋K
  else{
    limb[0] = f >> 50;
    limb[1] = (f >> 18) & 0xffffffff;
    limb[2] = (f << 14) & 0xffffffff;

    for(i = 3; i < limbs; i++){
      limb[i] = 0;
    }

    exponent = -32;

    // ̐K
    normalize();
  }
}

////////////////////////////////////////////////////////////////////////////////

// double ւ̕ϊ
double LongFloat::getDouble() const{
  double result;

  // 
  result = limb[2];
  result /= DOUBLE_0x100000000;
  result += limb[1];
  result /= DOUBLE_0x100000000;
  result += limb[0];

  // w
  result *= pow(DOUBLE_0x100000000, exponent);

  // 
  if(sign < 0){
    result = -result;
  }

  return result;
}

// double ւ̕ϊiۂߕwj
double LongFloat::getDouble(int round) const{
  double result;
  int roundOld, i;

  // ݂̊ۂߕۑB
  roundOld = getRound();

  // ۂߕݒ肷B
  setRound(round);

  // 
  result = 0;
  for(i = limbs - 1; i >= 0; i--){
    result /= DOUBLE_0x100000000;
    result += limb[i];
  }

  // w
  if(exponent > 0){
    for(i = 0; i < exponent; i++){
      result *= DOUBLE_0x100000000;
    }
  }
  if(exponent < 0){
    for(i = 0; i < -exponent; i++){
      result /= DOUBLE_0x100000000;
    }
  }

  // 
  if(sign < 0){
    result = -result;
  }

  // ۂߕɖ߂B
  setRound(roundOld);

  return result;
}

// ւ̕ϊ
string LongFloat::getString() const{
  ostringstream output;
  double m, a, f;
  int e;

  if(limb[0]){
    m = limb[2];
    m /= DOUBLE_0x100000000;
    m += limb[1];
    m /= DOUBLE_0x100000000;
    m += limb[0];

    // a = log10(m) + LIMB_BITS * log10(2) * exponent;
    a = log10(m) + 9.6329598612473982468 * exponent;

    e = static_cast<int>(floor(a));
    f = pow(10, a - e);

    if(sign < 0){
      output << "-";
    }
    else{
      output << " ";
    }

    output << fixed << f;

    if(e){
      output << "e" << e;
    }
  }
  else{
    output << " " << fixed << 0.0;
  }

  return output.str();
}

// ̕ւ̕ϊ
string LongFloat::getLongString(int digits) const{
  ostringstream output;
  LongFloat x;
  int i, e;

  if(digits < 1){
    cerr << "[ERROR] LongFloat::getLongString(int digits) : digits must be 2 or more." << endl;
    exit(1);
  }

  // 0 ̏ꍇ
  if(limb[0] == 0){
    output << " 0.";

    for(i = 1; i < digits; i++){
      output << "0";
    }

    return output.str();
  }

  // ̕\
  if(sign < 0){
    output << "-";
  }
  else{
    output << " ";
  }

  x = *this;

  // w̒
  e = 0;
  while(x.exponent > 0){
    x /= 1000000000;
    e += 9;
  }
  while(x.exponent < 0){
    x *= 1000000000;
    e -= 9;
  }

  while(x.limb[0] >= 10){
    x /= 10;
    e++;
  }

  //  1 ڂ̕\
  output << x.limb[0] << ".";
  x.limb[0] = 0;
  x.normalize();

  // c̕\
  for(i = 1; i < digits; i++){
    x *= 10;

    if(x.limb[0] < 10){
      output << x.limb[0];

      x.limb[0] = 0;
      x.normalize();
    }
    else{
      output << "0";
    }
  }

  // w̕\
  if(e){
    output << "e" << e;
  }

  return output.str();
}

// f[^\̎擾
string LongFloat::getInternalData() const{
  ostringstream output;
  int i;

  output << "sign     : " << sign << endl;

  output << "limb     : ";
  for(i = 0; i < limbs; i++){
    output << hex << setw(8) << setfill('0') << limb[i] << " ";
  }
  output << dec << endl;

  output << "exponent : " << exponent;

  return output.str();
}

// PZ
////////////////////////////////////////////////////////////////////////////////

// +LongFloat
LongFloat LongFloat::operator +() const{
  return *this;
}

// -LongFloat
LongFloat LongFloat::operator -() const{
  LongFloat result;

  result = *this;
  result.sign = -sign;

  return result;
}

// lZ
////////////////////////////////////////////////////////////////////////////////

// LongFloat + int
LongFloat LongFloat::operator +(int x) const{
  return *this + LongFloat(x);
}

// LongFloat - int
LongFloat LongFloat::operator -(int x) const{
  return *this - LongFloat(x);
}

// LongFloat * int
LongFloat LongFloat::operator *(int x) const{
  LongFloat result;

  result.mul(*this, x);

  return result;
}

// LongFloat / int
LongFloat LongFloat::operator /(int x) const{
  LongFloat result;

  if(x == 0){
    cerr << "[ERROR] LongFloat / int : Division by zero." << endl;
    exit(1);
  }

  result.div(*this, x);

  return result;
}

// LongFloat * Radius
LongFloat LongFloat::operator *(const Radius &x) const{
  LongFloat result;
  uint32 xHigh, xLow, carry;
  uint32 *work;
  uint64 tmp;
  int i;

  // ŵƂ
  if(x.exponent > 0){
    tmp = x.significand;
    tmp <<= x.exponent % LIMB_BITS;

    result.exponent = exponent + x.exponent / LIMB_BITS + 1;
  }

  // w 0 ܂͕̂Ƃ
  else{
    tmp = x.significand;
    tmp <<= x.exponent % LIMB_BITS + LIMB_BITS;

    result.exponent = exponent + x.exponent / LIMB_BITS;
  }

  // x vZɓK`ɕϊB
  xHigh = high32(tmp);
  xLow = low32(tmp);

  result.sign = sign;

  // [NXy[X̊m
  work = new uint32[limbs + 2];

  // MZɂZ
  carry = 0;
  for(i = limbs - 1; i >= 0; i--){
    tmp = xLow;
    tmp *= limb[i];
    tmp += carry;

    work[i + 2] = low32(tmp);
    carry = high32(tmp);
  }
  work[1] = carry;

  carry = 0;
  for(i = limbs - 1; i >= 0; i--){
    tmp = xHigh;
    tmp *= limb[i];
    tmp += carry;
    tmp += work[i + 1];

    work[i + 1] = low32(tmp);
    carry = high32(tmp);
  }
  work[0] = carry;

  // Zʂ̏ʂoB
  if(work[0]){
    for(i = 0; i < limbs; i++){
      result.limb[i] = work[i];
    }
    result.exponent++;
  }
  else{
    for(i = 0; i < limbs; i++){
      result.limb[i] = work[i + 1];
    }
  }

  // [NXy[X̔j
  delete []work;

  return result;
}

// LongFloat + LongFloat
LongFloat LongFloat::operator +(const LongFloat &x) const{
  LongFloat result;

  result.add(*this, x);

  return result;
}

// LongFloat - LongFloat
LongFloat LongFloat::operator -(const LongFloat &x) const{
  LongFloat result;

  result.sub(*this, x);

  return result;
}

// LongFloat * LongFloat
LongFloat LongFloat::operator *(const LongFloat &x) const{
  LongFloat result;

  result.mul(*this, x);

  return result;
}

// LongFloat / LongFloat
LongFloat LongFloat::operator /(const LongFloat &x) const{
  LongFloat invX;

  if(x.limb[0] == 0){
    cerr << "[ERROR] LongFloat / LongFloat : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  return *this * invX;
}

// LongFloat + LongInterval
LongInterval LongFloat::operator +(const LongInterval &x) const{
  return x + *this;
}

// LongFloat - LongInterval
LongInterval LongFloat::operator -(const LongInterval &x) const{
  LongInterval result;
  Radius r;

  r = x.radius;
  result.sub(*this, x.center);
  result.radius += r;

  return result;
}

// LongFloat * LongInterval
LongInterval LongFloat::operator *(const LongInterval &x) const{
  return x * *this;
}

// LongFloat / LongInterval
LongInterval LongFloat::operator /(const LongInterval &x) const{
  LongInterval invX;

  if(x.center.compareAbs(x.rad()) <= 0){
    cerr << "[ERROR] LongFloat / LongInterval : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  return *this * invX;
}

// LongFloat + LongMatrix
LongMatrix LongFloat::operator +(const LongMatrix &x) const{
  return x + *this;
}

// LongFloat - LongMatrix
LongMatrix LongFloat::operator -(const LongMatrix &x) const{
  LongMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongFloat * LongMatrix
LongMatrix LongFloat::operator *(const LongMatrix &x) const{
  return x * *this;
}

// LongFloat / LongMatrix
LongMatrix LongFloat::operator /(const LongMatrix &x) const{
  LongMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// LongFloat + LongIntervalMatrix
LongIntervalMatrix LongFloat::operator +(const LongIntervalMatrix &x) const{
  return x + *this;
}

// LongFloat - LongIntervalMatrix
LongIntervalMatrix LongFloat::operator -(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this - x.value[i][j];
    }
  }

  return result;
}

// LongFloat * LongIntervalMatrix
LongIntervalMatrix LongFloat::operator *(const LongIntervalMatrix &x) const{
  return x * *this;
}

// LongFloat / LongIntervalMatrix
LongIntervalMatrix LongFloat::operator /(const LongIntervalMatrix &x) const{
  LongIntervalMatrix result(x.m, x.n);
  int i, j;

  for(i = 0; i < x.m; i++){
    for(j = 0; j < x.n; j++){
      result.value[i][j] = *this / x.value[i][j];
    }
  }

  return result;
}

// rZ
////////////////////////////////////////////////////////////////////////////////

// LongFloat == int
bool LongFloat::operator ==(int x) const{
  return *this == LongFloat(x);
}

// LongFloat != int
bool LongFloat::operator !=(int x) const{
  return *this != LongFloat(x);
}

// LongFloat < int
bool LongFloat::operator <(int x) const{
  return *this < LongFloat(x);
}

// LongFloat > int
bool LongFloat::operator >(int x) const{
  return *this > LongFloat(x);
}

// LongFloat <= int
bool LongFloat::operator <=(int x) const{
  return *this <= LongFloat(x);
}

// LongFloat >= int
bool LongFloat::operator >=(int x) const{
  return *this >= LongFloat(x);
}

// LongFloat == LongFloat
bool LongFloat::operator ==(const LongFloat &x) const{

  // 0 ̏ꍇ
  if(limb[0] == 0){
    if(x.limb[0] == 0){
      return true;
    }
    else{
      return false;
    }
  }
  else{
    if(x.limb[0] == 0){
      return false;
    }
  }

  // ̔r
  if(sign != x.sign){
    return false;
  }

  // Βl̔r
  if(compareAbs(x) == 0){
    return true;
  }
  else{
    return false;
  }
}

// LongFloat != LongFloat
bool LongFloat::operator !=(const LongFloat &x) const{
  return !(*this == x);
}

// LongFloat < LongFloat
bool LongFloat::operator <(const LongFloat &x) const{

  // 0 ̏ꍇ
  if(limb[0] == 0){
    if(x.limb[0] && (x.sign == 1)){
      return true;
    }
    else{
      return false;
    }
  }

  if(x.limb[0] == 0){
    if(sign == -1){
      return true;
    }
    else{
      return false;
    }
  }

  if(sign == -1){
    if(x.sign == -1){
      if(compareAbs(x) > 0){
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return true;
    }
  }
  else{
    if(x.sign == 1){
      if(compareAbs(x) < 0){
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return false;
    }
  }
}

// LongFloat > LongFloat
bool LongFloat::operator >(const LongFloat &x) const{

  // 0 ̏ꍇ
  if(limb[0] == 0){
    if(x.limb[0] && (x.sign == -1)){
      return true;
    }
    else{
      return false;
    }
  }

  if(x.limb[0] == 0){
    if(sign == 1){
      return true;
    }
    else{
      return false;
    }
  }

  if(sign == -1){
    if(x.sign == -1){
      if(compareAbs(x) < 0){
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return false;
    }
  }
  else{
    if(x.sign == 1){
      if(compareAbs(x) > 0){
        return true;
      }
      else{
        return false;
      }
    }
    else{
      return true;
    }
  }
}

// LongFloat <= LongFloat
bool LongFloat::operator <=(const LongFloat &x) const{
  return !(*this > x);
}

// LongFloat >= LongFloat
bool LongFloat::operator >=(const LongFloat &x) const{
  return !(*this < x);
}

// LongFloat < LongInterval
int LongFloat::operator <(const  LongInterval &x) const{
  return x > *this;
}

// LongFloat > LongInterval
int LongFloat::operator >(const  LongInterval &x) const{
  return x < *this;
}

// LongFloat <= LongInterval
int LongFloat::operator <=(const  LongInterval &x) const{
  return x >= *this;
}

// LongFloat >= LongInterval
int LongFloat::operator >=(const  LongInterval &x) const{
  return x <= *this;
}

// Z
////////////////////////////////////////////////////////////////////////////////

// LongFloat = int
LongFloat &LongFloat::operator =(int x){
  int i;

  if(x < 0){
    sign = -1;
    x = -x;
  }
  else{
    sign = 1;
  }

  limb[0] = x;
  for(i = 1; i < limbs; i++){
    limb[i] = 0;
  }

  exponent = 0;

  return *this;
}

// LongFloat *= int
LongFloat &LongFloat::operator *=(int x){
  mul(*this, x);

  return *this;
}

// LongFloat /= int
LongFloat &LongFloat::operator /=(int x){
  if(x == 0){
    cerr << "[ERROR] LongFloat /= int : Division by zero." << endl;
    exit(1);
  }

  div(*this, x);

  return *this;
}

// LongFloat = LongFloat
LongFloat &LongFloat::operator =(const LongFloat &x){
  int i;

  sign = x.sign;
  exponent = x.exponent;

  for(i = 0; i < limbs; i++){
    limb[i] = x.limb[i];
  }

  return *this;
}

// LongFloat += LongFloat
LongFloat &LongFloat::operator +=(const LongFloat &x){
  *this = *this + x;

  return *this;
}

// LongFloat -= LongFloat
LongFloat &LongFloat::operator -=(const LongFloat &x){
  *this = *this - x;

  return *this;
}

// LongFloat *= LongFloat
LongFloat &LongFloat::operator *=(const LongFloat &x){
  mul(*this, x);

  return *this;
}

// LongFloat /= LongFloat
LongFloat &LongFloat::operator /=(const LongFloat &x){
  LongFloat invX;

  if(x.limb[0] == 0){
    cerr << "[ERROR] LongFloat =/ LongFloat : Division by zero." << endl;
    exit(1);
  }

  invX.inverse(x);

  *this *= invX;

  return *this;
}

// lZith֐j
////////////////////////////////////////////////////////////////////////////////

// int + LongFloat
LongFloat operator +(int a, const LongFloat &b){
  return LongFloat(a) + b;
}

// int - LongFloat
LongFloat operator -(int a, const LongFloat &b){
  return LongFloat(a) - b;
}

// int * LongFloat
LongFloat operator *(int a, const LongFloat &b){
  return b * a;
}

// int / LongFloat
LongFloat operator /(int a, const LongFloat &b){
  LongFloat invB;

  if(b.limb[0] == 0){
    cerr << "[ERROR] int / LongFloat : Division by zero." << endl;
    exit(1);
  }

  invB.inverse(b);

  return a * invB;
}

// rZith֐j
////////////////////////////////////////////////////////////////////////////////

// int == LongFloat
bool operator ==(int a, const LongFloat &b){
  return LongFloat(a) == b;
}

// int != LongFloat
bool operator !=(int a, const LongFloat &b){
  return LongFloat(a) != b;
}

// int < LongFloat
bool operator <(int a, const LongFloat &b){
  return LongFloat(a) < b;
}

// int > LongFloat
bool operator >(int a, const LongFloat &b){
  return LongFloat(a) > b;
}

// int <= LongFloat
bool operator <=(int a, const LongFloat &b){
  return LongFloat(a) <= b;
}

// int >= LongFloat
bool operator >=(int a, const LongFloat &b){
  return LongFloat(a) >= b;
}

// th֐
////////////////////////////////////////////////////////////////////////////////

// Βl
LongFloat abs(const LongFloat &x){
  if(x.sign > 0){
    return x;
  }
  else{
    return -x;
  }
}

// ׂ
LongFloat pow(const LongFloat &x, int n){
  LongFloat y, a;
  bool positive;

  if(n == 0){
    return 1;
  }

  if(n > 0){
    positive = true;
  }
  else{
    n = -n;
    positive = false;
  }

  n--;
  a = x;
  y = a;

  while(n > 0){
    if(n % 2){
      y *= a;
    }

    n /= 2;
    if(n){
      a *= a;
    }
  }

  if(positive){
    return y;
  }
  else{
    return 1 / y;
  }
}

// 
LongFloat sqrt(const LongFloat &x){
  LongFloat y, yOld, three;
  double d;

  if(x.limb[0] == 0){
    return 0;
  }

  if(x.sign < 0){
    cerr << "[ERROR] sqrt(LongFloat) : Complex number." << endl;
    exit(1);
  }

  d = x.limb[2];
  d /= DOUBLE_0x100000000;
  d += x.limb[1];
  d /= DOUBLE_0x100000000;
  d += x.limb[0];

  // y  1 / sqrt(x) ̋ߎlB
  if(x.exponent % 2){

    // x.exponent ̊̂Ƃ
    if(x.exponent >= 0){
      y.setDouble(0x10000 / sqrt(d));
      y.exponent -= x.exponent / 2 + 1;
    }

    // x.exponent ̊̂Ƃ
    else{
      y.setDouble(0x10000 / sqrt(d));
      y.exponent -= x.exponent / 2;
    }
  }

  // x.exponent ̂Ƃ
  else{
    y.setDouble(1 / sqrt(d));
    y.exponent -= x.exponent / 2;
  }

  three = 3;

  // Newton ŁA y  1 / sqrt(x) ɋ߂ÂB
  yOld = 0;
  while(y.compareAbs(yOld)){
    yOld = y;
    y *= (three - x * y * y) / 2;
  }

  return x * y;
}

////////////////////////////////////////////////////////////////////////////////

// std::ostream << LongFloat
ostream &operator <<(ostream &output, const LongFloat &x){
  output << x.getString();

  return output;
}
