/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect;

import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import javax.imageio.ImageIO;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import org.omegat.util.Log;

public class BasicEffect
extends Effect {
    private final String KEY_TARGET = "target";
    private final String KEY_OPACITY = "opacity";
    private final String KEY_IMAGE = "image";
    private final String KEY_PATH = "path";
    private final String KEY_BGCOLOR = "bgColor";
    private final String KEY_EXCLUDE = "exclude";
    private MoeUI.Parts target = MoeUI.Parts.MainWindow;
    private float opacity = 0.5f;
    private String image = "";
    private Color bgColor = null;
    private List<MoeUI.Parts> exclude = new ArrayList<MoeUI.Parts>();

    public BasicEffect(Map<String, Object> config) {
        Integer rgb;
        this.target = this.get("target", config, this.target);
        if (config.containsKey("image")) {
            Map conf = (Map)config.get("image");
            this.image = this.get("path", conf, this.image);
            this.opacity = this.get("opacity", conf, Float.valueOf(this.opacity)).floatValue();
        }
        if ((rgb = (Integer)this.get("bgColor", config, null)) != null) {
            this.bgColor = new Color(rgb);
        }
        this.exclude = this.get("exclude", config, this.exclude);
    }

    @Override
    public void invoke(MoeUI ui, ScheduledThreadPoolExecutor service) {
        EnumSet<MoeUI.Parts> excludeParts = EnumSet.noneOf(MoeUI.Parts.class);
        for (MoeUI.Parts part : EnumSet.allOf(MoeUI.Parts.class)) {
            if (!this.exclude.contains((Object)part)) continue;
            excludeParts.add(part);
        }
        if (!this.image.isEmpty()) {
            try {
                String lcased = this.image.toLowerCase();
                if (lcased.startsWith("http://") || lcased.startsWith("https://")) {
                    ui.setBackground(this.target, ImageIO.read(new URL(this.image)));
                } else {
                    ui.setBackground(this.target, ImageIO.read(new File(this.image)));
                }
            }
            catch (MalformedURLException ex) {
                Log.log((String)ex.getMessage());
            }
            catch (IOException ex) {
                Log.log((String)ex.getMessage());
            }
        }
        ui.setOpacity(this.target, this.opacity);
        ui.setBackground(this.target, this.bgColor);
        ui.transparent(this.target, excludeParts);
    }
}

