/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import com.sun.java.swing.plaf.windows.WindowsMenuBarUI;
import com.vlsolutions.swing.docking.AutoHideButtonPanel;
import com.vlsolutions.swing.docking.DockView;
import com.vlsolutions.swing.docking.DockViewTitleBar;
import com.vlsolutions.swing.docking.Dockable;
import com.vlsolutions.swing.docking.DockableState;
import com.vlsolutions.swing.docking.DockingDesktop;
import com.vlsolutions.swing.docking.SplitContainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.SystemColor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.MenuBarUI;
import javax.swing.plaf.PanelUI;
import javax.swing.text.Highlighter;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeDockViewTitleBarUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeRootPaneUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeTextPaneUI;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IProjectEventListener;
import org.omegat.util.Log;
import org.omegat.util.gui.UIThreadsUtil;

public class MoeUI
implements IProjectEventListener {
    public static final float OPACITY_OPAQUE = 1.0f;
    public static final float OPACITY_HALF = 0.5f;
    private static MoeUI moeUI = null;
    private final JFrame frame;
    private final JRootPane rootPane;
    private final Container contentPane;
    private final JMenuBar menuBar;
    private final DockingDesktop desktop;
    private final JPanel statusBar;
    private final AutoHideButtonPanel buttonPanel;
    private final Map<Parts, ComponentUI> uis;
    private boolean makeTransparentMenubar = true;
    private boolean makeTransparentButtonPanel = true;
    private boolean makeTransparentStatusbar = true;
    private boolean makeTransparentPaneTitlebar = true;
    private boolean isEditorTransparent = false;

    private MoeUI() {
        UIThreadsUtil.mustBeSwingThread();
        this.frame = Core.getMainWindow().getApplicationFrame();
        this.rootPane = this.frame.getRootPane();
        this.contentPane = this.frame.getContentPane();
        this.menuBar = this.frame.getJMenuBar();
        this.statusBar = this.getJPanel(this.contentPane);
        this.desktop = this.getDockingDesktop(this.contentPane);
        this.buttonPanel = this.getButtonPanel(this.desktop);
        this.uis = new EnumMap<Parts, ComponentUI>(Parts.class);
    }

    public static MoeUI getInstance() {
        if (moeUI == null) {
            moeUI = new MoeUI();
        }
        return moeUI;
    }

    public void setBackground(Parts target, BufferedImage image) {
        UIThreadsUtil.mustBeSwingThread();
        if (target == Parts.MainWindow) {
            this.getRootPaneUI().setBackgroundImage(image);
        } else if (target.compareTo(Parts.EDITOR) >= 0) {
            this.getTextPaneUI(target).setBackgroundImage(image);
            if (target == Parts.EDITOR) {
                this.getTextPaneUI(Parts.INSTANT_START).setBackgroundImage(image);
            }
        }
    }

    public void setBackground(Parts target, Color color) {
        UIThreadsUtil.mustBeSwingThread();
        if (target == Parts.MainWindow) {
            this.getRootPaneUI().setBackgroundColor(color);
        } else if (target.compareTo(Parts.EDITOR) >= 0) {
            this.getTextPaneUI(target).setBackgroundColor(color);
            if (target == Parts.EDITOR) {
                this.getTextPaneUI(Parts.INSTANT_START).setBackgroundColor(color);
            }
        }
    }

    public void setOpacity(Parts target, float opacity) {
        UIThreadsUtil.mustBeSwingThread();
        if (target == Parts.MainWindow) {
            this.getRootPaneUI().setOpacity(opacity);
        } else {
            Log.log((String)("warning: setOpacity(" + target.name() + ", " + opacity + ") is ignored. Opacity is available only for MainWindow."));
        }
    }

    public void transparent(Parts target, EnumSet<Parts> exclude) {
        switch (target) {
            case MainWindow: {
                if (exclude != null) {
                    this.makeTransparentMenubar = !exclude.contains((Object)Parts.MenuBar);
                    this.makeTransparentButtonPanel = !exclude.contains((Object)Parts.ButtonPanel);
                    this.makeTransparentStatusbar = !exclude.contains((Object)Parts.StatusBar);
                    this.makeTransparentPaneTitlebar = !exclude.contains((Object)Parts.PaneTitleBar);
                }
                this.transparent(exclude);
                break;
            }
            case EDITOR: {
                UIThreadsUtil.mustBeSwingThread();
                this.removeInstantStartBgColor();
                JEditorPane editor = this.getJEditorPaneFromEditorView();
                MoeTextPaneUI sourceUI = this.getTextPaneUI(Parts.INSTANT_START);
                if (editor == null) {
                    DocumentEditorUIRunner editorUIRunner = new DocumentEditorUIRunner();
                    editorUIRunner.setBackgroundImage(sourceUI.getBackgroundImage());
                    editorUIRunner.setBackgroundColor(sourceUI.getBackgroundColor());
                    CoreEvents.registerProjectChangeListener((IProjectEventListener)editorUIRunner);
                    break;
                }
                MoeTextPaneUI ui = this.getTextPaneUI(Parts.EDITOR);
                ui.setBackgroundImage(sourceUI.getBackgroundImage());
                ui.setBackgroundColor(sourceUI.getBackgroundColor());
                Highlighter h = editor.getHighlighter();
                editor.setUI(ui);
                editor.setHighlighter(h);
            }
        }
    }

    private void transparent(EnumSet<Parts> exclude) {
        UIThreadsUtil.mustBeSwingThread();
        if (this.makeTransparentMenubar) {
            this.transparent(this.menuBar);
        } else {
            int marginTop = this.menuBar.getHeight();
            if (!this.makeTransparentPaneTitlebar) {
                marginTop += this.getDockViewTitleBarHeight(this.desktop);
            }
            MoeRootPaneUI ui = (MoeRootPaneUI)this.uis.get((Object)Parts.MainWindow);
            ui.setMarginTop(marginTop);
        }
        this.transparentRecursive(this.contentPane, exclude);
        if (!exclude.contains((Object)Parts.EDITOR)) {
            this.removeInstantStartBgColor();
        }
        if (!exclude.contains((Object)Parts.EDITOR) && !this.isEditorTransparent) {
            this.isEditorTransparent = this.transparentEditor();
            if (!this.isEditorTransparent) {
                CoreEvents.registerProjectChangeListener((IProjectEventListener)this);
            }
        }
        this.frame.repaint();
    }

    public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
        switch (eventType) {
            case CREATE: 
            case LOAD: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CoreEvents.unregisterProjectChangeListener((IProjectEventListener)MoeUI.this);
                        MoeUI.this.isEditorTransparent = MoeUI.this.transparentEditor();
                    }
                });
                break;
            }
        }
    }

    public void repaint() {
        this.frame.repaint();
    }

    private int getDockViewTitleBarHeight(DockingDesktop desktop) {
        ArrayList<Dockable> dockables = this.getDockedDockables(desktop);
        if (!dockables.isEmpty()) {
            Dockable dockable = dockables.get(0);
            Container container = dockable.getComponent().getParent();
            DockView view = (DockView)container;
            DockViewTitleBar titleBar = view.getTitleBar();
            return titleBar.getHeight();
        }
        return 0;
    }

    private boolean transparentEditor() {
        UIThreadsUtil.mustBeSwingThread();
        JEditorPane editor = this.getJEditorPaneFromEditorView();
        if (editor == null) {
            return false;
        }
        editor.setOpaque(false);
        this.isEditorTransparent = true;
        this.frame.repaint();
        return true;
    }

    private JEditorPane getJEditorPane(Parts target) {
        switch (target) {
            case EDITOR: {
                return this.getJEditorPaneFromEditorView();
            }
            case INSTANT_START: {
                return this.getJTextPaneFromInstantStartView();
            }
        }
        String PANE_NAME = target.name();
        Dockable dockable = this.desktop.getContext().getDockableByKey(PANE_NAME);
        if (dockable != null) {
            JScrollPane sp = (JScrollPane)dockable.getComponent();
            return (JTextPane)sp.getViewport().getView();
        }
        return null;
    }

    private void transparent(JMenuBar menuBar) {
        menuBar.setUI((MenuBarUI)new WindowsMenuBarUI(){

            public void paint(Graphics g, JComponent c) {
                int alpha = 100;
                Color oldColor = g.getColor();
                SystemColor color = SystemColor.menu;
                g.setColor(new Color(color.getRGB() & 0xFFFFFF | alpha << 24, true));
                g.fillRect(0, 0, c.getWidth(), c.getHeight());
                g.setColor(oldColor);
            }
        });
        menuBar.setOpaque(false);
    }

    private void transparentRecursive(Component component, EnumSet<Parts> exclude) {
        JComponent c;
        if (exclude.contains((Object)Parts.StatusBar) && this.statusBar.equals(component)) {
            return;
        }
        if (exclude.contains((Object)Parts.ButtonPanel) && this.buttonPanel.equals(component)) {
            return;
        }
        if (!(!(component instanceof JComponent) || !(c = (JComponent)component).isShowing() || !c.isOpaque() || exclude.contains((Object)Parts.EDITOR) && c instanceof JTextPane && c.equals(this.getJTextPaneFromInstantStartView()) || exclude.contains((Object)Parts.EDITOR) && c instanceof JEditorPane && c.equals(this.getJEditorPaneFromEditorView()) || exclude.contains((Object)Parts.MATCHES) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.MATCHES)) || exclude.contains((Object)Parts.GLOSSARY) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.GLOSSARY)) || exclude.contains((Object)Parts.NOTES) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.NOTES)) || exclude.contains((Object)Parts.COMMENTS) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.COMMENTS)) || exclude.contains((Object)Parts.MACHINE_TRANSLATE) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.MACHINE_TRANSLATE)) || exclude.contains((Object)Parts.DICTIONARY) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.DICTIONARY)) || exclude.contains((Object)Parts.MULTIPLE_TRANS) && c instanceof JEditorPane && c.equals(this.getJEditorPane(Parts.MULTIPLE_TRANS)))) {
            c.setOpaque(false);
        }
        if (component instanceof Container) {
            Container container = (Container)component;
            for (Component c2 : container.getComponents()) {
                this.transparentRecursive(c2, exclude);
            }
        }
        if (component instanceof DockingDesktop) {
            this.transparentRecursive((DockingDesktop)component, exclude);
        }
    }

    private void transparentRecursive(DockingDesktop desktop, EnumSet<Parts> exclude) {
        ArrayList<Dockable> dockables = this.getDockedDockables(desktop);
        for (Dockable d : dockables) {
            Parts part = Parts.valueOf(d.getDockKey().getKey());
            if (exclude.contains((Object)part)) continue;
            this.transparentRecursive(d);
        }
    }

    private ArrayList<Dockable> getDockedDockables(DockingDesktop desktop) {
        return desktop.getContext().getDockablesByState(desktop, DockableState.Location.DOCKED);
    }

    private void transparentRecursive(Dockable dockable) {
        Container container = dockable.getComponent().getParent();
        DockView view = (DockView)container;
        if (view.isOpaque()) {
            view.setOpaque(false);
        }
        if (this.makeTransparentPaneTitlebar) {
            DockViewTitleBar titleBar = view.getTitleBar();
            if (titleBar.isOpaque()) {
                titleBar.setOpaque(false);
            }
            titleBar.setUI((PanelUI)((Object)new MoeDockViewTitleBarUI(titleBar)));
        }
        if ((container = container.getParent()) == null) {
            return;
        }
        if (container.isOpaque()) {
            ((SplitContainer)container).setOpaque(false);
        }
        if ((container = container.getParent()) == null) {
            return;
        }
        if (container.isOpaque()) {
            ((SplitContainer)container).setOpaque(false);
        }
    }

    private void removeInstantStartBgColor() {
        JTextPane ep = this.getJTextPaneFromInstantStartView();
        if (ep != null) {
            ep.setText(ep.getText().replace(" bgcolor=\"white\"", ""));
            ep.setCaretPosition(0);
        }
    }

    private DockingDesktop getDockingDesktop(Container container) {
        for (Component c : container.getComponents()) {
            if (!(c instanceof DockingDesktop)) continue;
            return (DockingDesktop)c;
        }
        return null;
    }

    private JPanel getJPanel(Container contentPane) {
        for (Component c : contentPane.getComponents()) {
            if (!(c instanceof JPanel)) continue;
            return (JPanel)c;
        }
        return null;
    }

    private AutoHideButtonPanel getButtonPanel(DockingDesktop desktop) {
        Container panel = null;
        for (Component c : desktop.getComponents()) {
            if (!c.getClass().getName().equals("javax.swing.JPanel")) continue;
            panel = (JPanel)c;
            break;
        }
        return panel == null ? null : (AutoHideButtonPanel)panel.getComponent(2);
    }

    private JEditorPane getJEditorPaneFromEditorView() {
        JEditorPane pane = this.getJEditorPaneFromEditor();
        return pane instanceof JTextPane ? null : pane;
    }

    private JTextPane getJTextPaneFromInstantStartView() {
        JEditorPane pane = this.getJEditorPaneFromEditor();
        return pane instanceof JTextPane ? (JTextPane)pane : null;
    }

    private JEditorPane getJEditorPaneFromEditor() {
        Dockable dockable = this.desktop.getContext().getDockableByKey(Parts.EDITOR.name());
        if (dockable != null) {
            JScrollPane sp;
            if (dockable.getComponent() instanceof JPanel) {
                JPanel jp = (JPanel)dockable.getComponent();
                sp = (JScrollPane)jp.getComponent(0);
            } else {
                sp = (JScrollPane)dockable.getComponent();
            }
            return (JEditorPane)sp.getViewport().getView();
        }
        return null;
    }

    private MoeRootPaneUI getRootPaneUI() {
        MoeRootPaneUI ui;
        Parts target = Parts.MainWindow;
        if (this.uis.containsKey((Object)target)) {
            ui = (MoeRootPaneUI)this.uis.get((Object)target);
        } else {
            ui = new MoeRootPaneUI();
            this.rootPane.setUI(ui);
            this.uis.put(target, ui);
        }
        return ui;
    }

    private MoeTextPaneUI getTextPaneUI(Parts target) {
        MoeTextPaneUI ui;
        if (this.uis.containsKey((Object)target)) {
            ui = (MoeTextPaneUI)this.uis.get((Object)target);
        } else {
            ui = new MoeTextPaneUI();
            JEditorPane pane = this.getJEditorPane(target);
            if (pane != null) {
                Highlighter h = pane.getHighlighter();
                pane.setUI(ui);
                pane.setHighlighter(h);
                if (!pane.isOpaque()) {
                    pane.setOpaque(true);
                    if (target == Parts.EDITOR) {
                        this.isEditorTransparent = false;
                    }
                }
            }
            this.uis.put(target, ui);
        }
        return ui;
    }

    private class DocumentEditorUIRunner
    extends MoeTextPaneUI
    implements IProjectEventListener,
    Runnable {
        private DocumentEditorUIRunner() {
        }

        @Override
        public void run() {
            CoreEvents.unregisterProjectChangeListener((IProjectEventListener)this);
            JEditorPane editor = MoeUI.this.getJEditorPaneFromEditor();
            Highlighter h = editor.getHighlighter();
            editor.setUI(this);
            editor.setHighlighter(h);
            if (!editor.isOpaque()) {
                editor.setOpaque(true);
                MoeUI.this.isEditorTransparent = false;
            }
        }

        public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
            switch (eventType) {
                case CREATE: 
                case LOAD: {
                    SwingUtilities.invokeLater(this);
                }
            }
        }
    }

    public static enum Parts {
        MainWindow,
        MenuBar,
        StatusBar,
        ButtonPanel,
        PaneTitleBar,
        EDITOR,
        MATCHES,
        GLOSSARY,
        NOTES,
        COMMENTS,
        MACHINE_TRANSLATE,
        DICTIONARY,
        MULTIPLE_TRANS,
        INSTANT_START;


        public static Parts[] configullables() {
            Parts[] values = Parts.values();
            int length = values.length - 1;
            Parts[] ret = new Parts[length];
            System.arraycopy(values, 0, ret, 0, length);
            return ret;
        }
    }
}

