/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.moenizer;

import groovy.util.ConfigObject;
import groovy.util.ConfigSlurper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUI;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.MoeUtil;
import jp.sourceforge.users.yutang.omegat.plugin.moenizer.effect.Effect;
import org.omegat.util.FileUtil;
import org.omegat.util.Log;

public class MoeConfig {
    static final String FILE_NAME = "moenizer.conf";
    private final String KEY_INDEX = "index";
    private final String KEY_ISACTIVE = "isActive";
    private final File file;
    private ConfigObject config = null;
    private final TreeSet<ConfigObject> sortedConfigs = new TreeSet<ConfigObject>(new Comparator<ConfigObject>(){

        @Override
        public int compare(ConfigObject conf1, ConfigObject conf2) {
            int index1 = (Integer)conf1.get((Object)"index");
            int index2 = (Integer)conf2.get((Object)"index");
            return index1 - index2;
        }
    });

    public MoeConfig(File file) throws IOException {
        this.file = file;
        if (file.isFile()) {
            String script = FileUtil.readTextFile((File)file);
            this.config = this.createBindedConfigSlurper().parse(script);
            this.addAll(this.sortedConfigs, this.config);
        }
    }

    private ConfigSlurper createBindedConfigSlurper() {
        ConfigSlurper configSlurper = new ConfigSlurper();
        HashMap<String, Enum> map = new HashMap<String, Enum>();
        for (MoeUI.Parts parts : MoeUI.Parts.configullables()) {
            map.put(parts.name(), parts);
        }
        for (Enum enum_ : Effect.Type.values()) {
            map.put(enum_.name(), enum_);
        }
        configSlurper.setBinding(map);
        return configSlurper;
    }

    public Object get(String key) {
        Map flatten;
        if (this.config != null && (flatten = this.config.flatten()).containsKey(key)) {
            return flatten.get(key);
        }
        return null;
    }

    public boolean get(String key, boolean defaultValue) {
        Object ret = this.get(key);
        return ret != null ? (Boolean)ret : defaultValue;
    }

    public Set<ConfigObject> getSortedConfigs() {
        return this.sortedConfigs;
    }

    public ConfigObject getCurrentConfig() {
        for (ConfigObject entry : this.sortedConfigs) {
            boolean isActive;
            if (!entry.containsKey((Object)"isActive") || !(isActive = ((Boolean)entry.get((Object)"isActive")).booleanValue())) continue;
            return entry;
        }
        ConfigObject defaultConfig = MoeConfig.getDefaultConfig();
        boolean isActive = (Boolean)defaultConfig.get((Object)"isActive");
        return isActive ? defaultConfig : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        Writer writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.file));
            this.config.writeTo(writer);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private void addAll(Set<ConfigObject> sortedConfigs, ConfigObject config) {
        for (Object entry : config.entrySet()) {
            Map.Entry e = (Map.Entry)entry;
            ConfigObject conf = (ConfigObject)e.getValue();
            sortedConfigs.add(conf);
        }
    }

    public static ConfigObject getDefaultConfig() {
        File parentDir = MoeUtil.getPrimaryMoeConfigDir();
        String imagePath = MoeConfig.getFirstImagePath(parentDir);
        if (imagePath.isEmpty()) {
            parentDir = MoeUtil.getSecondaryMoeConfigDir();
            imagePath = MoeConfig.getFirstImagePath(parentDir);
        }
        if (imagePath.isEmpty()) {
            try {
                parentDir = MoeUtil.getPluginJarDir();
                imagePath = MoeConfig.getFirstImagePath(parentDir);
            }
            catch (URISyntaxException ex) {
                Log.log((String)ex.getMessage());
            }
        }
        ConfigObject effect = new ConfigObject();
        effect.put((Object)"type", (Object)Effect.Type.Basic);
        LinkedHashMap<String, String> image = new LinkedHashMap<String, String>();
        image.put("path", imagePath);
        effect.put((Object)"image", image);
        ArrayList<ConfigObject> effects = new ArrayList<ConfigObject>(1);
        effects.add(effect);
        ConfigObject node = new ConfigObject();
        node.put((Object)"index", (Object)-1);
        node.put((Object)"isActive", (Object)(!image.isEmpty() ? 1 : 0));
        node.put((Object)"effects", effects);
        return node;
    }

    private static String getFirstImagePath(File parentDir) {
        try {
            List<String> imagePaths = MoeUtil.collectImagePaths(parentDir);
            if (!imagePaths.isEmpty()) {
                return imagePaths.get(0);
            }
        }
        catch (IOException ex) {
            Log.log((String)ex.getMessage());
        }
        return "";
    }
}

