/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.omegat.util.LFileCopy;
import org.omegat.util.Platform;
import org.omegat.util.StaticUtils;

public class FileUtil {
    private static final int MAX_BACKUPS = 11;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static void removeOldBackups(final File originalFile) {
        try {
            File[] bakFiles = originalFile.getParentFile().listFiles(new FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory() && f.getName().startsWith(originalFile.getName()) && f.getName().endsWith(".bak");
                }
            });
            if (bakFiles != null && bakFiles.length > 11) {
                Arrays.sort(bakFiles, new Comparator<File>(){

                    @Override
                    public int compare(File f1, File f2) {
                        return f2.getName().compareTo(f1.getName());
                    }
                });
                for (int i = 11; i < bakFiles.length; ++i) {
                    bakFiles[i].delete();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void backupFile(File f) throws IOException {
        long fileMillis = f.lastModified();
        String str = new SimpleDateFormat("yyyyMMddHHmm").format(new Date(fileMillis));
        LFileCopy.copy(f, new File(f.getPath() + "." + str + ".bak"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File writeScriptFile(String textToWrite, String fileName) {
        File outFile = new File(StaticUtils.getScriptDir(), fileName);
        File outFileTemp = new File(StaticUtils.getScriptDir(), fileName + ".temp");
        outFile.delete();
        BufferedWriter bw = null;
        try {
            textToWrite = textToWrite.replaceAll("\n", System.getProperty("line.separator"));
            bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFileTemp), "UTF-8"));
            bw.write(textToWrite);
        }
        catch (Exception ex) {
        }
        finally {
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        outFileTemp.renameTo(outFile);
        return outFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readScriptFile(File file) {
        String string;
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy(rd, out);
            string = out.toString().replace(System.getProperty("line.separator"), "\n");
        }
        catch (Throwable throwable) {
            try {
                rd.close();
                throw throwable;
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return null;
            }
        }
        rd.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readTextFile(File file) throws IOException {
        BufferedReader rd = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
        try {
            StringWriter out = new StringWriter();
            LFileCopy.copy(rd, out);
            String string = out.toString();
            return string;
        }
        finally {
            rd.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeTextFile(File file, String text) throws IOException {
        OutputStreamWriter wr = new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8");
        try {
            wr.write(text);
        }
        finally {
            ((Writer)wr).close();
        }
    }

    public static List<File> findFiles(File dir, FileFilter filter) {
        ArrayList<File> result = new ArrayList<File>();
        FileUtil.findFiles(dir, filter, result);
        return result;
    }

    private static void findFiles(File dir, FileFilter filter, List<File> result) {
        File[] list = dir.listFiles();
        if (list != null) {
            for (File f : list) {
                if (f.isDirectory()) {
                    FileUtil.findFiles(f, filter, result);
                    continue;
                }
                if (!filter.accept(f)) continue;
                result.add(f);
            }
        }
    }

    public static String computeRelativePath(File rootDir, File file) throws IOException {
        String rootAbs = rootDir.getAbsolutePath().replace('\\', '/') + '/';
        String fileAbs = file.getAbsolutePath().replace('\\', '/');
        switch (Platform.getOsType()) {
            case WIN32: 
            case WIN64: {
                if (fileAbs.toUpperCase().startsWith(rootAbs.toUpperCase())) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
            default: {
                if (fileAbs.startsWith(rootAbs)) break;
                throw new IOException("File '" + file + "' is not under dir '" + rootDir + "'");
            }
        }
        return fileAbs.substring(rootAbs.length());
    }

    public static String loadTextFileFromDoc(String textFile) {
        return null;
    }
}

