/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview.IPreview;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview.TempFileCleaner;
import jp.sourceforge.users.yutang.omegat.plugin.foldermenu.filepreview.WordPreview;
import org.omegat.core.Core;
import org.omegat.core.CoreEvents;
import org.omegat.core.events.IApplicationEventListener;
import org.omegat.core.events.IProjectEventListener;

public class FilePreview {
    private static final HashMap<String, IPreview> previews = new HashMap();
    private static IProjectEventListener projectEventListener = null;
    private static IApplicationEventListener applicationEventListener = null;

    public static boolean delete(File originalFile) throws IOException {
        String key = originalFile.getCanonicalPath();
        IPreview deleted = previews.remove(key);
        if (previews.isEmpty()) {
            FilePreview.unhookProjectChangeEvent();
        }
        return deleted != null;
    }

    public static void init() {
    }

    public static boolean open(File file) throws IOException {
        if (!file.isFile()) {
            return false;
        }
        if (!FilePreview.isUnderTargetFolder(file)) {
            return false;
        }
        if (!FilePreview.available(file)) {
            return false;
        }
        String key = file.getCanonicalPath();
        if (previews.containsKey(key)) {
            previews.get(key).activate();
            return true;
        }
        WordPreview p = new WordPreview(file);
        p.open();
        FilePreview.hookProjectChangeEvent();
        FilePreview.hookApplicationChangeEvent();
        previews.put(key, p);
        TempFileCleaner.addToList(p.getTempFiles());
        return true;
    }

    public static int size(Class<?> classObj) {
        if (classObj == null) {
            return previews.size();
        }
        int i = 0;
        for (IPreview o : previews.values()) {
            if (!classObj.isInstance(o)) continue;
            ++i;
        }
        return i;
    }

    private static boolean available(File file) {
        return WordPreview.isAvailable(file);
    }

    private static void hookProjectChangeEvent() {
        if (projectEventListener != null) {
            return;
        }
        projectEventListener = new IProjectEventListener(){

            @Override
            public void onProjectChanged(IProjectEventListener.PROJECT_CHANGE_TYPE eventType) {
                switch (eventType) {
                    case CLOSE: {
                        FilePreview.onProjectClose();
                        break;
                    }
                    case COMPILE: {
                        FilePreview.onProjectCompile();
                    }
                }
            }
        };
        CoreEvents.registerProjectChangeListener(projectEventListener);
    }

    private static void unhookProjectChangeEvent() {
        if (projectEventListener == null) {
            return;
        }
        CoreEvents.unregisterProjectChangeListener(projectEventListener);
        projectEventListener = null;
    }

    private static void hookApplicationChangeEvent() {
        if (applicationEventListener != null) {
            return;
        }
        applicationEventListener = new IApplicationEventListener(){

            @Override
            public void onApplicationStartup() {
            }

            @Override
            public void onApplicationShutdown() {
                FilePreview.closeAllPreviews();
            }
        };
        CoreEvents.registerApplicationEventListener(applicationEventListener);
    }

    private static void unhookApplicationChangeEvent() {
        if (applicationEventListener == null) {
            return;
        }
        CoreEvents.unregisterApplicationEventListener(applicationEventListener);
        applicationEventListener = null;
    }

    private static void onProjectClose() {
        FilePreview.closeAllPreviews();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FilePreview.unhookProjectChangeEvent();
                FilePreview.unhookApplicationChangeEvent();
            }
        });
    }

    private static void onProjectCompile() {
        FilePreview.reloadAllPreviews();
    }

    private static boolean isUnderTargetFolder(File file) throws IOException {
        String targetRoot = Core.getProject().getProjectProperties().getTargetRoot();
        return file.getCanonicalPath().startsWith(targetRoot);
    }

    private static void closeAllPreviews() {
        if (!previews.isEmpty()) {
            for (IPreview preview : previews.values()) {
                preview.close();
            }
        }
    }

    private static void reloadAllPreviews() {
        if (!previews.isEmpty()) {
            for (IPreview preview : previews.values()) {
                preview.reload();
            }
        }
    }

    static {
        TempFileCleaner.cleanup();
        WordPreview.init();
    }
}

