
//AGPLv3+
/* Copyright 2023 Momi-g
   Copyright 2005 The Geany contributors

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU Affero General Public License as
published by the Free Software Foundation, either version 3 of the
License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU Affero General Public License for more details.

You should have received a copy of the GNU Affero General Public License
along with this program.  If not, see <https://www.gnu.org/licenses/>.
*/

/*SH_doc
title=bejmp section=3 repnl=\040

@name bejmp
@_brief geany plugins, jump to B/EOF, 20clm left/right, jump dialog ext
@_syno -
@tl_dr
		@(code)@
	//build shared lib
	~$ cc bejmp.c -o bejmp.so -shared -fPIC $(pkg-config --cflags geany)
	~$ cp bejmp.so ~/.config/geany/plugins/   #--mkdir if plugins/ isnt
	
	//plugin_load: run geany >> menubar >> tool >> plugins and set keybind
	//add if you want: ~/.config/geany/geany.conf, [plugins] bejmp_width=10
		@()@
@_desc
	-- BOF/EOF jump--
	geany lacks the 'jump to BOF/EOF' keybind settings, and 'ctrl+Home/End'
	uses Scintilla api directly. this plugin add the settings. --
	--
	-- fixed width move to left/right--
	move caret left/right by 20 columns.
	edit ~/.config/geany/geany.conf(or other place) to change width as below: --
	@(code)--@
	#geany.conf
	...
	[plugins]
	...
	bejmp_width=25
	#add this line (change to 25 column)
	@()--@
	--
	-- linejump dialog extension--
	dfl linejump dialog cant move to EOF. '-1' means relative val, (current)-1.
	this plugin extends the syntax which supports EOF/EOL as follows:
		@(code)--@
	(same as dfl)
	12  : jump to abs line 12
	+12 : jump to relative line +12 (== 10+12==22, if caret is line 10)
	-12 : jump to relative line -12 (== 10-12== -2 >> 1, BOF)
	+0  : no change, current line
	-0  : no change
	
	(ext syntax, '0' prefix means END)
	0   : jump to EOF. prefix '0' means EOF
	0-3 : jump to EOF-3 == 97 (if EOF line is 100)
	0+3 : jump to EOF-3 == 97 (not typo. prefix '0' ignores next sign '-+')
	03  : jump to EOF-3 == 97 (accept no sign)
	
	12,30 : jump to abs line 12, column 30.
	12  30: same. grep '2nd number like' token as column
	,30   : l/c == current/30, blank val means current
	12,   : l/c == 12/current
	,+30  : l/c == - /current+30
	,-30  : l/c == - /current-30
	12,0  : l/c == 12 / EOL, column '0' prefix means END==EOL
	12,0-3: l/c == 12 / EOL-3
	12,0+3: l/c == 12 / EOL-3 ('+' >> '-', not typo. abs sub)
	12,03 : l/c == 12 / EOL-3
		@()--@
	geany BOF posinfo l/c is L1/C0. ext jmp dialog takes '1,1' to move BOF.
@_eg -
@return_value -
@notes	-
@conforming_to POSIX.1-2001+
@depend pkg-config, geanyplugin.h
@copyright
	Copyright 2023 momi-g, AGPLv3+ --
	Copyright 2005 The Geany contributors
@_ver 2023-01-11 v1.0.0 (2023-01-11 v1.0.0)
@_see
	https://github.com/geany/geany/issues/2994 --
	https://raw.githubusercontent.com/geany/geany/master/HACKING --
	https://www.geany.org/manual/reference/ --
	Geany 1.38 srccode (almost all is copied from here)
//SH_docE*/
#ifndef bejmp_3841399a47a2
#define bejmp_3841399a47a2

#include <stdio.h>
#include <string.h>
#if ( _POSIX_C_SOURCE +0 < 200112L )
	#include "stop cc: needs compiler posix-2001 or upper(c99+)"
#endif

#endif /* bejmp_3841399a47a2 */
