static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/****************************************************************************
*																			*
*	ړI@F mojiZ												*
*																			*
*	֐@  F int cl_cmpt_string(pAns, pOprtr, pInfoParm1, pInfoParm2)	*
*				(O)char		*pAns											*
*				(I)char  	*pOprtr											*
*				(I)tdtInfoParm *pInfoParm1									*
*				(I)tdtInfoParm *pInfoParm2									*
*																			*
*	߂l@@F ERROR														*
*				 NORMAL														*
*																			*
*	Tv@F															*
*																			*
*****************************************************************************/
#include <colmn.h>

#define ARGSEP  '&'
#define ARGSEP2 '@'
#define ARGPOS  '&'
#define ARGPOS2 '@'
extern CLPRTBL  *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern CLCOMMON CLcommon;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_string(pAns, pOprtr, pInfoParm1, pInfoParm2, nparm, prmp)
	char		**pAns;
	char		*pOprtr;
	tdtInfoParm	*pInfoParm1;
	tdtInfoParm	*pInfoParm2;
	int nparm;
	parmList  *prmp[];
{
	int rc,len,bmode,mflg;
	char *p;
	tdtInfoParm InfoParm3,*pInfoParm3,pParm[2],*ppParm[2];

	if (pAns) *pAns = NULL ;
	else {
		ERROROUT("pAns == NULL");
		return (-1);
	}
	bmode = 0;
	mflg = pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX;
	if (!stricmp(pOprtr,"CONCAT") || !stricmp(pOprtr,"&+") || !stricmp(pOprtr,"|+")) {
		rc=concat(pAns,pInfoParm1,pInfoParm2,nparm,prmp,NULL);
	}
	else if (!stricmp(pOprtr,"SUBSTR") || (bmode=!stricmp(pOprtr,"SUBSTRB")) ||
	         !stricmp(pOprtr,"MID")    || (bmode=!stricmp(pOprtr,"MIDB"))) {
		if (nparm>0) {
#if 1
			if ((rc=cl_gx_exp_obj_opt(1,&prmp[0],NULL,&InfoParm3,0)) < 0) return rc;
#else
			if (rc=cl_conv_arg(prmp[0],&InfoParm3)) return rc;
#endif
			pInfoParm3 = &InfoParm3;
		}
		else pInfoParm3 = NULL;
		if (bmode) mflg = 0;
		rc=substrm(pAns,mflg,pInfoParm1,pInfoParm2,pInfoParm3);
	}
	else if (!stricmp(pOprtr,"REP"))
		rc=replace(pAns,pInfoParm1,pInfoParm2);
	else if (!stricmp(pOprtr,"CONDAS"))			/* K-00044 */
		rc=condas(pAns,pInfoParm1,pInfoParm2);
	else {
		nparm = 2;
		cl_gx_copy_info(&pParm[0],pInfoParm1);
		cl_gx_copy_info(&pParm[1],pInfoParm2);
		ppParm[0] = pInfoParm1;
		ppParm[1] = pInfoParm2;
		if (!stricmp(pOprtr,"TRIM"))
			rc = cl_trim(pAns,nparm,ppParm);
		else if (!stricmp(pOprtr,"STRINGS"))
			rc = cl_strings(pAns,nparm,ppParm);
		else if (!stricmp(pOprtr,"LEFT") || (bmode=!stricmp(pOprtr,"LEFTB"))) {
			if (bmode) mflg = 0;
			rc = cl_leftm(pAns,mflg,nparm,ppParm);
		}
		else if (!stricmp(pOprtr,"RIGHT") || (bmode=!stricmp(pOprtr,"RIGHTB"))) {
			if (bmode) mflg = 0;
			rc = cl_rightm(pAns,mflg,nparm,ppParm);
		}
		else if (!stricmp(pOprtr,"EDIT"))
			rc = cl_edit(pAns,nparm,ppParm);
		else {
			/* cl_cmpt_string: ZqɌ肪܂B */
			ERROROUT2(FORMAT(245),"cl_cmpt_string",pOprtr);
			*pAns = NULL ;
			return( -1 );
		}
	}
	return (rc);
}

/****************************************/
/*										*/
/****************************************/
int concat(pAns, pInfoParm1, pInfoParm2, nparm, prmp, pParm)
char		**pAns;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
int nparm;
parmList  *prmp[];
tdtInfoParm	*pParm;
{
	int		rc,len1,len2,value,i;
	char	w1[16],w2[26],*p1,*p2;
	tdtInfoParm InfoParmW, *pInfoParmW;

	rc = -1;
	p1 = w1;
	if ((len1 = parm_to_char(pInfoParm1,&p1,NULL))<0) {
		return rc;
	}
	p2 = w2;
	if ((len2 = parm_to_char(pInfoParm2,&p2,NULL))<0) {
		goto err;
	}
	if (!(*pAns = Malloc(len1+len2+1))) {
		ERROROUT("concat: malloc error");
		goto err;
	}
	memcpy(*pAns,p1,len1);
	memcpy(*pAns+len1,p2,len2);
	*(*pAns+len1+len2)='\0';

	for (i=0;i<nparm;i++) {
		len1 += len2;
		if (pParm) pInfoParmW = &pParm[i];
		else {
			pInfoParmW = &InfoParmW;
#if 1
			if (rc=cl_gx_exp_obj_opt(1,&prmp[i],/*proc->Obj*/NULL,pInfoParmW,0)) goto err;
#else
			if (rc=cl_conv_arg(prmp[i],pInfoParmW)) goto err;
#endif
		}
		p2 = w2;
		if ((len2 = parm_to_char(pInfoParmW,&p2,NULL))<0) {
	 		goto err;
		}
		if (!(*pAns = Realloc(*pAns,len1+len2+1))) {
			ERROROUT("concat: malloc error");
			goto err;
		}
		memcpy(*pAns+len1,p2,len2);
		*(*pAns+len1+len2)='\0';
	}
	rc = 0;
	if (p1 = *pAns) {
		len1 = strlen(p1) + 1;
		if (*pAns = cl_tmp_const_malloc(len1)) memcpy(*pAns,p1,len1);
		else rc = -1;
		Free(p1);
	}
err:
	if (rc && *pAns) {
		Free(*pAns);
		*pAns = NULL;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int substr_mlen(pList,p1,len1,msp,mn)
parmList *pList;
char *p1;
int  len1,msp,mn;
{
	int i,n,m;
	char *p,*psp;

	if (mn <= 0) {
		psp = NULL;
		n = 0;
	}
	else {
		p = p1;
		for (i=1;i<msp;i++) {
			if (m=akxqiskanji(p)) p += m;
			else p++;
		}
		psp = p;
		n = 0;
		for (i=0;i<mn;i++) {
			if (m=akxqiskanji(p)) {
				p += m;
				n += m;
			}
			else {
				p++;
				n++;
			}
		}
	}
	pList->prp = psp;
	pList->prmlen = n;
	return n;
}

/****************************************/
/*										*/
/****************************************/
int substr_len(mflg, pList, pInfoParm1, pInfoParm2, pInfoParm3)
int mflg;
parmList	*pList;
tdtInfoParm	*pInfoParm1;
tdtInfoParm	*pInfoParm2;
tdtInfoParm	*pInfoParm3;
{
	int		rc,len1,len2,value,sp,n,i,mlen,attr;
	char	w1[16],w2[26],*p1,*p2,*psp;
	char	*pAns;

	rc = NORMAL;
	p1 = w1;
	if ((len1 = parm_to_char(pInfoParm1,&p1,NULL))<0) {
		return -1;
	}
/*
akxaxdump("p1",p1,len1);
*/
	if (mflg) {
		mlen = akxqmlen(p1,len1);
		if (mlen == len1) mflg = 0;
		else len1 = mlen;
	}
	if ((attr=pInfoParm2->pi_attr)==DEF_ZOK_BINA ||
	     attr == DEF_ZOK_FLOA || attr == DEF_ZOK_DECI) {
	/*	sp = cl_get_data_int(pInfoParm2);	*/
		if (rc = cl_get_parm_bin(pInfoParm2,&sp,"substr.p2")) return rc;
#if 1	/* 2018.6.6*/
		if (sp < 0) sp = len1+sp+1;
#endif
		if ((n=len1-sp+1)<0) n=0;
/*
printf("substr parm2 bin:sp=%d n=%d\n",sp,n);
*/
	}
	else if (attr == DEF_ZOK_CHAR) {
		if ((len2=pInfoParm2->pi_dlen)>25) len2=25;
		memcpy(w2,pInfoParm2->pi_data,len2);
		w2[len2]='\0';
		for (i=0;i<len2;i++) {
			if (w2[i]==',') break;
		}
		rc = axccvn(10,w2,i,&sp);
		if (rc == -1) sp = 1;
		else if (rc>0 || rc< -1) {
			ERROROUT(FORMAT(281));	/* Jnʒuł͂܂B */
		 	return( -1 );
	 	}
#if 1	/* 2018.6.6*/
		if (sp < 0) sp = len1+sp+1;
#endif
		if (i>=len2-1) {
			if ((n=len1-sp+1)<0) n=0;
		}
		else {
			rc = axccvn(10,w2+i+1,len2-(i+1),&n);
			if (rc>0 || rc< -1) {
				ERROROUT(FORMAT(282));	/* ł͂܂B */
		 		return -1;
	 		}
			else if (rc == -1) {
				if ((n=len1-sp+1)<0) n=0;
			}
			if (n>(len1-sp+1)) n=len1-sp+1;
		}
/*
printf("substr parm2 char:sp=%d n=%d\n",sp,n);
*/
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),"substr_len",attr);
		 return( -1 );
	}
	if (pInfoParm3) {
		if (pInfoParm3->pi_dlen > 0) {
			if (rc = cl_get_parm_bin(pInfoParm3,&n,"substr.p3")) return rc;
		}
		else n=len1-sp+1;
/*
printf("substr parm3:n=%d\n",n);
*/
		if (n>(len1-sp+1)) n=len1-sp+1;
	}
	if (n<0) n=0;
	if (sp<1 || sp>len1) n=0;
	if (mflg) {
		n = substr_mlen(pList,p1,len1,sp,n);
		psp = pList->prp;
	}
	else psp=p1+sp-1;
	if (!(pAns = cl_tmp_const_malloc(n+1))) {
		ERROROUT("substr:malloc error");
	 	return -1;
	}
	if (n>0) memcpy(pAns,psp,n);
	*(pAns+n)='\0';
/*
printf("substr:p=[%s] sp=%d n=%d\n",p1,sp,n);
printf("substr:Ans=[%s]\n",*pAns);
*/
	pList->prp = pAns;
	pList->prmlen = n;

	return NORMAL;
}

/****************************************/
/*										*/
/****************************************/
int substrm(pAns, mflg, pInfoParm1, pInfoParm2, pInfoParm3)
char **pAns;
int  mflg;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
tdtInfoParm *pInfoParm3;
{
	int ret;
	parmList tList;

	ret = substr_len(mflg,&tList,pInfoParm1,pInfoParm2,pInfoParm3);
	*pAns = tList.prp;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int substr(pAns, pInfoParm1, pInfoParm2, pInfoParm3)
char **pAns;
tdtInfoParm *pInfoParm1;
tdtInfoParm *pInfoParm2;
tdtInfoParm *pInfoParm3;
{
	return substrm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX
	              ,pInfoParm1,pInfoParm2,pInfoParm3);
}

/****************************************/
/*										*/
/****************************************/
int replace(pAns , pInfoParm1 , pInfoParm2)
	char		**pAns;
	tdtInfoParm	*pInfoParm1;
	tdtInfoParm	*pInfoParm2;
{
	int  rc,len1,len2,value,i,j,index,attr;
	char w1[16],w2[16],*p1,*p2,*p,argpos;
	struct ume {
		int spi;
		int len;
	} *pp;

	rc = NORMAL;
	if ((attr=pInfoParm1->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm1);
		cmn_i_to_a(value,w1);
		p1   = w1;
		len1 = strlen(w1);
	}
	else if (attr == DEF_ZOK_CHAR) {
		p1   = pInfoParm1->pi_data;
		len1 = pInfoParm1->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),"replace",attr);
		return -1;
	 }
	if ((attr=pInfoParm2->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm2);
		cmn_i_to_a(value,w2);
		p2   = w2;
		len2 = strlen(w2);
	}
	else if (attr == DEF_ZOK_CHAR) {
		p2   = pInfoParm2->pi_data;
		len2 = pInfoParm2->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),"replace",attr);
	 }

	if (!(p = *pAns = cl_tmp_const_malloc(len1+len2+1))) {
		ERROROUT("replace: malloc error");
	 	return( -1 );
	}
	value=0;
	for (i=0;i<len2-1;i++) {
		if (((p2[i]==ARGSEP)&&(p2[i+1]==ARGSEP)) ||
			((p2[i]==ARGSEP2)&&(p2[i+1]==ARGSEP2))) {
			i++;
			value++;
		}
	}
	if (!(pp = (struct ume *)Malloc((value+1)*8))) {
		ERROROUT("replace: malloc error");
		Free(p);
		*pAns = NULL;
	 	return( -1 );
	}
	value=0;
	pp[value].spi=0;
	for (i=0;i<len2-1;i++) {
		 if (((p2[i]==ARGSEP)&&(p2[i+1]==ARGSEP)) ||
			 ((p2[i]==ARGSEP2)&&(p2[i+1]==ARGSEP2))) {
			pp[value].len=i-pp[value].spi;
			i++;
			pp[++value].spi=i+1;
		}
	}
	pp[value].len=len2-pp[value].spi;
	if (pp[value].len>0) value++;
	for (i=0;i<len1;i++) {
		if ((p1[i]!=ARGPOS) && (p1[i]!=ARGPOS2)) {
			*p++ = p1[i];
			continue;
		}
		argpos = p1[i];
		if (i<len1-1 && p1[i+1]>='0' && p1[i+1]<='9') {
			for (j=i+2;j<len1;j++) {
				if (p1[j]<'0' || p1[j]>'9')
					break;
			}
			if (j<len1 && p1[j]==argpos) {
				if (axccvn(10,p1+i+1,j-(i+1),&index)) {
					/* replace: uw肪ł͂܂B */
					ERROROUT(FORMAT(284));
					Free(p);
					Free(pp);
					*pAns = NULL;
	 				return( -1 );
				}
				if (index<value) {
					memcpy(p,p2+pp[index].spi,pp[index].len);
					p+=pp[index].len;
					i=j;
					continue;
				}
				else if ( argpos == ARGPOS )
				{
					i = j;
					continue;
				}
			}
		}
		*p++ = argpos;
	}
	*p='\0';
	Free(pp);
	return( NORMAL );
}

/****************************************/
/*										*/
/****************************************/
int condas( pAns , pInfoParm1 , pInfoParm2 )
	char		**pAns;
	tdtInfoParm	*pInfoParm1;
	tdtInfoParm	*pInfoParm2;
{
	int  rc,len1,len2,value,i,flag,attr;
	char w1[16],w2[26],*p1,*p2,*p2w,sepc,*peq,*pt,*pf;
	char *p,*p1w;

	p1w = p2w = NULL;
	rc = -1;
	p1 = w1;
	if ((len1 = parm_to_char(pInfoParm1,&p1,NULL))<0) {
		return rc;
	}

	if ((attr=pInfoParm2->pi_attr) == DEF_ZOK_CHAR &&
		 pInfoParm2->pi_dlen > 2 ) {
		p2   = pInfoParm2->pi_data;
		len2 = pInfoParm2->pi_dlen;
	}
	else {
		/* %s: p[^̌^(%d)Ă܂B */
		ERROROUT2(FORMAT(285),"condas",attr);
		goto err;
	 }
	if (!(p2w = Malloc(len2+1))) {
		ERROROUT("condas: p2w malloc error");
		goto err;
	}
	memcpy(p2w,p2,len2);
	*(p2w+len2) = '\0';
	sepc = *p2w;
	pt = peq = p2w + 1;
	i = 1;
	for (;i<len2;i++,pt++) {
		if (*pt == sepc)
			break;
	}
	if (i>=len2) {
		ERROROUT("condas:no 1st seperator.");
		goto err;
	}
	*pt++ = '\0';
	i++;
	pf = pt;
	for (;i<len2;i++,pf++) {
		if (*pf == sepc)
			break;
	}
	if (i>=len2) {
		ERROROUT("condas:no 2nd seperator.");
		goto err;
	}
	*pf++ = '\0';
	if (strcmp(p1,peq))
		p2 = pf;
	else
		p2 = pt;
	p = p2;
	while (*p) {
		if (*p=='%' && *(p+1)=='q') {
			*++p = 's';
			if (len1==0) break;
			len1 += len1;
			if (!(p1w = Malloc(len1+1))) {
				ERROROUT("condas: p1w malloc error");
				goto err;
			}
			p = p1w;
			while (*p++ = *p1) {
				if (*p1++ == M_QUOTE1) *p++ = M_QUOTE1;
			}
			*p = '\0';
			p1 = p1w;
			break;
		}
		p++;
	}

	if (*pAns = cl_tmp_const_malloc(len1+len2)) {
		sprintf(*pAns,p2,p1);
		rc = 0;
	}
	else ERROROUT("condas: pAns malloc error");

err:
	if (p1w) Free(p1w);
	if (p2w) Free(p2w);
		
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_parm_to_char_opt(pInfoParm1,p1,p1_len,p1_free)
tdtInfoParm	*pInfoParm1;
char **p1, **p1_free;
int p1_len;
{
	int len1, value, ret, attr,iP1USE, im, opt, dec_pre, pre, size, p_len;
	char *p,*pp,wrk[10];
	double dValue,dw;
	MPA *mpa;
/*
printf("parm_to_char: pInfoParm1=%08x p1=%08x p1_len=%d p1_free=%08x\n",pInfoParm1,p1,p1_len,p1_free);
*/
	if (!pInfoParm1 || !p1) return -1;
	if (p1_len>0 && *p1) {
		iP1USE = p1_len;
		**p1 = '\0';
		p_len = p1_len;
	}
	else {
		iP1USE = 0;
		p_len = 32;
	}
	if (p1_free) {
		im = D_OPT_ALC_MALLOC;
		*p1_free = NULL;
	}
	else im = D_OPT_ALC_TMP;
	if (ret=cl_check_data_id(pInfoParm1,0)) return ret+ECL_CHK_VAR_ERROR;
	if ((attr=pInfoParm1->pi_attr) == DEF_ZOK_BINA) {
		value = cl_get_data_long(pInfoParm1);
		if (iP1USE) p = *p1;
		else {
			if (!(p = cl_opt_malloc(im,p_len))) {
				ERROROUT("parm_to_char: BINA p cl_opt_malloc error");
				return -1;
			}
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
		cmn_i_to_a(value,p);
		len1 = strlen(p);
	}
	else if (attr == DEF_ZOK_FLOA) {
		memcpy(&dValue,pInfoParm1->pi_data,sizeof(double));
		if (iP1USE) p = *p1;
		else {
			if (!(p = cl_opt_malloc(im,p_len))) {
				ERROROUT("parm_to_char: FLOA p cl_opt_malloc error");
				return -1;
			}
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
#if 1	/* 2018.7.23 */
		if ((len1=cl_double_to_str(p,p_len,dValue)) < 0) return len1;
#else
		pre = pGlobTable->options[19] & 0xff;
		if (pre > 0) {
			if (pre > 17) pre = 17;
			sprintf(wrk,"%%.%dg",pre);
			sprintf(p,wrk,dValue);
			len1 = strlen(p);
		}
		else {
			dw = X_ABS(dValue);
			if (dw && (dw>999999.999999 || dw<0.001)) {
				sprintf(p,"%e",dValue);
				len1 = strlen(p);
			}
			else {
				sprintf(p,"%f",dValue);
				len1 = strlen(p);
				len1 = akxnrskipin(p,len1,"0");
				if (len1>0 && *(p+len1-1)=='.') len1++;
				*(p+len1) = '\0';
			}
		}
#endif
	}
	else if (attr == DEF_ZOK_DECI) {
		mpa = (MPA *)pInfoParm1->pi_data;
		size = pGlobTable->options[19] & 0xffff;
		pre = size & 0xff;
		dec_pre = pInfoParm1->pi_hlen;
		if ((opt = pGlobTable->options[10]) & 0x40) {
			if (pre > 0) len1 = pre;
			else len1 = mpa->len;
			len1 += 8;
		}
		else {
			if ((len1=mpa->exp) < 0) len1 = -len1;
			len1 += mpa->len + 4+dec_pre;	/* ȂƂ\Ȓ */
		}
/*
printf("parm_to_char: len1=%d\n",len1);
*/
		if (!(p = cl_opt_malloc(im,len1))) {
			ERROROUT("parm_to_char: DECI p cl_opt_malloc error");
			return -1;
		}
#if 1
		len1 = cl_mpa2an(mpa,p,len1,0,dec_pre,pInfoParm1->pi_pos);
#else
		if (opt & 0x40) {
			opt = (opt & 0x0f) | ((pGlobTable->options[11]<<4) & 0xf0);
			len1 = m_mpa2an_exp(mpa,p,len1,pre,size>>8,opt);
		}
		else
			len1 = m_mpa2an(mpa,p,len1,pGlobTable->options[10]);
#endif
		*p1 = p;
		if (p1_free) *p1_free = p;
	}
	else if (attr == DEF_ZOK_CHAR) {
		len1 = pInfoParm1->pi_dlen;
		pp = pInfoParm1->pi_data;
		if (pInfoParm1->pi_alen & D_AULN_RANGE_DATA) len1 = akxstrnlen(pp,len1);
		if (len1 > 0) {
			*p1 = pp;
/*
printf("parm_to_char: p1=[%s]\n",*p1);
*/
			/* 0x80nmłȂƂ́A̍ŌɃkȂ\̂
			   stringɕϊ */
			if (p1_len<0 || !(pInfoParm1->pi_scale & 0x80)) {
				if (!(p = cl_opt_malloc(im,len1+1))) {
					ERROROUT("parm_to_char: CHAR p cl_opt_malloc error");
					return -1;
				}
			/*	strnzcpy(p,pp,len1);	2006.9.2 Koba */
				memzcpy(p,pp,len1);
				*p1 = p;
				if (p1_free) *p1_free = p;
			}
		}
		else *p1 = "";
	}
	else if (attr == DEF_ZOK_BULK) {
		len1 = pInfoParm1->pi_dlen;
		if (len1>0) {
			if (!(p = cl_opt_malloc(im,len1*D_BULK_TYPE+1))) {
				ERROROUT("parm_to_char: BULK p cl_opt_malloc error");
				return -1;
			}
			len1 = clcnvtb2c(pInfoParm1->pi_data,len1,p);
			*p1 = p;
			if (p1_free) *p1_free = p;
		}
	}
	else if (attr == DEF_ZOK_DATE) {
		if (!(p = cl_opt_malloc(im,20))) {
			ERROROUT("parm_to_char: DATE p cl_opt_malloc error");
			return -1;
		}
		len1 = cl_date2uxstr(p,19,NULL,pInfoParm1->pi_data);
		*p1 = p;
		if (p1_free) *p1_free = p;
	}
	else if (attr) {
		/* %s: p[^̌^(%d)Ă܂B */;
		ERROROUT2(FORMAT(285),"parm_to_char",attr);
		 return -1;
	}
	else {
		/* parm_to_char: ϐ܂̓f[^`łB */
		ERROROUT(FORMAT(286));
		 return ECL_NDEFVAR_ERROR;
	}
	return len1;
}

/****************************************/
/*										*/
/****************************************/
int cl_double_to_str(p,p_len,dValue)
char *p;
int p_len;
double dValue;
{
	int pre,len1;
	char wrk[10];
	double dw;

	if (!p || p_len<2) return -1;

	pre = pGlobTable->options[19] & 0xff;
	if (pre > 0) {
		if (pre > 17) pre = 17;
		sprintf(wrk,"%%.%dg",pre);
		snprintf(p,p_len,wrk,dValue);
		len1 = strlen(p);
	}
	else {
		dw = X_ABS(dValue);
		if (dw && (dw>999999.999999 || dw<0.001)) {
			snprintf(p,p_len,"%e",dValue);
			len1 = strlen(p);
		}
		else {
			snprintf(p,p_len,"%f",dValue);
			len1 = strlen(p);
			len1 = akxnrskipin(p,len1,"0");
			if (len1>0 && *(p+len1-1)=='.') len1++;
			*(p+len1) = '\0';
		}
	}
	return len1;
}

/****************************************/
/*										*/
/****************************************/
int cl_mpa2an(mpa,work,w_len,m_flg,dec_pre,dec_sca)
MPA *mpa;
char *work;
int w_len,m_flg,dec_pre,dec_sca;
{
	int opt,pre,len;
	MPA10W w;
/*
printf("cl_mpa2an: w_len=%d m_flg=%d dec_pre=%d dec_sca=%d\n",w_len,m_flg,dec_pre,dec_sca);
*/
	opt = pGlobTable->options[10];
	if (m_flg > 0) {
		opt |= m_flg & 0x20;
		m_flg &= ~0x20;
	}
	if (opt & 0x80) {
		dec_pre = dec_sca = 0;
	}
	if (dec_pre > 0) opt &= ~0x06;
/*
printf("cl_mpa2an: opt=%04x exp=%d\n",opt,mpa->exp);
*/
	if ((opt & 0x40) || (X_ABS(mpa->exp)>NMPA)) {
		pre = pGlobTable->options[19] & 0xffff;
		opt = (opt & 0x0f) | ((pGlobTable->options[11]<<4) & 0xf0);
		len = m_mpa2an_exp(mpa,work,w_len,pre & 0xff,pre>>8,opt);
	}
	else {
		if (m_flg > 0) opt |= 0x20;
		else if (m_flg < 0) opt &= ~0x20;
#if 0
		m_100to10(mpa,&w);
		if (dec_pre>0 && dec_sca>0) {
/*
printf("cl_mpa2an: w.exp=%d w.len=%d dec_pre=%d dec_sca=%d\n",w.exp,w.len,dec_pre,dec_sca);
*/
			w.len = dec_sca + w.exp + 1;
			if (w.len <= 0) w.len = 0;
		}
		len = m_mpa10_to_an(&w,work,w_len,opt);
#else
		len = m_mpa2an(mpa,work,w_len,opt);
#endif
	}
	return len;
}

/****************************************/
/*										*/
/****************************************/
int parm_to_char(pInfoParm1,p1,p1_free)
tdtInfoParm	*pInfoParm1;
char **p1, **p1_free;
{
/*
 * BINAFLOAɂẮA*p1̃AhXɌʂԂB
 *   *p1NULL̂Ƃ́AȉƓB
 * CHAR,DECI,BULKɂẮA
 *     p1_free!=NULL ̂Ƃ́AMalloc(im=4)B
 *     p1_free==NULL ̂Ƃ́Acl_tmp_const_malloc(im=3)B
 */
 	int im;
 
	if (!pInfoParm1 || !p1) return -1;
	if (*p1) im = 16;	/* BINAFLOAɂẮAp1̃AhXɌʂԂ */
	else im = 0;
	return cl_parm_to_char_opt(pInfoParm1,p1,im,p1_free);
}

/****************************************/
/*										*/
/****************************************/
int parm_to_char_tmp(pInfoParm1,p1,len)
tdtInfoParm *pInfoParm1;
char **p1;
int len;
{
	return cl_parm_to_char_opt(pInfoParm1,p1,len,NULL);	/* cl_tmp_const_malloc */
}

/****************************************/
/*										*/
/****************************************/
int cl_get_ITBL_maxargs(nparm,ppParm,pIndex,ppTBL,iMINARGS,iMAXARGS,pmaxargs,set_defualt)
int nparm;
tdtInfoParm *ppParm[];
tdtArrayIndex *pIndex;
tdtInfoParm ****ppTBL;
int iMINARGS,iMAXARGS,*pmaxargs,*set_defualt;
{
	int iRc,maxargs,set_val,*index,ret;
	tdtInfoParm *pInfoParm;

	index = pIndex->index;
#if 0	/* 2017.7.23 koba */
	index[4] = index[3] = 0;
#else
	index[1] = index[0] = 0;
#endif
	if (nparm>=1 && pIndex && ppTBL) {
		pInfoParm = ppParm[0];
		if (ret = cl_check_use_mapped_array(pInfoParm)) return ret;
		if (ret = cl_get_array_index_tbl(pInfoParm,pIndex,ppTBL,"cl_get_ITBL_maxargs.index:")) return ret;

DEBUGOUT_InfoParm(194,"cl_get_ITBL_maxargs:",pInfoParm,0,0);

		if (ret = cl_check_use_hash_array(pInfoParm,pIndex)) return ret;
	}

#if 0	/* 2017.7.23 koba */
DEBUGOUTL2(194,"cl_get_ITBL_maxargs: index[3]=%d index[4]=%d",index[3],index[4]);
#else
DEBUGOUTL2(194,"cl_get_ITBL_maxargs: index[0]=%d index[1]=%d",index[0],index[1]);
#endif

	if (!pmaxargs) return 0;
	set_val = 0;
#if 0	/* 2017.7.23 koba */
	if ((maxargs = iMAXARGS) > index[4]) maxargs = index[4];
#else
	if ((maxargs = iMAXARGS) > index[1]) maxargs = index[1];
#endif
	if (nparm >= 2) {
		if (pInfoParm = ppParm[1]) {
			if (pInfoParm->pi_dlen > 0) {
				if (iRc = cl_get_parm_bin(pInfoParm,&maxargs,"cl_get_ITBL_maxargs.maxargs:")) {
					if (iRc > 0) iRc = -3;
					goto Err;
				}
				if (maxargs<iMINARGS || maxargs>iMAXARGS) {
					ERROROUT1(FORMAT(287),maxargs);	/* max_args(%d)słB */
					iRc = -1;
					goto Err;
				}
#if 0	/* 2017.7.23 koba */
				if (maxargs > index[4]) {
					/* max_args(%d)ž(%d)𒴂Ă܂B܂B */
					ERROROUT2(FORMAT(288),maxargs,index[4]);
					maxargs = index[4];
				}
#else
				if (maxargs > index[1]) {
					/* max_args(%d)ž(%d)𒴂Ă܂B܂B */
					ERROROUT2(FORMAT(288),maxargs,index[1]);
					maxargs = index[1];
				}
#endif
				set_val = maxargs;
			}
		}
	}

DEBUGOUTL2(194,"cl_get_ITBL_maxargs: maxargs=%d set_val=%d",maxargs,set_val);

	iRc = 0;
  Err:
	if (pmaxargs) *pmaxargs = maxargs;
	if (set_defualt) *set_defualt = set_val;
	return iRc;
}

#define MAXARGS	256	/* max column of EXCEL */
/****************************************/
/*										*/
/****************************************/
int cl_get_args(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,map_index,max_args,opt) */
{
	tdtInfoParm *pInfoParm,rInfoParm/*,*ppParm[2]*/;
	tdtInfoParm ***pTBL;
	int iRc,n,i,maxargs,opt,len,parmlen,ix,*pSize,len5,set_defualt,nm,set_opt;
	char w1[32],*p1,*p2,parm[512],*argv[MAXARGS];
	char w5[32],*p5;
	ScrPrCT *pScCT;
	char c,*name;
	tdtArrayIndex tIndex;
	int  *index;

	p2 = NULL;
	iRc = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) return len;
/*
printf("cl_get_args: len=%d p1=[%s]\n",len,p1);
*/
/*
	ppParm[0] =  &pParm[1];
	ppParm[1] =  &pParm[2];
*/
	if (iRc=cl_get_ITBL_maxargs(nparm-1,&ppParm[1],&tIndex,&pTBL,1,MAXARGS,
	                            &maxargs,&set_defualt)) return iRc;
	if (!len) {
		n = 0;
		goto zero;
	}
	set_opt = 0;
	if (nparm>=4 && ppParm[3]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[3],&opt,"getargs.opt:")) goto err;
		set_opt = 1;

DEBUGOUTL1(191,"cl_get_args: opt=%08x",opt);

	}
	else opt = AKX_ARGV_DELM_COM | AKX_ARGV_TERM_IGE |
	           AKX_ARGV_IGNR_EQU | AKX_ARGV_DELM_CLN;

	p5 = NULL;
	if (nparm>=5 && ppParm[4]->pi_dlen>0) {
		p5 = w5;
		if ((len5 = parm_to_char(ppParm[4],&p5,NULL)) < 0) goto err;
		if (len5 > 0) {
		/*	opt = (opt & AKX_ARGV_NOT_CUT_QUOT) | AKX_ARGV_USE_ATTR2_SEP;	*/
		/*	opt |= AKX_ARGV_USE_ATTR2_SEP;	*/

DEBUGOUTL2(191,"cl_get_args: sep=[%s] opt=%08x",p5,opt);

			if (!set_opt && *p5==',') opt |= AKX_ARGV_FOR_CSV;
		}
		else p5 = NULL;
	}

	p2 = parm;
	parmlen = sizeof(parm);
	len += maxargs + 1;
	if (len > parmlen) {
		if (!(p2=Malloc(len))) {
			iRc = -1;
			goto err;
		}
		parmlen = len;
	}

DEBUGOUTL4(194,"cl_get_args: len=%d parm=%08x parmlen=%d p2=%08x",len,parm,parmlen,p2);

	if ((n=akxtgetargvns2(p1,INT_MAX,argv,maxargs,p2,parmlen,p5,opt)) < 0) {
		iRc = n;
		goto err;
	}
 zero:
	nm = X_MAX(n,set_defualt);

DEBUGOUTL1(194,"cl_get_args: n=%d",n);

	index = tIndex.index;
#if 1	/* 2017.7.23 koba */
	ix = index[3];
#else
	ix = index[0];
#endif
	for (i=0;i<nm;i++,ix++) {
		pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (pInfoParm) {

DEBUGOUT_InfoParm(194,"cl_get_args: i=%d ix=%d",pInfoParm,i,ix);

			if (i < n) {
				p1  = argv[i];
				len = strlen(p1);
			}
			else {
				p1  = "";
				len = 0;
			}
		/*	memset(&rInfoParm,0,sizeof(tdtInfoParm));	*/
			cl_set_parm_char(&rInfoParm,p1,len);
			if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) goto err;
		}
		else {
			iRc = -1;
			goto err;
		}
	}
/* zero:	*/
	memcpy(pWork,&n,sizeof(int));
 err:
	if (p2 && p2!=parm) Free(p2);

DEBUGOUTL1(194,"cl_get_args: iRc=%d",iRc);

	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_word(pWork,nparm,ppParm)
char *pWork;
int  nparm;
tdtInfoParm *ppParm[];	/* (line,map_index,sep,opt) */
{
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL,*ppInfo[6];
	int iRc,n,opt,len,i,ix,wdsize,wdlen,len3;
	char *line, *sep, wrk[512];
	tdtArrayIndex tIndex;
	SSPL_S sspl;

	n = -1;
	memcpy(pWork,&n,sizeof(int));
	iRc = 0;
	/*** line ***/
	line = NULL;
	if ((len = parm_to_char(ppParm[0],&line,NULL)) <= 0) return len;
/*
printf("cl_get_word: len=%d line=[%s]\n",len,line);
*/
	/*** map_index ***/
	if (iRc=cl_get_ITBL_maxargs(1,&ppParm[1],&tIndex,&pTBL,0,0,0,0)) return iRc;
#if 1	/* 2017.7.23 koba */
/*
printf("cl_get_word: index=%d %d %d %d\n",
tIndex.index[3],tIndex.index[4],tIndex.index[5],tIndex.index[6]);
*/
	if (tIndex.index[4] < 6) {
		ERROROUT1("zTCY(%d)́A6ȏKvłB",tIndex.index[4]);
		return -1;
	}
	ix = tIndex.index[3];
#else
/*
printf("cl_get_word: index=%d %d %d %d\n",
tIndex.index[0],tIndex.index[1],tIndex.index[2],tIndex.index[3]);
*/
	if (tIndex.index[1] < 6) {
		ERROROUT1("zTCY(%d)́A6ȏKvłB",tIndex.index[1]);
		return -1;
	}
	ix = tIndex.index[0];
#endif
	for (i=0;i<6;i++,ix++) {
		ppInfo[i] = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
		if (!ppInfo[i]) return -1;
DEBUGOUT_InfoParm(194,"cl_get_word: i=%d",ppInfo[i],i,0);
	}
	memset(&sspl,0,sizeof(SSPL_S));
	sspl.wd = wrk;
	sspl.wdmax = sizeof(wrk);
	if (iRc = cl_get_parm_bin(ppInfo[0],&sspl.sp,"getwd.sp:")) return iRc;
/*
printf("cl_get_word: sp=%d\n",sspl.sp);
*/
	/*** wdlen ***/
	if (nparm>=5 && ppParm[4]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[4],&wdlen,"getwd.opt:")) return iRc;
/*
printf("cl_get_word: wdlen=%d\n",wdlen);
*/
		if (wdlen > 0) {
			wdsize = wdlen + 1;
			if (wdsize > sspl.wdmax) {
				sspl.wd = cl_tmp_const_malloc(wdsize);
			}
			sspl.wdmax = wdsize;
		}
	}
/*
printf("cl_get_word: wdmax=%d\n",sspl.wdmax);
*/
	/*** sep ***/
	sep = NULL;
	if (nparm>=3 && ppParm[2]->pi_dlen>0) {
		if ((len3 = parm_to_char(ppParm[2],&sep,NULL)) < 0) return len3;
		else if (!len3) sep = NULL;
	}
/*
printf("cl_get_word: sep=[%s]\n",sep);
*/
	/*** opt ***/
	opt = 7;
	if (nparm>=4 && ppParm[3]->pi_dlen>0) {
		if (iRc = cl_get_parm_bin(ppParm[3],&opt,"getwd.opt:")) return iRc;
/*
printf("cl_get_word: opt=%08x\n",opt);
*/
	}

	n = akxtgwnsl(line,len,&sspl,sep,opt);
	if (n >= 0) {
/*
printf("cl_get_word: n=%d wd=[%s]\n",n,sspl.wd);
*/
		cl_set_parm_char(&rInfoParm,sspl.wd,n);
		if (iRc=cl_gx_rep_info_set(ppInfo[1],&rInfoParm,1)) return iRc;
	}
	cl_set_parm_bin(ppInfo[0],sspl.sp);
	for (i=0;i<4;i++) {
		cl_set_parm_bin(ppInfo[i+2],sspl.attr[i]);
	}
	if (!n && !sspl.attr[0]) n = -1;

	memcpy(pWork,&n,sizeof(int));
/*
printf("cl_get_args: iRc=%d\n",iRc);
*/
	return iRc;
}

/****************************************/
/*										*/
/****************************************/
int cl_trim(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,opt) */
{
	int  ret,opt,len;
	char *p1;

	ret = 0;
	if ((len = parm_to_char_tmp(ppParm[0],&p1,-1)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_trim: len=%d p1=[%s]\n",len,p1);
*/
		if (nparm >= 2) {
			if (ret = cl_get_parm_bin(ppParm[1],&opt,"trim.opt:")) return ret;
/*
printf("clTrm: opt=%d\n",opt);
*/
		}
		else opt = 0;	/* 1-->0 2017.11.03 */
		len = akxtsapb(opt,p1,len+1);
/*
printf("cl_trim: len=%d p=[%s]\n",len,p);
*/
	}
	*pAns = p1;
	ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_strings(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	int  ret,num,len,len_num,i;
	char w1[32],*p1,*p;

	*pAns = NULL;
	num = ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_strings: len=%d p1=[%s]\n",len,p1);
*/
		if (ret = cl_get_parm_bin(ppParm[1],&num,"Strings.num:")) return ret;
	}
/*
printf("cl_strings: num=%d\n",num);
*/
	if ((len_num = len*num) > 0) {
		if (p = cl_tmp_const_malloc(len_num+1)) {
			*pAns = p;
			for (i=0;i<num;i++,p+=len) {
				memcpy(p,p1,len);
			}
			*p = '\0';
		}
		else {
			ERROROUT("Strings: pAns malloc error");
			ret = -1;
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_leftm(pAns,mflg,nparm,ppParm)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_right_leftm(pAns,mflg,nparm,ppParm,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_left(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_leftm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX,nparm,ppParm);
}

/****************************************/
/*										*/
/****************************************/
int cl_right_leftm(pAns,mflg,nparm,ppParm,rl)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
int  rl;	/* 0:right / 1:left */
{
	tdtInfoParm tInfoParmS,tInfoParm1,tInfoParm2;
	int  ret,num,len,i;
	char w1[32],*p1;

	*pAns = NULL;
	num = ret = 0;
	p1 = w1;
	if ((len = parm_to_char(ppParm[0],&p1,NULL)) < 0) return len;
	else if (len > 0) {
/*
printf("cl_right: len=%d p1=[%s]\n",len,p1);
*/
		if (ret = cl_get_parm_bin(ppParm[1],&num,"Right/Left.num:")) return ret;
	}
/*
printf("cl_right: num=%d\n",num);
*/
	if (len>0 && num!=0) {
		cl_set_parm_char(&tInfoParmS,p1,len);
		if (mflg) len = akxqmlen(p1,len);
		if (num < 0) {
			if ((num += len) <= 0) return 0;
		}
		if (rl) {	/* left */
			cl_set_parm_bin(&tInfoParm1,1);
			cl_set_parm_bin(&tInfoParm2,num);
			ret = substrm(pAns,mflg,&tInfoParmS,&tInfoParm1,&tInfoParm2);
		}
		else {		/* right */
			if ((i = len - num + 1) <= 0) i = 1;
			cl_set_parm_bin(&tInfoParm1,i);
			ret = substrm(pAns,mflg,&tInfoParmS,&tInfoParm1,NULL);
		}
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_rightm(pAns,mflg,nparm,ppParm)
char **pAns;
int  mflg;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_right_leftm(pAns,mflg,nparm,ppParm,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_right(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	return cl_rightm(pAns,pCLprocTable->CurScr->pFlag & D_SCRPT_NEW_LEX,nparm,ppParm);
}

/****************************************/
/*										*/
/****************************************/
int cl_in_str(pWork,nparm,pParm)
char *pWork;
int  nparm;
tdtInfoParm *pParm;	/* (buf,map_index,max_args,opt) */
{
	int  i,ret,opt,len[2];
	char w1[64],*p1[2];

	p1[0] = w1;
	p1[1] = w1 + 32;
	for (i=0;i<2;i++) {
		ret = parm_to_char(&pParm[i],&p1[i],NULL);
/*
printf("cl_in_str: i=%d len=%d p1=[%s]\n",i,ret,p1[i]);
*/
		if (ret < 0) return ret;
		len[i] = ret;
	}
	if (nparm >= 3) {
		if (ret = cl_get_parm_bin(&pParm[2],&opt,"option:")) return ret;
	}
	else opt = 0;
/*
printf("cl_in_str: opt=%d\n",opt);
*/
	ret = akxs_in_mem_opt(p1[0],len[0],p1[1],len[1],opt);
/*
printf("cl_in_str: ret=%d\n",ret);
*/
	memcpy(pWork,&ret,sizeof(int));
	if (ret >= 0) ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _edit_width(widths,p_b,data,len)
int widths;
char *p_b,*data;
int len;
{
	int width;

	if ((width=widths) < 0) width = -width;

	if (widths >= 0) {
		memzcpy(p_b,data,len);
		if (width > len) {
			memset(p_b+len,' ',width-len);
			*(p_b+width) = '\0';
		}
	}
	else if (widths < 0) {
		if (width > len) {
			memset(p_b,' ',width-len);
			p_b += width-len;
		}
		memzcpy(p_b,data,len);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_edit_sub(pAns,format,nparm,ppParm)
char **pAns,*format;
int  nparm;
tdtInfoParm **ppParm;	/* (buf,opt) */
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	tdtInfoParm *pInfoParm;
	int  len_f,len_d,i,len,ipa,val,width,widths,ret,iVal[2],iAttr[3];
	char form[256],buf[256],*p_b,*p,*p_f,*p_d,c,attr,w1[16];
	double dValue;
	uchar uc;

	if (!pAns) return -1;
	*pAns = NULL;
	len_f = strlen(p_f=format);
	if (len_f <= 0) return 0;
	ipa = 0;
	buf[0] = '\0';
	mcat.mc_ipos = 0;
	for (;;) {
/*
printf("cl_edit:1: len_f=%d p_f=[%s]\n",len_f,p_f);
*/
		c = '\0';
		i = 0;
		while (i<len_f && (c=*(p_f+i))) {
			if (c=='%') {
				if (*(p_f+i+1)=='%') i++;
				else break;
			}
			i++;
		}
		akxtmcat(&mcat,p_f,i);
		if (c != '%') {
			break;
		}
		p_f += i;
		len_f -= i;
/*
printf("cl_edit:2: len_f=%d p_f=[%s]\n",len_f,p_f);
*/
		widths = atoi(p_f+1);
		if ((width=widths) < 0) width = -width;
		i = 1;
		p_b = buf;
		if (width > sizeof(buf)-1) {
			if (!(p_b=cl_tmp_const_malloc(width+1))) return -1;
		}
		*p_b = '\0';
		while (i<len_f && (c=*(p_f+i)) &&
		       ((c>='0' && c<='9')||(c=='.')||(c=='+')||(c=='-'))) i++;
		i++;
		if (ipa < nparm) {
			memnzcpy(form,p_f,i,sizeof(form)-1);
/*
printf("cl_edit: form=[%s] widths=%d\n",form,widths);
*/
			c = toupper(c);
			pInfoParm = ppParm[ipa];
			attr = pInfoParm->pi_attr;
			p_d  = pInfoParm->pi_data;
			len_d = pInfoParm->pi_dlen;
			if (len_d > 0) {
				if (attr==DEF_ZOK_FLOA)
					memcpy(&dValue,p_d,sizeof(double));
				else if (attr==DEF_ZOK_BINA)
					val = cl_get_data_long(pInfoParm);
			}
			if (len_d <= 0) {
				if (c=='S' && attr==DEF_ZOK_CHAR) sprintf(p_b,form,"");
				else {
					p = "(null)";
					_edit_width(widths,p_b,p,strlen(p));
				}
			}
			else if (c == 'S') {
#if 1
				if (attr != DEF_ZOK_CHAR) {
					p_d = w1;
					len_d = parm_to_char(pInfoParm,&p_d,NULL);
				}
				if (len_d < 0) {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
				else {
					if (len_d>width && len_d>sizeof(buf)-1) {
						if (!(p_b = cl_tmp_const_malloc(len_d+1))) return -1;
					}
					sprintf(p_b,form,p_d);
				}
#else
				if (attr == DEF_ZOK_CHAR) {
					if (len_d>width && len_d>sizeof(buf)-1) {
						if (!(p_b = cl_tmp_const_malloc(len_d+1))) return -1;
					}
					sprintf(p_b,form,p_d);
				}
				else {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
#endif
			}
			else if (c == 'C') {
				if (attr==DEF_ZOK_FLOA) {
					val = dValue;
					uc = val;
				}
				else if (attr==DEF_ZOK_BINA) uc = val;
				else if (attr==DEF_ZOK_DECI) {
					if (cl_get_parm_bin(pInfoParm,&val,"cl_edit_sub:C:")) uc = ' ';
					else uc = val;
				}
				else if (attr==DEF_ZOK_DATE) {
					p_d = w1;
					len_d = parm_to_char(pInfoParm,&p_d,NULL);
					if (len_d < 0) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					}
					uc = (uchar)*p_d;
				}
				else uc = (uchar)*p_d;
				sprintf(p_b,form,uc);
			}
			else if (c=='F' || c=='E' || c=='G' || c=='A') {
				if (attr == DEF_ZOK_FLOA) sprintf(p_b,form,dValue);
				else if (attr == DEF_ZOK_BINA) {
					dValue = val;
					sprintf(p_b,form,dValue);
				}
#if 1
				else if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DECI) {
					if (ret=cl_get_parm_double(pInfoParm,iVal,"cl_edit_sub:DOUBLE:",iAttr)) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					/*	return -1;	*/
					}
					else {
						if (iAttr[0] == DEF_ZOK_BINA) dValue = CL_GET_VAL_BIN(iVal);
						else memcpy(&dValue,iVal,sizeof(double));
						sprintf(p_b,form,dValue);
					}
				}
#endif
				else {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
			}
			else if (c=='D' || c=='I' || c=='O' || c=='U' || c=='X') {
				if (attr == DEF_ZOK_BINA) sprintf(p_b,form,val);
				else if (attr == DEF_ZOK_FLOA) {
					val = cl_chk_over_flow_d2_i(dValue,"cl_edit_sub");
					sprintf(p_b,form,val);
				}
#if 1
				else if (attr==DEF_ZOK_CHAR || attr==DEF_ZOK_DECI) {
					if (ret=cl_get_parm_bin(pInfoParm,&val,"cl_edit_sub:BIN:")) {
						p = "(ERR)";
						_edit_width(widths,p_b,p,strlen(p));
					/*	return -1;	*/
					}
					else sprintf(p_b,form,val);
				}
#endif
				else if (attr==DEF_ZOK_DATE) {
					p = "(ERR)";
					_edit_width(widths,p_b,p,strlen(p));
				}
				else sprintf(p_b,form,p_d);
			}
			else {
				sprintf(p_b,form,p_d);
			}
			ipa++;
		}
		else {
			p = "(N/A)";
			_edit_width(widths,p_b,p,strlen(p));
		}
		akxtmcats(&mcat,p_b);
		p_f += i;
		len_f -= i;
	}
	*pAns = mcat.mc_bufp;
	return mcat.mc_ipos;
}

/****************************************/
/*										*/
/****************************************/
int cl_edit(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	tdtInfoParm *pInfoParm;
	int ret,len_f;
	char *pWork,*p,*format;

	if (!pAns) return -1;
	*pAns = NULL;
	ret = 0;
	pWork = "";
	if (nparm > 0) {
		pInfoParm = ppParm[0];
		len_f = pInfoParm->pi_dlen;
		if (len_f > 0) {
			if (pInfoParm->pi_attr != DEF_ZOK_CHAR) return -2;
			format = pInfoParm->pi_data;
			if ((ret=cl_edit_sub(&pWork,format,nparm-1,&ppParm[1])) < 0) return ret;
		}
	}
	if (!(p=cl_tmp_const_malloc(ret+1))) return -1;
	memzcpy(p,pWork,ret);
	*pAns = p;

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_chr(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];	/* (buf,num) */
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	int  ret,val[2],i;
	char w[2],*p;

	*pAns = NULL;
	ret = 0;
	mcat.mc_ipos = 0;
	for (i=0;i<nparm;i++) {
		if (ret=cl_get_parm_bin(ppParm[i],val,"cl_chr:")) return ret;
		w[0] = val[0];
		akxtmcat(&mcat,w,1);
	}
	if (mcat.mc_ipos > 0) {
		if (p = cl_tmp_const_malloc(mcat.mc_ipos+1)) {
			memzcpy(p,mcat.mc_bufp,mcat.mc_ipos);
			*pAns = p;
		}
		else {
			return -1;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_asc(pWork,mflg,nparm,ppParm)
char *pWork;
int  mflg,nparm;
tdtInfoParm *ppParm[];
{
	int  ret,num,n,nn;
	uchar w1[32],*p1;
	char *p;

	memset(pWork,0,sizeof(int));
	p1 = w1;
	if ((ret = parm_to_char(ppParm[0],&p1,NULL)) > 0) {
		if (mflg) n = akxqkanjilen(p1);
		else n = 1;
		num = 0;
		p = (char *)&num;
		memcpy(p+4-n,p1,n);
		nn = ntohl(num);
		memcpy(pWork,&nn,sizeof(int));
	}
	if (ret > 0) ret = 0;
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _get_line_pat(nparm,ppParm,p1,len,iOpt,pos,pplike,pos_opt)
int nparm,len[],iOpt[],pos[];
tdtInfoParm **ppParm;
char *p1[];
tdtLike **pplike;
int pos_opt;	/* 4:replike, 3:inlike */
{
/* len[6]:pos, len[5]:pos܂ŃXLbvoCg */
/* INLIKE (line,pat,rep,opt,escape)	*/
/* REPLIKE(line,pat,opt,escape)	*/
	static tdtLike *plike=NULL;
	int  iCASE,iG,iTOP,iBTM,iONLY;
	int  i,n,ret,opt,patlen,ll,pos_escape,pos0_opt,pos0_escape,pos0[2],j,shift,nn;
	char *p,*pat,*plen1,*pp,*plen2,c,c1,c2;
	uchar *pesc,escape;
	tdtInfoParm *pInfoParm;

	pos0[1] = -1;
	pInfoParm = ppParm[1];
	if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_BINA) {
#if 1
		if (ret=_get_pos_len(0,pInfoParm,pos0)) return ret;
#else
		pos0[0] = cl_get_data_long(pInfoParm);
#endif
		shift = 1;
		pInfoParm = ppParm[2];
		if (pInfoParm->pi_attr==DEF_ZOK_BINA) {
			if (ret=_get_pos_len(1,pInfoParm,pos0)) return ret;
			shift = 2;
		}
/*
printf("_get_line_pat: attr1=%d pos0=%d shift=%d\n",attr1,pos0,shift);
*/
	}
	else {
		shift = 0;
		pos0[0] = 1;
	}
	len[6] = pos0[0];
	pos_escape = pos_opt + 1;
	pos0_opt = pos_opt - 1;
	pos0_escape = pos_escape - 1;
	iONLY = iCASE = iG = iTOP = iBTM = 0;

	n = X_MIN(nparm,pos_opt);
	for (i=1;i<n;i++) {
		p1[i] = p1[i-1] + 32;
	}
	nn = X_MIN(nparm,pos_opt+shift);
	for (i=0,j=0;i<nn;i++) {
		if ((i==1 && shift) || (i==2 && shift==2)) ;
		else {
			ret = parm_to_char(ppParm[i],&p1[j],NULL);
			if (ret < 0) return ret;
			len[j++] = ret;
		}
	}
	p1[5] = p1[0];
/*
printf("_get_line_pat: p1[0]=%08x [%s]\n",p1[0],p1[0]);
printf("_get_line_pat: p1[5]=%08x [%s]\n",p1[5],p1[5]);
*/
	len[5] = 0;
	if (!len[1]) return 0;
	if (n == pos_opt) {
		if (inistr(p1[pos0_opt],"i")) iCASE = 1;
		if (inistr(p1[pos0_opt],"g")) iG = 1;
		if (inistr(p1[pos0_opt],"o")) iONLY = 1;
		if (inistr(p1[pos0_opt],"z")) iCASE |= 2;
	}
	if (plike) {
		plike->lk_option = iCASE;
		plike->lk_pos = pos;
	}
	else if (!(plike = akxs_xlike_new(0,iCASE,pos))) {
		return -1;
	}
	*pplike = plike;
	escape = 0xff;
	if (nparm >= pos_escape+shift) {
		if ((ret=parm_to_char_tmp(ppParm[pos0_escape+shift],&pesc,0)) < 0) return ret;
		if (!(escape = *pesc)) escape = 0xff;
		plike->lk_escape = escape;
	}
	else escape = akxs_like_escape(0xff);
	if (shift) {
		len[5] = len[0];
		if (ret=_get_str_pos(pos0,p1,&len[0],NULL)) return ret;
		len[5] -= len[0];
/*
printf("_get_line_pat: len[0]=%d len[5]=%d len[6]=%d\n",len[0],len[5],len[6]);
printf("_get_line_pat: p1[0]=%08x [%s]\n",p1[0],p1[0]);
printf("_get_line_pat: p1[5]=%08x [%s]\n",p1[5],p1[5]);
*/
	}
	if (ret = akxs_xlike_set_line(plike,p1[0],len[0])) return ret;
	p = p1[1];
	patlen = len[1];
	plen1 = p + patlen - 1;
	if (pat = cl_tmp_const_malloc(patlen+3)) {
		memzcpy(pat+1,p,patlen);
	}
	else return -1;

	if (patlen==1 && *p==escape) {
		*pat = '%';
		*(pat+2) = escape;
		*(pat+3) = '%';
		patlen = 4;
	}
	else {
		if (patlen >= 2) plen2 = plen1 - 1;
		else plen2 = plen1 + 1;
		if ((c=*p) == '^') {
			iTOP = 1;
			iG = 0;
			pat += 2;
			patlen--;
		}
		else if (c == '%') {
			pat++;
		}
		else if (c == '$') pat++;
		else {
			*pat = '%';
			patlen++;
		}
		if ((c2=*plen2) != escape) {
			if ((c1=*plen1) == '$') {
				iBTM = 1;
				iG = 0;
				patlen--;
			}
			else if (c1 == '%') ;
			else if (c1 != '^') {
				*(pat+patlen) = '%';
				patlen++;
			}
		}
		else {
			*(pat+patlen) = '%';
			patlen++;
		}
	}
	*(pat+patlen) = '\0';
/*
printf("_get_line_pat: iG=%d iCASE=%d la=%d iTOP=%d iBTM=%d patlen=%d pat=[%s]\n",
iG,iCASE,plike->lk_la,iTOP,iBTM,patlen,pat);
*/
	p1[4] = pat;
	len[4] = patlen;
	iOpt[0] = iCASE;
	iOpt[1] = iG;
	iOpt[2] = iTOP;
	iOpt[3] = iBTM;
	iOpt[4] = iONLY;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_rep_like(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm **ppParm;
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	tdtLike *plike;
	int  iCASE,iG,iTOP,iBTM,pos[4],sp,iONLY,iOpt[5];
	int  i,n,ret,opt,len[7],is,patlen,ll;
	char w1[128],*p1[7],*p,*pat,*plen1,*pp,*plen2,c,c1,c2;
	uchar *pesc,escape;

	*pAns = NULL;
	p1[0] = w1;
	if (ret=_get_line_pat(nparm,ppParm,p1,len,iOpt,pos,&plike,4)) return ret;
	if (!len[1]) {
		ll = len[0];
		pp = p1[0];
		goto end;
	}
	pat = p1[4];
	patlen = len[4];
	iG    = iOpt[1];
	iTOP  = iOpt[2];
	iBTM  = iOpt[3];
	iONLY = iOpt[4];
	memset(pos,0,sizeof(pos));
	is = sp = 0;
	mcat.mc_ipos = 0;
	if (!(pGlobTable->options[17] & 0x04) && !iONLY && len[5]>0) {
/*
printf("cl_rep_like: len[5]=%d p1[5]=[%s]\n",len[5],p1[5]);
*/
		if ((ret=akxtmcat(&mcat,p1[5],len[5]))<0) goto err;
	}
	if (patlen == 0) {
		if (iTOP) {
			if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
		}
		if ((ret=akxtmcat(&mcat,p1[0],len[0]))<0) goto err;
		if (iBTM) {
			if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
		}
	}
	else {
		while (sp < plike->lk_la) {
			ret = akxs_pxlike(plike,pat,patlen);
			if (!ret) {
/*
printf("cl_rep_like: is=%d pos=%d %d %d %d\n",is,pos[0],pos[1],pos[2],pos[3]);
*/
				if (iONLY) {
					if ((ret=akxtmcat(&mcat,p1[0]+pos[0],pos[1]))<0) goto err;
				}
				else {
					if ((ret=akxtmcat(&mcat,p1[0]+is,pos[0]-is))<0) goto err;
					if ((ret=akxtmcat(&mcat,p1[2],len[2]))<0) goto err;
				}
				is = pos[0] + pos[1];
				if (iG) sp = pos[2] + pos[3];
				else break;
			}
			else {
				if (ret < 0) goto err;
				break;
			}
		}
		if (!iONLY) {
			if ((ret=akxtmcat(&mcat,p1[0]+is,len[0]-is))<0) goto err;
		}
	}
	ret = 0;
	ll = mcat.mc_ipos;
	pp = mcat.mc_bufp;
 end:
	if (ll > 0) {
		if (p = cl_tmp_const_malloc(ll+1)) {
			memzcpy(p,pp,ll);
			*pAns = p;
		}
		else ret = -1;
	}
 err:
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_sbs(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];
{
	int  ret,len;

	if ((ret = parm_to_char_tmp(ppParm[0],&pAns,0)) < 0) return ret;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_in_like(pWork,mflg,nparm,ppParm)
char *pWork;
int  mflg;
int  nparm;
tdtInfoParm **ppParm;
{
/* INLIKE(pos,npos,line,pat,opt,escape)	*/
	tdtInfoParm *pInfoParm,rInfoParm;
	tdtInfoParm ***pTBL;
	tdtArrayIndex tIndex;
	int  *index;
	tdtLike *plike;
	int  iCASE,iG,iTOP,iBTM,iONLY,iOpt[5];
	int  iRc,i,len[7],is,sp,patlen,pos[4],ix,maxargs;
	char w1[128],*p1[7],*pat;

	iRc = 0;
	pInfoParm = ppParm[1];
	if ((i=pInfoParm->pi_dlen)>0) {
		if (iRc = cl_get_parm_bin(pInfoParm,&maxargs,"IsLike.maxargs:")) return iRc;
		if (maxargs < 0) {
			/* max_pos(%d)słB */
			ERROROUT1(FORMAT(289),maxargs);
			return -1;
		}
	}
	else maxargs = 1;
/*
printf("cl_in_like: maxargs=%d\n",maxargs);
*/
	if (maxargs) {
		index = tIndex.index;
#if 1
		if (iRc=cl_get_ITBL_maxargs(1,ppParm,&tIndex,&pTBL,0,0,0,0)) return iRc;
#else
		pInfoParm = ppParm[0];
		if (iRc=cl_check_use_mapped_array(pInfoParm)) return iRc;
		if (iRc=cl_get_array_index_tbl(pInfoParm,&tIndex,&pTBL,"getargs.index:")) return iRc;
		if (iRc=cl_check_use_hash_array(pInfoParm,&tIndex)) return iRc;
#endif
#if 1	/* 2017.7.23 koba */
		ix = index[3];
		if (i > 0) {
			if (maxargs > index[4]/2) {
				/* max_pos(%d)ž/2(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(290),maxargs,index[4]/2);
				maxargs = index[4]/2;
			}
		}
		else maxargs = index[4]/2;
#else
		ix = index[0];
		if (i > 0) {
			if (maxargs > index[1]/2) {
				/* max_pos(%d)ž/2(%d)𒴂Ă܂B܂B */
				ERROROUT2(FORMAT(290),maxargs,index[1]/2);
				maxargs = index[1]/2;
			}
		}
		else maxargs = index[1]/2;
#endif
	}
	p1[0] = w1;
	if (iRc=_get_line_pat(nparm-2,&ppParm[2],p1,len,iOpt,pos,&plike,3)) return iRc;
	patlen = len[4];
	pat = p1[4];
	iG = iOpt[1];
	memset(pos,0,sizeof(pos));
	if (patlen == 0) {
		pos[0] = 0;
		pos[1] = len[0];
		iG = 0;
	}
	is = sp = 0;
	while (sp < plike->lk_la) {
		if (patlen > 0) {
			if (iRc=akxs_pxlike(plike,pat,patlen)) {
				if (iRc < 0) return iRc;
				else break;
			}
/*
printf("cl_in_like: is=%d pos=%d %d %d %d\n",is,pos[0],pos[1],pos[2],pos[3]);
*/
		}
		if (is++ < maxargs) {
			if (mflg) {
				len[0] = pos[2] + 1;
				len[1] = pos[3];
			}
			else {
				len[0] = pos[0] + 1;
				len[1] = pos[1];
			}
			if (!(pGlobTable->options[17] & 0x02) && len[6]>1) len[0] += len[6] - 1;
			for (i=0;i<2;i++,ix++) {
				pInfoParm = cl_get_array_and_var_ent(&tIndex,pTBL,ix);
				if (pInfoParm) {
DEBUGOUT_InfoParm(194,"cl_in_like: i=%d ix=%d",pInfoParm,i,ix);
					cl_set_parm_bin(&rInfoParm,len[i]);
					if (iRc=cl_gx_rep_info_set(pInfoParm,&rInfoParm,1)) return iRc;
				}
				else return -1;
			}
		}
	/*	if (iG) sp = pos[2] + pos[3];	*/
		if (iG) sp = pos[0] + pos[1];
		else break;
	}
	memcpy(pWork,&is,sizeof(int));
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_rlpad(pAns,mflg,nparm,ppParm,ope,pOperator)
char **pAns;
int  mflg,nparm;
tdtInfoParm **ppParm;	/* (buf,num) */
int  ope;
char *pOperator;
{
	static char *Pad=" ";
	tdtInfoParm rParm[3],*pParm[2];
	int ret,len,str_len,pad_len,add_len,str_lenm,pad_lenm,add_lenm,i;
	char *pWork,*p1,*p2;
	char w1[32],*str,*pad;

	*pAns = "";
	str = w1;
	if ((str_len=parm_to_char(ppParm[0],&str,NULL)) < 0) return str_len;
	if (mflg) str_lenm = akxqmlen(str,str_len);
	else str_lenm = str_len;
	if (ret=cl_get_parm_bin(ppParm[1],&len,"cl_rlpad:len:")) return ret;
	ret = 0;
	if (len > str_len) {
		if (nparm >= 3) {
			pad = w1;
			if ((ret=parm_to_char(ppParm[2],&pad,NULL)) < 0) return ret;
			if (!*pad) pad = Pad;
		}
		else pad = Pad;
		pad_len = strlen(pad);
		cl_set_parm_char(&rParm[0],pad,pad_len);
		if (mflg) pad_lenm = akxqmlen(pad,pad_len);
		else pad_lenm = pad_len;
		add_lenm = len-str_lenm;
		if (pad_lenm > 1) add_lenm = (add_lenm+pad_lenm-1)/pad_lenm;
#if 1
		add_len = add_lenm*pad_len;
		pWork = cl_tmp_const_malloc(str_len+add_len+1);
		if (ope==D_FUC_LPAD || ope==D_FUC_LPADB) {
			p2 = pWork;
			p1 = pWork + add_len;
		}
		else {
			p1 = pWork;
			p2 = pWork + str_len;
		}
		memcpy(p1,str,str_len);
		for (i=0;i<add_lenm;i++) {
			memcpy(p2,pad,pad_len);
			p2 += pad_len;
		}
		str_len += add_len;
		pWork[str_len] = '\0';
#else
		cl_set_parm_bin(&rParm[1],add_lenm);
		if ((ret=cl_strings(&pWork,2,rParm)) < 0) return ret;
		cl_set_parm_char(&rParm[0],pWork,strlen(pWork));
		cl_set_parm_char(&rParm[1],str,strlen(str));
		if (ope==D_FUC_LPAD || ope==D_FUC_LPADB) {
			pParm[0] = &rParm[0];
			pParm[1] = &rParm[1];
		}
		else {
			pParm[0] = &rParm[1];
			pParm[1] = &rParm[0];
		}
		if ((ret=concat(&pWork,pParm[0],pParm[1],0,NULL,NULL)) < 0) return ret;
		str_len = strlen(pWork);
#endif
		cl_set_parm_char(&rParm[0],pWork,str_len);
	}
	else cl_set_parm_char(&rParm[0],str,str_len);

	cl_set_parm_bin(&rParm[1],len);
	pParm[0] = &rParm[0];
	pParm[1] = &rParm[1];
	if (ope==D_FUC_LPAD || ope==D_FUC_LPADB)
		ret = cl_rightm(pAns,mflg,2,pParm);
	else
		ret = cl_leftm(pAns,mflg,2,pParm);
	return ret;
}

#include <iconv.h>
static char *code_str[]={"","EUC","SJIS","ISO-2022-JP-3","","UTF-8","UCS-4-INTERNAL"};
/****************************************/
/*										*/
/****************************************/
char *_get_iconv_code(data_type)
int data_type;
{
	char *code;
	if (data_type<1 || data_type>6) code = NULL;
	else code = code_str[data_type];
	return code;
}

/****************************************/
/*	rstr=str_conv(str, to [,from])		*/
/****************************************/
int cl_func_str_conv(pAns,nparm,ppParm)
char **pAns;
int  nparm;
tdtInfoParm *ppParm[];
{
	char *inptr; 		/* Pointer used for input buffer  */
	char *outptr;		/* Pointer used for output buffer */
	char *inbuf;		/* input buffer */
	char *outbuf;		/* output buffer  */
	iconv_t cd;			/* conversion descriptor		  */
	size_t inleft;		/* number of bytes left in inbuf  */
	size_t outleft;		/* number of bytes left in outbuf */
	int rc;				/* return code of iconv()		 */
	int  ret,len,outlen,i,i1,tr_dtype,atr,err_cnt,wrn_cnt;
	char ww[16],*p1,*tr_code[2];
	tdtInfoParm *pInfoParm;

	p1 = ww;
	if ((ret = parm_to_char(ppParm[0],&p1,0)) < 0) return ret;
	len = ret;
	i1 = 1;
	for (i=0;i<2;i++) {
		tr_dtype = 0;
		if (nparm > i1) {
			pInfoParm = ppParm[i1];
			atr = pInfoParm->pi_attr;
			if (atr == DEF_ZOK_BINA)
				tr_dtype = cl_get_data_int(pInfoParm);
			else {
				tr_code[i] = ww;
				if ((ret = parm_to_char(ppParm[i1],&tr_code[i],0)) < 0) return ret;
				else if (!ret) atr = DEF_ZOK_BINA;
			}
		}
		else atr = DEF_ZOK_BINA;
		if (atr == DEF_ZOK_BINA){
			if (!tr_dtype) tr_dtype = akxt_get_code_type();
			if (!(tr_code[i]=_get_iconv_code(tr_dtype))) {
				ERROROUT1("ϊf[^^Cv(%d)Ă܂B",tr_dtype);
				return ECL_SCRIPT_ERROR;
			}
		}
		i1++;
	}
#ifdef USE_ICONV
	if ((cd = iconv_open(tr_code[0],tr_code[1])) == (iconv_t)(-1)) {
		ERROROUT2("Cannot open converter from %s to %s",tr_code[1],tr_code[0]);
		return ECL_SCRIPT_ERROR;
	}

	outlen = len*4;
	outbuf = cl_tmp_const_malloc(outlen);
	inleft = len;
	outleft = outlen;
	inptr = p1;
	outptr = outbuf;
	err_cnt = wrn_cnt = 0;
	for (i=0;i<len;i++) {
		rc = iconv(cd, &inptr, &inleft, &outptr, &outleft);
		if (rc == -1) {
			if (errno==EILSEQ || errno==EINVAL) {
				err_cnt++;
				inptr++;
				*outptr++ = '?';
				inleft--;
				outleft--;

printf("rc=%d inleft=%d outleft=%d\n",rc,inleft,outleft);

				if (inleft <= 0) break;
			}
			else {
				ERROROUT1("Error in converting characters. errno=%d",errno);
				ret = ECL_SCRIPT_ERROR;
				break;
			}
		}
		else {
			wrn_cnt = rc;
			ret = 0;
			break;
		}
	}
	iconv_close(cd);
#endif
	if (err_cnt > 0) ERROROUT1("ϊG[ %d܂B",err_cnt);
	if (wrn_cnt > 0) ERROROUT1("stϊ %d܂B",wrn_cnt);
	len = outlen - outleft;
	outbuf[len]='\0';

printf("rc=%d inleft=%d outleft=%d len=%d [%s]\n",rc,inleft,outleft,len,outbuf);

	if (pAns) *pAns = outbuf;
	return ret;
}
