static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F                                                     *
*                                                                             *
*      ֐@@@F@int cl_user_func( pLeaf, name )                        *
*                      (I)Leaf     *pLeaf                                     *
*                      (2)char     *name                                      *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>

#define DEBUGP(x)
extern CLPRTBL *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

static int _print_info();
static int _print_info_data();
static void _print_list();

static int q_flg=1;	/* "string" */
static int c_flg=1;	/* output ',' */
static int t_flg=0;	/* unused */
static int n_flg;	/* output 'name=' */
static int x_flg=0;	/* %08x for int val */
static int e_flg=0;	/* output ERROROUT() */
static int d_flg=0;	/* dump mode */
static int m_flg=0;	/* output money ',' */
static int i_flg=0;	/* output info */

/********************************************/
/*											*/
/********************************************/
int cl_user_func(pLeaf, proc, name )
Leaf *pLeaf;
ProcCT  *proc;
char *name;
{
	int rc;
	parmList  *pparmList;
	tdtInfoParm InfoParm;
	char dummy[256];
	ProcCT  *procct;

DEBUGOUTL1(190,"cl_user_func:start.[%s]",name);
	if (!stricmp(name,"UserFunc")) {
		if (pLeaf->cmd.prmnum > 3) {
			pparmList = pLeaf->cmd.prmp[2];
			if (rc=cl_arg_to_char(pparmList,proc->Obj,&InfoParm,"UserFunc proc")) return rc;
			strnzcpy(dummy,InfoParm.pi_data,sizeof(dummy)-1);
		}
		else {
			ERROROUT("cl_user_func:no proc name");
			return (ECL_EX_EXEC);
		}
	}
	else strnzcpy(dummy,name,sizeof(dummy)-1);

DEBUGOUTL1(190,"cl_user_func:dummy=[%s]",dummy);
	if (!stricmp(dummy,"print") || !stricmp(dummy,"DT")) {
		cl_print_text(&pLeaf->cmd.prmp[3],proc->Obj,
		              pLeaf->cmd.prmnum-3,"Print: ");
	}
	else {
		ERROROUT("cl_user_func:undeifinition proc.");
		return (ECL_EX_EXEC);
	}
	if (!strcmp(name,"UserFunc")) {
		if (!(procct = cl_search_proc_ct())) return (ECL_SYSTEM_ERROR);
		cmn_set_stat(RET_PR,&procct->ptype,L_ON);
	}
	return NORMAL;
}

/********************************************/
/*											*/
/********************************************/
static void _set_flag_sub(p)
char *p;
{
	char c,c1;
/*
printf("\n_set_flag: *p=[%s]\n",p);
*/
	p++;
	c = *p++;
	c1 = *p;
	if (c == 'c') {
		if (c1 == '-') c_flg = 0;
		else c_flg = 1;
	}
	else if (c == 'q') {
		if (c1 == '-') q_flg = 0;
		else q_flg = 1;
	}
	else if (c == 'd') {
		if (c1 == '-') d_flg = 0;
		else d_flg = 1;
	}
	else if (c == 'x') {
		if (c1 == '-') x_flg = 0;
		else x_flg = 1;
	}
	else if (c == 'e') {
		if (c1 == '-') e_flg = 0;
		else e_flg = 1;
	}
	else if (c == 'm') {
		if (c1 == '-') m_flg = -1;
		else if (c1 == '+') m_flg = 1;
		else m_flg = 0;
	}
	else if (c == 'i') {
		if (c1 == '-') i_flg = 0;
		else i_flg = 1;
	}
/*
printf("_set_flag: c_flg=%d\n",c_flg);
*/
}

/********************************************/
/*											*/
/********************************************/
static void _set_flag(p)
char *p;
{
	char c,c1,*pp,w[4];
	int i,is,ie,n;

	w[0] = '/';
	w[3] = '\0';
	p++;
	n = 0;
	pp = p;
	for (;;) {
		c = *p++;
		if (c=='+' || c=='-' || !c) {
			w[2] = c;
			while (n-- > 0) {
				w[1] = *pp++;
				_set_flag_sub(w);
			}
			if (!c) break;
			n = 0;
			pp = p;
		}
		else n++;
	}
}

/********************************************/
/*											*/
/********************************************/
char *cl_get_attr_name(iParm)
int  iParm[];
{
	static char *name[]={"variant","char","int","double","dec","bulk","date","variant",""};
	static char dummy[30];
	int attr,size,pre,sca;
	char *p;

	attr = iParm[0];
	size = iParm[1];
	pre  = iParm[2];
	sca  = iParm[3];
	if (attr>=0 && attr<=7) p = name[attr];
	else p = "other";
	switch (attr) {
	case DEF_ZOK_CHAR:
	case DEF_ZOK_BULK:
		if (size > 0) {
			sprintf(dummy,"%s(%d)",p,size);
			p = dummy;
		}
		break;
	case DEF_ZOK_DECI:
		if (pre > 0) {
			sprintf(dummy,"dec(%d,%d)",pre,sca);
			p = dummy;
		}
		break;
	}
	return p;
}

/********************************************/
/*											*/
/********************************************/
static int _print_attr(mcat,pInfoParm,iParm)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int  iParm[];
{
	int attr,size,pre,sca,iPm[4],*ipParm;

	if (pInfoParm) {
		iPm[0] = pInfoParm->pi_attr;
		if (pInfoParm->pi_aux[0])
			size = pInfoParm->pi_len;
		else size = pInfoParm->pi_dlen;
		iPm[1] = size;
		iPm[2] = pInfoParm->pi_hlen;
		iPm[3] = pInfoParm->pi_pos;
		ipParm = iPm;
	}
	else if (iParm) ipParm = iParm;
	akxtmcats(mcat,cl_get_attr_name(ipParm));
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_data(mcat,pInfoParm)
MCAT *mcat;
tdtInfoParm *pInfoParm;
{
	int rc,i,Value,len,opt,pre;
	double dValue,dw;
	char dummy[512],*p,id,*fmt,wrk[10];
	MPA *mpa;
	tdtInfoParm tInfoParm;
/*
DEBUGOUT_InfoParm(0,"_print_data:",pInfoParm,0,0);
*/
	if (cl_is_null_parm(pInfoParm)) return 0;

	len = pInfoParm->pi_dlen;
	p = pInfoParm->pi_data;
	switch (pInfoParm->pi_attr) {
	case DEF_ZOK_CHAR:
		if (x_flg && pInfoParm->pi_id==' ') {
			len = X_MIN((sizeof(dummy)-1)/2,len);
			akxcxtoc(p,len,dummy);
			akxtmcatz(mcat,dummy,len*2);
		}
		else {
			if (q_flg) akxtmcats(mcat,"\"");
			if (p) {
				len = akxstrnlen(p,len);
				akxtmcatz(mcat,p,len);
				if ((id=pInfoParm->pi_id)==D_DATA_ID_FUNCTION || id==D_DATA_ID_CLMETHOD
				 || id==D_DATA_ID_PROC)
					akxtmcats(mcat,"()");
			}
			if (q_flg) akxtmcats(mcat,"\"");
		}
		break;
	case DEF_ZOK_BINA:
		if (len) {
			Value = cl_get_data_long(pInfoParm);
			if (x_flg) fmt = "0x%08x";
			else fmt = "%d";
			sprintf(dummy,fmt,Value);
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_FLOA:
		if (len) {
			memcpy((char *)&dValue,p,sizeof(double));
			if (x_flg) {
				akxcxtoc(&dValue,sizeof(double),dummy);
				dummy[len*2] = '\0';
			}
			else {
#if 1	/* 2018.7.23 */
				cl_double_to_str(dummy,sizeof(dummy),dValue);
#else
				pre = pGlobTable->options[19] & 0xff;
				if (pre > 0) {
					if (pre > 17) pre = 17;
					sprintf(wrk,"%%.%dg",pre);
					sprintf(dummy,wrk,dValue);
				}
				else {
					dw = X_ABS(dValue);
					if (dw && (dw>999999.999999 || dw<0.001))
						sprintf(dummy,"%e",dValue);
					else {
						sprintf(dummy,"%f",dValue);
						len = strlen(dummy);
						len = akxnrskipin(dummy,len,"0");
						if (len>0 && *(dummy+len-1)=='.') len++;
						*(dummy+len) = '\0';
					}
				}
#endif
			}
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_DECI:
		if (len > 0) {
			mpa = (MPA *)p;
			if (x_flg) {
				akxcxtoc(mpa,len,dummy);
				dummy[len*2] = '\0';
			}
			else {
#if 1
				cl_mpa2an(mpa,dummy,sizeof(dummy),m_flg,pInfoParm->pi_hlen,pInfoParm->pi_pos);
#else
				opt = pGlobTable->options[10];
				if (opt & 0x40) {
					opt = (opt & 0x0f) | ((pGlobTable->options[11]<<4) & 0xf0);
					m_mpa2an_exp(mpa,dummy,sizeof(dummy),0,0,opt);
				}
				else {
					if (m_flg > 0) opt |= 0x20;
					else if (m_flg < 0) opt &= ~0x20;
					m_mpa2an(mpa,dummy,sizeof(dummy),opt);
				}
#endif
			}
			akxtmcats(mcat,dummy);
		}
		else akxtmcats(mcat,"null");
		break;
	case DEF_ZOK_DATE:
		if (len > 0) {
			mpa = (MPA *)p;
			if (x_flg) {
				akxcxtoc(mpa,len,dummy);
				dummy[len*2] = '\0';
				p = dummy;
			}
			else {
				m_mpa2an(mpa,dummy,sizeof(dummy),0);
				p = dummy + strlen(dummy) + 1;
				strcpy(p,"YYYY/MM/DD HH:MM:SS");
				memcpy(p,dummy,4);
				memcpy(p+5,dummy+4,2);
				memcpy(p+8,dummy+6,2);
				memcpy(p+11,dummy+8,2);
				memcpy(p+14,dummy+10,2);
				memcpy(p+17,dummy+12,2);
			}
		}
		else p = "null";
		akxtmcats(mcat,p);
		break;
	case DEF_ZOK_VARI:
		akxtmcats(mcat,"**VARI**");
		break;
	case 0:
		akxtmcats(mcat,"**undef**");
		break;
	case DEF_ZOK_BULK:
		akxtmcats(mcat,"**BULK**");
		if (len > 0) {
			if (len > 512) {
				len = 512;
				PRINTOUTL1(0,"BULK data too long len=%d",pInfoParm->pi_dlen);
			}
			akxaxdump("BULK",p,len);
			printf("\n");
		}
		break;
	default:
		akxtmcats(mcat,"**INVALID**");
		if (len > 0) {
			if (len > 512) {
				len = 512;
			}
			akxaxdump("INVALID",p,len);
			printf("\n");
		}
	}
	if (pInfoParm->pi_alen & D_AULN_RANGE_DATA) {
		akxtmcats(mcat,"..");
		cl_gx_copy_info(&tInfoParm,pInfoParm);
		tInfoParm.pi_aux[0] = tInfoParm.pi_alen = 0;
		if (tInfoParm.pi_attr == DEF_ZOK_BINA) tInfoParm.pi_pos = tInfoParm.pi_hlen;
		else tInfoParm.pi_data += tInfoParm.pi_dlen;
		_print_data(mcat,&tInfoParm);
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_array(mcat,pInfoParm)
MCAT *mcat;
tdtInfoParm *pInfoParm;
{
	int i,*index,f,k1,k2,iParm[4],ndim;
	char dummy[256],wrk[128],id,*varnam;
	tdtArrayIndex *pIndex;
	XHASHB *xhp;
	tdtInfoParm *pInfo;

	id = pInfoParm->pi_id;
	/* ` */
	if (!(varnam=(char *)pInfoParm->pi_pos)) varnam=AKX_NULL_PRINT;
	if (id=='R' && (pInfo=(tdtInfoParm *)pInfoParm->pi_paux) && pInfo->pi_id!='R') {
		ERROROUT1(FORMAT(388),varnam);		/* z[%s]łB */
		akxtmcats(mcat,"##ERROR##,");
	}
	else {
		if (pGlobTable->options[12]) {
			/* ` */
			akxtmcats(mcat,varnam);
			akxtmcats(mcat,"[]");
			cl_debug_array_info(dummy,0,pInfoParm);
		}
		else {
			pIndex = (tdtArrayIndex *)pInfoParm->pi_data;
			/* f[^^ */
			if (id=='A' || id=='R') {
				iParm[0] = pIndex->uAttr[0];
				iParm[2] = pIndex->uAttr[2];
				iParm[3] = pIndex->uAttr[3];
				iParm[1] = pIndex->size;
				_print_attr(mcat,NULL,iParm);
			}
			else
				_print_attr(mcat,pInfoParm,NULL);
			akxtmcats(mcat," ");

			/* ` */
			akxtmcats(mcat,varnam);

			/* z` */
			index = pIndex->index;
#if 1	/* 2017.7.23 koba */
			if ((xhp=pIndex->xhp) || (id=='R' && (index[2] & 0x80))) {
				sprintf(dummy," Hash(%d)",index[4]);
			}
			else {
				if (id=='A') sprintf(dummy,"[(%d),",index[3]);
				else strcpy(dummy,"[");
				ndim = index[0];
				f = index[2];
				for (i=0;i<ndim;i++) {
					if (i > 0) strcat(dummy,",");
					k1 = index[i+4];
				/*	if (f & 0x01) {	*/
						k2 = index[i+ndim+4];
					if (k2) {
#else
			if ((xhp=pIndex->xhp) || (id=='R' && (index[MAX_ARRAY_DIM+1] & 0x80))) {
				sprintf(dummy," Hash(%d)",index[1]);
			}
			else {
				if (id=='A') sprintf(dummy,"[(%d),",index[0]);
				else strcpy(dummy,"[");
				f = index[MAX_ARRAY_DIM+1];
				for (i=0;i<MAX_ARRAY_DIM;i++) {
					if (i > 0) strcat(dummy,",");
					k1 = index[i+1];
					if (f & 0x01) {
						k2 = index[i+MAX_ARRAY_DIM+2];
#endif
						sprintf(wrk,"%d..%d",k2,k2+k1-1);
					}
					else sprintf(wrk,"%d",k1);
					strcat(dummy,wrk);
					f >>= 1;
				}
				strcat(dummy,"]");
			}
		}
		akxtmcats(mcat,dummy);
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static void _print_list(mcat,pInfoParm,_print_info)
MCAT *mcat;
tdtInfoParm *pInfoParm;
int (*_print_info)();
{
	tdtRbCtl *pCt;
	int i;
	char *p1,*p2;

	if (pInfoParm->pi_id == D_DATA_ID_LIST) {
		p1 = "{";
		p2 = "}";
	}
	else {	/* id====D_DATA_ID_NARABI */
		p1 = "[";
		p2 = "]";
	}
	akxtmcats(mcat,p1);
	pCt = (tdtRbCtl *)pInfoParm->pi_data;
	if (akxs_rb_used(pCt)) {
		akxs_rb_read(pCt,0);
		i = 0;
		while (pInfoParm=(tdtInfoParm *)akxs_rb_read(pCt,1)) {
			if (i > 0) {
				if (c_flg) akxtmcats(mcat,",");
				else akxtmcats(mcat," ");
			}
			_print_info(mcat,pInfoParm,NULL);
			i++;
		}
	}
	else akxtmcats(mcat,"**NIL**");
	akxtmcats(mcat,p2);
}

/********************************************/
/*											*/
/********************************************/
static int _print_info_data(mcat,pInfoParm,varnam0)
MCAT *mcat;
tdtInfoParm *pInfoParm;
char *varnam0;
{
/*	tdtRbCtl *pCt;	*/
	int i,j,iParm[4],ix1,nm1,iRc,iAux1,*index,f,k1,k2,type;
	char dummy[256],wrk[128],id,*varnam,*scope;
	tdtArrayIndex *pIndex,tIndex1;
	XHASHB *xhp;
	parmList  **parmName;
	tdtDefType *pDeftype;
	tdtInfoParm *pParmI,***pTBL1,*pInfo,tInfoParm;
#if 0
	if (!(pInfoParm->pi_aux[0] & DEF_ZOK_DATA)) return _print_info(mcat,pInfoParm,varnam0);
#endif
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_print_info_data: varnam0=[%s]",pInfoParm,varnam0,0);
*/
	if ((id=pInfoParm->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI) {
		_print_list(mcat,pInfoParm,_print_info_data);
	}
	else if (id=='P' || id=='T') {
	/*	c_flg = 1;	*/
		if (id == 'P') type = pInfoParm->pi_aux[0];
		else type = D_AUX0_TYPE_STRUCT;
		if (type == D_AUX0_TYPE_STRUCT) {
			akxtmcats(mcat,"{");
			pDeftype = (tdtDefType *)pInfoParm->pi_data;
			parmName = pDeftype->vname;
			for (j=0;j<pDeftype->ntype;j++) {
				if (j > 0) {
					if (c_flg) akxtmcats(mcat,",");
					else akxtmcats(mcat," ");
				}
			/*	varnam = strtemp(parmName[j]->prp,parmName[j]->prmlen);	*/
				akxtmcat(mcat,parmName[j]->prp,parmName[j]->prmlen);
				akxtmcats(mcat,"=");
				_print_info_data(mcat,pDeftype->pType[j],NULL);
			}
			akxtmcats(mcat,"}");
		}
		else {
			if (type == D_AUX0_TYPE_ARRAY) id = 'R';
			else id = 'A';
			pInfoParm->pi_id = id;
			_print_info_data(mcat,pInfoParm,NULL);
		}
	/*	c_flg = q_flg;	*/
	}
	else if (id=='A' || id=='R') {
		if (iRc=cl_get_array_info(pInfoParm,&tIndex1,&pTBL1,iParm)) return iRc;
		nm1  = iParm[1];
		ix1  = iParm[2];
		for (i=0;i<nm1;i++,ix1++) {
			if ((iRc=cl_array_get_info_parm(&pParmI,&tIndex1,pTBL1,ix1,'r')) < 0) return iRc;
			if (i > 0) {
				if (c_flg) akxtmcats(mcat,",");
				else akxtmcats(mcat," ");
			}
			if (pParmI && !cl_is_undef_parm(pParmI) && !cl_is_null_parm(pParmI)) {
				if (xhp=tIndex1.xhp) {
					*dummy = '[';
					strnzcpy(dummy+1,xhp->xha_hashb->ha_key,sizeof(dummy)-4);
					strcat(dummy,"]=");
					akxtmcats(mcat,dummy);
				}
				 _print_info_data(mcat,pParmI,NULL);
			}
		}
	}
	else if (id==' ' && (pInfoParm->pi_alen & D_AULN_RANGE_DATA) &&
	                    (pInfoParm->pi_aux[0] & DEF_ZOK_DATA)) {
		if (iRc = cl_func_count(&nm1,1,&pInfoParm,1)) return iRc;
		cl_gx_copy_info(&tInfoParm,pInfoParm);
		if (tInfoParm.pi_attr != DEF_ZOK_BINA) {
			if (!(tInfoParm.pi_data=cl_tmp_const_malloc(tInfoParm.pi_dlen))) return -1;
			memcpy(tInfoParm.pi_data,pInfoParm->pi_data,pInfoParm->pi_dlen);
			if (tInfoParm.pi_attr==DEF_ZOK_CHAR) *(tInfoParm.pi_data+1) = '\0';
		}
		tInfoParm.pi_aux[0] = tInfoParm.pi_alen = 0;
		for (i=0;i<nm1;i++) {
			if (i > 0) {
				if (c_flg) akxtmcats(mcat,",");
				else akxtmcats(mcat," ");
				if (tInfoParm.pi_attr == DEF_ZOK_CHAR) {
					*(uchar *)(tInfoParm.pi_data) = *(uchar *)(tInfoParm.pi_data) + 1;
				}
				else if ((iRc=_gx_ppmm(14,&tInfoParm)) < 0) return iRc;
			}
			_print_data(mcat,&tInfoParm);
		}
	}
	else if (id==D_DATA_ID_PNAME) {
		_print_info(mcat,pInfoParm,varnam0);
	}
	else if (id==D_DATA_ID_UNDEFVAR) akxtmcats(mcat,"**undef**");
	else _print_data(mcat,pInfoParm);

	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _print_info(mcat,pInfoParm,varnam0)
MCAT *mcat;
tdtInfoParm *pInfoParm;
char *varnam0;
{
/*	tdtRbCtl *pCt;	*/
	int i,j,iParm[4],ix1,nm1,iRc,iAux1,*index,f,k1,k2,type,len;
	char dummy[256],wrk[128],id,*varnam,*scope,*p;
	tdtArrayIndex *pIndex,tIndex1;
	XHASHB *xhp;
	ScrPrCT *pScCT;
	parmList  **parmName;
	tdtDefType *pDeftype;
	tdtInfoParm *pParmI,***pTBL1,*pInfo;
	Leaf *wkleaf;

	if ((id=pInfoParm->pi_id)==D_DATA_ID_LIST || id==D_DATA_ID_NARABI) {
		_print_list(mcat,pInfoParm,_print_info);
	}
	else if (id=='P' || id=='T' || id=='A' || id=='R' || varnam0 || id==' ') {
		/* XR[v */
		iAux1 = pInfoParm->pi_aux[1];
		scope = "";
		if (iAux1 & D_AUX1_LOCAL_VAR) scope = "local ";
		else if (iAux1 & D_AUX1_PRIVATE_VAR) scope = "private ";
		else if (iAux1 & D_AUX1_PUBLIC_VAR) scope = "public ";
		else if (iAux1 & D_AUX1_GLOBAL_VAR) scope = "global ";
		if (*scope) akxtmcats(mcat,scope);

		/* CONST */
		if (iAux1 & D_AUX1_PROTECTED) akxtmcats(mcat,"const ");

		if (id == 'P') {
			type = pInfoParm->pi_aux[0];
			/* ^` */
			akxtmcats(mcat,"type ");
		}
		else if (id == 'T') type = D_AUX0_TYPE_STRUCT;
		else type = 0;
		if (type == D_AUX0_TYPE_STRUCT) {
					/* \ */
			c_flg = 1;

			/* ^` */
		/*	if (id=='P') akxtmcats(mcat,"type ");	*/

			/* ` */
			if (!(varnam=(char *)pInfoParm->pi_pos)) varnam="NONA";
			akxtmcats(mcat,varnam);
			akxtmcats(mcat,"{");
			pDeftype = (tdtDefType *)pInfoParm->pi_data;
			parmName = pDeftype->vname;
			for (j=0;j<pDeftype->ntype;j++) {
				if (j > 0) akxtmcats(mcat,", ");
				/* o擾 */
				varnam = strtemp(parmName[j]->prp,parmName[j]->prmlen);
/*
printf("_print_info: varnam=[%s]\n",varnam);
*/
				_print_info(mcat,pDeftype->pType[j],varnam);
			}
			akxtmcats(mcat,"}");
			c_flg = q_flg;
		}
		else {
			if (type == D_AUX0_TYPE_ARRAY) id = 'R';
			else if (type == D_AUX0_TYPE_MAPPED) id = 'A';
			pInfoParm->pi_id = id;
			/* z */
			if (id=='A' || id=='R')
				_print_info_array(mcat,pInfoParm);
			else {
				/* f[^^ */
				_print_attr(mcat,pInfoParm,NULL);

				/* ` */
				akxtmcats(mcat," ");
#if 1	/* 2017.4.18 */
				if (varnam0) akxtmcats(mcat,varnam0);
#else
				if (varnam0) varnam = varnam0;
				else varnam = "NONA";
				akxtmcats(mcat,varnam);
#endif
			}
		}
	}
	else if (id==D_DATA_ID_CLASS || id==D_DATA_ID_INSTANCE) {
		*dummy = '\0';
		if (q_flg) strcat(dummy,"\"");
		if (id == D_DATA_ID_CLASS) {
			strcat(dummy,"Class ");
			if (varnam=pInfoParm->pi_data)
				len = akxstrnlen(varnam,pInfoParm->pi_dlen);
		}
		else if (id == D_DATA_ID_INSTANCE) {
			strcat(dummy,"Instance as ");
			if (wkleaf = (Leaf *)pInfoParm->pi_paux) {
				if (varnam=wkleaf->cmd.prmp[0]->prp) len = strlen(varnam);
			}
			else varnam = NULL;
		}
		if (varnam) memcat(dummy,varnam,len);
		else strcat(dummy,AKX_NULL_PRINT);
		if (q_flg) strcat(dummy,"\"");
		akxtmcats(mcat,dummy);
	}
	else if (id==D_DATA_ID_PNAME) {
		if (pInfoParm->pi_attr==2) {
/*
DEBUGOUT_InfoParm(0,"_print_info:",pInfoParm,0,0);
*/
			 akxtmcats(mcat,pInfoParm->pi_paux);
			 akxtmcats(mcat,"==>");
			_print_data(mcat,pInfoParm->pi_pos);
		}
		else {
			_print_data(mcat,pInfoParm->pi_data);
			 akxtmcats(mcat,"==>");
		}
	}
	else if (id==D_DATA_ID_UNDEFVAR) akxtmcats(mcat,"**undef**");
	else _print_data(mcat,pInfoParm);
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _mcat_text_infoparm(mcat,tInfoParm2,k)
MCAT *mcat;
tdtInfoParm tInfoParm2[];
int k;
{
	int j,nparm,iPARMINFO2,opt,len,data_flg;
	tdtInfoParm *pInfoParm,tInfoParm;
	char name[30],name2[30],*p,id;

	if ((tInfoParm2[0].pi_alen & D_AULN_PARMINFO2) &&
	    (nparm=tInfoParm2[1].pi_pos)) {
		pInfoParm = (tdtInfoParm *)tInfoParm2[1].pi_data;
		if (d_flg) {
			sprintf(name,"DUMP%d",k+1);
			cl_dump_info(&tInfoParm2[0],"%s=",name);
			sprintf(name2,"#%s#->",name);
			akxtmcats(mcat,name2);
		}
		iPARMINFO2 = 1;
	}
	else {
		nparm = 1;
		pInfoParm = tInfoParm2;
		iPARMINFO2 = 0;
	}
/*
DEBUGOUTL2(LVL_GXEXOBJ,"_mcat_text_infoparm: nparm=%d,iPARMINFO2=%d",nparm,iPARMINFO2);
*/
	opt = pGlobTable->options[12];
	for (j=0;j<nparm;j++,pInfoParm++) {
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text_infoparm: j=%d",pInfoParm,j,0);
*/
#if 1
/*
printf("\n_mcat_text_infoparm: c_flg=%d\n",c_flg);
*/
		if (opt & 0x02) {
			if (pInfoParm->pi_id==' ' && pInfoParm->pi_attr==DEF_ZOK_CHAR && (len=pInfoParm->pi_dlen)>=2) {
				if (p = pInfoParm->pi_data) {
					if (*p == '/') {
						_set_flag(p);
						continue;
					}
					else if (!memcmp(p,"\\/",2)) {
						cl_set_parm_char(&tInfoParm,p+1,len-1);
						pInfoParm = &tInfoParm;
					}
				}
			}
		}
#endif
		if (j > 0) {
			if (c_flg) akxtmcats(mcat,",");
			else akxtmcats(mcat," ");
		}
		if (d_flg) {
			if (iPARMINFO2) sprintf(name,"DUMP%d-%d",k+1,j+1);
			else sprintf(name,"DUMP%d",k+1);
			cl_dump_info(pInfoParm,"%s=",name);
			sprintf(name2,"#%s#",name);
			akxtmcats(mcat,name2);
		}
		else {
#if 1	/* 2018.7.7 */
			if (i_flg==0 &&
			    ((pInfoParm->pi_aux[0] & DEF_ZOK_DATA) ||
				 (id=pInfoParm->pi_id)==' ' || id==D_DATA_ID_LIST  || id==D_DATA_ID_NARABI))
				_print_info_data(mcat,pInfoParm,NULL);
			else
				_print_info(mcat,pInfoParm,NULL);
#else
			if (pInfoParm->pi_aux[0] & DEF_ZOK_DATA)
				_print_info_data(mcat,pInfoParm,NULL);
#if 1	/* 2017.4.18 */
			else if ((id=pInfoParm->pi_id)==' ' || id==D_DATA_ID_LIST)
				_print_info_data(mcat,pInfoParm,NULL);
#endif
			else
				_print_info(mcat,pInfoParm,NULL);
#endif
		}
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static int _mcat_text(mcat,prmp,Obj,prmnum)
MCAT *mcat;
parmList *prmp[];
int      *Obj;
int      prmnum;
{
	int rc,i,j,nparm,len,k,nn_flg,iPARMINFO2,optW;
	parmList  *pparmList;
	tdtInfoParm tInfoParm2[2],*pInfoParm;
	char *p,c,c1,name[30],name2[30];
	SSPL_S sspl;

	d_flg = 0;
	for (i=0,k=0;i<prmnum;i++) {
		pparmList = prmp[i];
		len = pparmList->prmlen;
		len = akxtsapb(0,p=strtemp(pparmList->prp,len),len);	/* 1-->0 2017.11.03 */
		if (*p == '/') {
			_set_flag(p);
			continue;
		}
		if (k > 0) {
			if (c_flg) akxtmcats(mcat,",");
			akxtmcats(mcat," ");
		}
		nn_flg = n_flg;
		if (nn_flg && !d_flg && !x_flg) {
			if ((c=*p)=='-' || c=='+') {
				if (akxnskipin(p+1,len-1,".0123456789")>=len-1) nn_flg = 0;
			}
			else {
				sspl.sp = 0;
				sspl.wdmax = 0;
				j = akxtgwnsl(p,len,&sspl," \t'+-*/&|=^~!<>[](),;?:{}",0x41);
				if ((j==len && (sspl.attr[0]==5 || sspl.attr[0]==6)) ||
				    akxnskipin(p,len,".0123456789")>=len) nn_flg = 0;
			}
		}
		if (nn_flg) {
			akxtmcat(mcat,p,len);
			akxtmcats(mcat,"=");
		}
		optW = D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE;
		if (i_flg) optW |= D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;
		rc=cl_gx_exp_obj_opt(1,&pparmList,Obj,tInfoParm2,optW);

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_mcat_text: i=%d rc=%d",tInfoParm2,i,rc);

		if (rc!=NORMAL/* || InfoParm.pi_data==NULL*/) {
			if (rc == 100) {
				if (q_flg) akxtmcats(mcat,"\"\"");
			}
			else akxtmcats(mcat,"##ERROR##");
		}
		else {
			_mcat_text_infoparm(mcat,tInfoParm2,k);
		}
		k++;
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
static void _option_to_flag(opt)
int opt;
{
	if (opt & 0x04) c_flg = 1;
	if (opt & 0x08) q_flg = 1;
	if (opt & 0x10) n_flg = 1;
	if (opt & 0x20) m_flg = 1;
}

/********************************************/
/*											*/
/********************************************/
static int _flag_to_option()
{
	int opt;

	opt = 0;
	if (c_flg) opt |= 0x04;
	if (q_flg) opt |= 0x08;
	if (n_flg) opt |= 0x10;
	if (m_flg>0) opt |= 0x20;
	return opt;
}

/********************************************/
/*											*/
/********************************************/
static void cl_print_echo_text_init(mcat,name,opt)
MCAT *mcat;
char *name;
int  opt;
{
	memset(mcat,0,sizeof(MCAT));
	mcat->mc_extlen = 256;
	if (!name) name = "";
	akxtmcats(mcat,name);
	t_flg = x_flg = e_flg = d_flg = m_flg = i_flg = 0;
	q_flg = c_flg = n_flg = opt & 0x01;
	_option_to_flag(pGlobTable->options[12]);
}

/********************************************/
/*											*/
/********************************************/
static void cl_print_echo_text_out(mcat,opt)
MCAT *mcat;
int  opt;
{
	char *p=mcat->mc_bufp;
	FILE *fp;

	if (opt & 0x02) {
		if (e_flg) ERROROUTL(0,p);
		else PRINTOUTL(0,p);
	}
	else {
		if (e_flg) fp = stderr;
		else fp = stdout;
		fprintf(fp,"%s",p);
		akxa_log_new_line(fp,pGlobTable->options[2]);
	}
	if (p) Free(p);
}

/********************************************/
/*											*/
/********************************************/
int cl_print_echo_text(prmp,Obj,prmnum,name,opt)
parmList *prmp[];
int      *Obj;
int      prmnum;
char     *name;
int      opt;
{
	MCAT mcat;
	FILE *fp;

	if (!prmp) return 0;
	cl_print_echo_text_init(&mcat,name,opt);
	_mcat_text(&mcat,prmp,Obj,prmnum);
	cl_print_echo_text_out(&mcat,opt);
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_print_text(prmp,Obj,prmnum,name)
parmList *prmp[];
int      *Obj;
int      prmnum;
char     *name;
{
	return cl_print_echo_text(prmp,Obj,prmnum,name,0x03);
}

/****************************************/
/*										*/
/****************************************/
int cl_echo_text(prmp,Obj,prmnum,opt)
parmList *prmp[];
int      *Obj;
int      prmnum;
int      opt;
{
	return cl_print_echo_text(prmp,Obj,prmnum,NULL,opt & 0x01);
}

/********************************************/
/*											*/
/********************************************/
int cl_dump_info(pInfoParm,fmt,name)
tdtInfoParm *pInfoParm;
char *fmt,*name;
{
	char *p;
	int f;

	if (!fmt) fmt = "";
	if (!name) name = "";
	f = LOGFLG(D_LOG_NO_DEBUG,D_LOG_FLG_CHECK);
	LOGFLG(D_LOG_NO_DEBUG,f | D_LOG_FLG_STDOUT);
	DEBUGOUT_InfoParm(0,fmt,pInfoParm,name,0);
	LOGFLG(D_LOG_NO_DEBUG,f);
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_dump(prmp,prmnum,Obj)
parmList *prmp[];
int      prmnum;
char     *Obj;
{
	int rc,i,len;
	parmList *pparmList;
	tdtInfoParm tInfoParm2[2];
	char *p,c;

	n_flg = 1;
	for (i=0;i<prmnum;i++) {
		pparmList = prmp[i];
		len = pparmList->prmlen;
		len = akxtsapb(0,p=strtemp(pparmList->prp,len),len);	/* 1-->0 2017.11.03 */
		rc = cl_gx_exp_obj_opt(1,&pparmList,Obj,tInfoParm2,D_GX_OPT_PARMINFO2|D_GX_OPT_GET_RANGE);
		if (rc) DEBUGOUT1("%s=##ERROR##",p);
		else cl_dump_info(tInfoParm2,"%s=",p);
	}
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_func_print(pAns,nparm,ppParm,ope)
char *pAns;
int ope,nparm;
tdtInfoParm *ppParm[];
{
	MCAT mcat;
	int opt,k,rc;
	tdtInfoParm tParm2[2];

	if (ope == D_FUC_LPRINT) opt = 3;
	else if (ope == D_FUC_PRINT) opt = 1;
	else opt = 0;
	cl_print_echo_text_init(&mcat,NULL,opt);

	for (k=0;k<nparm;k++) {
		if (k > 0) {
			if (c_flg) akxtmcats(&mcat,",");
			akxtmcats(&mcat," ");
		}
#if 1
		cl_gx_copy_info(tParm2,ppParm[k]);
		memset(&tParm2[1],0,sizeof(tdtInfoParm));
		_mcat_text_infoparm(&mcat,tParm2,k);
#else
		_mcat_text_infoparm(&mcat,ppParm[k],k);
#endif
	}
	cl_print_echo_text_out(&mcat,opt);
	rc = 0;
	memcpy(pAns,&rc,sizeof(int));
	return 0;
}

/********************************************/
/*											*/
/********************************************/
int cl_str_print(ppAns,pParm,iOpt)
char **ppAns;
tdtInfoParm *pParm;
int iOpt[];
{
	static MCAT mcat={'M','C',512,0,0,0,NULL,0};
	tdtInfoParm tParm2[2];

	if (!ppAns || !pParm) return -1;
	t_flg = x_flg = e_flg = d_flg = m_flg = 0;
	q_flg = c_flg = n_flg = i_flg = 0;
	_option_to_flag(iOpt[0]);
	mcat.mc_ipos = 0;
	cl_gx_copy_info(tParm2,pParm);
	memset(&tParm2[1],0,sizeof(tdtInfoParm));
	_mcat_text_infoparm(&mcat,tParm2,0);
	iOpt[0]= _flag_to_option();
	*ppAns = mcat.mc_bufp;
	return mcat.mc_ipos;
}
