static  char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Compile & Execution expression              */
/*                                                   */
/*           coded by A.Kobayashi 2010.10.26         */
/*                                                   */
/*****************************************************/
#include "colmn.h"
/*
#define LVL_GXCOMPL	150
#define LVL_GXEXOBJ	160
*/
#define DATA_NARABI

extern GlobalCt  *pGlobTable;
extern int giOptions[];

static int iEROUT_NDEF;

/****************************************/
/*										*/
/****************************************/
static char *_atr2ope(atr)
int atr;
{
	static char *ope[]={""
/*  1-10 */ ,"(",")","[","]","func(","cast(","{","}",0,0
/* 11-20 */ ,0,0,"NEW","++","--","!!","~~","!","~","CAST"
/* 21-30 */ ,"*","/","%","+","-","<<",">>","ABS",".","**"
/* 31-40 */ ,"<",">","<=",">=","==","!=","LIKE","MAX","MIN",0
/* 41-50 */ ,"&","^","|",0,0,0,0,0,0,0
/* 51-60 */ ,"&&","||",0,0,0,0,0,0,"?",":"
/* 61-70 */ ,0,0,"MOD",0,"iEQ","iNE",0,0,0,0
/* 71-80 */ ,"&=","^=","|=",0,0,0,0,0,"~=",0
/* 81-90 */ ,"*=","/=","%=","+=","-=","<<=",">>=","&+=",0,"="
/* 91-100*/ ,"PUSH",0,0,0,"..","<==","==>",",",";",0};
	char *op=NULL;

	if (atr < 0) {
		atr= -atr;
		if ((atr>=14 && atr<=19) || atr==21 || atr==24 || atr==25 || atr==30) op = ope[atr];
	}
	else if (atr < 100) {
		op = ope[atr];
	}
	return op;
}

/****************************************/
/*										*/
/****************************************/
static char *_atr2name(da,atr)
char *da[];
int atr;
{
	int i,k;
	char *p;

	if (atr<100) {
		if (!(p=_atr2ope(atr))) p = AKX_NULL_PRINT;
		return p;
	}
#if 1
	for (k=9001;k>=1001;k-=1000) {
		if (atr >= k) {
			i = atr - k;
			break;
		}
	}
#else
	if (atr>=5001) i=atr-5001;
	else if (atr>=4001) i=atr-4001;
	else if (atr>=3001) i=atr-3001;
	else if (atr>=2001) i=atr-2001;
	else i=atr-1001;
#endif
	if (i==998) return "֐lorzl";
	else return da[i];
}

/****************************************/
/*										*/
/****************************************/
static int _rep_data_memory(im,pInfoParmW)
int im;
tdtInfoParm *pInfoParmW;
{
	tdtInfoParm tInfoParm;
	char *pW,*p;
	uchar uc;
	int rc,len;

	if (!pInfoParmW) return -1;
	if (pInfoParmW->pi_id==' ' && (len=pInfoParmW->pi_dlen)>0 &&
	    ((uc=pInfoParmW->pi_attr)==DEF_ZOK_CHAR || uc==DEF_ZOK_BULK || uc==DEF_ZOK_DECI) &&
	    (pW=pInfoParmW->pi_data)) {
		if (uc == DEF_ZOK_CHAR) len++;
		if (!(p=cl_opt_malloc(im,len))) return -1;
		memcpy(p,pW,len);
		pInfoParmW->pi_data = p;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_aux1_from_opt(opt)
int opt;
{
	int i;

	if (opt & D_GX_OPT_SET_LOCAL) i = D_AUX1_LOCAL_VAR;
	else if (opt & D_GX_OPT_SET_PRIVATE) i = D_AUX1_PRIVATE_VAR;
	else if (opt & D_GX_OPT_SET_PUBLIC) i = D_AUX1_PUBLIC_VAR;
	else if (opt & D_GX_OPT_SET_GLOBAL) i = D_AUX1_GLOBAL_VAR;
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_opt_from_aux1(i)
int i;
{
	int opt;

	if (i & D_AUX1_LOCAL_VAR) opt = D_GX_OPT_SET_LOCAL;
	else if (i & D_AUX1_PRIVATE_VAR) opt = D_GX_OPT_SET_PRIVATE;
	else if (i & D_AUX1_PUBLIC_VAR) opt = D_GX_OPT_SET_PUBLIC;
	else if (i & D_AUX1_GLOBAL_VAR) opt = D_GX_OPT_SET_GLOBAL;
	return i;
}

/****************************************/
/*										*/
/****************************************/
int _conv_arg_opt(da,pInfoParmW,opt)
char *da;
tdtInfoParm *pInfoParmW;
int opt;
{
	parmList qprmL;
	int x,rc=0;
	char buf[10];

	if (!pInfoParmW) return -1;
	if (*da == '<') {
		memzcpy(buf,da,D_LEN_STR_SCOPE);
		if (!(x=cl_get_def_scope(buf))) {
			/* _conv_arg_opt: Invalid scope name[%s] */
			ERROROUT2(FORMAT(135),"_conv_arg_opt",buf);
			return -1;
		}
		opt |= x;
		da += D_LEN_STR_SCOPE;
	}
	qprmL.prp = da;
	qprmL.prmlen = strlen(da);
	if (rc=cl_conv_arg_opt(&qprmL,pInfoParmW,opt)) {
		if (rc == ECL_NDEFVAR_ERROR) {
			cl_set_parm_char(pInfoParmW,qprmL.prp,qprmL.prmlen);
			pInfoParmW->pi_id = D_DATA_ID_UNDEFVAR;
			pInfoParmW->pi_aux[1] = cl_gx_get_aux1_from_opt(opt);
			rc = 0;
		}
		else if (rc==ECL_DEFINED_ARRAY || rc==NULL_PARM) {
			rc = 0;
		}
		else if (rc == NAME_CONST) {
			if (rc = cl_conv_parm_opt(&qprmL,pInfoParmW,opt)) {
				if (rc == ECL_NDEFVAR_ERROR) {
					cl_set_parm_char(pInfoParmW,qprmL.prp,qprmL.prmlen);
					pInfoParmW->pi_id = D_DATA_ID_UNDEFVAR;
					pInfoParmW->pi_aux[1] = cl_gx_get_aux1_from_opt(opt);
					rc = 0;
				}
				else if (rc==ECL_DEFINED_ARRAY || rc==NULL_PARM) {
					rc = 0;
				}
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _name_to_func_var(atr,name,pInfoParm)
int atr;
char *name;
tdtInfoParm *pInfoParm;
{
	ScrPrCT *pScCT;
	ProcCT  *cur_procct;
	Leaf    *wkleaf,*nodeleaf;
	char     id;

	if (atr == 10000) {
		wkleaf = NULL;
		id = '\0';
		if (!stricmp(name,D_SYS_CLASS_SYSTEM) ||
		    !stricmp(name,D_SYS_CLASS_FILE) ||
		    !stricmp(name,D_SYS_CLASS_MATH)) {
			atr = 101;
			id = 'C';
		}
		else if (pScCT = cl_search_src_ct()) {
#if 1
			cur_procct = cl_search_proc_ct();
			if (wkleaf=cl_search_class_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
				atr = 101;
				id = 'C';
			}
			else if (wkleaf=cl_search_func_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
			/*	atr = 61;	*/
				atr = 62;
				id = 'F';
			}
			else if (wkleaf=cl_search_proc_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
				atr = 101;
				id = 'O';
			}
#else
			if (cl_search_func(pScCT->TreeTop,name)) atr = 61;
#endif
		}
		if (atr!=62 && atr!=101) atr = 3000;
		if (pInfoParm) {
			pInfoParm->pi_id = id;
			pInfoParm->pi_len = atr;
			pInfoParm->pi_pos = (long)wkleaf;
			pInfoParm->pi_paux = (char *)nodeleaf;
			pInfoParm->pi_alen = D_AULN_SET_POS_LEAF;
		}
	}
	return atr;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_yoyakugo(name)
char *name;
{
	cmdTable *pcmd;

	if (pcmd = cl_cmd_chk(name)) {
		if (pcmd->cmdid != C_UNKNOWN) return 1;
	}
#if 1	/* 2017.6.2 */
	if (cl_chk_sysvar_name(name,strlen(name))) return 3;
#endif
	if (cl_get_name_attr(name,strlen(name),0x01,0xffff)) return 2;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_pname_name(name)
char *name;
{
	char *p;
	int rc,len;

	if (!(p=name)) return -1;
	if (!(rc=cl_is_yoyakugo(p))) {
		len = strlen(p);
		if (!(rc=cl_chk_name(p,len)))
#if 0	/* 2017.6.2 */
			if (!(rc=cl_chk_sysvar_name(p,len)))
#endif
				if ((rc=cl_gx_chk_opt(name)) == NAME_CONST) rc = 0;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _set_null_parm(im,pGxObjExpand,piob,piob0,pida)
int im;
GXObjectExpand *pGxObjExpand;
int *piob,*piob0,*pida;
{
	short *obj;
	tdtInfoParm **obj0;
	char **da;
	int iob,iob0,ida;
	tdtInfoParm *pInfoParmW;

	iob = *piob;
	iob0 = *piob0;
	ida = *pida;

	if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
	obj[iob++]=91;
	if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
		return ECL_MALLOC_ERROR;
	cl_null_parm(pInfoParmW);
	obj[iob++]=ida;

	if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
	if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
#if 1	/* 2019.2.21 */
	obj0[ida]=pInfoParmW;
#else
	obj0[iob0++]=pInfoParmW;
#endif
	da[ida++] = "";
#if 1	/* 2019.2.21 */
	iob0 = ida;
#endif

	*piob = iob;
	*piob0 = iob0;
	*pida = ida;

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_compile_gp_opt(pgwprm,pssp,iOpt,pGxObjExpand)
GWPRM_S *pgwprm;
SSPL_S  *pssp;
int iOpt;
GXObjectExpand *pGxObjExpand;
{
	static char *name="cl_gx_compile";
	static char *fa[]={"(","[","{"};
	static tdtInfoParm tInfoParmK,tInfoParmF,tInfoParmA,tInfoParmL;
	int ida,idai,isp;
	char **da,*cast0,*word,cw,*fai,buf[64];
	short *obj;
	int nobj,iob,iob0;
	int sp;
	MCAT ms_stack,ms_stk_str;
	short *stack;
	int i,opt1,im,opt_scope;
	char *p,c,*pp;
	parmList  *prmL, qprmL;
	int atr,attr0,i1,i2,ac,mc,atrn,rc,conv_flg,len,attr1;
	tdtInfoParm *pInfoParmW,**obj0,tInfoParm;
	int iobj_goto1,iobj_goto2,ista_goto1,ista_goto2,lvl_3kou1,lvl_3kou2,optimize_flg;
	int sta_goto1[10],sta_goto2[10];
	char **stk_str;
/*
printf("cl_gx_compile: len=%d buf=[%s]\n",pgwprm->line_len,pgwprm->line);
*/
	cl_parm_set0(&tInfoParm);
	cl_set_parm_bin(&tInfoParmK,0);
	tInfoParmK.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmF,1);
	tInfoParmF.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmA,2);
	tInfoParmA.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmL,3);
	tInfoParmL.pi_aux[1] = D_AUX1_FUNC_ARRY;
	iobj_goto1=iobj_goto2=ista_goto1=ista_goto2=lvl_3kou1=lvl_3kou2=0;
	iob0=iob=0;
	ida=0;
	word = pssp->wd;
	pGxObjExpand->nobj = iob;
	pGxObjExpand->nda = ida;
	pGxObjExpand->nobj0 = iob0;
	cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
	cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
	cl_gx_expand(pGxObjExpand->ms_da,-1,&da);
	cl_gx_init_expand(&ms_stack,"ST",sizeof(short),MAX_STACK);
	cl_gx_expand(&ms_stack,0,&stack);
	cl_gx_init_expand(&ms_stk_str,"SS",sizeof(char *),MAX_STACK);
	cl_gx_expand(&ms_stk_str,0,&stk_str);
	prmL = &qprmL;
	stack[0]=0;
	sp=1;
	atr=0;
	optimize_flg=0;
	im = (iOpt & D_GX_OPT_ALC_MASK)>>12;
	opt1 = (iOpt & ~D_GX_OPT_SET_SCOPE) | D_GX_OPT_SET_ADDR | D_GX_OPT_NOEROUT_NDEF;
	opt_scope = iOpt & D_GX_OPT_SET_SCOPE;

DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile: *** start iOpt=%08x opt1=%08x",iOpt,opt1);

	for(;;) {
		/* x++,x-- ̂Ƃ́A++,--PÔ(attr0)Ƃ͂Ȃ */
		if (atr!=14 && atr!=15) attr0 = atr;
		for(;;) {
			if ((atr=cmp_gtwd(pgwprm,pssp))<0) return atr;
			cw = *word;

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:cmp_gtwd: attr0=%d, gtwd attr=%d, wd=[%s] ssp.sp=%d",
attr0,atr,word,pssp->sp);

			tInfoParm.pi_id = '\0';
			tInfoParm.pi_len = atr;
			tInfoParm.pi_pos = 0;
			tInfoParm.pi_paux = NULL;
			if (attr0==1 && atr>=10000) {
				if (cl_gx_is_operator(word,FUNCCAST)) {
					SSPL_S   qssp;
					char wrk[4096];

					isp = pssp->sp;
					len = strlen(word);
					memcpy(&qssp,pssp,sizeof(SSPL_S));
					qssp.wd = wrk;
					if ((atrn=cmp_gtwd(pgwprm,&qssp))<0) return atrn;
					if (atrn==1) {
						if (rc=cl_skip_to_delm(pgwprm->line,pgwprm->line_len,"()",&qssp," \t(),'",1)) return rc;
						pssp->sp = qssp.sp;
						memzcpy(word+strlen(word),pgwprm->line+isp,qssp.sp-isp);
						if ((atrn=cmp_gtwd(pgwprm,&qssp))<0) return atrn;
					}
					if (atrn==2) {
						if ((atrn=cmp_gtwd(pgwprm,&qssp))<0) return atrn;
						atrn = _name_to_func_var(atrn,qssp.wd,&tInfoParm);
						if (atrn==1 || atrn==3000 || atrn==4000 || atrn==5000) atr=6000;
						else if (atrn==61 || atrn==62 || atrn==63 || atrn==28) {
							if ((atrn=cmp_gtwd(pgwprm,&qssp))<0) return atrn;
							if (atrn==1) atr=6000;	/* CAST */
						}
					}
					pssp->sp = isp;
					*(word+len) = '\0';
					if (atr==6000) {
						if (stack[sp-1]==1) stack[sp-1] = 10;	/* 6;	*/	/* '(' of caszt */
					}
				}
			}
			if (atr==10001) atr = 62;
			if (atr == 10000) {
				if (rc=cl_get_def_scope(word)) {
					opt_scope = rc;
					continue;
				}
				if ((atr=_name_to_func_var(atr,word,&tInfoParm)) == 3000) {
					if (cl_is_yoyakugo(word)) {
						ERROROUT2(FORMAT(121),name,word);	/* %s: [%s]͗\łB */
						RETURN(-11)
					}
				}
			}
			pp = pssp->wd;
			pssp->wd += strlen(word) + 1;
			attr1 = cmp_peekwd(pgwprm,pssp);
			pssp->wd = pp;
			if (atr==23 && 	/* 23=% */
				(attr0==0 || attr0==1 ||  attr0==3 || attr0==5 || attr0==7 ||
#if 1
				    attr0<0 ||
#else
				    attr0==-18 || attr0==-19 || attr0==-25 ||
#endif
				    (attr0>=20 && attr0<2000))) {
					atr = 63;	/* ֐ */
			}
			else if (atr==13) {	/* new */
				if (attr1 == 1) atr = 62;
			}
DEBUGOUTL1(LVL_GXCOMPL+1,"cl_gx_compile: modified attr=%d",atr);
#if 1
			if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==7 ||
			    (attr0>=21 && attr0<=2000)) {
				if ((atr>=14 && atr<=19) || atr==24 || atr==25 || atr==28 ||
				    atr==61 || atr==62 ||atr==63) ;
				else if (atr==98 && (attr0==0 || attr0==1 || attr0==3 ||
				                     attr0==5 || attr0==7 || attr0==98)) ;
				else if ((atr>=22 && atr<100) ||
				         (attr0==29 && (atr>=2 && atr<22))) {
					/* %s: [%s]̌[%s]̈ʒusłB */
					ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
					return -8;
				}
			}
			else if ((attr0==14 || attr0==15) && (atr==61 || atr==62 || atr>=3000)) {
				/* %s: [%s]̌[%s]̈ʒusłB */
				ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
				return -8;
			}
#if 0
			else if ((attr0>=2000 && attr0<2999) && (atr==61 || atr==62 || atr==63 || atr==101)) {
				if (!stricmp(_atr2name(da,attr0),"NEW") && atr==101) ;
				else {
					/* %s: [%s]̌[%s]̈ʒusłB */
					ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
					return -8;
				}
			}
#endif
		/*	if (atr==63) atr=23;	*/
#endif
			if (atr==99) {
				atr=0;
			}
		/*	else if ((attr0>=2000 && atr>=2000) ||	*/
			else if ((attr0>=2000 && (atr==7 || atr==101 || atr>=2000)) ||
			         (((attr0>=4000 && attr0<6000) || (attr0>=7000 && attr0<8000)) && (atr==1 /*|| atr==3 || atr==7*/))) {
				/* %s: Zq܂B%s %s */
				ERROROUT3(FORMAT(123),name,
				          _atr2name(da,attr0),word);
			/*	          _atr2name(da,attr0),_atr2name(da,atr));	*/
				return -2;
			}
			else if (atr>=3000 && atr<=6000) {
				rc = 0;
				if (opt_scope) {
					if (atr==4000 || atr==5000) rc = -9;
					else if (atr==3000 && (cw=='$' || cw=='#' || cw=='%')) {
						if (cw=='$') {
							 if (((c=toupper(word[1]))<'A' || c>'Z') && c!='_') rc = -9;
						}
						else rc = -9;
					}
				}
				if (rc) {
					/* %s: [%s]ɃANZXCq͎wł܂B */
					ERROROUT2(FORMAT(124),name,word);
					return rc;
				}
				if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
				if (!(da[ida]=cl_opt_malloc(im,strlen(word)+2+D_LEN_STR_SCOPE)))
					return ECL_MALLOC_ERROR;
#if 1
				p = da[ida];
				if (atr == 3000) {
					if (attr0 == 29) {
						pp = word;
						if (cw == '$') pp++;
						if (cl_chk_name(pp,strlen(pp))) {
							/* %s: o[[%s]słB */
							ERROROUT2(FORMAT(136),name,word);
							return ECL_SCRIPT_ERROR;
						}
					}
					if (attr0!=D_IMD_PNAME && attr1!=D_IMD_NAMED) {
						if (cw!='$' && cw!='%' && cw!='#') *p++ = '$';
					}
				}
				strcpy(p,word);
#else
				if (atr==3000 && cw!='$' && cw!='%' && cw!='#') {
					*da[ida] = '$';
					strcpy(da[ida]+1,word);
				}
				else strcpy(da[ida],word);
#endif
				if (atr==6000) cast0 = da[ida];
				atr += ++ida;
			}
			else if ((atr>=13 && atr<=19) || atr==21 || atr==24 || atr==25) {
				if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==6 || attr0==7 ||
				    (attr0>=21 && attr0<=2000) ||
					(atr!=21 && (attr0<=-14 && attr0>=-19) || attr0==-21 || attr0==-25)) {
#if 1	/* 2017.8.28 koba */
					atr = -atr;
#else
					if (atr==24) continue;
					else atr= -atr;
#endif
				}
			}
			else if (atr==61 || atr==62 || atr==63 || atr==28 || atr==101) {	/* 63=MOD 28=ABS */
				if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==6 || attr0==7 ||
#if 1
				    attr0<0 ||
#else
				    attr0==-18 || attr0==-19 || attr0==-25 ||
#endif
				    (attr0>=20 && attr0<2000)) {
					if (atr == 101) {
						if (attr0 == -13) atr = 8000;	/* new CLASS */
						else atr = 7000;	/* CLASS */
					}
					else atr = 2000;	/* ֐ */
				}
				else if (atr==62 || atr==28) atr = 2000;
				else if (atr==61) {
#if 0
					pssp->wd += strlen(word) + 1;
					if (cmp_peekwd(pgwprm,pssp) == 1) atr = 2000;	/* ֐ */
					else
#endif
					atr = 1000;	/* Zq */
					pssp->attr[1] = 61;
					pssp->wd = word;
				}
#if 1
				if (attr0>=2000 && atr>=2000) {
								/* %s: Zq܂B%s %s */
					ERROROUT3(FORMAT(123),name,_atr2name(da,attr0),word);
					return -2;
				}
#endif
				if (atr==1000 || atr==2000 || atr==7000 || atr==8000) {
					if (opt_scope) {
						if (atr==2000 && (cw=='$' || cw=='#' || cw=='%')) ;
						else {
							/* %s: [%s]ɃANZXCq͎wł܂B */
							ERROROUT2(FORMAT(124),name,word);
							return -10;
						}
					}
					if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
					if (!(da[ida]=cl_opt_malloc(im,strlen(word)+1)))
						return ECL_MALLOC_ERROR;
					strcpy(da[ida],word);
					atr += ++ida;
				}
			}
			else if (atr==1 && ((attr0>=2001 && attr0<=5000) ||
			                    (attr0>=6001 && attr0<=7000) ||		/* ֐( */
			                    (attr0>=8001 && attr0<=9000))) {	/* new Class( */
				atr = 5;
			}
			else if (atr==2 && attr0>=6001 && attr0<=7000) {	/* CAST */
				atr = 20;
			}
#if 1
			else if (atr == 3) {	/* [ */
				if ((attr0>=3001 && attr0<4000) ||	/* ʕϐ */
				    attr0==2 || attr0==4 || attr0==2999) atr = 6;	/* z[ */
				else if (attr0<=100) ;								/* f[^ю̊Jn'[' */
				else {
					/* %s: z񖼂ȂsłB */
					ERROROUT1(FORMAT(137),name);
					return -10;
				}
			}
#else
			else if (atr==3 && (attr0<=3000 || attr0>=4000) &&
			         !(attr0==2 || attr0==4 || attr0==2999 || attr0==3999)) {	/* [ */
				/* %s: z񖼂ȂsłB */
				ERROROUT1(FORMAT(137),name);
				return -10;
			}
#endif
		/*
			else if (atr==7) {
				if (attr0==0 || attr0==1 ||  attr0==3 || attr0==5 || attr0==7 ||
				    attr0==59 || attr0==60 || attr0==90 || attr0==98 || attr0==99) ;
				else {
					** %s: [%s]̌[%s]̈ʒusłB **
					ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
					return -11;
				}
			}
		*/
			else if (atr>=71 && atr<=90)
				opt1 &= ~(D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
			break;
		}
		if ((atr>1000 && atr<=3000) || atr>4000) opt_scope = 0;

DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:          attr=%d opt_scope=%08x",atr,opt_scope);

		if (atr == 60) lvl_3kou2 = lvl_3kou1;

		i2=cmp_mkix(atr);
		for(;;) {
			if (sp<1) return ECL_SYNTAX_ERROR;
			i1=cmp_mkix(mc=stack[sp-1]);
			ac=cmp_act(i1,i2);
			if (atr==D_IMD_PNAME && mc==D_IMD_PNAME) ac = 3;
			if (mc==59 && atr==60) {
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile: lvl_3kou1=%d lvl_3kou2=%d",lvl_3kou1,lvl_3kou2);
				if (lvl_3kou1 < lvl_3kou2) ac = 2;
			}
			if (i1==24 && i2==1 && attr0==29) ac=2;
		/*	if (atr == 60) {
				if (i1==19 && i2==18) ac = 3;
			}	*/
		/*	if (i2==2 && ac==4 && (atr-mc)!=1) ac=2;	*/
		/*	if ((mc==14 || mc==15) && ac==1) return ECL_SYNTAX_ERROR;	*/

DEBUGOUTL5(LVL_GXCOMPL+1,"cl_gx_compile:cmp_act: attr=%d, mc=%d, act i1=%d, i2=%d, ac=%d",
atr,mc,i1,i2,ac);

			if (ac<0) return ECL_SYNTAX_ERROR;
			else if (ac == 99) {
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				obj[iob++]=ac;
				obj[iob]=0;
if (DEBUGOUTCHECK(LVL_GXCOMPL)) {
for (i=0;i<iob;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"obj[%2d]=%d",i,obj[i]);
}
for (i=0;i<iob0;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"obj0[%2d]=0x%08x",i,obj0[i]);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+5,"",obj0[i],0,0);
}
for (i=0;i<ida;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"da[%2d]=[%s]",i,da[i]);
}
}
				pGxObjExpand->nobj = (iob+1) & (~0x01);
				pGxObjExpand->nda = ida;
				pGxObjExpand->nobj0 = iob0;
				return optimize_flg;
			}
			else if (ac == 1) {
				if (cl_gx_expand(&ms_stk_str,ida,&stk_str) < 0) return ECL_MALLOC_ERROR;
			/*	stk_str[sp] = "+";	*/
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				conv_flg = 1;
				if (atr<=3000 || atr>6000) {
					if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
						return ECL_MALLOC_ERROR;
					if (atr <= 3000) {	/* ֐ */
						idai = atr - 2001;
						p = da[idai];
						cl_set_parm_char(pInfoParmW,p,strlen(p));
					/*	memset(pInfoParmW,0,sizeof(tdtInfoParm));	*/
						pInfoParmW->pi_id = D_DATA_ID_FUNCTION;
					/*	pInfoParmW->pi_attr = DEF_ZOK_CHAR;
						pInfoParmW->pi_dlen  = strlen(da[idai]);
						pInfoParmW->pi_data = da[idai];	*/
						pInfoParmW->pi_pos = tInfoParm.pi_pos;
						pInfoParmW->pi_paux = tInfoParm.pi_paux;
						pInfoParmW->pi_alen = tInfoParm.pi_alen;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:FUNCTION ",pInfoParmW,0,0);

					/*	if (inistr(",IIF,NVAL,NSVAL,NDEF,NULLIF",stradd(",",p)) > 0) {	*/
					/*		if (cl_gx_expand(&ms_stk_str,ida,&stk_str) < 0) return ECL_MALLOC_ERROR;	*/
							if (!(pp=cl_tmp_const_malloc(strlen(p)+1))) return ECL_MALLOC_ERROR;
							stk_str[sp] = pp;
							strcpy(pp,p);

DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:set stk_str[%d]=%s",idai,pp);

						if (inistr(",IIF,NVAL,NSVAL,NDEF,NULLIF",stradd(",",p)) > 0) {
							optimize_flg = C_DO_OPTIMIZE;
						}
					}
					else if (atr <= 7000) {	/* CAST */
						idai = atr - 6001;
						cl_set_parm_char(pInfoParmW,da[idai],strlen(da[idai]));
						pInfoParmW->pi_id = ' '; /* D_DATA_ID_FUNCTION; */
						pInfoParmW->pi_aux[0] = FUNCCAST;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:CAST ",pInfoParmW,0,0);

					}
					else if (atr <= 9000) {	/* CLASS */
						if (atr <= 8000) idai = atr - 7001;
						else idai = atr - 8001;
						cl_set_parm_char(pInfoParmW,da[idai],strlen(da[idai]));
					/*	pInfoParmW->pi_id = D_DATA_ID_CLASS;	*/
						pInfoParmW->pi_id = tInfoParm.pi_id;
						pInfoParmW->pi_pos = tInfoParm.pi_pos;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:CLASS ",pInfoParmW,0,0);

					}
				}
				else {
			/*	else if (atr <= 6000) {	*/
					if (atr <= 4000) {	/* Variable */
						idai = atr - 3001;
						p = da[idai];
#if 1
					/*	conv_flg = 0;	*/
/*
printf("cl_gx_compile_gp_opt: opt_scope=%08x\n",opt_scope);
*/						if (opt_scope) {
							if (opt_scope==D_GX_OPT_SET_GLOBAL) pp=D_STR_SCOPE_GLOBAL;
							else if (opt_scope==D_GX_OPT_SET_PUBLIC) pp=D_STR_SCOPE_PUBLIC;
							else if (opt_scope==D_GX_OPT_SET_PRIVATE) pp=D_STR_SCOPE_PRIVATE;
							else pp=D_STR_SCOPE_LOCAL;
							strnzcpy(buf,p,sizeof(buf)-1);
							strcpy(p,pp);
							strcat(p,buf);
						}
						if ((c=*p++)=='$' || c=='%' || c=='#') {
						/*	if ((c=*p)>='0' && c<='9') conv_flg = 1;	*/
							if ((c=*p)=='$' || c=='%' || c=='#') conv_flg = 0;
						}
					/*	else if (attr0 == D_IMD_PNAME) conv_flg;	*/
#else
#if 1
						if ((c=*p++)=='$' || c=='%' || c=='#') {
#else
						if ((c=*p++) == '$') {
#endif
							if ((c=*p)=='$' || c=='%' || c=='#') conv_flg = 0;
						}
					/*	else if (c == '#') conv_flg = 0;	*/
#endif
					}
					else if (atr <= 5000) {	/* System Var. */
						idai = atr - 4001;
						conv_flg = 0;
					}
					else idai = atr - 5001;	/* CONSTANT */
				/*	if (attr0 == 29) conv_flg = 0;	*/
					if (conv_flg) {
						if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
							return ECL_MALLOC_ERROR;
						p = da[idai];
						c = *p;
						if (attr0 == 29) {
							cl_set_parm_char(pInfoParmW,p,strlen(p));
							pInfoParmW->pi_alen = D_AULN_NAME_DATA;
						}
						else if ((attr0==D_IMD_PNAME || attr1==D_IMD_NAMED)
						     && atr<=4000 && !(c=='$' || c=='%' || c=='#')) {
							cl_set_parm_char(pInfoParmW,p,strlen(p));
							pInfoParmW->pi_id = D_DATA_ID_PNAME;
						}
						else if (rc=_conv_arg_opt(p,pInfoParmW,opt1|opt_scope)) return rc;
						if (atr > 5000) {
							if (rc=_rep_data_memory(im,pInfoParmW)) return rc;
						}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:ConvArg da=[%s]",pInfoParmW,p,0);
					}

				}
				if (conv_flg) {
					obj[iob++]=91;
					obj[iob++]=idai;
					if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
#if 1	/* 2019.2.21 */
					obj0[idai]=pInfoParmW;
					iob0 = ida;
#else
					obj0[iob0++]=pInfoParmW;
#endif
				}
				else {
					obj[iob++]=92;
					obj[iob++]=idai;
				}
				opt_scope = 0;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:PUSH:    sp=%d, opr=[%s] iob=%d",sp,word,iob);
			}
			else if (ac == 2) {
				if (cl_gx_expand(&ms_stack,sp,&stack) < 0) return -4;
				stack[sp++]=atr;
#if 1
				if (atr==5 || atr==3 || atr==6 || atr==7) {	/* func( [ { */
#else
				if (atr==1 || atr==5 || atr==3 || atr==6 || atr==7) {	/* ( func( [ { */
#endif
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=91;
					obj[iob++]=ida;
					if (atr==1) {
						fai = fa[0];
						pInfoParmW = &tInfoParmK;
					}
					else if (atr==5) {
						fai = fa[0];
						pInfoParmW = &tInfoParmF;
					}
					else if (atr==3 || atr==6) {
						fai = fa[1];
						pInfoParmW = &tInfoParmA;
					}
					else {
						fai = fa[2];
						pInfoParmW = &tInfoParmL;
					}
					if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
					if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
#if 1	/* 2019.2.21 */
					da[ida] = fai;
					obj0[ida++]=pInfoParmW;
					iob0 = ida;
#else
					da[ida++] = fai;
					obj0[iob0++]=pInfoParmW;
#endif
				}
				else if (atr == 59) {
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++] = atr;
					obj[iob++] = 0;
					sta_goto1[ista_goto1++] = iob;
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Push goto1: iob=%d ista_goto1=%d",iob,ista_goto1);
					obj[iob++] = 0;
					lvl_3kou1++;
				}
				if (atr==1 || atr==5 || atr==3 || atr==6 || atr==7) {	/* ( func( [ { */
					atrn = cmp_peekwd(pgwprm,pssp);
					if (atrn == 98) {	/* , */
						/* ",,"ňȗꂽꍇ́ANULL} */
						if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
						cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
						cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
						cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d func(, or [,",
iob,atr,atrn,ida);

					}
				}
			}
			else if (ac == 3) {
				if (sp < 1) return ECL_SYNTAX_ERROR;
				sp--;
				if (mc == 60) {	/* : */
					if (ista_goto1==0 || ista_goto1!=ista_goto2) {
						return -6;
					}
					ista_goto1--;
					ista_goto2--;
					iobj_goto2 = sta_goto2[ista_goto2];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Pop goto2: iobj_goto2=%d ista_goto2=%d",iobj_goto2,ista_goto2);
#if 1	/* 2019.4.7 */
					obj[iobj_goto2] = iob - iobj_goto2;
#else
					obj[iobj_goto2] = iob;
#endif
					lvl_3kou2--;
				}
				else if (mc == 59) {	/* ? */
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++] = 93;	/* GOTO */
					obj[iob] = 0;
					ista_goto2 = ista_goto1;
					sta_goto2[ista_goto2-1] = iob;
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Push goto2: iob=%d ista_goto2=%d",iob,ista_goto2);
					iob++;
					iobj_goto1 = sta_goto1[ista_goto1-1];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Peek goto1: iobj_goto1=%d ista_goto1=%d",iobj_goto1,ista_goto1);
#if 1	/* 2019.4.7 */
					obj[iobj_goto1] = iob - iobj_goto1;
#else
					obj[iobj_goto1] = iob;
#endif
					lvl_3kou1--;
				}
				else {
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=stack[sp];

DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:         sp=%d, opr=%s iob=%d",sp,pssp->wd,iob);

					if (mc==20 && !stricmp(cast0,"FUNC")) attr0 = 2001;
					if (mc>=14 && mc<=17) pGxObjExpand->index0 |= 0x02;
				}
				continue;
			}
			else if (ac == 4) {	/* ( and ) or { and } */
				sp--;
#if 1
				if (mc==5 || mc==7) {	/* ֐ */
#else
				if ((atr!=20 && mc==1) || mc==5 || mc==7) {	/* ֐ */
#endif
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=mc;
#if 1
					atr = 2999;
#else
					if (mc == 1) {
						atr = attr0;
						pGxObjExpand->index0 |= 0x01;
					}
				/*	else atr = 2001;	*/
					else atr = 2999;
#endif
				}
				else if (atr==20 || mc==10) {	/* CAST */
					if (cl_gx_expand(&ms_stack,sp,&stack) < 0) return -4;
					atr = 20;
					stack[sp++]=atr;
				}
				else atr = attr0;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:         sp=%d, opr=%s iob=%d",sp,word,iob);
			}
			else if (ac == 5) {	/* [ and ] z or f[^ю */
				sp--;
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				obj[iob++]=mc;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile: sp=%d, opr=%s iob=%d",sp,word,iob);
#if 1
				if (mc == 3) {
					atr = attr0;
					pGxObjExpand->index0 |= 0x01;
				}
				else atr = 3999;
#else
			/*	atr = 2001;	*/
				atr = 3999;
#endif
			}
			else if (ac == 6) {
				if (!(opt1 & D_GX_OPT_GET_DEF_ATTR) && mc==1) return ECL_SYNTAX_ERROR;
				atrn = cmp_peekwd(pgwprm,pssp);
				if (atrn==98 || atrn==2 || atrn==4 || atrn==8) {
					/* ",,"ňȗꂽꍇ́ANULL} */
					if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
					cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
					cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
					cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d func(, or [,",
iob,atr,atrn,ida);

				}
				p = stk_str[sp-1];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:get stk_str[%d]=%s",sp-1,p);
				if (!p) p = "+";
				if (inistr(",IIF,NVAL,NSVAL,NDEF,NULLIF",stradd(",",p)) > 0) {
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=98;
					obj[iob++]=0;
				}
			}
			else if (ac == 0) {
				if ((iOpt & D_GX_OPT_PARMINFO2) && atr==98 && (attr0==0 || attr0==98)) {
					if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
					cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
					cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
					cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"ccl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d ,,",
iob,atr,atrn,ida);

				}
			}
			else {
				return -6;
			}
			break;
		}
	}
}

/****************************************/
/*										*/
/****************************************/
int _ex_get_member(ppInfoParmW,opt,da,len)
tdtInfoParm **ppInfoParmW;
int opt;
char *da;
int len;
{
	tdtInfoParm *pInfoParmW,*pInfoParm;
	char *p,id;
	int rc=0;
	parmList  **parmName;
	tdtDefType *pDeftype;
	int i,ntype,n,datalen,iCASE;
	tdtArrayIndex *pIndex;

	if (!(pInfoParm = *ppInfoParmW)) return -1;
	pDeftype = (tdtDefType *)pInfoParm->pi_data;
	parmName = pDeftype->vname;
	iCASE = pInfoParm->pi_alen & D_AULN_IGN_CASE;
	for (i=0;i<pDeftype->ntype;i++) {
		if (len == parmName[i]->prmlen) {
			if (iCASE) {
				rc = akxmemicmp(da,parmName[i]->prp,len);
			}
			else {
				rc = memcmp(da,parmName[i]->prp,len);
			}
			if (!rc) {
#if 1
				pInfoParmW = pDeftype->pType[i];
				if (pInfoParmW->pi_id == 'F') pInfoParmW->pi_paux = (char *)pInfoParm;
#else
				if (!(pInfoParmW=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm)))) return -1;
				*pInfoParmW = *(pDeftype->pType[i]);
				if ((id=pInfoParmW->pi_id)=='A' || id=='R') {
					if (!(pIndex = (tdtArrayIndex *)cl_tmp_const_malloc(sizeof(tdtArrayIndex)))) return -1;
					memcpy(pIndex,pInfoParmW->pi_data,sizeof(tdtArrayIndex));
					pIndex->pVarIndex = (tdtInfoParm **)(pDeftype->data + parmName[i]->opt);
					pInfoParmW->pi_data = (char *)pIndex;
				}
				else {
					pInfoParmW->pi_data = pDeftype->data + parmName[i]->opt;
					pInfoParmW->pi_paux = pInfoParmW->pi_data;
					pInfoParmW->pi_aux[1] &= ~D_AUX1_PROTECTED;
					if (pInfoParmW->pi_aux[0] == DEF_ZOK_CHAR)
						pInfoParmW->pi_dlen = strlen(pInfoParmW->pi_data);
					else if (pInfoParmW->pi_aux[0] == DEF_ZOK_BULK) {
						memcpy(&datalen,pInfoParmW->pi_paux,sizeof(int));
						pInfoParmW->pi_data += sizeof(int);
						pInfoParmW->pi_dlen = datalen;
					}
				}
#endif

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_exGetMembe:found da=[%s]",pInfoParmW,da,0);

				*ppInfoParmW = pInfoParmW;
				return 0;
			}
		}
	}
	/* _ex_get_member: [%s] is no member. */
	ERROROUT1(FORMAT(138),da);
	return -1;
}

/****************************************/
/*										*/
/****************************************/
int _ex_conv_parm_opt(ppInfoParmW,opt,da)
tdtInfoParm **ppInfoParmW;
int opt;
char *da;
{
	static char *func_name="_ex_conv_parm_opt";
	parmList qprmL;
	tdtInfoParm *pInfoParmW;
	char c,buf[D_LEN_STR_SCOPE+1],*cpDat,*cpKey,*name,cOpt;
	int rc=0,i,len,x,iDATA_NARABI,opts;
	tdtInfoParm ***pTBL,*pParmI;
	tdtArrayIndex *pIndex;
	int  ParmNo,ix,iParm[4],attr,iCONST;
	XHASHB *xhp;

	if (!(pInfoParmW = *ppInfoParmW)) return ECL_NULL_POINTER;

DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:Enter opt=%08x da=[%s]",pInfoParmW,opt,da);

	if (pInfoParmW->pi_id == D_DATA_ID_UNDEFVAR) {
		if (pInfoParmW->pi_attr == DEF_ZOK_CHAR) {
			iDATA_NARABI = pInfoParmW->pi_alen & D_AULN_DATA_NARABI;
			qprmL.prp = pInfoParmW->pi_data;
			qprmL.prmlen = pInfoParmW->pi_dlen;
			if (*da == '<') {
				memzcpy(buf,da,D_LEN_STR_SCOPE);
				if (!(x=cl_get_def_scope(buf))) {
					/* _ex_conv_parm_opt: Invalid scope name[%s] */
					ERROROUT2(FORMAT(135),func_name,buf);
					return -1;
				}
				opt |= x;
			}
			if (rc=cl_conv_parm_opt(&qprmL,pInfoParmW,opt)) {
				if (rc == ECL_DEFINED_ARRAY) rc = 0;
				else {
#if 1
					if (rc==ECL_NDEFVAR_ERROR && (opt & D_GX_OPT_NOERROR_NDEF)) {
						cl_set_parm_char(pInfoParmW,qprmL.prp,qprmL.prmlen);
						pInfoParmW->pi_id = 'U';
						pInfoParmW->pi_alen |= iDATA_NARABI;
						rc = 0;
					}
#endif
				/*
					if (rc == NAME_CONST) {
						** %s: [%s]Ă܂B**
						ERROROUT2(FORMAT(125),func_name,qprmL.prp);
						rc = -10;
					}
				*/
					return rc;
				}
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:ConvParm rc=%d",pInfoParmW,rc,0);
		}
		else {
			if (!(name=(char *)pInfoParmW->pi_pos)) name = "";
			pIndex = (tdtArrayIndex *)pInfoParmW->pi_data;
			iCONST = pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED;
			opts = opt & (D_GX_OPT_STORE_CHK | D_GX_OPT_STORE) ;
			if (pIndex->xhp) {
				xhp = (XHASHB *)pIndex->xhp;
				cpKey = (char *)pInfoParmW->pi_len;
				xhp->xha_xhix = 0;
				ix = akxs_xhash2(xhp,'r',cpKey,&cpDat);

DEBUGOUTL2(194,"_ex_conv_parm_opt: HASH: r cpKey=[%s] ix=%d",cpKey,ix);

				if (ix<0 || !pInfoParmW) return ix;
				else if (ix > 0) memcpy(&pParmI,cpDat,sizeof(tdtInfoParm *));
				else {
					if (opts || (pGlobTable->options[0] & 0x01)) {
						if (!(pParmI=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
						if (pGlobTable->options[0] & 0x04) cl_parm_set0(pParmI);
						else cl_null_data(pParmI);
						attr = pIndex->uAttr[0];
						if (attr && attr!=DEF_ZOK_VARI) {
							iParm[0] = attr;
							iParm[2] = pIndex->uAttr[2];
							iParm[3] = pIndex->uAttr[3];
							iParm[1] = pIndex->size;
							if (rc=cl_set_parm_init(pParmI,iParm,0x01)) return rc;
						}
						ix = akxs_xhash2(xhp,'s',cpKey,&pParmI);

DEBUGOUTL2(194,"_ex_conv_parm_opt: HASH: s cpDat=[%s] ix=%d",cpDat,ix);

						if (ix <= 0) {
							if (ix == 0) ix = -12;
							cl_free_info_parm(pParmI);
							return ix;
						}
					}
					else {
						if (pGlobTable->options[0] & 0x04) {
							if (iEROUT_NDEF)
								/* f[^ݒłB */
								ERROROUT1(FORMAT(203),func_name);
							return ECL_NDEFVAR_ERROR;
						}
						else {
							if (!(pParmI=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm)))) return -1;
							cl_null_parm(pParmI);
						}
					}
				}
			}
			else {
				pTBL   = (tdtInfoParm ***)pInfoParmW->pi_paux;
				ParmNo = pInfoParmW->pi_hlen;
				if (opts) cOpt = 's';
				else cOpt = 'r';

DEBUGOUTL2(194,"_ex_conv_parm_opt: ParmNo=%d cOpt=%c",ParmNo,cOpt);

				if ((rc=cl_array_get_info_parm(&pParmI,pIndex,pTBL,ParmNo,cOpt)) < 0) return rc;
			}
			if (pParmI) {
				if (opts) {
					cl_set_parm_long(pInfoParmW,(long)pParmI);
					pInfoParmW->pi_id   = 'S';
					if ((c=*name)=='%' || c=='#')
						pInfoParmW->pi_aux[1] = D_AUX1_PROTECTED;
				}
				else
					cl_gx_copy_info(pInfoParmW, pParmI);
			}
			else {
				cl_parm_set0(pInfoParmW);
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:U:array: rc=%d",pInfoParmW,rc,0);
		}
	}
	if (pInfoParmW->pi_id == D_DATA_ID_STOREVAR) {
		if (opt & D_GX_OPT_GET_ADDR) {
			*ppInfoParmW = pInfoParmW;
			return 0;
		}
		if (opt & D_GX_OPT_STORE_CHK) {
			if (pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED) {
				ERROROUT2(FORMAT(126),func_name,da);	/* %s: %sւ͑͂ł܂B */
				return -1;
			}
		}
		pInfoParmW = (tdtInfoParm *)pInfoParmW->pi_pos;
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:STOREVAR ",pInfoParmW,0,0);
		if (!pInfoParmW) return ECL_NULL_POINTER;
	}
	else if ((c=pInfoParmW->pi_id)=='A' || c=='R' || c=='T' || c==D_DATA_ID_PNAME) ;
#if 1
	else if (opt & D_GX_OPT_STORE_CHK) {
		if (iEROUT_NDEF && pInfoParmW->pi_id=='\0') {
			ERROROUT2(FORMAT(127),func_name,da);	/* %s: %s̃f[^ݒłB */
			return ECL_NDEFVAR_ERROR;
		}
		else if (pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED) {
			ERROROUT2(FORMAT(126),func_name,da);	/* %s: %sւ͑͂ł܂B */
			return -1;
		}
	}
#endif
#if 0
	if ((c=pInfoParmW->pi_id)=='T') {
		len = strlen(da);
		i = akxnskipto(da,len,".");
		if (++i < len) {
			if (rc=_ex_get_member(&pInfoParmW,opt,da+i,len-i)) return rc;
		}
	}
#endif
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:RETURN rc=%d",pInfoParmW,rc,0);

	if (!(opt & D_GX_OPT_STORE_CHK) && iEROUT_NDEF && pInfoParmW->pi_id=='\0') {
		ERROROUT2(FORMAT(127),func_name,da);	/* %s: %s̃f[^ݒłB */
		return ECL_NDEFVAR_ERROR;
	}
	*ppInfoParmW = pInfoParmW;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static tdtInfoParm *_info_parm_temp_dup(pInfoParm)
tdtInfoParm *pInfoParm;
{
	char *p;
	tdtInfoParm *pInfoParmW;
	int attr;

	if (pInfoParm->pi_aux[0] &&
	    ((attr=pInfoParm->pi_attr)==DEF_ZOK_DECI || attr==DEF_ZOK_DATE)) {
		if (!(pInfoParmW=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return NULL;
		*pInfoParmW = *pInfoParm;
		if (!(p=cl_tmp_const_malloc(sizeof(MPA)))) return NULL;
		memcpy(p,pInfoParm->pi_data,sizeof(MPA));
		pInfoParmW->pi_data = p;
		pInfoParm = pInfoParmW;
	}
	return pInfoParm;
}

/****************************************/
/*										*/
/****************************************/
static int _mk_info_parm2(nparm,ppParm,iOpt,dastk,ipr2s,ms_pp2stk)
int nparm;
tdtInfoParm *ppParm[];
int iOpt,*ipr2s;
char *dastk[];
MCAT *ms_pp2stk;
{
	tdtInfoParm **pp2stk;
	tdtInfoParm *pInfoParm1,*pInfoParm2,*pInfoParm;
	int rc,i,len,optW,ir2s;
	char *da1,id;

	len = sizeof(tdtInfoParm)*(nparm+1);
	if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(len))) return ECL_MALLOC_ERROR;
	pInfoParm2 = pInfoParm1 + 1;
	memset(pInfoParm1,0,sizeof(tdtInfoParm));
	pInfoParm1->pi_id = '2';
	pInfoParm1->pi_pos = nparm;
	pInfoParm1->pi_dlen = len - sizeof(tdtInfoParm);
	pInfoParm1->pi_data = (char *)pInfoParm2;
	for (i=0;i<nparm;i++,pInfoParm2++) {
		pInfoParm = ppParm[i];
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_mk_info_parm2: i=%d ",pInfoParm,i,0);
		da1 = dastk[i];
#ifdef DATA_NARABI
#if 1	/* 2015.11.17 */
		optW = D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_NOERROR_NDEF | D_GX_OPT_GET_ADDR;
#else
		optW = D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_NOERROR_NDEF;
#endif
		if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) {
			pInfoParm1->pi_hlen = rc;
			pInfoParm1->pi_len++;
		}
#else
		optW = iOpt & D_GX_OPT_NOEROUT_NDEF;
		if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) {
			pInfoParm1->pi_hlen = rc;
			pInfoParm1->pi_len++;
		/*	return rc;	*/
		}
		else if (cl_is_undef_parm(pInfoParm)) {
			pInfoParm1->pi_hlen = ECL_NDEFVAR_ERROR;
			pInfoParm1->pi_len++;
			if (!(iOpt & D_GX_OPT_NOEROUT_NDEF))
				/* %s: %s̃f[^ݒłB */
				ERROROUT2(FORMAT(127),"_mk_info_parm2",da1);
		/*	return rc;	*/
		}
#endif
		else {
#if 0
			if ((id=pInfoParm->pi_id)==D_DATA_ID_UNDEFVAR || id==D_DATA_ID_STOREVAR ||
			     (pInfoParm->pi_alen & D_AULN_DATA_NARABI)) {
				cl_gx_copy_info(pInfoParm2,pInfoParm);
			}
			else {
				cl_set_parm_long(pInfoParm2,(long)pInfoParm);
				pInfoParm2->pi_id = 'S';
			}
#else
			cl_gx_copy_info(pInfoParm2,pInfoParm);
#endif
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_mk_info_parm2: pInfoParm2=",pInfoParm2,0,0);
		}
	}
	ir2s = *ipr2s;
	if (cl_gx_expand(ms_pp2stk,ir2s,&pp2stk) < 0) return -1;
	pp2stk[ir2s++] = pInfoParm1;
	*ipr2s = ir2s;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
#if 1	/* 2019.5.17 */
static int _kakko(ppmstk,irs,pW,opt,pmstk,dastk)
tdtInfoParm *pmstk,*pW,*ppmstk[];
int irs,opt;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc,iFunc,optW;
	char id;

	i = irs;
	while (i >= 0) {	/* '['T[` */
		pm = ppmstk[i];

DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko:search'[': i=%d ",pm,i,0);

		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {	/* '[' */
			if (pm->pi_pos != 2) return -1;
			else {
				rc = cl_set_list(pW,irs-i,&ppmstk[i+1]);
				pW->pi_id = D_DATA_ID_NARABI;
				if (rc) i = cl_gx_conv_rc(rc, ECL_GX_FUNC_ERROR1);
				return i;
			}
		}
		i--;
	}
	/* '['܂B */
	ERROROUT2(FORMAT(76),"_kakko","[");
	return i;
}
#else
static int _kakko(ppmstk,irs,pW,opt,dastk,ir2s,ms_pp2stk)
tdtInfoParm *pW,*ppmstk[];
int irs,opt,*ir2s;
char *dastk[];
MCAT *ms_pp2stk;
{
	tdtInfoParm *pm;
	int i,rc;

	i = irs;
	while (i >= 0) {	/* '('T[` */
		pm = ppmstk[i];
#if 1
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko:search'[': i=%d ",pm,i,0);
		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {	/* '[' */
			if (pm->pi_pos != 2) return -1;
#else
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko:search'(': i=%d ",pm,i,0);
		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {	/* '(' */
			if (pm->pi_pos) return -1;
#endif
			if (i < irs) {
				pm = ppmstk[irs];
#if 1
#if 0	/* 2015.10.18 */
				if (irs-i > 1) {	/* ()ɂQȏ゠ */
#endif
					if (_mk_info_parm2(irs-i,&ppmstk[i+1],opt,&dastk[i+1],ir2s,ms_pp2stk)) return -1;
				/*	if (rc=_ex_conv_parm_opt(&pm,0,dastk[irs])) return rc;	*/
					if (pm->pi_id == D_DATA_ID_STOREVAR) pm = (tdtInfoParm *)pm->pi_pos;
					cl_gx_copy_info(pW,pm);
				/*	pW->pi_alen |= D_AULN_PARMINFO2;	*/
					pW->pi_alen |= D_AULN_DATA_NARABI;
#if 0	/* 2015.10.18 */
				}
				else cl_gx_copy_info(pW,pm);	/* ()ɂ͂P */
#endif
#else
				if (rc=_ex_conv_parm_opt(&pm,0,dastk[irs])) return rc;
				cl_gx_copy_info(pW,pm);
				if (irs-i > 1) {
					if (_mk_info_parm2(irs-i,&ppmstk[i+1],opt,&dastk[i+1],ir2s,ms_pp2stk)) return -1;
					pW->pi_alen |= D_AULN_PARMINFO2;
				}
#endif
			}
			else {
				pW->pi_id = '\0';
			}
			return i;
		}
		i--;
	}
	ERROROUT(FORMAT(139));	/* _kakko: '('܂B */
	return i;
}
#endif
#if 1	/* 2019.5.18 */
int _kakko_tenkai(mcat,tInfoParm2,pInfoParm)
MCAT *mcat;
tdtInfoParm tInfoParm2[],*pInfoParm;
{
	static MCAT tmcat={'M','C',256,0,0,0,NULL,0};
	int  i,rc,len,nparm;
	char *p;
	tdtInfoParm tInfoParm,*pInfoParmW,*pInfoParm1,*pW,*pInfo;
	tdtRbCtl *pCt;

DEBUGOUTL2(120,"_kakko_tenkai:Enter: mcat=%08x tInfoParm2=%08x",mcat,tInfoParm2);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_kakko_tenkai: pInfoParm=",pInfoParm,0,0);
	if (!mcat) {
		mcat = &tmcat;
		mcat->mc_ipos = 0;
	}
#if 0	/* 2019.6.1 */
	if (pInfoParm->pi_id == 'N') {
		pCt = (tdtRbCtl *)pInfoParm->pi_data;
		if (akxs_rb_used(pCt)) {
			akxs_rb_read(pCt,0);
			while (pW=(tdtInfoParm *)akxs_rb_read(pCt,1)) {
				if (rc=_ex_conv_parm_opt(&pW,0,"")) return rc;
				if (pW->pi_id=='N' || (pW->pi_alen & D_AULN_PARMINFO2)) {
					if ((rc=_kakko_tenkai(mcat,NULL,pW)) < 0) return rc;
				}
				else {
					if ((rc=akxtmcat(mcat,pW,sizeof(tdtInfoParm))) < 0) return rc;
				}
			}
		}
	}
	else 
#endif
	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
		pInfoParm1 = pInfoParm + 1;
		if (nparm=pInfoParm1->pi_pos) {
			pInfo = (tdtInfoParm *)pInfoParm1->pi_data;
			for (i=0;i<nparm;i++,pInfo++) {
				pW = pInfo;
				if (rc=_ex_conv_parm_opt(&pW,0,"?")) return rc;
#if 1	/* 2019.6.1 */
				if (pW->pi_alen & D_AULN_PARMINFO2) {
#else
				if (pW->pi_id=='N' || (pW->pi_alen & D_AULN_PARMINFO2)) {
#endif
					if ((rc=_kakko_tenkai(mcat,NULL,pW)) < 0) return rc;
				}
				else {
					if ((rc=akxtmcat(mcat,pW,sizeof(tdtInfoParm))) < 0) return rc;
				}
			}
		}
	}
	if (tInfoParm2) {
		pInfoParmW = tInfoParm2;
		len = mcat->mc_ipos;
		if (len > 0) {
			if (!(p=cl_tmp_const_malloc(len))) return ECL_MALLOC_ERROR;
			pInfoParm1 = pInfoParmW + 1;
			memset(pInfoParm1,0,sizeof(tdtInfoParm));
			nparm = len/sizeof(tdtInfoParm);
			pInfoParm1->pi_id = '2';
			pInfoParm1->pi_pos = nparm;
			pInfoParm1->pi_dlen = len;
			pInfoParm1->pi_data = p;
			pW = (tdtInfoParm *)mcat->mc_bufp;
			pInfoParm1 = (tdtInfoParm *)p;
			for (i=0;i<nparm;i++,pW++,pInfoParm1++) {
				cl_gx_copy_info(pInfoParm1,pW);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_kakko_tenkai: i=%d pInfoParm1=",pInfoParm1,i,0);
			}
			pInfoParm1 = (tdtInfoParm *)p;
			cl_gx_copy_info(pInfoParmW, &pInfoParm1[nparm-1]);
			pInfoParmW->pi_alen |= D_AULN_PARMINFO2;
		}
		else {
			memset(pInfoParmW,0,sizeof(tdtInfoParm));
		}
	}
DEBUGOUTL(120,"_kakko_tenkai:Exit:");
	return 0;
}
#else
/****************************************/
/*										*/
/****************************************/
static int _kakko_tenkai(mcat,ir2s,pp2stk)
MCAT *mcat;
int ir2s;
tdtInfoParm *pp2stk[];
{
	tdtInfoParm *pInfoParm1,*pInfoParm,*pW;
	int i,nparm,rc;

DEBUGOUTL1(LVL_GXEXOBJ,"_kakko_tenkai:Enter:ir2s=%d",ir2s);
	pInfoParm1 = pp2stk[--ir2s];
	pInfoParm = (tdtInfoParm *)pInfoParm1->pi_data;
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko_tenkai:Top:",pInfoParm,0,0);
	nparm = pInfoParm1->pi_pos;
	pInfoParm += (nparm-1);
	for (i=0;i<nparm;i++,pInfoParm--) {
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko_tenkai: i=%d ",pInfoParm,i,0);
	/*	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {	*/
#if 1	/* 2015.11.15 */
		pW = pInfoParm;
	/*	if (pW->pi_id == D_DATA_ID_STOREVAR) pW = (tdtInfoParm *)pW->pi_pos;	*/
		if (pW->pi_alen & D_AULN_DATA_NARABI) {
#else
		if (pInfoParm->pi_alen & D_AULN_DATA_NARABI) {
#endif
			ir2s = _kakko_tenkai(mcat,ir2s,pp2stk);
		}
		else {
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_kakko_tenkai:i=%d",pInfoParm,i,0);
			rc = akxtmcat(mcat,pInfoParm,sizeof(tdtInfoParm));
			if (rc < 0) return rc;
		}
	}
	return ir2s;
}
#endif

/****************************************/
/*										*/
/****************************************/
void _reset_addr(ppmstk,pmstk,irs)
tdtInfoParm *pmstk,*ppmstk[];
int irs;
{
	int i;
/*
printf("_reset_addr: irs=%d\n",irs);
*/
	for (i=0;i<=irs;i++,pmstk++,ppmstk++) *ppmstk = pmstk;
}

/****************************************/
/*										*/
/****************************************/
static int _new_class(ppmstk,irs,pW,dastk)
tdtInfoParm *pW,*ppmstk[];
int irs;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc;

	i = cl_get_data_long(pW);
/*
printf("_new_class: irs=%d i=%d\n",irs,i);
*/
	ppmstk[i+1] = ppmstk[i];
	dastk[i+1] = dastk[i];
	rc = cl_func_new(pW,irs-i,&ppmstk[i+1]);
	if (!rc) rc = i;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _rep_info_set3(mc,ppInfoParm1,pInfoParm2,opt,da1,ir2s,pp2stk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *da1;
int ir2s;
tdtInfoParm *pp2stk[];
{
#if 0	/* 2019.5.17 */
	static MCAT mcat1={'M','C',256,0,0,0,NULL,0};
	static MCAT mcat2={'M','C',256,0,0,0,NULL,0};
#endif
	int rc,i,i1,n1,n2,optW,m,iPARMINFO2;
	tdtInfoParm *pInfoParm1,*pInfo1,*pInfo2,*pW1,*pW2,*pInfoParm;
	tdtRbCtl *pCt1,*pCt2;

	pInfoParm1 = *ppInfoParm1;
#if 1	/* 2019.5.17 */
	pCt1 = (tdtRbCtl *)pInfoParm1->pi_data;
	n1 = akxs_rb_used(pCt1);
	if (iPARMINFO2 = (pInfoParm2->pi_alen & D_AULN_PARMINFO2)) {
		pInfo2 = pInfoParm2 + 1;
		n2 = pInfo2->pi_pos;
		pInfo2 = (tdtInfoParm *)pInfo2->pi_data;
		pInfo2--;
	}
	else {
		pCt2 = (tdtRbCtl *)pInfoParm2->pi_data;
		n2 = akxs_rb_used(pCt2);
		akxs_rb_read(pCt2,0);
	}
	optW = opt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
	optW |= D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set3:n1=%d n2=%d",n1,n2);
	akxs_rb_read(pCt1,0);
	for (i=0;i<n1;i++) {
		if (i < n1) pInfo1 = (tdtInfoParm *)akxs_rb_read(pCt1,1);
		if (i < n2) {
			if (iPARMINFO2) pInfo2++;
			else pInfo2 = (tdtInfoParm *)akxs_rb_read(pCt2,1);
		}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pInfo1:",pInfo1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pInfo2:",pInfo2,0,0);
		pW1 = pInfo1;
		pW2 = pInfo2;
		if (rc=_ex_conv_parm_opt(&pW1,optW,da1)) return rc;
		if (rc=_ex_conv_parm_opt(&pW2,0,da1)) return rc;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW1:",pW1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW2:",pW2,0,0);
		if (rc = cl_gx_rep_info_set_name(pW1,pW2,1,da1)) return rc;
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set3:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
	}
	*ppInfoParm1 = pW1;
	return 0;
#else
	if (pInfoParm2->pi_alen & D_AULN_PARMINFO2) {
		n2 = pInfoParm2[1].pi_pos;
		pInfo2 = (tdtInfoParm *)pInfoParm2[1].pi_data;
		pInfo2--;
		m = -1;
	}
	else {
		mcat2.mc_ipos = 0;
		ir2s = _kakko_tenkai(&mcat2,ir2s,pp2stk);
		if (ir2s < 0) return ir2s;
		i1 = mcat2.mc_ipos;
		n2 = i1/sizeof(tdtInfoParm);
		pInfo2 = (tdtInfoParm *)(mcat2.mc_bufp + i1);
		m = 1;
	}
	mcat1.mc_ipos = 0;
	ir2s = _kakko_tenkai(&mcat1,ir2s,pp2stk);
	if (ir2s < 0) return ir2s;
	i1 = mcat1.mc_ipos;
	n1 = i1/sizeof(tdtInfoParm);
	pInfo1 = (tdtInfoParm *)(mcat1.mc_bufp + i1);
	n = X_MAX(n1,n2);
	optW = opt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
	optW |= D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
DEBUGOUTL3(LVL_GXEXOBJ,"_rep_info_set3:n1=%d n2=%d n=%d",n1,n2,n);
	for (i=0;i<n;i++) {
		if (i < n1) pInfo1--;
		if (i < n2) pInfo2 -= m;
		pW1 = pInfo1;
		pW2 = pInfo2;
		if (rc=_ex_conv_parm_opt(&pW1,optW,da1)) return rc;
		if (rc=_ex_conv_parm_opt(&pW2,0,da1)) return rc;
		if (i == 0) *ppInfoParm1 = pW1;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW1:",pW1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW2:",pW2,0,0);
		if (rc = cl_gx_rep_info_set_name(pW1,pW2,1,da1)) return rc;
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set3:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
	/*
		if (*da1=='<') {
			if (rc = cl_gx_clear_var90(pInfo1,da1)) return rc;
		}
	*/
	}
#endif
}

/****************************************/
/*										*/
/****************************************/
static int _rep_info_set2(mc,ppInfoParm1,pInfoParm2,opt,da1,ir2s,pp2stk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *da1;
int ir2s;
tdtInfoParm *pp2stk[];
{
	int rc,i,nparm,optW;
	tdtInfoParm *pm,*pInfoParm,*pInfoParm1,*pmW;
	tdtRbCtl *pCt;

	pInfoParm1 = *ppInfoParm1;
#if 1	/* 2019.5.17 */
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set2:Enter mc=%d",pInfoParm1,mc,0);
	if (pInfoParm1->pi_id == 'N') {
		pCt = (tdtRbCtl *)pInfoParm1->pi_data;
		if (akxs_rb_used(pCt)) {
			akxs_rb_read(pCt,0);
			while (pmW=(tdtInfoParm *)akxs_rb_read(pCt,1)) {
				ir2s = _rep_info_set2(mc,&pmW,pInfoParm2,opt,da1,ir2s,pp2stk);
				if (ir2s < 0) return ir2s;
			}
		/*	*ppInfoParm1 = pmW;	*/
		}
	}
	else {
#else
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set2:Enter mc=%d ir2s=%d",pInfoParm1,mc,ir2s);
/*	if (pInfoParm1->pi_alen & D_AULN_PARMINFO2) {	*/
	if (pInfoParm1->pi_alen & D_AULN_DATA_NARABI) {
		pm = pp2stk[--ir2s];
		pInfoParm = (tdtInfoParm *)pm->pi_data;
		nparm = pm->pi_pos;
		pInfoParm += (nparm-1);
DEBUGOUTL1(LVL_GXEXOBJ,"_rep_info_set2: nparm=%d",nparm);
		for (i=0;i<nparm;i++,pInfoParm--) {
			pmW = pInfoParm;
		/*	if (rc=_ex_conv_parm_opt(&pInfoParm1,optW,da1)) return rc;	*/
			ir2s = _rep_info_set2(mc,&pmW,pInfoParm2,opt,da1,ir2s,pp2stk);
			if (ir2s < 0) return ir2s;
		}
	}
/*	else {	*/
#endif
		optW = opt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
		optW |= D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
		if (rc=_ex_conv_parm_opt(&pInfoParm1,optW,da1)) return rc;
		if (rc = cl_gx_rep_info_set_name(pInfoParm1,pInfoParm2,1,da1)) return rc;
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set2:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
		if (*da1=='<') {
			if (rc = cl_gx_clear_var90(pInfoParm1,da1)) return rc;
		}
		*ppInfoParm1 = pInfoParm1;
#if 1	/* 2019.5.17 */
	}
#else
/*	}	*/
#endif
	return ir2s;
}

/****************************************/
/*										*/
/****************************************/
static int _rep_info_set(mc,ppInfoParm1,pInfoParm2,opt,da1,ir2s,pp2stk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *da1;
int ir2s;
tdtInfoParm *pp2stk[];
{
	int rc,i,nparm,optW;
	tdtInfoParm *pm,*pInfoParm,*pInfoParm1,*pmW;

	pInfoParm1 = *ppInfoParm1;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set:Enter mc=%d ir2s=%d pInfoParm1=",pInfoParm1,mc,ir2s);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set:pInfoParm2=",pInfoParm2,0,0);
#if 1	/* 2019.5.17 */
	if ((pInfoParm1->pi_id=='N') &&
	    ((pInfoParm2->pi_id=='N') || (pInfoParm2->pi_alen & D_AULN_PARMINFO2))) {
#else
	if ((pInfoParm1->pi_alen & D_AULN_DATA_NARABI) &&
	    (pInfoParm2->pi_alen & (D_AULN_DATA_NARABI | D_AULN_PARMINFO2))) {
#endif
		rc = _rep_info_set3(mc,ppInfoParm1,pInfoParm2,opt,da1,ir2s,pp2stk);
	}
	else {
		rc = _rep_info_set2(mc,ppInfoParm1,pInfoParm2,opt,da1,ir2s,pp2stk);
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _mk_obj_stack(pbxObj)
GXObject *pbxObj;
{
	int im,cnt;

	if (!pbxObj) return -1;
	if (pbxObj->nobj <= 0) return 0;

	im = D_OPT_ALC_TMP;
	cnt = (pbxObj->nobj+3)/2 & ~0x01;
	if (!(pbxObj->stack = (char **)cl_opt_malloc(im,6*sizeof(char *)))) return ECL_MALLOC_ERROR;
	if (!(pbxObj->stack[0] = cl_opt_malloc(im,cnt*(
	/* pp2stk,"P2" */	  sizeof(tdtInfoParm *)
	/* ppmstk,"PM" */	+ sizeof(tdtInfoParm *)
	/* pmstk,"MS" */	+ sizeof(tdtInfoParm)
	/* ppmstack,"PS" */	+ sizeof(tdtInfoParm *)
	/* stack,"ST" */	+ sizeof(short)
	/* dastk,"DS" */	+ sizeof(char *))))) return ECL_MALLOC_ERROR;
	pbxObj->stack[1] = pbxObj->stack[0] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[2] = pbxObj->stack[1] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[3] = pbxObj->stack[2] + cnt*sizeof(tdtInfoParm);
	pbxObj->stack[4] = pbxObj->stack[3] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[5] = pbxObj->stack[4] + cnt*sizeof(short);
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_ex_obj(Obj,pGxObj,pInfoParmW,iOpt)
tdtInfoParm **Obj;
GXObject *pGxObj;
tdtInfoParm *pInfoParmW;
int iOpt;
{
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	static char *name="cl_gx_ex_obj";
	int ida;
	char **da,**obj_stack;
	short *obj;
	int iob;
	int irs,ir2s,irs_max;
	int iMAX_PMSTK,iMAX_STACK;
	MCAT Ms_pp2stk,Ms_ppmstk,Ms_pmstk,Ms_ppmstack,Ms_stack,Ms_dastk;
	tdtInfoParm **pp2stk;
	tdtInfoParm **ppmstk;
	tdtInfoParm *pmstk,**ppmstack;
	short *stack;
	char **dastk;
	char *da1,*da2,*da3,id,id2,*p1,*p2;
/*	int i,scale,rc,opt,iEROUT_NDEF=1,opt0,optW;	*/
	int i,scale,rc,opt0,optW,opt1,im,val,opt2;
	char pOperator[32], *pWork, *p, c;
	tdtInfoParm InfoParm1,*pInfoParm1,InfoParmW2[2];
	tdtInfoParm InfoParm2,*pInfoParm2,*pInfoParm,**obj0;
	tdtInfoParm InfoParm3,*pInfoParm3;
	parmList  *prmL, qprmL;
	int sp,atr,attr0,i1,i2,amc,mc,atrn,iFN_level,iAR_level,len,len1,len2,aux1,iDEF_ZOK_DATA;
	int ib,ib0,kind;

	if (!pGxObj) return -1;
	iob = pGxObj->nobj;
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj: *** start nobj=%d iOpt=%08x",iob,iOpt);
	if (iob<1) return 100;
	obj = pGxObj->obj;
	if (iob>=1 && obj[0]==99) return 100;
	da  = pGxObj->da;
	obj0 = Obj;

	iMAX_PMSTK = (iob+1)/2;
	iMAX_STACK = iMAX_PMSTK;
#if 1
	if (rc=_mk_obj_stack(pGxObj)) return rc;
	obj_stack = pGxObj->stack;
	pp2stk = (tdtInfoParm **)obj_stack[0];
	ppmstk = (tdtInfoParm **)obj_stack[1];
	pmstk = (tdtInfoParm *)obj_stack[2];
	ppmstack = (tdtInfoParm **)obj_stack[3];
	stack = (short *)obj_stack[4];
	dastk = (char **)obj_stack[5];
	if (pGxObj->index0) {
		if (pGxObj->index0 & 0x01)
			cl_gx_init_set_expand(&Ms_pp2stk,"P2",sizeof(tdtInfoParm *),iMAX_PMSTK,pp2stk);
		if (pGxObj->index0 & 0x02) {
			cl_gx_init_set_expand(&Ms_ppmstack,"PS",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstack);
			cl_gx_init_set_expand(&Ms_stack,"ST",sizeof(short),iMAX_STACK,stack);
		}
		if (pGxObj->index0 & 0x04) {
			cl_gx_init_set_expand(&Ms_ppmstk,"PM",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstk);
			cl_gx_init_set_expand(&Ms_pmstk,"MS",sizeof(tdtInfoParm),iMAX_PMSTK,pmstk);
			cl_gx_init_set_expand(&Ms_dastk,"DS",sizeof(char *),iMAX_PMSTK,dastk);
		}
	}
#else
	cl_gx_init_expand(&Ms_pp2stk,"P2",sizeof(tdtInfoParm *),iMAX_PMSTK);
	cl_gx_init_expand(&Ms_ppmstk,"PM",sizeof(tdtInfoParm *),iMAX_PMSTK);
	cl_gx_init_expand(&Ms_pmstk,"MS",sizeof(tdtInfoParm),iMAX_PMSTK);
	cl_gx_init_expand(&Ms_ppmstack,"PS",sizeof(tdtInfoParm *),iMAX_PMSTK);
	cl_gx_init_expand(&Ms_stack,"ST",sizeof(short),iMAX_STACK);
	cl_gx_init_expand(&Ms_dastk,"DS",sizeof(char *),iMAX_PMSTK);
	cl_gx_expand(&Ms_pp2stk,0,&pp2stk);
	cl_gx_expand(&Ms_ppmstk,0,&ppmstk);
	cl_gx_expand(&Ms_pmstk,0,&pmstk);
	cl_gx_expand(&Ms_ppmstack,0,&ppmstack);
	cl_gx_expand(&Ms_stack,0,&stack);
	cl_gx_expand(&Ms_dastk,0,&dastk);
#endif

	if (!pInfoParmW) pInfoParmW = InfoParmW2;
	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	if (iOpt & D_GX_OPT_PARMINFO2) memset(pInfoParmW+1,0,sizeof(tdtInfoParm));
	stack[0]=0;
	sp=0;
	irs=ir2s=0;
	atr=0;
	ida=0;
	im = (iOpt & D_GX_OPT_ALC_MASK)>>12;
	iEROUT_NDEF = !(iOpt & D_GX_OPT_NOEROUT_NDEF);
/*	opt = 0;	*/
	opt0 = iOpt | D_GX_OPT_STORE;
	opt1 = D_GX_OPT_SET_ADDR | D_GX_OPT_NOEROUT_NDEF |
	       (iOpt & (D_GX_OPT_STORE | D_GX_OPT_GET_ADDR));
	opt2 = opt0;	/*iOpt;*/
	ib0=ib=irs=iFN_level=iAR_level=0;
	while (ib<iob) {
		mc = obj[ib++];
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:ib+1=%d,mc=%d",ib,mc);
		if (!mc) {	/* NOP */
			continue;
		}
		else if (mc==99) {

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:sp=%d, irs=%d",sp,irs);

		/*	if (irs<=0) return -5;	*/
			if (irs<0) return -5;
#if 0
			else if (irs>1) {
				ERROROUT1(FORMAT(128),name);	/* %s: Zq܂B */
				return -2;
			}
			else if (irs==1) {
#else
			else if (irs>=1) {
#endif
				pInfoParm = ppmstk[--irs];
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:end: irs=%d",pInfoParm,irs,0);
				iDEF_ZOK_DATA = pInfoParm->pi_aux[0] & DEF_ZOK_DATA;
				if ((iOpt & D_GX_OPT_GET_ADDR) && (pInfoParm->pi_id==D_DATA_ID_STOREVAR)) {
					cl_gx_copy_info(pInfoParmW,pInfoParm);
				}
				else {
					da1 = dastk[irs];
					optW = iOpt & (D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_STORE | D_GX_OPT_GET_ADDR);
					if (iOpt & D_GX_OPT_GET_ADDR) optW |= D_GX_OPT_SET_ADDR;
					aux1 = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
					if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) return rc;
					if (cl_is_undef_parm(pInfoParm)) {
						if (!(iOpt & D_GX_OPT_NOERROR_NDEF)) rc = ECL_NDEFVAR_ERROR;
										/* %s: %s̃f[^ݒłB */
						if (iEROUT_NDEF) ERROROUT1(FORMAT(127),name);
						return rc;
					}
#if 1	/* 2019.5.17 */
					if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
						memcpy(pInfoParmW,pInfoParm,sizeof(tdtInfoParm)*2);
					}
					else
#endif
					cl_gx_copy_info(pInfoParmW,pInfoParm);

					if (pInfoParmW->pi_scale & D_DATA_ARRAY_INDEX) {
						/* %s: [%s]indexw肪܂B */
						ERROROUT2(FORMAT(129),name,da1);
						return ECL_EX_LET;
					}
					pInfoParm->pi_aux[1] |= aux1;
					pInfoParm->pi_aux[0] |=iDEF_ZOK_DATA;
				}
#if 1
#if 1	/* 2019.5.17 */
				if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) ;
				else 
#endif
				if (iOpt & D_GX_OPT_PARMINFO2) {
				/*	cl_gx_expand(&Ms_pp2stk,-1,&pp2stk);	*/
					pInfoParm1 = pInfoParmW + 1;
					memset(pInfoParm1,0,sizeof(tdtInfoParm));
/*
printf("cl_gx_ex_obj: irs=%d\n",irs);
*/
				/*	if (irs>=1 || (pInfoParmW->pi_alen & D_AULN_PARMINFO2)) {	*/
					if (irs>=1 || (pInfoParmW->pi_alen & D_AULN_DATA_NARABI)) {
						mcat.mc_ipos = 0;
						for (i=irs;i>=0;i--) {
							pInfoParm = ppmstk[i];
#if 0	/* 2019.5.17 */
						/*	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {	*/
							if (pInfoParm->pi_alen & D_AULN_DATA_NARABI) {
								ir2s = _kakko_tenkai(&mcat,ir2s,pp2stk);
							}
							else {
#endif
#if 0	/* 2015.10.25 */
								da1 = dastk[i];
								optW = iOpt & D_GX_OPT_NOEROUT_NDEF;
								if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) {
									pInfoParm1->pi_hlen = rc;
									pInfoParm1->pi_len++;
								/*	return rc;	*/
								}
								else if (cl_is_undef_parm(pInfoParm)) {
									pInfoParm1->pi_hlen = ECL_NDEFVAR_ERROR;
									pInfoParm1->pi_len++;
													/* %s: %s̃f[^ݒłB */
									if (iEROUT_NDEF) ERROROUT1(FORMAT(127),name);
								/*	return rc;	*/
								}
								else
#endif	/* 2015.10.25 */
									akxtmcat(&mcat,pInfoParm,sizeof(tdtInfoParm));
/*
printf("cl_gx_ex_obj: i=%d da1=[%s] pi_hlen=%d\n",i,da1,pInfoParm1->pi_hlen);
*/
#if 0	/* 2019.5.17 */
							}
#endif
						}
						i1 = mcat.mc_ipos;
						if (!(p=cl_tmp_const_malloc(i1))) {
							pInfoParm1->pi_hlen = ECL_MALLOC_ERROR;
							return 0;
						}
						irs = i1/sizeof(tdtInfoParm);
						pInfoParm1->pi_id = '2';
						pInfoParm1->pi_pos = irs;
						pInfoParm1->pi_dlen = i1;
						pInfoParm1->pi_data = p;
						pInfoParm1->pi_aux[0] |= iDEF_ZOK_DATA;
						pInfoParm2 = (tdtInfoParm *)p;
						p = mcat.mc_bufp + i1 - sizeof(tdtInfoParm);
						for (i=0;i<irs;i++,pInfoParm2++) {
#if 1	/* 2015.10.25 */
							pInfoParm = (tdtInfoParm *)p;
							optW = iOpt & D_GX_OPT_NOEROUT_NDEF;
							if (rc=_ex_conv_parm_opt(&pInfoParm,optW,"?")) {
								pInfoParm1->pi_hlen = rc;
								pInfoParm1->pi_len++;
							}
							else if (cl_is_undef_parm(pInfoParm)) {
								pInfoParm1->pi_hlen = ECL_NDEFVAR_ERROR;
								pInfoParm1->pi_len++;
												/* %s: %s̃f[^ݒłB */
								if (iEROUT_NDEF) ERROROUT1(FORMAT(127),name);
							}
							else {
								cl_gx_copy_info(pInfoParm2,pInfoParm);
								pInfoParm2->pi_aux[0] |= iDEF_ZOK_DATA;
							}
#else
							cl_gx_copy_info(pInfoParm2,p);
#endif	/* 2015.10.25 */
							p -= sizeof(tdtInfoParm);
						}
						pInfoParmW->pi_alen |= D_AULN_PARMINFO2;
					}
				}
#endif
			/*	pInfoParmW->pi_alen &= ~D_AULN_PARMINFO2;	*/
			}
			else {
				memset(pInfoParmW,0,sizeof(tdtInfoParm));
				if (iOpt & D_GX_OPT_PARMINFO2)
					memset(pInfoParmW+1,0,sizeof(tdtInfoParm));
			}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:exit:",pInfoParmW,0,0);

			for (i=0;i<sp;i++) {
				if (rc = cl_gx_let_ppmm(stack[i],ppmstack[i])) return rc;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"LAST cl_gx_let_ppmm:rc=%d",ppmstack[i],rc,0);
			}
			return 0;
		}
		else if (mc == 91) {
		/*
			if (cl_gx_expand(&Ms_dastk,irs,&dastk) < 0) return -3;
			if (cl_gx_expand(&Ms_pmstk,irs,&pmstk) < 0) return -3;
			if ((irs_max=cl_gx_expand(&Ms_ppmstk,irs,&ppmstk)) < 0) return -3;
			else if (irs_max) _reset_addr(ppmstk,pmstk,irs);
		*/
			ida = obj[ib++];
			dastk[irs] = da[ida];
			ib0 = ida;
			if (!(pInfoParm=(tdtInfoParm *)obj0[ib0])) {
#if 1
				return -7;
#else
				if (!(pInfoParm=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
					return ECL_MALLOC_ERROR;
				pInfoParm->pi_id = '\0';
				obj0[ib0] = (long)pInfoParm;
#endif
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 91:1:ida=%d da=[%s]",pInfoParm,ida,da[ida]);
			if ((c=pInfoParm->pi_id)=='S' && !pInfoParm->pi_pos) {
				optW = opt1;
			/*	i = pInfoParm->pi_aux[1];
				if (i & D_AUX1_LOCAL_VAR) optW |= D_GX_OPT_SET_LOCAL;
				else if (i & D_AUX1_GLOBAL_VAR) optW |= D_GX_OPT_SET_GLOBAL;
				else if (i & D_AUX1_PUBLIC_VAR) optW |= D_GX_OPT_SET_PUBLIC;
				else if (i & D_AUX1_PRIVATE_VAR) optW |= D_GX_OPT_SET_PRIVATE;	*/
				if (rc=_conv_arg_opt(da[ida],pInfoParm,optW)) return rc;
			}
			else if (!c) {
				if (rc=_conv_arg_opt(da[ida],pInfoParm,opt1)) return rc;
			/*	if (rc=_rep_data_memory(im,pInfoParm)) return rc;	*/
			}
			if (pInfoParm->pi_aux[1] == D_AUX1_FUNC_ARRY) {
				if ((i=pInfoParm->pi_pos) == 2) iAR_level++;
				else if (i) iFN_level++;
			}
			ib0++;
			cl_gx_copy_info(pInfoParmW,pInfoParm);
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			pInfoParm = &pmstk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 91:2:ida=%d da=[%s]",pInfoParm,ida,da[ida]);

			ppmstk[irs++] = pInfoParm;

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:irs=%d, attr=%d",irs,pInfoParm->pi_attr);

		}
		else if (mc == 92) {
		/*
			if (cl_gx_expand(&Ms_dastk,irs,&dastk) < 0) return -3;
			if (cl_gx_expand(&Ms_pmstk,irs,&pmstk) < 0) return -3;
			if ((irs_max=cl_gx_expand(&Ms_ppmstk,irs,&ppmstk)) < 0) return -3;
			else if (irs_max) _reset_addr(ppmstk,pmstk,irs);
		*/
			ida = obj[ib++];
			if (rc=_conv_arg_opt(da[ida],pInfoParmW,opt1)) return rc;
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			pInfoParm = &pmstk[irs];
			dastk[irs] = da[ida];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 92:ida=%d da=[%s]",pInfoParm,ida,da[ida]);

			ppmstk[irs++] = pInfoParm;
		}
#if 1
		else if (mc == 6) {	/* z */
#else
		else if (mc == 3) {	/* z */
#endif

DEBUGOUTL4(LVL_GXEXOBJ,"cl_gx_ex_obj: mc=%d, irs=%d, attr=%d opt2=%08x",
mc,irs,pInfoParmW->pi_attr,opt2);

			irs=cl_gx_array3(ppmstk,--irs,pInfoParmW,opt2,pmstk,dastk);
			if (irs < 0) return irs;
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
#if 1
			da1 = dastk[irs];
			da2 = "[]";
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(da2)+1)))
				return ECL_MALLOC_ERROR;
			strcpy(p,da1);
			strcat(p,da2);
			dastk[irs] = p;
#endif
			irs++;
			iAR_level--;
		}
#if 1
		else if (mc==3) {	/* [f[^] */
#else
		else if (mc==1) {	/* () */
#endif
			da1 = dastk[irs-1];
#if 1	/* 2019.5.17 */
			irs = _kakko(ppmstk,--irs,pInfoParmW,opt0,pmstk,dastk);
#else
			irs = _kakko(ppmstk,--irs,pInfoParmW,opt0,dastk,&ir2s,&Ms_pp2stk);
#endif
			if (irs < 0) return irs;
			else if (pInfoParmW->pi_id) {
				cl_gx_copy_info(&pmstk[irs],pInfoParmW);
				ppmstk[irs] = &pmstk[irs];
				dastk[irs] = da1;
				irs++;
			}
/*
printf("cl_gx_ex_obj: ir2s=%d\n",ir2s);
*/
		}
		else if (mc==5 || mc==7) {	/* ֐ {} */

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj:mc=%d, irs=%d, attr=%d",mc,irs,pInfoParmW->pi_attr);

			rc = cl_gx_func(ppmstk,--irs,pInfoParmW,opt0,pmstk,dastk);

DEBUGOUTL1(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_func rc=%d",rc);

			if (rc < 0) return rc;
			else if (rc == ECL_FUNC_CLASS) {
				rc = -1;
				if (ib<iob) {
					mc = obj[ib++];
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:func_class:ib+1=%d,mc=%d",ib,mc);
					if (mc == -13) {
						rc = _new_class(ppmstk,irs,pInfoParmW,dastk);
						if (rc < 0) return rc;
					}
				}
				if (rc < 0) {
					/* %s: New܂B */
					ERROROUT1(FORMAT(137),name);
					return ECL_SCRIPT_ERROR;
				}
			}
			irs = rc;
#if 0
			pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
#endif
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
#if 1
			da1 = dastk[irs];
			da2 = FORMAT(131);	/* ֐(%s)̖߂l */
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(da2)+1)))
				return ECL_MALLOC_ERROR;
			sprintf(p,da2,da1);
			dastk[irs] = p;
#endif
			irs++;
			iFN_level--;
		}
		else if (mc == 60) {	/* : */
			continue;
		}
		else if (mc == 93) {	/* GOTO */
#if 1	/* 2019.4.7 */
			ib += obj[ib];
#else
			ib = obj[ib];
#endif
			if (ib <= 0) {
				return -6;
			}
			continue;
		}
		else if (mc == D_IMD_RANGE) {	/* .. */

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj:mc=%d, irs=%d, attr=%d",mc,irs,pInfoParmW->pi_attr);

			optW = opt0;
#if 1
			if (iAR_level+iFN_level)
#endif
				optW |= D_GX_OPT_GET_RANGE;
			irs=cl_gx_range(ppmstk,--irs,pInfoParmW,optW,pmstk,dastk,
			                &Ms_ppmstk,&Ms_pmstk,&Ms_dastk);
			if (irs < 0) return irs;
			if ((optW & D_GX_OPT_PARMINFO2) && !(optW & D_GX_OPT_GET_RANGE)) {
				cl_gx_expand(&Ms_dastk,-1,&dastk);
				cl_gx_expand(&Ms_pmstk,-1,&pmstk);
				cl_gx_expand(&Ms_ppmstk,-1,&ppmstk);
			}
			else {
#if 1
				pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
#endif
				cl_gx_copy_info(&pmstk[irs],pInfoParmW);
				ppmstk[irs] = &pmstk[irs];
				dastk[irs] = FORMAT(134);	/* ͈͎w */
				irs++;
			}
		}
		else if (mc == 98) {	/* , */
			ib++;
		}
		else {

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: mc=%d, irs=%d, attr=%d",
mc,irs,pInfoParmW->pi_attr);

			amc = X_ABS(mc);
			if (amc <= 100) {
				if (!(p=_atr2ope(amc))) return -4;
			}
			else p = da[amc-1001];
			strcpy(pOperator,p);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj: sp=%d, opr=%s",sp,pOperator);

		/*******
			if (mc == 60) {
				if (irs<=0) return -5;
				cl_gx_copy_info(&InfoParm3,&pmstk[--irs]);
				pInfoParm3 = &InfoParm3;
				da3 = dastk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:pop3: irs=%d da3=[%s]",pInfoParm3,irs,da3);

			}
		*******/
			if (irs<=0) return -5;
			/****************/
			/*     pop2     */
			/****************/
			cl_gx_copy_info(&InfoParm2,&pmstk[--irs]);
			pInfoParm2 = &InfoParm2;
			da2 = dastk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:pop2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

#if 1	/* 2016.10.08 */
			if (pInfoParm2->pi_id==D_DATA_ID_PNAME && pInfoParm2->pi_attr==2 &&
			    mc!=90 && mc!=D_IMD_PNAME) {
				pInfoParm2->pi_id = D_DATA_ID_STOREVAR;

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: changed id=[%c] irs=%d da2=[%s]",pInfoParm2->pi_id,irs,da2);

			}
#endif
			if (mc < 0 ||
			    mc==28 ||						/* ABS */
		/*	    mc==36 ||	*/					/* != */
			    mc==59 ||						/* ? */
			    mc==79 || (mc>=14 && mc<=17)) {	/* ~= ++ -- || ~~*/
				pInfoParm1 = &InfoParm1;
#if 0	/* 2017.7.9 */
				if (amc==24 || amc==25)
					cl_set_parm_bin(pInfoParm1,0);
				else
					cl_none_parm(pInfoParm1);
#else
			/*	cl_set_parm_bin(pInfoParm1,0);	*/
				cl_none_parm(pInfoParm1);
#endif
				da1 = "";
			}
			else {
				if (irs<=0) return -5;
				/****************/
				/*     pop1     */
				/****************/
				cl_gx_copy_info(&InfoParm1,&pmstk[--irs]);
				pInfoParm1 = &InfoParm1;
				da1 = dastk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:pop1: irs=%d da1=[%s]",pInfoParm1,irs,da1);

#if 1	/* 2016.10.08 */
				if (pInfoParm1->pi_id==D_DATA_ID_PNAME && pInfoParm1->pi_attr==2 &&
				    mc!=D_IMD_NAMED) {
					pInfoParm1->pi_id = D_DATA_ID_STOREVAR;

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: changed id=[%c] irs=%d da2=[%s]",pInfoParm1->pi_id,irs,da1);

				}
#endif
				optW = iOpt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
				if (mc>=71 && mc<=90) {
					optW |= D_GX_OPT_STORE_CHK;
					if (mc==90) optW |= D_GX_OPT_STORE;
				}
				else if (mc == 29) optW |= D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;
				else optW = 0;
#ifdef DATA_NARABI
			  if (mc != 90)
#endif
				if (rc=_ex_conv_parm_opt(&pInfoParm1,optW,da1)) return rc;
			}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:1: irs=%d da1=[%s]",pInfoParm1,irs,da1);

			if ((mc>=71 && mc<=90) || (amc>=14 && amc<=17) ||
			    mc==D_IMD_PNAME || mc==D_IMD_NAMED) {
				if (mc==79 || (mc>=14 && mc<=17) || mc<0)
					optW = D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
				else optW = 0;
				if (rc=_ex_conv_parm_opt(&pInfoParm2,optW,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				if (optW) pInfoParm = pInfoParm2;
				else pInfoParm = pInfoParm1;
				if (((c=pInfoParm->pi_id)=='A' || c=='R') &&
				    (pInfoParm->pi_scale & D_DATA_INDEX_FREE)) {
					p = (char *)pInfoParm->pi_pos;
					/* %s: z(%s)ւ̑͂ł܂B */
					ERROROUT2(FORMAT(132),name,p);
					return ECL_EX_LET;
				}
				if (mc>=71 && mc<=89) {
					pOperator[strlen(pOperator)-1] = '\0';
					if (rc = cl_gx_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,0,NULL)) {
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:mc=%d rc=%d",mc,rc);
						return rc;
					}
					if (mc == 79) pInfoParm1 = pInfoParm2;
					rc = cl_gx_rep_info_set(pInfoParm1,pInfoParmW,1);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_rep_info_set:mc=%d rc=%d",mc,rc);
				}
				else if (mc == 90) {
#ifdef DATA_NARABI
					rc = 0;
					ir2s = _rep_info_set(mc,&pInfoParm1,pInfoParm2,iOpt,da1,ir2s,pp2stk);
					if (ir2s < 0) rc = ir2s;
#else
					rc = cl_gx_rep_info_set_name(pInfoParm1,pInfoParm2,1,da1);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
					if (!rc && *da1=='<') rc = cl_gx_clear_var90(pInfoParm1,da1);
#endif
				}
				else if (mc<=-14 && mc>=-17) {
					rc = cl_gx_let_ppmm(mc,pInfoParm2);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_let_ppmm:mc=%d rc=%d",mc,rc);
					pInfoParm1 = pInfoParm2;
				}
				else if (mc>=14 && mc<=17) {
					if (cl_gx_expand(&Ms_ppmstack,sp,&ppmstack) < 0) return -3;
					if (cl_gx_expand(&Ms_stack,sp,&stack) < 0) return -3;
					ppmstack[sp] = _info_parm_temp_dup(pInfoParm2);
					stack[sp++] = mc;
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:ppmstack:mc=%d sp=%d",mc,sp);
					pInfoParm1 = pInfoParm2;
				}
				if (mc==D_IMD_PNAME || mc==D_IMD_NAMED) {	/* <== ==> */
					if (mc == D_IMD_NAMED) {
						pInfoParm = pInfoParm2;
						pInfoParm2 = pInfoParm1;
						pInfoParm1 = pInfoParm;
						da3 = da1;
					}
					else da3 = da2;
					if ((atr=pInfoParm2->pi_attr) == 1) {
						rc = cl_chk_pname_name(pInfoParm2->pi_data);
					}
					else rc = -1;
					if (rc) {
						ERROROUT3(FORMAT(168),name,da3,atr);
						return ECL_SCRIPT_ERROR;
					}
					if (!(pInfoParm=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
						return ECL_MALLOC_ERROR;
					memset(pInfoParm,0,sizeof(tdtInfoParm));
					rc = cl_gx_rep_info_set(pInfoParm,pInfoParm1,1);
					cl_set_parm_long(pInfoParmW,(long)pInfoParm);
					pInfoParmW->pi_id = D_DATA_ID_PNAME;
					pInfoParmW->pi_paux = pInfoParm2->pi_data;
				}
				else {
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:1=: mc=%d",pInfoParm1,mc,0);
					cl_set_parm_long(pInfoParmW,(long)pInfoParm1);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
			}
			else if (mc == 59) {	/* ? */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				val = 0;
#if 1	/* 2019.3.10 */
#if 1	/* 2019.4.20 */
				kind = obj[ib++];
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:kind=%d iob=%d",kind,iob);
				if (kind <= 1)	/* IIF */
					val = cl_is_true(pInfoParm2);
				else if (kind == 2)		/* NVAL, NULLIF */
					val = cl_is_null_chk_null_parm(pInfoParm2);
				else if (kind == 3) {	/* NSVAL */
					val = cl_is_null_chk_null_parm(pInfoParm2);
					if (!val) val = cl_is_spaces(pInfoParm2);
				}
				else	/* NDEF */
					val = cl_is_ndef(pInfoParm2);
#else
				val = cl_is_true(pInfoParm2);
#endif
#else
				if (rc=cl_get_parm_bin(pInfoParm2,&val,"cl_gx_ex_obj:?:")) return rc;
#endif
				if (val < 0) return val;
				else if (!val) {
#if 1	/* 2019.4.7 */
					ib += obj[ib];
#else
					ib = obj[ib];
#endif
					if (ib <= 0) {
						return -6;
					}
				}
				else {
					ib++;
					if (kind > 0) ib += 3;
				}
				continue;
			}
			else if (mc == 20) {	/* CAST */
			/*	if (irs<=0) return -5;	*/
			/*	irs--;	*/
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				if (rc = cl_gx_cast(pInfoParmW,pInfoParm1,pInfoParm2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:CAST: mc=%d",pInfoParmW,mc,rc);

			}
			else if (mc == -21) {	/* *name */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: mc=%d irs=%d",pInfoParm2,mc,irs);

				id = pInfoParm2->pi_id;
				if (id==' ' && (pInfoParm2->pi_alen & D_AULN_RANGE_DATA)) ;
				else if (id!='A' && id!='R' && id!='T' && id!='L' && id!='N') {
					/* %s: %s'*'͎wł܂B */
					ERROROUT2(FORMAT(140),name,da2);
					return ECL_EX_LET;
				}
				cl_gx_copy_info(pInfoParmW,pInfoParm2);
				pInfoParmW->pi_aux[0] |= DEF_ZOK_DATA;
			}
			else if (mc == 29) {	/* .name */
/*
printf("cl_gx_ex_obj: da1=%s da2=%s\n",da1,da2);
*/
				id2 = pInfoParm2->pi_id;
				p2 = da2;
				if ((c=*p2) == '$') p2++;
#if 0
				else if (c=='%' || c=='#') {
					/* %s: o[[%s]słB */
					ERROROUT2(FORMAT(136),name,da2);
					return ECL_SCRIPT_ERROR;
				}
#endif
				len2 = strlen(p2);
				if ((id=pInfoParm1->pi_id)=='T') {
					optW = D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
#if 1
					if (rc=_ex_get_member(&pInfoParm1,optW,p2,len2)) return rc;
#else
					if (rc=_ex_get_member(&pInfoParm1,optW,pInfoParm2->pi_data+1,pInfoParm2->pi_dlen-1)) return rc;
#endif
					cl_set_parm_long(pInfoParmW,(long)pInfoParm1);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
				else if ((id=='F' || id=='M' || id=='O' || id=='U')&&
				         (id2=='F' || id2=='C' || id2=='O' || id2=='U' || id2==' ')) {
					len1 = pInfoParm1->pi_dlen;
					len = len1 + len2 + 1;
					if (!(p=cl_tmp_const_malloc(len+1))) return ECL_MALLOC_ERROR;
					p1 = pInfoParm1->pi_data;
					if (*p1 == '$') {
						p1++;
						len1--;
					}
					memcpy(p,p1,len1);
					memcpy(p+len1,".",1);
					memzcpy(p+len1+1,p2,len2);
					cl_set_parm_char(pInfoParmW,p,len1+len2+1);
				 	if (id2=='U' || id2==' ') pInfoParmW->pi_id = 'F';
				 	else pInfoParmW->pi_id = id2;
				}
				else if ((id==' ' || id=='A' || id=='R' || id=='L' || id=='N') && id2=='F') {
					if (rc=cl_set_system_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else if (id=='I') {
					if (rc=cl_set_instance_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else if (id=='C') {
					if (rc=cl_set_class_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else {
#if 1
					if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;
					if (rc=cl_gx_str_pos(pInfoParmW,pInfoParm1,optW,pInfoParm2)) {
#else
					if (rc=cl_gx_str_pos(pInfoParmW,pInfoParm1,optW,p2,len2)) {
#endif
						if (rc == ECL_SYNTAX_ERROR) {
#if 1
							/* %s: [%s]Ă܂B*/
							ERROROUT2(FORMAT(125),name,da2);
#else
							/* %s: [%s]o[͎wł܂B */
							ERROROUT2(FORMAT(166),name,da1);
#endif
							rc = ECL_SCRIPT_ERROR;
						}
						return rc;
					}
				}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:.name: mc=%d",pInfoParmW,mc,rc);
			}
			else if (mc == -13) {	/* new */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				id = pInfoParm2->pi_id;
				if (id != 'C') {
					/* %s: ϐ[%s]%sł͂܂B */
					ERROROUT3(FORMAT(431),name,da2,FORMAT(120));	/* NX */
					return ECL_EX_LET;
				}
				if (rc = cl_func_new(pInfoParmW,1,&pInfoParm2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:NEW: mc=%d",pInfoParmW,mc,rc);

			}
			else {
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: mc=%d irs=%d",pInfoParm2,mc,irs);

				rc = cl_gx_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,0,NULL);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:mc=%d rc=%d",mc,rc);

			}
			if (rc) return (rc);
#if 0
			if (mc != 90) {
				pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
				if (pInfoParmW->pi_id == D_DATA_ID_STOREVAR) {
					if (pInfoParm = (tdtInfoParm *)pInfoParmW->pi_pos)
						pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
				}
			}
#endif
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
#if 1
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(pOperator)+strlen(da2)+3)))
				return ECL_MALLOC_ERROR;
			sprintf(p,"%s %s %s",da1,pOperator,da2);
			dastk[irs] = p;
#else
			dastk[irs] = FORMAT(133);	/* Z */
#endif
			irs++;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:push W: irs=%d",ppmstk[irs-1],irs,0);
*/
		}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:push W: irs=%d dastk=[%]",ppmstk[irs-1],irs,dastk[irs-1]);
	}
	return -6;
}

/****************************************/
/*										*/
/****************************************/
int _clear_obj_addr(pGxObj,pInfoParm0,obj0)
GXObject *pGxObj;
tdtInfoParm *pInfoParm0,**obj0;
{
	int n,atr,len;
	short *obj;
	int nob,ib,mc,ida,ib0;
	char **da,c,*pd;
	tdtInfoParm *p,*pInfoParm=pInfoParm0,*pParmW,tParmW;
	uchar pi_aux;

	nob = pGxObj->nobj;
	obj = pGxObj->obj;
	da  = pGxObj->da;
	n = ib0 = ib = 0;

DEBUGOUTL5(LVL_GXEXOBJ+1,"_clear_obj_addr: pGxObj=0x%08x pInfoParm0=0x%08x nobj0=%d obj0=0x%08x option=0x%08x",
pGxObj,pInfoParm0,pGxObj->nobj0,obj0,pGxObj->option);
/*
printf("_clear_obj_addr: nobj0=%d obj0=0x%08x\n",pGxObj->nobj0,obj0);
*/
	while (ib<nob) {
		mc = obj[ib++];
/*
printf("_clear_obj_addr: ib=%d obj=%d\n",ib-1,mc);
*/
		if (mc==99) break;
		else if (mc == 91) {
			ida = obj[ib++];
/*
printf("_clear_obj_addr: ida=%d da=[%s]\n",ida,da[ida]);
*/
			pd = da[ida];
			len = strlen(pd);
			if (pParmW = obj0[ib0]) tParmW = *pParmW;
			else cl_parm_set0(&tParmW);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: pParmW ",pParmW,0,0);
#if 0
			if (pParmW = obj0[ib0]) c = pParmW->pi_id;
			else c = ' ';
			if ((c!='F' && (atr=cl_chk_parm(pd,len))==NAME_CONST) ||
			     atr==PARAMETER) {
#else
			if (len>1 && ((c=*da[ida])=='$' || c=='%' || c=='#' || c=='<')) {
#endif
				if (pInfoParm) {
					obj0[ib0] = pInfoParm;
DEBUGOUTL3(LVL_GXEXOBJ+1,"_clear_obj_addr: c=%c ib0=%d pInfoParm=%08x",c,ib0,pInfoParm);
					pInfoParm++;
					n++;
				}
				if (!(pGxObj->option & D_GX_OPT_SET_PROC_OBJ)) {
					if ((p=obj0[ib0]) && !(p->pi_alen & D_AULN_NAME_DATA)) {
						if (tParmW.pi_id == 'S') {
							*p = tParmW;
							p->pi_pos = 0;
							p->pi_aux[1] = 0;
						}
						else cl_parm_set0(p);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: p ",p,0,0);
					}
				}
			}
			ib0++;
		}
		else if (mc == 92) ib++;
	}
	if (n > 0) pGxObj->option |= D_GX_OPT_SET_PROC_OBJ;
	return n;
}

/************************************/
/*									*/
/************************************/
int cl_gx_set_scr_obj(scrprct)
ScrPrCT *scrprct;
{
	int i,count;

	if (!scrprct) return -1;
	if (scrprct->Obj) return 0;

	if (!(scrprct->Obj=cl_mk_obj0(cl_get_obj0_used(NULL,scrprct),0))) return -1;
	return 0;
}

/************************************/
/*									*/
/************************************/
tdtObjHead *cl_gx_get_scr_obj()
{
	ScrPrCT *scrct;

	if (scrct=cl_search_src_ct()) return scrct->Obj;
	return NULL;
}

/************************************/
/*									*/
/************************************/
tdtObjHead *cl_gx_get_proc_obj()
{
	ProcCT *proc;

	if (proc=cl_search_proc_ct()) return proc->Obj;
	return NULL;
}

/****************************************/
/*										*/
/****************************************/
static int _clear_var_obj(varnam,pGxObj,Obj,scope)
char *varnam;
GXObject *pGxObj;
tdtObjHead *Obj;
int scope;
{
	int n,atr,len,k;
	short *obj;
	int nob,ib,mc,ida,ib0;
	char **da,c,*pd;
	tdtInfoParm **obj0,*p,*pParmW,**Obj0;
	uchar ucAux1;

	nob = pGxObj->nobj;
	obj = pGxObj->obj;
	da  = pGxObj->da;
	Obj0 = Obj->Obj0;
	obj0 = &Obj0[pGxObj->maxobj0];
	n = ib0 = ib = 0;

DEBUGOUTL5(LVL_GXEXOBJ+1,"_clear_var_obj: varnam=[%s] pGxObj=0x%08x nobj0=%d obj0=0x%08x scope=0x%08x",
varnam,pGxObj,pGxObj->nobj0,obj0,scope);
/*
printf("_clear_var_obj: nobj0=%d obj0=0x%08x\n",pGxObj->nobj0,obj0);
*/
	while (ib<nob) {
		mc = obj[ib++];
/*
printf("_clear_var_obj: ib=%d obj=%d\n",ib-1,mc);
*/
		if (mc==99) break;
		else if (mc == 91) {
			ida = obj[ib++];
/*
printf("_clear_var_obj: ida=%d da=[%s]\n",ida,da[ida]);
*/
			if (varnam) k = !strcmp(varnam,da[ida]);
			else k = 1;
			if (k) {
DEBUGOUTL2(LVL_GXEXOBJ+1,"_clear_var_obj: ida=%d da=[%s]",ida,da[ida]);
				if (pParmW=obj0[ib0]) {
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_var_obj: pParmW ",pParmW,0,0);

					if (pParmW->pi_id == 'S') {
						ucAux1 = pParmW->pi_aux[1];
						if (p=(tdtInfoParm *)pParmW->pi_pos) {

DEBUGOUTL2(LVL_GXEXOBJ+1,"_clear_var_obj: pi_aux[1]=%08x scope=%08x",p->pi_aux[1],scope);

							if ((ucAux1 | p->pi_aux[1]) & scope) {
								pParmW->pi_pos = 0;
								pParmW->pi_aux[1] = 0;
							}
						}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_var_obj: p ",p,0,0);
					}
				}
			}
			ib0++;
		}
		else if (mc == 92) ib++;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj(leaf,curleaf,varnam,Obj,scope)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
{
	return cl_gx_clear_var_obj_sub(leaf,curleaf,varnam,Obj,scope,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj_sub(leaf,curleaf,varnam,Obj,scope,right_flg)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
int right_flg;
{
	int i,k,rc,scopew,cmdid,flg;
	parmList **prmp,*parmp;
	GXObject *pbxObj;
	Leaf *leafw;
	ScrPrCT *scrpt;
	ProcCT *proc;
/*
printf("cl_gx_clear_var_obj: leaf=%08x curleaf=%08x\n",leaf,curleaf);
printf("               varnam=[%s] scope=%08x right_flg=%d node=[%s]\n",
varnam,scope,right_flg,cl_gets_cmd_name(leaf->cmd.cid));
*/
	if (!leaf) return 0;
	if (!Obj) return 0;

DEBUGOUTL4(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_sub: varnam=[%s] Obj=0x%08x right_flg=%d cmd=%s",
varnam,Obj,right_flg,cl_gets_cmd_name(leaf->cmd.cid));
	if (!curleaf || (curleaf && leaf!=curleaf)) {
		prmp = leaf->cmd.prmp;
		for (i=0;i<leaf->cmd.prmnum;i++) {
			parmp = *prmp++;
			if (pbxObj=parmp->bxobj) {
				if (pbxObj->nobj0) {
					if ((rc=_clear_var_obj(varnam,pbxObj,Obj,scope)) < 0) return rc;
				}
			}
		}
	}

	if (leafw=leaf->leftleaf)  {
		if ((rc=cl_gx_clear_var_obj_sub(leafw,curleaf,varnam,Obj,scope,1)) < 0) return rc;
	}
	if (right_flg) {
		if (leafw=leaf->rightleaf) {
			if ((rc=cl_gx_clear_var_obj_sub(leafw,curleaf,varnam,Obj,scope,1)) < 0) return rc;
		}
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var90(pInfoParm,da)
tdtInfoParm *pInfoParm;
char *da;
{
	int vnlen,scope,opt;
	char *varnam,buf[10];
	ProcCT  *proc;
	ScrPrCT *scrct;
	Leaf *topleaf,*procleaf;
	tdtObjHead *pObj;

	if (!(scrct=cl_search_src_ct())) return 0;
	pObj = scrct->Obj;
/*
printf("cl_gx_clear_var90: da=[%s]\n",da);
*/
	varnam = da + D_LEN_STR_SCOPE;
	vnlen = strlen(varnam);
	if (*(varnam+vnlen-1) == ']') return 0;

	topleaf = scrct->TreeTop;

	memzcpy(buf,da,D_LEN_STR_SCOPE);
	if (!(opt=cl_get_def_scope(buf))) {
		/* cl_gx_clear_var90: Invalid scope name[%s] */
		ERROROUT2(FORMAT(135),"cl_gx_clear_var90",buf);
		return -1;
	}
	if (opt & D_GX_OPT_SET_GLOBAL)
		return 0;
	else if (opt & D_GX_OPT_SET_PUBLIC)
		scope = D_AUX1_GLOBAL_VAR;
	else if (opt & D_GX_OPT_SET_PRIVATE)
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
	else /*if (opt & D_GX_OPT_SET_LOCAL)*/ {
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
		if (!(proc=cl_search_proc_ct())) return -1;
		topleaf = proc->ProcTop->leftleaf;
		pObj = proc->Obj;
		return cl_gx_clear_var_obj(topleaf,NULL,varnam,pObj,scope);
	}
/*
printf("cl_gx_clear_var90: scope=%08x topleaf=%08x\n",scope,topleaf);
*/
	return cl_gx_clear_var_obj_all(scrct,NULL,varnam,scope);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_define(scrct,proc,varnam,opt)
ScrPrCT *scrct;
ProcCT  *proc;
char *varnam;
int opt;
{
	int scope;
	char c,*p,buf[Var_NM_MAX+2];
	Leaf *topleaf;
	tdtObjHead *pObj;

	if (!scrct) return 0;
	pObj = scrct->Obj;

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define: varnam=[%s] opt=%08x",varnam,opt);

	if ((c=*varnam)!='$' && c!='%' && c!='#') {
		p = buf;
		*buf = '$';
		strnzcpy(buf+1,varnam,sizeof(buf)-2);
	}
	else p = varnam;

	topleaf = scrct->TreeTop;

	opt &= D_GX_OPT_SET_GLOBAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_LOCAL;
	if (opt & D_GX_OPT_SET_GLOBAL)
		return 0;
	else if (opt & D_GX_OPT_SET_PUBLIC)
		scope = D_AUX1_GLOBAL_VAR;
	else if (!opt || (opt & D_GX_OPT_SET_PRIVATE))
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
	else /*if (opt & D_GX_OPT_SET_LOCAL)*/ {
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
		if (!proc) return -1;
		topleaf = proc->ProcTop->leftleaf;
		pObj = proc->Obj;

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define:LOCAL: scope=%08x topleaf=%08x",scope,topleaf);

		return cl_gx_clear_var_obj(topleaf,NULL,p,pObj,scope);
	}

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define: scope=%08x topleaf=%08x",scope,topleaf);

	return cl_gx_clear_var_obj_all(scrct,NULL,p,scope);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj_all(scrpt,curleaf,varnam,scope)
ScrPrCT *scrpt;
Leaf *curleaf;
char *varnam;
int scope;
{
	Leaf *leaf;
	tdtObjHead *Obj;
	int rc;
	ProcCT *proc;

DEBUGOUTL3(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_all: scrpt=%08x varnam=[%s] scope=%08x",scrpt,varnam,scope);

	if (!scrpt) return -1;
	proc = scrpt->ProCT;
	while (proc) {

DEBUGOUTL1(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_all: while: ProcNM=[%s]",proc->ProcNM);

		leaf = proc->ProcTop;
		Obj = proc->Obj;
		if ((rc=cl_gx_clear_var_obj(leaf,curleaf,varnam,Obj,scope)) < 0) return rc;
		proc = proc->nextPCT;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_iif_optimize(obj,nob,obj0)
short obj[];
tdtInfoParm *obj0[];
int   nob;
{
	tdtInfoParm *pInfoParm;
	int i,mc,kind,ib0,k;
	char *p,c;

printf("cl_gx_iif_optimize:Enter nob=%d\n",nob);
	i = 0;
	while (i < nob) {
		mc = obj[i++];
printf("cl_gx_iif_optimize: mc=%d i=%d\n",mc,i);
		if (mc == 91) {
			ib0 = obj[i];
			pInfoParm = obj0[ib0];
			c = pInfoParm->pi_id;
			if (c == 'S') {
				pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				c = pInfoParm->pi_id;
			}
			if ((c=='F'/* && pInfoParm->pi_aux[0]==0*/) || c=='A' || c=='R') {
				p = pInfoParm->pi_data;
				i = cl_gx_iif_optimize_sub(obj,nob,obj0,i-1,p);
				if (i < 0) break;
			}
			else i++;
		}
		else if (mc==92 || mc==93)
			i++;
		else if (mc == 98) {
			i = ECL_OPTIMIZE_ERROR;
			break;
		}
		else if (mc==59) {
			kind = obj[i++];
			if (!kind) i += 2; 
			else i += 4;
		}
		else if (mc == 99) {
			break;
		}
	}
for (k=0;k<nob;k++) {
printf("cl_gx_iif_optimize: obj[%2d]=%d\n",k,obj[k]);
}
	if (i > 0) i = 0;
printf("cl_gx_iif_optimize:Exit i=%d\n",i);
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_iif_optimize_sub(obj,nob,obj0,i0,nam)
short obj[];
tdtInfoParm *obj0[];
int   nob;
char *nam;
{
	tdtInfoParm *pInfoParm;
	int ret,i,mc,disp,kind,i1,i2,i3,i_true,i_false,i_end,i_goto,ib0;
	char *p,c;

printf("cl_gx_iif_optimize_sub:Enter nob=%d i0=%d nam=[%s]\n",nob,i0,nam);
	ret = 0;
	i = i0;
	i1 = i;
	i3 = i + 4;
	i++;
	if (!stricmp(nam,"IIF")) kind = 1;
	else if (!stricmp(nam,"NVAL") || !stricmp(nam,"NULLIF")) kind = 2;
	else if (!stricmp(nam,"NSVAL")) kind = 3;
	else if (!stricmp(nam,"NDEF")) kind = 4;
	i++;
printf("cl_gx_iif_optimize_sub: i1=%d i3=%d i=%d kind=%d\n",i1,i3,i,kind);
	if (kind) disp = 1;
	i_false = i_goto = 0;
	while (i < nob) {
		mc = obj[i++];
printf("cl_gx_iif_optimize_sub: mc=%d i=%d disp=%d\n",mc,i,disp);
		if (mc == 91) {
			ib0 = obj[i];
			pInfoParm = obj0[ib0];
			c = pInfoParm->pi_id;
			if (c == 'S') {
				pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				c = pInfoParm->pi_id;
			}
			if ((c=='F'/* && pInfoParm->pi_aux[0]==0*/) || c=='A' || c=='R') {
				p = pInfoParm->pi_data;
				i = cl_gx_iif_optimize_sub(obj,nob,obj0,i-1,p);
				if (i < 0) break;
			}
			else i++;
		}
		else if (mc==92 || mc==93)
			i++;
		else if (mc == 98) {
			i--;
			if (disp == 1) {
				i2 = i;
				disp = 2;
printf("cl_gx_iif_optimize_sub: i2=%d disp=%d\n",i2,disp);
			}
			else if (disp == 2) {
				disp = 3;
				i_goto = i;
				i_false = i + 2;;
printf("cl_gx_iif_optimize_sub: disp=%d i_false=%d i_goto=%d\n",disp,i_false,i_goto);
			}
			else if (disp == 2) {
				i = C_CAN_NOT_OPTIMIZE;
				break;
			}
			else {
				i = ECL_OPTIMIZE_ERROR;
				break;
			}
			i += 2;
		}
		else if (mc==5 || mc==6) {
			if (disp > 0) {
				if (disp==1 || (disp==2 && kind==1)) break;
				memcpy(obj+i1,obj+i3, (i2-i3)*sizeof(short));
				i_end = i;
				if (!i_false) i_false = i_end;
				i3 = i2 - i3;
				obj[i3]   = 59;
				obj[i3+1] = kind;
				obj[i3+2] = i_false - (i3+2);
				obj[i3+3] = i_end   - (i3+3);
				obj[i3+4] = 0;
				obj[i3+5] = 0;
				obj[i-1] = 0;
				if (i_goto > 0) {
					obj[i_goto++] = 93;
					obj[i_goto] = i_end - i_goto;
				}
			}
			break;
		}
		else if (mc==59) {
			kind = obj[i++];
			if (!kind) i += 2; 
			else i += 4;
		}
		else if (mc == 99) {
			break;
		}
	}
printf("cl_gx_iif_optimize_sub:Exit i=%d\n",i);
	return i;
}
