/*static    char    sccsid[]="%Z% %M% %I% %E% %U%";*/
/*************************************************
 *
 *  akacomm.c (include file)
 *
 *        coded by A.Kobayashi 2010.5.10
 *
 *************************************************/
#include "akacommon.h"

extern tdtMsgCtl tMsgCtl;

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_msec(ptval)
struct timeval *ptval;
{
	return akxe_get_msec(tMsgCtl.pTimerCtl,ptval);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_timer_proc()
{
	return akxe_proc_timer(tMsgCtl.pTimerCtl);
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_min_wait_time(iWaitTime)
int iWaitTime;
{
	struct timeval tmtime, tmset;
	int iMinWaitTime,iTimerMinWait;
	int i,iTime[3];

	iTime[0] = iWaitTime;
	iTime[1] = tMsgCtl.pTimerCtl->th_minwait;
DEBUGOUTL2(AKA_LOG_GROUP|255,
"aka_get_min_wait_time:WaitTime=%d TimerWait=%d",
iTime[0],iTime[1]);

	iMinWaitTime = -1;
	for (i=0;i<2;i++) {
		if ((iMinWaitTime < 0) ||
		    (iMinWaitTime >= 0 && iTime[i] >= 0 &&
		     iTime[i] < iMinWaitTime)) {
			if (!(iMinWaitTime = iTime[i])) break;
		}
	}

	return iMinWaitTime;
}

/********************************************************/
/*                                                      */
/********************************************************/
int  aka_shut_control(iAttribute,cpValue)
int iAttribute;
char *cpValue;
{
	char c;
	int ret = 0;

	if (iAttribute != AKA_SHUT_GET) {
		if (!cpValue) return -18502804;
		c = *cpValue;
	}
	switch (iAttribute) {
	case AKA_SHUT_MODE:
			if (c == 0x00) tMsgCtl.ucShutMode = 0;
			else if (c & AKA_SHUT_MODE_SHUT)
				tMsgCtl.ucShutMode |= AKA_SHUT_MODE_SHUT;
			else if (c & AKA_SHUT_MODE_FSHUT)
				tMsgCtl.ucShutMode |= AKA_SHUT_MODE_FSHUT;
			else ret = -18502803;
			break;
	case AKA_SHUT_SUSPEND:
			if (c == 0x00) tMsgCtl.ucShutSuspend = 0;
			else if (c == AKA_SHUT_SUSPEND_SET) tMsgCtl.ucShutSuspend = 1;
			else ret = -18502803;
			break;
	case AKA_SHUT_GET:
			if (cpValue) {
				*cpValue++ = tMsgCtl.ucShutMode;
				*cpValue   = tMsgCtl.ucShutSuspend;
			}
			ret = tMsgCtl.ucShutMode & AKA_SHUT_MODE_FSHUT;
			if (!ret && !tMsgCtl.ucShutSuspend &&
			    (tMsgCtl.ucShutMode & AKA_SHUT_MODE_SHUT))
				ret = tMsgCtl.ucShutMode & AKA_SHUT_MODE_SHUT;
			break;
	default:
			ret = -18502802;
	}
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
static char *gcpVerDate[2]={AKX_NULL_PRINT,AKX_NULL_PRINT};
static int   giVerDateLen[2]={0,0};

static int _getverdate(p,pd)
char *p,**pd;
{
	int i;

	*pd = p;
	i = strlen(p);
	while (*p && *p!='[') p++;
	if (*p) {
		*pd = ++p;
		i = 0;
		while (*p && *p!=']') {
			p++;
			i++;
		}
	}
	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_set_ver_date(ver,date)
char *ver,*date;
{
	static char *cpVersion=NULL;
	static char *cpMakeDate=NULL;

	if (ver)  {
		if (!(cpVersion  = Strdup(ver))) return -1;
		giVerDateLen[0] = _getverdate(cpVersion,&gcpVerDate[0]);
		*(gcpVerDate[0]+giVerDateLen[0]) = '\0';
	}
	if (date) {
		if (!(cpMakeDate = Strdup(date))) return -2;
		giVerDateLen[1] = _getverdate(cpMakeDate,&gcpVerDate[1]);
		*(gcpVerDate[1]+giVerDateLen[1]) = '\0';
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int aka_get_ver_date(cpVerDate,iVerDateLen)
char *cpVerDate[];
int   iVerDateLen[];
{
	if (cpVerDate) {
		cpVerDate[0] = gcpVerDate[0];
		cpVerDate[1] = gcpVerDate[1];
	}
	if (iVerDateLen) {
		iVerDateLen[0] = strlen(gcpVerDate[0]);
		iVerDateLen[1] = strlen(gcpVerDate[1]);
	}
	return 0;
}
