static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  p[^ϊ                                         *
*                                                                             *
*      ֐@@@F@int cl_conv_parm( pparmList , pInfoParm )              *
*                      (I)prmList	*pparmList                                *
*                      (O)tdtINFO_PARM	*pInfoParm                            *
*                                                                             *
*            F@Ȃ                                                   *
*                                                                             *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>
extern int giOptions[];
extern CLPRTBL *pGLprocTable;
extern CLPRTBL *pCLprocTable;
extern GlobalCt  *pGlobTable;

static long lnull = 0;

/****************************************/
/*										*/
/****************************************/
static int _set_nest_var_name(pparmList, pInfoParm)
parmList   *pparmList;
tdtINFO_PARM *pInfoParm;
{
	int ret,vnlen;
	char *p,*vname;

	if (pInfoParm->pi_scale & D_DATA_ARRAY_INDEX) {	/* 0x10 */
		if (!(p=(char *)pInfoParm->pi_pos)) return ECL_SYSTEM_ERROR;
/*
printf("_set_nest_var_name: p=[%s] vnlen=%d vname=[%s]\n",
p,pparmList->prmlen,pparmList->prp);
*/
		if ((vnlen=pparmList->prmlen-strlen(p)-1) <= 0) return ECL_SYSTEM_ERROR;
		vname = pparmList->prp;
		if (!(p=cl_tmp_const_malloc(vnlen+Var_NM_MAX*2+1))) {
			ERROROUT("_set_nest_var_name: nest var name area malloc");
			return ECL_SYSTEM_ERROR;
		}
		strnzcpy(p,vname,vnlen);
		pInfoParm->pi_pos = (long)p;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_conv_parm(pparmList, pInfoParm)
parmList   *pparmList;
tdtINFO_PARM *pInfoParm;
{
	return cl_conv_parm_opt(pparmList, pInfoParm, 0);
}

/****************************************/
/*										*/
/****************************************/
int cl_conv_parm_opt(pparmList, pInfoParm, opti)
parmList   *pparmList;
tdtINFO_PARM *pInfoParm;
int opti;
{
	int	rc, alclen, opt, ret;
	int ParmNo;
	tdtINFO_PARM	*pInfoParmW;
	ScrPrCT     *pScCT;
	char op,c,*p;
	ParList par_pSize;

	if (!pparmList) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return( ECL_SYSTEM_ERROR );
	}
	if (!pparmList->prp) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return( ECL_SYSTEM_ERROR );
	}
	if (!pInfoParm) {
		ERROROUT(FORMAT(30));	/* VXeG[ */
		return ECL_SYSTEM_ERROR;
	}

DEBUGOUTL2(194,"--->cl_conv_parm_op: pparmList->prp=[%s] opti=%08x",pparmList->prp,opti);

	memset(pInfoParm,0,sizeof(tdtINFO_PARM));
	pScCT = cl_search_src_ct();
	opt = opti & D_GX_OPT_STORE;
	if (opt) op = 's';
	else {
		if (opti & D_GX_OPT_NOEROUT_NDEF) op = 'R';
		else op = 'r';
	}
	rc = cl_gx_get_info_parm_opt_psize(pScCT,op,pparmList,&pInfoParmW,opti,&par_pSize);

DEBUGOUT_InfoParm(194,"cl_conv_parm_opt:<---cl_gx_get_info_parm_opt opt=%d rc=%d",
pInfoParmW,opt,rc);

	if (rc) {
		if (rc == ECL_DEFINED_ARRAY) {
			if (!pInfoParmW) return -1;
			if (ret=_set_nest_var_name(pparmList,pInfoParmW)) return ret;
		}
		else return rc;
	}
	if (opt || (opti & D_GX_OPT_SET_ADDR)) {
		cl_set_parm_long(pInfoParm,(long)pInfoParmW);
		pInfoParm->pi_id = 'S';
		pInfoParm->pi_aux[1] = pInfoParmW->pi_aux[1];
	/*
		if ((c=*pparmList->prp)=='%' || c=='#')
			pInfoParm->pi_aux[1] = D_AUX1_PROTECTED;
		else if (pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED)
			pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	*/
		pInfoParm->pi_paux = par_pSize.par;
		pInfoParm->pi_hlen = par_pSize.parlen;	/* ParmNoĂ */
	}
	else {
		memcpy(pInfoParm,pInfoParmW,sizeof(tdtINFO_PARM));
		if ((c=pInfoParmW->pi_id) == 'A' || c == 'R') rc = ECL_DEFINED_ARRAY;
	}
DEBUGOUT_InfoParm(194,"cl_conv_parm_opt:Exit rc=%d",pInfoParm,rc,0);
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_chk_vnam(opt,pha,name,nl)
char opt,*name;
int nl;
XHASHB *pha;
{
	char hakey[Var_NM_MAX*2+2];
	int i;

	if (!pha) return 0;
#ifdef HASH_FIXED_KEYL  /* 2001.2.22 Koba */
	if (nl >= pha->xha_keylen) {
		memcpy(hakey,name,pha->xha_keylen);
	}
	else {
		memset(hakey,' ',pha->xha_keylen);
		memcpy(hakey,name,nl);
	}
	hakey[Var_NM_MAX] = '\0';
/*
ERROROUT3("opt=[%c] name=[%s] nl=%d",opt,name,nl);
*/
#else
	nl = memnzcpy(hakey,name,nl,sizeof(hakey));
#endif

DEBUGOUTL5(194,"cl_gx_chk_vnam: pha=%08x opt=%c nl=%d hakey=[%s] i=%d",pha,opt,nl,hakey,i);
/*
printf("cl_gx_chk_vnam: pha=%08x opt=%c nl=%d hakey=[%s] i=%d\n",pha,opt,nl,hakey,i);
*/
	pha->xha_xhix = 0;
	i = akxs_xhash(pha,opt,hakey);
	return i;
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_gx_setprm_list_g(name,len)
char *name;
int len;
{
	tdtINFO_PARM InfoParm,*pInfoParm;
	parmList pL;
	char buf[33],*p;

	*buf = '$';
	if (len>31) len = 31;
	memzcpy(buf+1,name,len);
	pL.prp = buf;
	pL.prmlen = len + 1;
	if (cl_conv_sysvar(&pL,&InfoParm)) return NULL;
	if (pInfoParm = (tdtINFO_PARM *)cl_const_malloc(sizeof(tdtINFO_PARM))) {
		if (cl_gx_rep_info_set_ign(pInfoParm ,&InfoParm ,0)) {
			pInfoParm = NULL;
		}
	}
	return pInfoParm;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_info_parm_opt(pScCT,opt,pparmList,ppInfoParm,iOpt)
ScrPrCT	  *pScCT;
char opt;
parmList  *pparmList;
tdtINFO_PARM **ppInfoParm;
int iOpt;
{
	return cl_gx_get_info_parm_opt_psize(pScCT,opt,pparmList,ppInfoParm,iOpt,NULL);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_info_parm_opt_psize(pScCT,opt,pparmList,ppInfoParm,iOpt,ppar_pSize)
ScrPrCT	  *pScCT;
char opt;
parmList  *pparmList;
tdtINFO_PARM **ppInfoParm;
int iOpt;
ParList *ppar_pSize;
{
	int  ParmNo,rc,vnlen,pLlen,iLOCAL,ix,code_type;
	char c, *vname, *pLprp, data_id, *p;
	tdtINFO_PARM *pInfoParm, ***pTBL_vnam;
	char varnam[Var_NM_MAX+1];
	tdtArrayIndex tIndex;
	ProcCT  *proc;
	uchar ucLGopt;
	parmList tparmList;

	if (ppar_pSize) {
		ppar_pSize->par = NULL;
		ppar_pSize->parlen = 0;
	}
	if (!ppInfoParm) return -1;
	*ppInfoParm=NULL;
	pInfoParm=NULL;

	pLlen = pparmList->prmlen;
	pLprp = pparmList->prp;
	code_type = GET_TYPE_OPT(pparmList->opt);
#if 1	/* 2022.6.11 */
	if (!(rc=cl_skip_scope_mark(pLprp,pLlen,&ix))) ;
	else if (rc > 0) {
		iOpt |= ix;
		tparmList = *pparmList;
		pparmList = &tparmList;
		pLlen -= rc;
		pLprp += rc;
		pparmList->prmlen = pLlen;
		pparmList->prp = pLprp;
	}
	else  return rc;
#endif

DEBUGOUTL4(194,"--->cl_gx_get_info_parm_opt: pScCT=%08x opt=%c name=[%s]",
pScCT,opt,pLprp,0);

	LOGBUF(strlen(pLprp)+128);
	if ((ParmNo=cl_gx_get_index_array(pparmList,varnam,&pInfoParm,iOpt)) < 0) {
		if (ParmNo == ECL_DEFINED_ARRAY) *ppInfoParm = pInfoParm;
				/* cl_gx_get_info_parm_opt:%s̓p[^Ɍ肪܂B */
		else if (!(iOpt & D_GX_OPT_NOEROUT_NDEF)) ERROROUT1(FORMAT(311),pLprp);
		return ParmNo;
	}

	c = *pLprp;
	if (ParmNo==0 && *varnam &&		/* ϐz񖼂ǂ̃`FbN */
	    (c=='%' || c=='#')) {		/* z񖼂́A%,#tœo^Ă */
		ucLGopt = 0;
		rc = 0;
		proc = NULL;
		if (pScCT) proc = cl_search_proc_ct();
		rc = cl_gx_get_parm_no(pScCT,proc,pLprp,pLlen,'r',0,&pTBL_vnam,&ucLGopt);
DEBUGOUTL5(194,"<---cl_gx_get_info_parm_opt.array: pScCT=%08x proc=%08x ParmNo=%d %s rc=%d",
pScCT,proc,ParmNo,pLprp,rc);
		if (rc > 0){
			/* z񖼂Ƃēo^Ă */
			if (pInfoParm = cl_get_var_ent(pTBL_vnam,rc)) {

DEBUGOUT_InfoParm(194,"cl_gx_get_info_parm_opt.array: ",pInfoParm,0,0);

			/*	if (iLOCAL) pInfoParm->pi_aux[1] |= D_AUX1_LOCAL_VAR;	*/
				pInfoParm->pi_aux[1] |= D_AUX1_HASHED_NAME | ucLGopt;
				*ppInfoParm = pInfoParm;
				return 0;
			}
		}
	}
	rc = cl_gx_get_all_var_ent_psize(pScCT,opt,pLprp,ppInfoParm,ParmNo,varnam,iOpt,ppar_pSize);
	if (!rc) {
		pInfoParm = *ppInfoParm;
		ix = akxnskipto(pLprp,pLlen,".");
		if (++ix < pLlen) {
			if (pInfoParm->pi_id=='T') {
				if (rc=_ex_get_member(&pInfoParm,opt,pLprp+ix,pLlen-ix)) return rc;
				*ppInfoParm = pInfoParm;
			}
			else {
				/* cl_gx_get_info_parm_opt: [%s]o[͎wł܂B */
				ERROROUT2(FORMAT(166),"cl_gx_get_info_parm_opt",pLprp);
				rc = ECL_SCRIPT_ERROR;
			}
		}
		if (pInfoParm->pi_id=='R' &&
		    (!pInfoParm->pi_pos || (pInfoParm->pi_pos && !*(char *)pInfoParm->pi_pos))) {
			vnlen = strlen(varnam);
			if (!(p=Malloc(vnlen+1))) {
				ERROROUT1("cl_gx_get_info_parm_opt: Array name[%s] area malloc",varnam);
				return -1;
			}
			strnzcpy(p,varnam,vnlen);
			pInfoParm->pi_pos = (long)p;
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_info_parm(pScCT,opt,pparmList,ppInfoParm)
ScrPrCT	  *pScCT;
char opt;
parmList  *pparmList;
tdtINFO_PARM **ppInfoParm;
{
	return cl_gx_get_info_parm_opt(pScCT,opt,pparmList,ppInfoParm,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_parm_no(pScCT,proc,varnam,vnlen,opt,iOpt,ppTBL_vnam,piLGopt)
ScrPrCT	*pScCT;
ProcCT  *proc;
char    *varnam;
int      vnlen;
char     opt;
int      iOpt;
tdtINFO_PARM ****ppTBL_vnam;
uchar   *piLGopt;
{
	int  ParmNo,iNEW_LEX,iSKIP,iCHECK,iLGopt,vlen;
	char *vnam,wrk[Pr_NM_MAX+Var_NM_MAX+2],*p;
	tdtINFO_PARM ***pTBL_vnam;
	ProcCT  *procW;
	ScrPrCT	*pGLScCT;

DEBUGOUTL5(190,"--->cl_gx_get_parm_no: pScCT=%08x proc=%08x [%s] opt=%c iOpt=%08x",
pScCT,proc,varnam,opt,iOpt);
	if ((iOpt & D_GX_OPT_SET_PRIVATE) ||
	    (opt=='s' && (pGlobTable->options[9] & 0x01))) iSKIP = 1;
	else iSKIP = 0;
	if (pScCT) iNEW_LEX = pScCT->pFlag & D_SCRPT_NEW_LEX;
	else iNEW_LEX = 0;
DEBUGOUTL2(190,"cl_gx_get_parm_no: iNEW_LEX=%08x iSKIP=%d",iNEW_LEX,iSKIP);
	vnlen = akxnskipto(varnam,vnlen,".");
	ParmNo = 0;
	pTBL_vnam = NULL;
	iLGopt= 0;
	if (proc && proc->pha_vnam && iNEW_LEX && !iSKIP) {
		if ((ParmNo=cl_gx_chk_scope(opt,proc,varnam,vnlen,&procW)) > 0) {
			pTBL_vnam = procW->pTBL_vnam;
			iLGopt = D_AUX1_LOCAL_VAR;
DEBUGOUTL1(190,"cl_gx_get_parm_no: LOCAL ParmNo=%d",ParmNo);
		}
		else if (!ParmNo) {
			vlen = cl_mk_static_name(wrk,proc->ProcNM,strlen(proc->ProcNM),varnam,vnlen);
			if ((ParmNo=cl_gx_chk_vnam(opt,pScCT->Vary->pha_vnam,wrk,vlen)) > 0) {
				pTBL_vnam = pScCT->Vary->pTBL_vnam;
				iLGopt = D_AUX1_LOCAL_VAR;
DEBUGOUTL1(190,"cl_gx_get_parm_no: LOCAL ParmNo=%d",ParmNo);
			}
		}
	}
	if (ParmNo<=0 && pScCT) {
		if ((ParmNo=cl_gx_chk_vnam(opt,pScCT->Vary->pha_vnam,varnam,vnlen)) > 0) {
			pTBL_vnam = pScCT->Vary->pTBL_vnam;
			iLGopt = D_AUX1_PRIVATE_VAR;
DEBUGOUTL1(190,"cl_gx_get_parm_no: SCRIPT ParmNo=%d",ParmNo);
		}
	}
	if (ParmNo<=0 && opt=='r') {
		if ((ParmNo=cl_gx_chk_vnam(opt,pCLprocTable->pha_vnam,varnam,vnlen)) > 0) {
			pTBL_vnam = pCLprocTable->pTBL_vnam;
			iLGopt = D_AUX1_PUBLIC_VAR;
DEBUGOUTL1(190,"cl_gx_get_parm_no: PUBLIC ParmNo=%d",ParmNo);
		}
	}
	if (ParmNo<=0 && opt=='r') {
		if ((ParmNo=cl_gx_chk_vnam(opt,pGLprocTable->pha_vnam,varnam,vnlen)) > 0) {
			pTBL_vnam = pGLprocTable->pTBL_vnam;
			iLGopt = D_AUX1_GLOBAL_VAR;
DEBUGOUTL1(190,"cl_gx_get_parm_no: GLOBAL ParmNo=%d",ParmNo);
		}
	}
	if (ppTBL_vnam) *ppTBL_vnam = pTBL_vnam;
	*piLGopt= iLGopt;

	return ParmNo;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_all_var_ent(pScCT,opti,name,ppInfoParm,ParmNo,varnam,iOpt)
ScrPrCT	  *pScCT;
char opti,*name;
tdtINFO_PARM **ppInfoParm;
int  ParmNo;
char *varnam;
int  iOpt;
{
	return cl_gx_get_all_var_ent_psize(pScCT,opti,name,ppInfoParm,ParmNo,varnam,iOpt,NULL);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_all_var_ent_psize(pScCT,opti,name,ppInfoParm,ParmNo,varnam,iOpt,ppar_pSize)
ScrPrCT	  *pScCT;
char opti,*name;
tdtINFO_PARM **ppInfoParm;
int  ParmNo;
char *varnam;
int  iOpt;
ParList *ppar_pSize;
{
	static char *_fn_="cl_gx_get_all_var_ent";
	int rc, vnlen,*pSize,iEROUT_NDEF,iLOCAL,ix,iLGopt,val,ex_opt1;
	char c,opt,optw;
	tdtINFO_PARM *pInfoParm, ***pTBL_vnam;
	ProcCT  *proc;

	rc = 0;
	if (ppar_pSize) {
		ppar_pSize->par = NULL;
		ppar_pSize->parlen = 0;
	}
	if (!ppInfoParm) return -1;
	*ppInfoParm = NULL;
	pInfoParm = NULL;
	iEROUT_NDEF = !(iOpt & D_GX_OPT_NOEROUT_NDEF);
	if ((opt=opti) == 'R') {
		iEROUT_NDEF = 0;
		iOpt |= D_GX_OPT_NOEROUT_NDEF;
		opt = 'r';
	}
	iLOCAL = iOpt & D_GX_OPT_SET_LOCAL;

DEBUGOUTL5(190,"--->cl_gx_get_all_var_ent: opti=%c pScCT=%08x ParmNo=%d %s(%s)",
opti,pScCT,ParmNo,name,varnam);
DEBUGOUTL3(190,"cl_gx_get_all_var_ent: iOpt=%08x opt=%c iEROUT_NDEF=%d",iOpt,opt,iEROUT_NDEF);

	if ((c=name[0])=='$' || (c!='%' && c!='#')) {
		if (ParmNo == 0 && *varnam) {	/* złȂϐ̃`FbN */
										/* $,%,#Ȃœo^Ă */
		/*
			if (ppar_pSize) {
				ppar_pSize->par = NULL;
				ppar_pSize->parlen = 0;
			}
		*/
			if (iOpt & (D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_GLOBAL | D_GX_OPT_SET_PUBLIC/* | D_GX_OPT_SET_PRIVATE*/))
				return cl_gx_get_lg_var_ent(pScCT,opti,name,ppInfoParm,varnam,iOpt);
			vnlen = strlen(varnam);
			if (cl_chk_sysvar_name(varnam,vnlen)) {
				pInfoParm = cl_gx_setprm_list_g(varnam,vnlen);
			}
			else {
				ex_opt1 = cl_get_option(1,0);
				if ((ex_opt1 & 0x02) && !(ex_opt1 & 0x10)) opt = 's';	/* 2021.7.16 add */
				iLGopt = 0;
				proc = NULL;
				if (pScCT) proc = cl_search_proc_ct();
/*
printf("cl_gx_get_all_var_ent: proc=%08x\n",proc);
*/
				ParmNo = cl_gx_get_parm_no(pScCT,proc,varnam,vnlen,'r',0,&pTBL_vnam,&iLGopt);
DEBUGOUTL1(190,"cl_gx_get_all_var_ent:r ParmNo=%d",ParmNo);
				if (ParmNo <= 0) {
				/*	ex_opt1 = cl_get_option(1,0);	*/
				/*	if (ex_opt1 & 0x02) ;
					else */
#if 1	/* 2021.8.4 */
					if (opt == 'r') {
#else
					if (opt=='r' ||
					    (opt=='s' && !(opt & D_GX_OPT_DEFINE) && (ex_opt1 & 0x10))) {
#endif
										/* cl_gx_get_all_var_ent: %s(%s)͖`łB */
						if (iEROUT_NDEF)
							ERROROUT3(FORMAT(317),_fn_,name,varnam);
						else if (!(iOpt & D_GX_OPT_NOHOLD_NDEF))
							ERRORHOLD5(FORMAT(317),_fn_,name,varnam,0,0);
						return ECL_NDEFVAR_ERROR;
					}
					ParmNo = cl_gx_get_parm_no(pScCT,proc,varnam,vnlen,'s',iOpt,&pTBL_vnam,&iLGopt);
DEBUGOUTL1(190,"cl_gx_get_all_var_ent:s ParmNo=%d",ParmNo);
				}
				if (ParmNo <= 0) {
					if (opt == 's')
						/* cl_gx_get_all_var_ent: %s(%s)̃Ggp̋󂫂܂B */
						ERROROUT3(FORMAT(316),_fn_,name,varnam);
					else {
										/* cl_gx_get_all_var_ent: %s(%s)͖`łB */
						if (iEROUT_NDEF) ERROROUT3(FORMAT(317),_fn_,name,varnam);
						return ECL_NDEFVAR_ERROR;
					}
					return ECL_SCRIPT_ERROR;
				}
				else {
					pInfoParm = cl_get_var_ent_opt(pTBL_vnam,ParmNo,opt);
					if (!pInfoParm) rc = -2;
					else {
						pInfoParm->pi_aux[1] |= D_AUX1_HASHED_NAME | iLGopt;
						if (opt == 's') pInfoParm->pi_aux[1] |= D_AUX1_OPT_STORE;
					}
				}
			}
		}
		else {
			if (!*varnam &&
			    (iOpt & (D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL))) {
				/* cl_gx_get_all_var_ent: %s͎gpł܂B */
				ERROROUT2(FORMAT(318),_fn_,name);
				return ECL_SCRIPT_ERROR;
			}
			if (!pScCT) return -1;
			pSize = (int *)pScCT->Vary->pTBL_dolu[0];
			if (ParmNo>0 && ParmNo<=pSize[2]) {
				pInfoParm = cl_get_var_ent_opt_psize(pScCT->Vary->pTBL_dolu,ParmNo,'r',ppar_pSize);
				if (!pInfoParm) rc = -2;
				else pInfoParm->pi_aux[1] |= D_AUX1_PRIVATE_VAR;
			}
			else if (opt=='r' && ParmNo==0) {
				pInfoParm = cl_var_size_parm(pSize);
			}
			else rc = -1;
		}
	}
	else if (c=='%' || c=='#') {
		if (!ParmNo && *varnam) {
			/* cl_gx_get_all_var_ent: %s͎gpł܂B */
			ERROROUT2(FORMAT(318),_fn_,name);
			return (ECL_SCRIPT_ERROR);
		}
		else {
			if (!pScCT) return -1;
			if (c == '%') {
				if (iLOCAL) {
					if (!(proc = cl_search_proc_ct())) return SysError;
					if (pTBL_vnam=proc->pTBL_pasento) pSize = (int *)pTBL_vnam[0];
					else ParmNo = -1;
					iLGopt = D_AUX1_LOCAL_VAR;
				}
				else {
					pTBL_vnam = pScCT->Vary->pTBL_pasento;
					pSize = (int *)pTBL_vnam[0];
					iLGopt = D_AUX1_PRIVATE_VAR;
				}
				if (ParmNo>0 && ParmNo<=pSize[2]) {
					pInfoParm = cl_get_var_ent(pTBL_vnam,ParmNo);
				/*	pInfoParm = cl_get_var_ent_opt_psize(pTBL_vnam,ParmNo,'r',ppar_pSize);	*/
				}
				else if (ParmNo == 0) {
					pInfoParm = cl_var_size_parm(pSize);
				}
				else rc = -1;
				if (!rc && pInfoParm) {
					if (!pInfoParm->pi_id) cl_null_parm(pInfoParm);
					pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED | iLGopt;
				}
			}
			else if (c=='#') {
				if (ParmNo>0 && ParmNo<=pScCT->Vary->varnam_igeta)
					pInfoParm = cl_get_var_ent_opt_psize(pScCT->Vary->pTBL_igeta,ParmNo,'r',ppar_pSize);
				else if (ParmNo == 0) {
					pInfoParm = cl_var_size_parm(pScCT->Vary->pTBL_igeta[0]);
				}
				else rc = -1;
				if (!rc) pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED | D_AUX1_PRIVATE_VAR;
			}
		}
	}
	else {
		/* cl_gx_get_all_var_ent: %s͕ϐł͂܂B */
		ERROROUT2(FORMAT(319),_fn_,name);
		return (ECL_SCRIPT_ERROR);
	}

DEBUGOUT_InfoParm(194,"cl_gx_get_all_var_ent: rc=%d name=%s",pInfoParm,rc,name);

	if (rc) {
		if (rc == -1)
			/* cl_gx_get_all_var_ent: %s̃CfbNX(%d)͔͈͊OłB */
			ERROROUT3(FORMAT(320),_fn_,name,ParmNo);
		else
			/* cl_gx_get_all_var_ent: %spMallocG[B*/
			ERROROUT2(FORMAT(321),_fn_,name);
		return ECL_SCRIPT_ERROR;
	}
	if (pInfoParm == NULL) {
		return ECL_SCRIPT_ERROR;
	}
	else if (opt == 'r' && pInfoParm->pi_id == '\0') {
		if (pGlobTable->options[0] & 0x01) {
			val = pInfoParm->pi_aux[1];
			cl_null_data(pInfoParm);
			pInfoParm->pi_aux[1] = val;
			rc = 0;
		}
		else {
			if (iOpt & D_GX_OPT_INFO_MODE) rc = 0;
			else {
								/* cl_gx_get_all_var_ent: %s̃f[^ݒłB */
				if (iEROUT_NDEF) ERROROUT2(FORMAT(127),_fn_,name);
				rc = ECL_NO_DATA_ERROR;
			}
		}
	}
#if 1	/* 2021.3.24 */
	else if (iEROUT_NDEF && ((c=pInfoParm->pi_id)=='A' || c=='R') && pInfoParm->pi_hlen) {
#else
	else if (((c=pInfoParm->pi_id)=='A' || c=='R') && pInfoParm->pi_hlen) {
#endif
#if 1	/* 2021.4.4 */
		if (rc = _check_gid_alive(pInfoParm,_fn_,name,iEROUT_NDEF)) return rc;
#else
		if ((ix=akxs_xhasl(pGLprocTable->pha_gid,'R',pInfoParm->pi_hlen,0)) <= 0) {
			if (iEROUT_NDEF) {
						/* cl_gx_get_all_var_ent: ϐ(%s)̔z͖ł(gid hash ix=%d)B */
				ERROROUT3(FORMAT(322),_fn_,name,ix);
				cl_free_info_parm(pInfoParm);
				return ECL_NDEFVAR_ERROR;
			}
		/*	return ECL_NDEFVAR_ERROR;	*/
		}
#endif
	}
	*ppInfoParm = pInfoParm;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _get_lg_var_ent(scope,opti,pxha,varnam,vnlen,iOpt)
char *scope,opti;
XHASHB	*pxha;
char *varnam;
int vnlen,iOpt;
{
	static char *_fn_="_get_lg_var_ent";
	int iParmNo,iEROUT_NDEF;
	char opt,name[Var_NM_MAX+1];

	iEROUT_NDEF = !(iOpt & D_GX_OPT_NOEROUT_NDEF);
	if (pGlobTable->options[0] & 0x02) opt = 's';
	else opt = opti;
	memnzcpy(name,varnam,vnlen,sizeof(name));
/*
printf("_get_lg_var_ent: opti=%c name=[%s]\n",opti,name);
*/
	if ((iParmNo=cl_gx_chk_vnam('r',pxha,varnam,vnlen)) < 0) return iParmNo;
	else if (!iParmNo) {
#if 1	/* 2021.8.4 */
		if (opt != 's') {
#else
		if (opt!='s' || (opt=='s' && !(iOpt & D_GX_OPT_DEFINE) && (cl_get_option(1,0) & 0x10))) {
#endif
								/* cl_gx_get_all_var_ent: %s(%s)͖`łB */
			if (iEROUT_NDEF) ERROROUT3(FORMAT(317),_fn_,name,varnam);
			else ERRORHOLD5(FORMAT(317),_fn_,name,varnam,0,0);
			return ECL_NDEFVAR_ERROR;
		}
		if (opt == 's') {
			iParmNo = cl_gx_chk_vnam(opt,pxha,varnam,vnlen);
			if (iParmNo <= 0) {
						/* _get_lg_var_ent: %s%sGgp̋󂫂܂B */
				ERROROUT3(FORMAT(323),_fn_,name,scope);
				iParmNo = ECL_SCRIPT_ERROR;
			}
		}
	}
DEBUGOUTL5(190,"%s: scope=[%s] opt=%c name=[%s] iParmNo=%d",_fn_,scope,opt,name,iParmNo);
	return iParmNo;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_lg_var_ent(pScCT,opti,name,ppInfoParm,varnam,iOpt)
ScrPrCT	  *pScCT;
char opti,*name;
tdtINFO_PARM **ppInfoParm;
char *varnam;
int  iOpt;
{
	return cl_gx_get_lg_var_ent_psize(pScCT,opti,name,ppInfoParm,varnam,iOpt,NULL);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_lg_var_ent_psize(pScCT,opti,name,ppInfoParm,varnam,iOpt,ppar_pSize)
ScrPrCT	  *pScCT;
char opti,*name;
tdtINFO_PARM **ppInfoParm;
char *varnam;
int  iOpt;
ParList *ppar_pSize;
{
	static char *_fn_="cl_gx_get_lg_var_ent";
	int rc,vnlen,iEROUT_NDEF;
	tdtINFO_PARM *pInfoParm, ***pTBL_vname;
	ProcCT  *proc,*procW;
	int  iParmNo,iLGopt;
	XHASHB	*pxha;

DEBUGOUTL5(190,"--->%s: pScCT=%08x opti=[%c] varnam=[%s] iOpt=%08x",_fn_,pScCT,opti,varnam,iOpt);

	iEROUT_NDEF = !(iOpt & D_GX_OPT_NOEROUT_NDEF);
	rc = 0;
	vnlen = strlen(varnam);
	vnlen = akxnskipto(varnam,vnlen,".");
	if (pScCT) proc = cl_search_proc_ct();
	if (iOpt & D_GX_OPT_SET_LOCAL) {
		proc = NULL;
		if (pScCT) proc = cl_search_proc_ct();
/*
printf("%s: proc=%08x\n",_fn_,proc);
*/
		if (proc && proc->pha_vnam) {
			if (opti=='r' && !(pGlobTable->options[0] & 0x02)) {
				if ((iParmNo=cl_gx_chk_scope(opti,proc,varnam,vnlen,&procW)) < 0) return iParmNo;
				else if (!iParmNo) {
								/* %s: %s͖`łB */
					if (iEROUT_NDEF) ERROROUT2(FORMAT(127),_fn_,strname(varnam,vnlen));
					return ECL_NDEFVAR_ERROR;
				}
				pTBL_vname = procW->pTBL_vnam;
			}
			else {
				pxha = proc->pha_vnam;
				if ((iParmNo=_get_lg_var_ent("LOCAL",opti,pxha,varnam,vnlen,iOpt)) < 0) return iParmNo;
				pTBL_vname = proc->pTBL_vnam;
			}
			iLGopt = D_AUX1_LOCAL_VAR;
		}
		else return -1;
	}
	else {
		if (iOpt & D_GX_OPT_SET_GLOBAL) {
			pxha = pGLprocTable->pha_vnam;
			if ((iParmNo=_get_lg_var_ent("GLOBAL",opti,pxha,varnam,vnlen,iOpt)) < 0) return iParmNo;
			pTBL_vname = pGLprocTable->pTBL_vnam;
			iLGopt = D_AUX1_GLOBAL_VAR;
		}
		else if (iOpt & D_GX_OPT_SET_PUBLIC) {
			pxha = pCLprocTable->pha_vnam;
			if ((iParmNo=_get_lg_var_ent("PUBLIC",opti,pxha,varnam,vnlen,iOpt)) < 0) return iParmNo;
			pTBL_vname = pCLprocTable->pTBL_vnam;
			iLGopt = D_AUX1_PUBLIC_VAR;
		}
		else if (pScCT) {
			pxha = pScCT->Vary->pha_vnam;
			if ((iParmNo=_get_lg_var_ent("SCRIPT",opti,pxha,varnam,vnlen,iOpt)) < 0) return iParmNo;
			pTBL_vname = pScCT->Vary->pTBL_vnam;
			iLGopt = D_AUX1_PRIVATE_VAR;
		}
		else {
			/* %s: SCRIPTϐ[%s]͒`ł܂B */
			ERROROUT2(FORMAT(324),_fn_,varnam);
			return ECL_SCRIPT_ERROR;
		}
	}

DEBUGOUTL2(190,"%s: iParmNo = %d",_fn_,iParmNo);

	pInfoParm = cl_get_var_ent_opt_psize(pTBL_vname,iParmNo,'r',ppar_pSize);
	if (!pInfoParm) rc = -2;
	else {
		if (opti=='r' && pInfoParm->pi_id == '\0') {
			if (pGlobTable->options[0] & 0x01) {
				cl_null_data(pInfoParm);
				rc = 0;
			}
			if (iOpt & D_GX_OPT_INFO_MODE) rc = 0;
			else {
				if (iEROUT_NDEF) ERROROUT2(FORMAT(127),_fn_,varnam);
				rc = ECL_NO_DATA_ERROR;
			}
		}
		pInfoParm->pi_aux[1] |= D_AUX1_HASHED_NAME | iLGopt;
	}

	if (ppInfoParm) *ppInfoParm = pInfoParm;
	return rc;
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_var_ent(pVarIndex,ParmNo)
tdtINFO_PARM **pVarIndex[];
int ParmNo;
{
	return cl_get_var_ent_opt(pVarIndex,ParmNo,'r');
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_var_ent_opt(pVarIndex,ParmNo,opt)
tdtINFO_PARM **pVarIndex[];
int ParmNo;
char opt;
{
	ParList par_pSize;

	return cl_get_var_ent_opt_psize(pVarIndex,ParmNo,opt,&par_pSize);
}

/****************************************/
/*										*/
/****************************************/
tdtINFO_PARM *cl_get_var_ent_opt_psize(pVarIndex,ParmNo,opt,ppar_pSize)
tdtINFO_PARM **pVarIndex[];
int ParmNo;
char opt;
ParList *ppar_pSize;
{
	int ix,iy,i,*pSize,iMAX_VAR_IX,iMAX_VAR_IY,val;
	tdtINFO_PARM *pDummy, **TBL_var;

	if (!pVarIndex || ParmNo<=0) return NULL;
	pSize = (int *)pVarIndex[0];
	if (ParmNo > pSize[2]) return NULL;
	iMAX_VAR_IX = pSize[0];
	iMAX_VAR_IY = pSize[1];
	pVarIndex++;
/*
printf("cl_get_var_ent: id=%s iMAX_IX=%d iMAX_IY=%d MAX_XY=%d\n",
&pSize[3],iMAX_VAR_IX,iMAX_VAR_IY,pSize[2]);
*/
	ParmNo--;
	ix = ParmNo / iMAX_VAR_IY;
	iy = ParmNo % iMAX_VAR_IY;

DEBUGOUTL4(190,"--->cl_get_var_ent_opt_psize:pVarIndex=%08x ParmNo=%d ix=%d iy=%d",
pVarIndex,ParmNo,ix,iy);

	if (!(TBL_var = pVarIndex[ix])) {
		if (!(TBL_var=(tdtINFO_PARM **)Malloc(sizeof(tdtINFO_PARM *)*iMAX_VAR_IY)))
			return NULL;
/*
printf("cl_get_var_ent_opt_psize:Malloc TBL_var=%08x\n",TBL_var);
*/
		memset(TBL_var,0,sizeof(tdtINFO_PARM *)*iMAX_VAR_IY);
		pVarIndex[ix++] = TBL_var;
		pSize[5] = X_MAX(ix,pSize[5]);
		if (!(pDummy=(tdtINFO_PARM *)Malloc(sizeof(tdtINFO_PARM)*iMAX_VAR_IY)))
			return NULL;
/*
printf("cl_get_var_ent_opt_psize:Malloc pDummy=%08x\n",pDummy);
*/
		for(i=0;i<iMAX_VAR_IY;i++) {
			TBL_var[i] = (tdtINFO_PARM *)parm_set0(pDummy);
			pDummy++;
		}
	}
	ParmNo++;
/*	pSize[6] = X_MAX(ParmNo,pSize[6]);	*/
	pSize[6] = ParmNo;
/*
printf("cl_get_var_ent_opt_psize: ParmNo=%d pSize[6]=%d\n",ParmNo,pSize[6]);
*/
	if (opt == 's') {
		cl_set_max_var_ent(pSize,ParmNo);
		if (ppar_pSize) {
			ppar_pSize->par = NULL;
			ppar_pSize->parlen = 0;
		}
	}
	else {
		if (ppar_pSize) {
			ppar_pSize->par = (char *)pSize;
			ppar_pSize->parlen = ParmNo;
		}
	}
/*
printf("cl_get_var_ent_opt_psize:TBL_var[iy]=%08x\n",TBL_var[iy]);
*/
	pDummy = TBL_var[iy];
	if (!pDummy->pi_id && (pGlobTable->options[0] & 0x01)) cl_null_data(pDummy);

DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"cl_get_var_ent_opt_psize:",pDummy,0,0);

	return pDummy;
}

/****************************************/
/*										*/
/****************************************/
int cl_set_max_var_ent(pSize,ParmNo)
int *pSize,ParmNo;
{
	tdtINFO_PARM *pInfoParm;
	int ret,val;
	char *name;

	if (ParmNo<0 || ParmNo>pSize[7]) {
		name = (char *)&pSize[3];

DEBUGOUTL3(200,"cl_set_max_var_ent: name=[%s] ParmNo=%d pSize[7]=%d",name,ParmNo,pSize[7]);

		if (ParmNo < 0) ParmNo = 0;
		pSize[7] = ParmNo;
		pInfoParm = cl_var_size_parm(pSize);
		cl_set_parm_bin(pInfoParm,ParmNo);
		pInfoParm->pi_aux[1] |= D_AUX1_PROTECTED;
	/*	ret = cl_reflect_size_of_number_array(name,ParmNo);	*/
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _free_info_array(pDummy)
tdtINFO_PARM *pDummy;
{
	tdtArrayIndex *pIndex;
	char *p;

	if (pIndex=(tdtArrayIndex *)pDummy->pi_data) {
/*
printf("_free_info_array: pDummy->pi_pi_scale=%08x\n",pDummy->pi_scale);
*/
		if (pDummy->pi_scale & D_DATA_INDEX_FREE) cl_free_array_ent(pIndex);
		Free(pIndex);
	}
	if (p=(char *)pDummy->pi_pos) {
		if (!(pDummy->pi_alen & D_AULN_NO_AL_LPOS)) Free(p);
		pDummy->pi_pos = 0;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_free_info_parm(pDummy)
tdtINFO_PARM *pDummy;
{
	tdtArrayIndex *pIndex;
	char c,*p;
	XHASHB *xhp;
	tdtINFO_PARM *pParm;
	tdtINFO_PARM *pInfoParm1,*pInfoS;
	tdtRB_CTL *pCt;
	tdtDefType *pDeftype;
	int ix,type,i,len,n,rc;
	ProcCT *proc;

DEBUGOUT_InfoParm(250,"--->cl_free_info_parm:",pDummy,0,0);
DEBUGOUTL1(250,"cl_free_info_parm: pDummy->pi_data=%08x",pDummy->pi_data);

	if (pDummy && pDummy->pi_id) {
DEBUGOUTL2(250,"cl_free_info_parm: id=[%c] pi_scale=%02x",pDummy->pi_id,pDummy->pi_scale);
		if (pDummy->pi_scale & D_DATA_MALLOC) {
#if 0	/* 2022.9.20 */
			if (pCLprocTable->Vary) {
				if (!pCLprocTable->Vary->varnam_dolu) {
					if ((c=pDummy->pi_id)=='R' || c=='A' || c=='T') {
						if (akxs_xhasl(pCLprocTable->Vary->pha_vnam,'R',pDummy,NULL) > 0) {
printf("cl_free_info_parm: id=[%c] pDummy=%08x found. not free.\n",c,pDummy);
							return ECL_NOT_FREE_INFO;
						}
					}
				}
			}
#endif
			if ((c=pDummy->pi_id)=='R' || c=='A') {
				_free_info_array(pDummy);
			}
			else if (c=='P' || c=='T') {
				if (c == 'P') {
					if (pDummy->pi_len > 0) {
						ix = akxs_xhasl(pGLprocTable->pha_gid,'D',pDummy->pi_len,0);
/*
printf("cl_free_info_parm: Delete gid=%ld ix=%d\n",pDummy->pi_len,ix);
*/
					}
					type = pDummy->pi_aux[0] & ~DEF_ZOK_DATA;
				}
				else type = D_AUX0_TYPE_STRUCT;
				if (type == D_AUX0_TYPE_STRUCT) {
					if (pDeftype=(tdtDefType *)pDummy->pi_data) {
						if (pDummy->pi_scale & D_DATA_INDEX_FREE)
							cl_free_deftype(c,pDeftype);
						Free(pDeftype);
					}
					if (!(pDummy->pi_alen & D_AULN_NO_AL_LPOS)) {
						if (p=(char *)pDummy->pi_pos) {
							Free(p);
							pDummy->pi_pos = 0;
						}
					}
				}
				else _free_info_array(pDummy);
			}
			else if (c==D_DATA_ID_LIST || c==D_DATA_ID_NARABI) {
				if (pCt=(tdtRB_CTL *)pDummy->pi_data) {
				/*	if (pDummy->pi_scale & D_DATA_INDEX_FREE) {	*/
						while (pParm=(tdtINFO_PARM *)akxs_rb_get_n(pCt)) {
							rc = cl_free_info_parm(pParm);
							if (rc != ECL_NOT_FREE_INFO) {
								if (!pCt->rb_malloc) Free(pParm);
							}
						}
						akxs_rb_free(pCt);
				/*	}
					else Free(pCt);	*/
				}
			}
#if 0	/* 2022.9.17 */
/*
			else if (c==D_DATA_ID_INSTANCE) {
DEBUGOUTL3(250,"cl_free_info_parm: id=%c pDummy=%08xpi_data=[%s] not free.",c,pDummy,pDummy->pi_data);
printf("cl_free_info_parm: id=%c pDummy=%08x pi_data=[%s] not free.\n",c,pDummy,pDummy->pi_data);
				;
			}
*/
			else if (c=='i') {
DEBUGOUTL3(250,"cl_free_info_parm: id=%c pDummy=%08xpi_data=[%s]",c,pDummy,pDummy->pi_data);
/*
printf("cl_free_info_parm: id=%c pDummy=%08x pi_data=[%s]\n",c,pDummy,pDummy->pi_data);
*/
				if (p=pDummy->pi_data) Free(p);
				if (proc=(ProcCT *)pDummy->pi_len) {
					cl_prc_clear(proc);
				}
			}
#endif
			else if (c==D_DATA_ID_INSTANCE || c==D_DATA_ID_CLASS || c==D_DATA_ID_CLMETHOD) {
DEBUGOUTL4(250,"cl_free_info_parm: id=%c pDummy=%08x pi_scale=%02x pi_data=[%s]"
,c,pDummy,pDummy->pi_scale,pDummy->pi_data);
/*
printf("cl_free_info_parm: id=%c pDummy=%08x pi_scale=%02x pi_data=[%s]\n",c,pDummy,pDummy->pi_scale,pDummy->pi_data);
*/
				if (p=pDummy->pi_data) Free(p);
				if (proc=(ProcCT *)pDummy->pi_len) {
					if (pDummy->pi_scale & D_DATA_CLEAR_PROC) cl_prc_clear(proc);
				/*	if (!(pDummy->pi_scale & D_DATA_COPIED_PROC)) cl_prc_clear(proc);	*/
				/*	else if (!(pDummy->pi_scale & D_DATA_NO_FREE_PROC)) Free(proc);	*/
				}
			}
			else if (c == D_DATA_ID_PNAME) {
				if (pInfoParm1 = (tdtINFO_PARM *)pDummy->pi_pos) {
					if (pDummy->pi_scale & D_DATA_INDEX_FREE) {
DEBUGOUTL1(198,"cl_free_info_parm: pInfoParm1=%08x",pInfoParm1);
						rc = cl_free_info_parm(pInfoParm1);
						if (rc != ECL_NOT_FREE_INFO) {
DEBUGOUTL1(198,"cl_free_info_parm: Free(pInfoParm1)",0);
							Free(pInfoParm1);
						}
					}
				}
			}
			else if (p=pDummy->pi_data) Free(p);
			pDummy->pi_data = NULL;
		}
		else if (pDummy->pi_alen & D_AULN_PARMINFO2) {
			pInfoParm1 = pDummy + 1;
			if (pInfoParm1->pi_scale & D_DATA_MALLOC) {
				len = pInfoParm1->pi_dlen;
				pInfoS = (tdtINFO_PARM *)pInfoParm1->pi_data;
				n = len/sizeof(tdtINFO_PARM);
				for (i=0;i<n;i++,pInfoS++) {
					pInfoS->pi_alen &= ~D_AULN_PARMINFO2;
					cl_free_info_parm(pInfoS);
				}
				Free(pInfoParm1->pi_data);
			}
		}
		cl_parm_set0(pDummy);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_free_var_ent_opt(pVarIndex,reset)
tdtINFO_PARM **pVarIndex[];
int reset;
{
	int ix,iy;
	tdtINFO_PARM *pDummy, **TBL_var;
	int *pSize,iMAX_VAR_IX,iMAX_VAR_IY;

DEBUGOUTL1(190,"--->cl_free_var_ent:pVarIndex=%08x",pVarIndex);

	if (!pVarIndex) return -1;
	pSize = (int *)pVarIndex[0];
	iMAX_VAR_IX = pSize[5];
	iMAX_VAR_IY = pSize[1];
	pVarIndex++;

DEBUGOUTL4(190,"cl_free_var_ent: id=%s iMAX_IX=%d iMAX_IY=%d MAX_XY=%d",
&pSize[3],iMAX_VAR_IX,iMAX_VAR_IY,pSize[2]);

	for (ix = 0; ix < iMAX_VAR_IX; ix++) {
		if (TBL_var = pVarIndex[ix]) {
			if (TBL_var[0]) {
				for (iy = 0; iy < iMAX_VAR_IY; iy++) {
					pDummy = TBL_var[iy];
					if (pDummy && pDummy->pi_id) {
						if (reset) parm_set0(pDummy);
						else cl_free_info_parm(pDummy);
					}
				}
				if (!reset) Free(TBL_var[0]);
			}
			if (!reset) {
				Free(TBL_var);
				pVarIndex[ix] = NULL;
			}
		}
	}
	if (reset) {
		pSize[5] = pSize[6] = pSize[7] = 0;
		cl_set_parm_bin(cl_var_size_parm(pSize),0);
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_free_var_ent(pVarIndex)
tdtINFO_PARM **pVarIndex[];
{
	return cl_free_var_ent_opt(pVarIndex,0);
}

/****************************************/
/*										*/
/****************************************/
int cl_reset_var_ent(pVarIndex)
tdtINFO_PARM **pVarIndex[];
{
	return cl_free_var_ent_opt(pVarIndex,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_chk_scope(opt,proc,varnam,vnlen,pprocW)
char     opt;
ProcCT  *proc;
char    *varnam;
int      vnlen;
ProcCT  **pprocW;
{
	ProcCT	*procW;
	char *path0,*path;
	int ParmNo,len,len0;

DEBUGOUTL2(120,"cl_gx_chk_scope:Enter opt=%c varnam=[%s]",opt,strname(varnam,vnlen));
/*
printf("cl_gx_chk_scope: proc->pha_vnam=%08x\n",proc->pha_vnam);
*/
	if ((ParmNo=cl_gx_chk_vnam(opt,proc->pha_vnam,varnam,vnlen)) > 0) *pprocW = proc;
	else if (!ParmNo && (pGlobTable->options[7] & 0x02) && (path=proc->ProcPath)) {
	/*	path = proc->ProcPath;	*/

DEBUGOUTL1(120,"cl_gx_chk_scope: path=[%s]",path);

		if (*path == '*') {
			path++;
		}
		if ((len=akxnrskipto(path,strlen(path),".")) <= 0) return 0;
		procW = proc;
		while (procW = procW->prePCT) {
/*
printf("cl_gx_chk_scope: procW->ProcPath=%08x\n",procW->ProcPath);
*/
			if (path0 = procW->ProcPath) {
				len0 = strlen(path0);
/*
printf("cl_gx_chk_scope: path0=[%s] len0=%d\n",path0,len0);
*/
				if (len0 <= len) {
					if (!memcmp(path,path0,len0)) {
						if ((ParmNo=cl_gx_chk_vnam(opt,procW->pha_vnam,varnam,vnlen)) > 0) {
							*pprocW = procW;
/*
printf("cl_gx_chk_scope: found ParmNo=%d in path0=[%s]\n",ParmNo,path0);
*/
							break;
						}
						else if (ParmNo < 0) return ParmNo;
					}
				}
			}
			else {
				/* cl_gx_chk_scope:W: %s̏ʂProcPathNULLproc܂B */
				ERROROUT1(FORMAT(325),path);
			}
		}
	}
DEBUGOUTL1(120,"cl_gx_chk_scope:Exit ParmNo=%d",ParmNo);
	return ParmNo;
}

/************************************/
/*	_check_gid_alive				*/
/************************************/
int _check_gid_alive(pInfoParmW,fnam,vnam,iEROUT_NDEF)
tdtINFO_PARM *pInfoParmW;
char *fnam,*vnam;
int iEROUT_NDEF;
{
	int rc,ix;

	rc = 0;
	if (pInfoParmW->pi_hlen) {
		if ((ix=akxs_xhasl(pGLprocTable->pha_gid,'R',pInfoParmW->pi_hlen,0)) <= 0) {
						/* %s: ϐ(%s)̔z͖ł(gid hash ix=%d)B */
			if (!fnam) fnam = "_check_gid_alive";
			if (!vnam) vnam = (char *)pInfoParmW->pi_pos;
			if (iEROUT_NDEF) ERROROUT3(FORMAT(322),fnam,nvalid(vnam,""),ix);
			cl_free_info_parm(pInfoParmW);
			rc = ECL_NDEFVAR_ERROR;
		}
	}
	return rc;
}

/************************************/
/*	cl_mk_static_name				*/
/************************************/
int cl_mk_static_name(wrk,prnam,prlen,varnam,vnlen)
char *wrk,*prnam,*varnam;
int prlen,vnlen;
{
	char *p;

	p = wrk;
	memcpy(p,prnam,prlen);
	p += prlen;
	*(p++) = '.';
	memzcpy(p,varnam,vnlen);
/*
printf("cl_mk_static_name: wrk=[%s]\n",wrk);
*/
	return prlen+vnlen+1;
}
