static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/******************************************************************************
*                                                                             *
*      ړI@@F  _Z                          @@@           *
*                                                                             *
*      ֐@    F@int cl_cmpt_logic(pAns,pOprtr,pInfoParm1,pInfoParm2)   *
*						(O)int		 *pAns									  *
*						(I)char		 *pOprtr								  *
*						(I)tdtINFO_PARM *pInfoParm1							  *
*						(I)tdtINFO_PARM *pInfoParm2 						  *
*                                                                             *
*      ߂l@@@F@ERROR                                    @            *
*                      NORMAL                                                 *
*                                                                             *
*      Tv@@F@                                                       *
*                                                                             *
******************************************************************************/
#include <colmn.h>
extern CLPRTBL CLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

int cl_get_logic_val(pInfoParm1)
tdtINFO_PARM *pInfoParm1;
{
	int rc,atr;
	long Value;
	double dValue;
	char *dat;
	MPA *mpa;

	rc = 1;
	if (pInfoParm1->pi_id == ' ') {
		atr = pInfoParm1->pi_attr;
		dat = pInfoParm1->pi_data;
		if (atr == DEF_ZOK_BINA) {
			memcpy(&Value,dat,sizeof(long));
			if (!Value) rc = 0;
		}
		else if (atr == DEF_ZOK_FLOA) {
			memcpy(&dValue,dat,sizeof(double));
			if (dValue == 0.0) rc = 0;
		}
		else if (atr == DEF_ZOK_DECI) {
			mpa = (MPA *)dat;
			if (mpa->zero) rc = 0;
		}
		else {
			if (!pInfoParm1->pi_dlen) rc = 0;
		}
	}
	return rc;
}

int cl_cmpt_logic(pAns,pOprtr,pInfoParm1,pInfoParm2)
long *pAns;
char *pOprtr;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
{
	int rc=0,Result,atr[2],len[2],i,k,Value[2];
	double dValue;
	char *dat[2];
	uchar *p;
	MPA *mpa;

#if 1	/* 2021.10.28 */
	Value[0] = cl_get_logic_val(pInfoParm1);
	Value[1] = cl_get_logic_val(pInfoParm2);
#else
	atr[0] = pInfoParm1->pi_attr;
	len[0] = pInfoParm1->pi_dlen;
	dat[0] = pInfoParm1->pi_data;
	atr[1] = pInfoParm2->pi_attr;
	len[1] = pInfoParm2->pi_dlen;
	dat[1] = pInfoParm2->pi_data;
	Value[0] = Value[1] = 0;
	for (k=0;k<2;k++) {
		if (atr[k] == DEF_ZOK_BINA) {
			memcpy(&Value[k],dat[k],sizeof(long));
			if (Value[k]) Value[k] = 1;
		}
		else if (atr[k] == DEF_ZOK_FLOA) {
			memcpy(&dValue,dat[k],sizeof(double));
			if (dValue != 0.0) Value[k] = 1;
			else Value[k] = 1;
		}
		else if (atr[k] == DEF_ZOK_DECI) {
			mpa = (MPA *)dat[k];
			Value[k] = mpa->zero ? 0 : 1;
		}
		else {
			if (len[k]) Value[k] = 1;
			else Value[k] = 0;
		}
	}
#endif
/*
printf("cl_cmpt_logic: Value1=%d Value2=%d pOprtr=[%s]\n",Value[1],Value[1],pOprtr);
*/
	sswitch( pOprtr )
		sicase( "AND" )
				Result = Value[0] & Value[1];
		sicase( "OR" )
				Result = Value[0] | Value[1];
		scase( "&&" )
				Result = Value[0] & Value[1];
		scase( "||" )
				Result = Value[0] | Value[1];
#if 1
		sicase( "NOT" )
				Result = ! Value[1];
		scase( "!" )
				Result = ! Value[1];
#endif
		sdefault
			/* cl_cmpt_logic: Zq(%s)Ɍ肪܂B */
			ERROROUT2(FORMAT(245),"cl_cmpt_logic",pOprtr);
			Result = 0;
			rc = ECL_SCRIPT_ERROR;
	endssw;

	*pAns = Result;
	return rc;

}

/****************************************/
/*										*/
/****************************************/
int cl_cmpt_agg(pInfoParmW,pOprtr,pInfoParm1,pInfoParm2)
tdtINFO_PARM *pInfoParmW;
char         *pOprtr;
tdtINFO_PARM *pInfoParm1;
tdtINFO_PARM *pInfoParm2;
{
	int ret;
	char op,id1,id2;
	tdtRB_CTL *pCt;

	op = *pOprtr;
	id1 = pInfoParm1->pi_id;
	id2 = pInfoParm2->pi_id;
	if (id1=='L' || id2=='L' || id1=='N' || id2=='N') {
		if (op=='+' || op=='|') {
			ret = cl_gx_list_add(pInfoParmW,op,pInfoParm1,pInfoParm2);
		}
		else if (op=='-' || op=='&' || op=='^') {
			ret = cl_gx_list_minus(pInfoParmW,op,pInfoParm1,pInfoParm2);
		}
		else {
			ERROROUT1(FORMAT(256),pOprtr);	/* cl_cmpt_agg: non suported operater(%s)!! */
			ret = -1;
		}
		if (ret>=0 && !(pGlobTable->options[4] & 0x01)) {
			if (pCt = (tdtRB_CTL *)pInfoParmW->pi_data) {
				if (akxs_rb_used(pCt) <= 0) cl_null_data(pInfoParmW);
			}
		}
	}
	else {
		if (op=='+' || op=='|') {
			ret = cl_gx_array_add(pInfoParmW,op,pInfoParm1,pInfoParm2);
		}
		else if (op=='-' || op=='&' || op=='^') {
			ret = cl_gx_array_minus(pInfoParmW,op,pInfoParm1,pInfoParm2);
		}
		else {
			ERROROUT1(FORMAT(256),pOprtr);	/* cl_cmpt_agg: non suported operater(%s)!! */
			ret = -1;
		}
	}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_cmpt_agg:Exit ret=%d pOprtr=[%s] pInfoParmW=",pInfoParmW,ret,pOprtr);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int cl_func_logic(ppWork,pOperator,nparm,ppParm,ope)
char **ppWork;
char *pOperator;
tdtINFO_PARM **ppParm;
int nparm,ope;
{
	tdtINFO_PARM *pInfoParm;
	int  i,val,iAND,iOR;
	char *pWork;

	pWork = *ppWork;
	iAND = 1;
	iOR  = 0;
	for (i=0;i<nparm;i++) {
		pInfoParm = ppParm[i];
		if (!cl_is_null_parm(pInfoParm)) {
			val = cl_get_logic_val(pInfoParm);
			if (ope==D_FUC_OR && val) {
				iOR = 1;
				break;
			}
			else if (ope==D_FUC_AND && !val) {
				iAND = 0;
				break;
			}
		}
	}
	if (ope == D_FUC_AND) val = iAND;
	else val = iOR;
	memcpy(pWork,&val,sizeof(int));
	return DEF_ZOK_BINA;
}
