static  char    sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Compile & Execution expression              */
/*                                                   */
/*           coded by A.Kobayashi 2010.10.26         */
/*                                                   */
/*****************************************************/
#include "colmn.h"
/*
#define LVL_GXCOMPL	150
#define LVL_GXEXOBJ	160
*/
#define DATA_NARABI

extern CLPRTBL  *pCLprocTable;
extern GlobalCt *pGlobTable;
extern int giOptions[];
extern char *ScopeNames[];
extern char *ScopeMarks[];
extern int  ScopeGXOpts[];
extern int  ScopeAUX1s[];

static int iEROUT_NDEF;

/****************************************/
/*										*/
/****************************************/
static char *_atr2ope(atr)
int atr;
{
	static char *ope[]={""
/*  1-10 */ ,"(",")","[","]","func(","array[","{","}",0,"cast("
/* 11-20 */ ,0,0,"NEW","++","--","!!","~~","!","~","CAST"
/* 21-30 */ ,"*","/","%","+","-","<<",">>","ABS",".","**"
/* 31-40 */ ,"<",">","<=",">=","==","!=","LIKE","MAX","MIN",0
/* 41-50 */ ,"&","^","|",0,0,0,0,">>>",0,"`"
/* 51-60 */ ,"&&","||",0,0,0,0,0,0,"?",":"
/* 61-70 */ ,0,0,"MOD",0,"iEQ","iNE",0,0,0,0
/* 71-80 */ ,"&=","^=","|=",0,0,0,0,0,"~=",0
/* 81-90 */ ,"*=","/=","%=","+=","-=","<<=",">>=","&+=",">>>=","="
/* 91-100*/ ,"PUSH",0,0,0,"..","<==","==>",",",";",0};
	char *op=NULL;

	if (atr < 0) {
		atr= -atr;
		if ((atr>=14 && atr<=19) || atr==21 || atr==24 || atr==25 || atr==30) op = ope[atr];
	}
	else if (atr < 100) {
		op = ope[atr];
	}
	return op;
}

/****************************************/
/*										*/
/****************************************/
static char *_atr2name(da,atr)
char *da[];
int atr;
{
	static char *obj[]={"Zl","֐l","ʕϐl","VXeϐl",
	                    "NULL","castl","CLASSl","new CLASSl","zl","NAME"};
	int i,j,k;
	char *p;

	if (atr<100) {
		if (!(p=_atr2ope(atr))) p = AKX_NULL_PRINT;
		return p;
	}
	j = 9;
	for (k=9001;k>=1001;k-=1000,j--) {
		if (atr >= k) {
			i = atr - k;
			break;
		}
	}
/*	if (i==998) return "֐lorzl";	*/
	if (i >= 997) {
		if (i == 998) p = obj[j-1];
		else p = obj[8];
	}
	else p = da[i];
	return p;
}

/****************************************/
/*										*/
/****************************************/
static int _rep_data_memory(im,pInfoParmW)
int im;
tdtInfoParm *pInfoParmW;
{
	tdtInfoParm tInfoParm;
	char *pW,*p;
	uchar uc;
	int rc,len;

	if (!pInfoParmW) return -1;
	if (pInfoParmW->pi_id==' ' && (len=pInfoParmW->pi_dlen)>0 &&
	    ((uc=pInfoParmW->pi_attr)==DEF_ZOK_CHAR || uc==DEF_ZOK_BULK ||
	      uc==DEF_ZOK_DECI || uc==DEF_ZOK_DATE) &&
	    (pW=pInfoParmW->pi_data)) {
		if (uc == DEF_ZOK_CHAR) len++;
		if (!(p=cl_opt_malloc(im,len))) return -1;
		memcpy(p,pW,len);
		pInfoParmW->pi_data = p;
		if (im == D_OPT_ALC_MALLOC) pInfoParmW->pi_scale |= D_DATA_MALLOC;
	}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_aux1_from_opt(opt)
int opt;
{
	int i,k;

	i = 0;
	if ((k=akxs_iseq_opt(ScopeGXOpts,D_MAX_SCOPE,opt,1)) > 0) i = ScopeAUX1s[k-1];
/*
	for (k=0;k<D_MAX_SCOPE;k++) {
		if (opt & ScopeGXOpts[k]) {
			i = ScopeAUX1s[k];
			break;
		}
	}
printf("cl_gx_get_aux1_from_opt: opt=%08x i=%08x\n",opt,i);
*/
/*
	if (opt & D_GX_OPT_SET_LOCAL) i = D_AUX1_LOCAL_VAR;
	else if (opt & D_GX_OPT_SET_PRIVATE) i = D_AUX1_PRIVATE_VAR;
	else if (opt & D_GX_OPT_SET_PUBLIC) i = D_AUX1_PUBLIC_VAR;
	else if (opt & D_GX_OPT_SET_GLOBAL) i = D_AUX1_GLOBAL_VAR;
	else i = 0;
*/
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_get_opt_from_aux1(i)
int i;
{
	int opt,k;

	opt = 0;
	if ((k=akxs_iseq_opt(ScopeAUX1s,D_MAX_SCOPE,i,1)) > 0) opt = ScopeGXOpts[k-1];
/*
	for (k=0;k<D_MAX_SCOPE;k++) {
		if (i & ScopeAUX1s[k]) {
			opt = ScopeGXOpts[k];
			break;
		}
	}
printf("cl_gx_get_opt_from_aux1: i=%08x opt=%08x\n",i,opt);
*/
/*
	if (i & D_AUX1_LOCAL_VAR) opt = D_GX_OPT_SET_LOCAL;
	else if (i & D_AUX1_PRIVATE_VAR) opt = D_GX_OPT_SET_PRIVATE;
	else if (i & D_AUX1_PUBLIC_VAR) opt = D_GX_OPT_SET_PUBLIC;
	else if (i & D_AUX1_GLOBAL_VAR) opt = D_GX_OPT_SET_GLOBAL;
	else opt = 0;
*/
	return opt;
}

/****************************************/
/*										*/
/****************************************/
static char *cl_get_scope_from_opt(opt)
int opt;
{
	char *pp;
	int k;

	pp = "";
	if ((k=akxs_iseq_opt(ScopeGXOpts,D_MAX_SCOPE,opt,1)) > 0) pp = ScopeMarks[k-1];
/*
	for (k=0;k<D_MAX_SCOPE;k++) {
		if (opt & ScopeGXOpts[k]) {
			pp = ScopeMarks[k];
			break;
		}
	}
printf("cl_gx_get_opt_from_aux1: opt=%08x pp=[%s]\n",opt,pp);
*/
/*
	if (opt & D_GX_OPT_SET_LOCAL) pp = D_STR_SCOPE_LOCAL;
	else if (opt & D_GX_OPT_SET_PRIVATE) pp = D_STR_SCOPE_PRIVATE;
	else if (opt & D_GX_OPT_SET_PUBLIC) pp = D_STR_SCOPE_PUBLIC;
	else if (opt & D_GX_OPT_SET_GLOBAL) pp = D_STR_SCOPE_GLOBAL;
	else pp = "";
*/
	return pp;
}

/****************************************/
/*										*/
/****************************************/
char *cl_gx_get_name_from_id(id)
char id;
{
	static char *ida = " ARFSULPTCIMOEN";
	static int msgnoa[15] = {329,149,150,115,339,589,153,466,154,120,159,162,114,169,170};
	char *p,c,*nam;
	int i;

	p = ida;
	nam = "";
	i = 0;
	while (c = *p++) {
		if (c == id) {
			nam = FORMAT(msgnoa[i]);
			break;
		}
		i++;
	}
	return nam;
}

/****************************************/
/*										*/
/****************************************/
char *cl_gx_get_name_from_info(pInfoParmW)
tdtInfoParm *pInfoParmW;
{
	char id,*nam;

	id = pInfoParmW->pi_id;
	if (id == ' ') {
		if (pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED) {
			nam = FORMAT(302);
			return nam;
		}
	}
	nam = cl_gx_get_name_from_id(id);
	return nam;
}

/****************************************/
/*										*/
/****************************************/
int cl_skip_scope_mark(pLprp,pLlen,pix)
char *pLprp;
int pLlen,*pix;
{
	char buf[D_LEN_SCOPE_MARK+1];
	int rc,ix;

	rc = 0;
	if (!pLprp) return -1;
	if (*pLprp == '<') {
		memzcpy(buf,pLprp,D_LEN_SCOPE_MARK);
		if (!(ix=cl_get_def_scope(buf))) {
			ERROROUT2(FORMAT(135),"cl_skip_scope_mark",buf);	/* %s: Invalid scope name[%s] */
			return -1;
		}
		if (pix) *pix = ix;
		rc = D_LEN_SCOPE_MARK;
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int _conv_arg_opt(da,pInfoParmW,opt)
char *da;
tdtInfoParm *pInfoParmW;
int opt;
{
	static char *_fn_="_conv_arg_opt";
	parmList qprmL;
	int x,rc,len;

DEBUGOUTL3(194,"--->%s:Enter: opt=%08x da=[%s]",_fn_,opt,da);

	if (!pInfoParmW) return -1;
	qprmL.prp = da;
	qprmL.prmlen = len = strlen(da);
	if (!(rc=cl_skip_scope_mark(qprmL.prp,qprmL.prmlen,&x))) ;
	else if (rc > 0) {
		qprmL.prp += rc;
		qprmL.prmlen -= rc;
	/*	opt |= x;	2022.9.26 */
		opt = (opt & ~D_GX_OPT_SET_SCOPE) | x;
	}
	else return rc;

DEBUGOUTL3(150,"%s: opt=%08x da=[%s]",_fn_,opt,qprmL.prp);

	if (rc=cl_conv_arg_opt(&qprmL,pInfoParmW,opt)) {
DEBUGOUTL2(197,"%s:<--- cl_conv_arg_opt rc=%d",_fn_,rc);
		if (rc == NAME_CONST) {
			rc = cl_conv_parm_opt(&qprmL,pInfoParmW,opt);
DEBUGOUTL2(197,"%s:<--- cl_conv_parm_opt rc=%d",_fn_,rc);
		}
		if (rc == ECL_NDEFVAR_ERROR) {
			if (cl_get_option(1,0) & 0x10) {
				ERROROUT2(FORMAT(438),_fn_,da);	/* %s: [%s]͖`łB*/
			}
			else {
				cl_set_parm_char(pInfoParmW,da,len);
				pInfoParmW->pi_id = D_DATA_ID_UNDEFVAR;
				pInfoParmW->pi_aux[1] = cl_gx_get_aux1_from_opt(opt);
				rc = 0;
			}
		}
		else if (rc==ECL_DEFINED_ARRAY || rc==NULL_PARM || rc==ECL_NO_DATA_ERROR) {
			rc = 0;
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _name_to_func_var(atr,name,pInfoParm)
int atr;
char *name;
tdtInfoParm *pInfoParm;
{
	ScrPrCT *pScCT;
	ProcCT  *cur_procct;
	Leaf    *wkleaf,*nodeleaf;
	char     id;

	if (atr == 10000) {
		wkleaf = nodeleaf = NULL;
		id = '\0';
		if (!stricmp(name,D_SYS_CLASS_SYSTEM) ||
		    !stricmp(name,D_SYS_CLASS_FILE) ||
		    !stricmp(name,D_SYS_CLASS_MATH)) {
			atr = 101;
			id = 'C';
		}
		else if (pScCT = cl_search_src_ct()) {
			cur_procct = cl_search_proc_ct();
			if (wkleaf=cl_search_class_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
				atr = 101;
				id = 'C';
			}
			else if (wkleaf=cl_search_func_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
			/*	atr = 61;	*/
				atr = 62;
				id = 'F';
			}
			else if (wkleaf=cl_search_proc_leaf_and_inner(pScCT,cur_procct,name,&nodeleaf)) {
				atr = 101;
				id = 'O';
			}
		}
#if 1	/* 2021.3.22 */
		if (atr!=62 && atr!=101) {
			atr = 3000;
			if (pInfoParm) cl_parm_set0(pInfoParm);
		}
		else if (pInfoParm) {
#else
		if (atr!=62 && atr!=101) atr = 3000;
		if (pInfoParm) {
#endif
			cl_set_parm_char(pInfoParm,name,strlen(name));
			pInfoParm->pi_id = id;
			pInfoParm->pi_len = atr;
			pInfoParm->pi_pos = (long)wkleaf;
			pInfoParm->pi_paux = (char *)nodeleaf;
			pInfoParm->pi_alen = D_AULN_SET_POS_LEAF;
		}
	}
	return atr;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_yoyakugo(name)
char *name;
{
	cmdTable *pcmd;

	if (pcmd = cl_cmd_chk(name)) {
		if (pcmd->cmdid != C_UNKNOWN) return 1;
	}
	if (cl_chk_sysvar_name(name,strlen(name))) return 3;
	if (cl_get_name_attr(name,strlen(name),0x01,0xffff)) return 2;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_is_yoyakugo_opt(name,n,white,opt)
char *name,*white[];
int n,opt;
{
	int rc;

	if ((rc=akxs_seqr_str(white,n,name,opt))) {
		if (rc > 0) rc = 0;
		return rc;
	}
	return cl_is_yoyakugo(name);
}

/****************************************/
/*										*/
/****************************************/
int cl_chk_pname_name(name)
char *name;
{
	char *p;
	int rc,len;

	if (!(p=name)) rc = -1;
	else if (cl_is_redirect_fp(name,0)) rc = 0;
	else {
		if (!(rc=cl_is_yoyakugo(name))) {
			len = strlen(p);
			if (!(rc=cl_chk_name(p,len))) {
				if ((rc=cl_gx_chk_opt(name,0))==NAME_CONST || rc==SYSVAR) rc = 0;
			}
		}
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
static int _set_null_parm(im,pGxObjExpand,piob,piob0,pida)
int im;
GXObjectExpand *pGxObjExpand;
int *piob,*piob0,*pida;
{
	short *obj;
	tdtInfoParm **obj0;
	char **da;
	int iob,iob0,ida;
	tdtInfoParm *pInfoParmW;

	iob = *piob;
	iob0 = *piob0;
	ida = *pida;

	if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
	obj[iob++]=91;
	if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
		return ECL_MALLOC_ERROR;
	cl_null_parm(pInfoParmW);
	obj[iob++]=ida;

	if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
	if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
	obj0[ida]=pInfoParmW;
	da[ida++] = "";
	iob0 = ida;

	*piob = iob;
	*piob0 = iob0;
	*pida = ida;

	return 0;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_compile_gp_opt(pgwprm,pssp,iOpt,pGxObjExpand)
GWPRM_S *pgwprm;
SSPL_S  *pssp;
int iOpt;
GXObjectExpand *pGxObjExpand;
{
	static char *name="cl_gx_compile";
	static char *fa[]={"(","[","{"};
	static tdtInfoParm tInfoParmK,tInfoParmF,tInfoParmA,tInfoParmL;
	int ida,idai,isp;
	char **da,*cast0,*word,cw,*fai,buf[64];
	short *obj;
	int nobj,iob,iob0;
	int sp;
	MCAT ms_stack,ms_stk_str;
	short *stack;
	int i,opt1,im,opt_scope;
	char *p,c,*pp;
	parmList  *prmL, qprmL;
	int atr,attr0,i1,i2,ac,mc,atrn,rc,conv_flg,len,attr1,word_len,kind;
	tdtInfoParm *pInfoParmW,**obj0,tInfoParm;
	int iobj_goto1,iobj_goto2,ista_goto1,ista_goto2,lvl_3kou1,lvl_3kou2,optimize_flg;
	int sta_goto1[10],sta_goto2[10];
	char **stk_str;
/*
printf("cl_gx_compile: len=%d buf=[%s]\n",pgwprm->line_len,pgwprm->line);
*/
	cl_parm_set0(&tInfoParm);
	cl_set_parm_bin(&tInfoParmK,0);
	tInfoParmK.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmF,1);
	tInfoParmF.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmA,2);
	tInfoParmA.pi_aux[1] = D_AUX1_FUNC_ARRY;
	cl_set_parm_bin(&tInfoParmL,3);
	tInfoParmL.pi_aux[1] = D_AUX1_FUNC_ARRY;
	iobj_goto1=iobj_goto2=ista_goto1=ista_goto2=lvl_3kou1=lvl_3kou2=0;
	iob0=iob=0;
	ida=0;
	word = pssp->wd;
	pGxObjExpand->nobj = iob;
	pGxObjExpand->nda = ida;
	pGxObjExpand->nobj0 = iob0;
	cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
	cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
	cl_gx_expand(pGxObjExpand->ms_da,-1,&da);
	cl_gx_init_expand(&ms_stack,"ST",sizeof(short),MAX_STACK);
	cl_gx_expand(&ms_stack,0,&stack);
	cl_gx_init_expand(&ms_stk_str,"SS",sizeof(char *),MAX_STACK);
	cl_gx_expand(&ms_stk_str,0,&stk_str);
	prmL = &qprmL;
	stack[0]=0;
	sp=1;
	atr=0;
	optimize_flg=0;
	im = (iOpt & D_GX_OPT_ALC_MASK)>>12;
	opt1 = (iOpt & ~D_GX_OPT_SET_SCOPE) | D_GX_OPT_SET_ADDR | D_GX_OPT_NOEROUT_NDEF;
	opt_scope = iOpt & D_GX_OPT_SET_SCOPE;
/*
printf("cl_gx_compile: *** start iOpt=%08x opt1=%08x opt_scope=%08x\n",iOpt,opt1,opt_scope);
*/
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile: *** start iOpt=%08x opt1=%08x opt_scope=%08x",iOpt,opt1,opt_scope);

	for(;;) {
		/* x++,x-- ̂Ƃ́A++,--PÔ(attr0)Ƃ͂Ȃ */
		if (atr!=14 && atr!=15) attr0 = atr;
		for(;;) {
			if ((atr=cmp_gtwd(pgwprm,pssp,iOpt))<0) return atr;
			cw = *word;
			word_len = strlen(word);

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:cmp_gtwd: attr0=%d, gtwd attr=%d, wd=[%s] ssp.sp=%d",
attr0,atr,word,pssp->sp);

			tInfoParm.pi_id = '\0';
			tInfoParm.pi_len = atr;
			tInfoParm.pi_pos = 0;
			tInfoParm.pi_paux = NULL;
			if (attr0==1 && ((atr>=3000 && atr<=5000) || atr>=10000)) {
				if (atr == 3000) i = 1;
				else if (cl_gx_is_operator(word,FUNCCAST)) i = 1;
				else i = 0;
				if (i) {
					SSPL_S qssp;
				/*	char wrk[4096];	*/

					isp = pssp->sp;
					len = word_len;	/*strlen(word);*/
					memcpy(&qssp,pssp,sizeof(SSPL_S));
					qssp.wd = word + word_len + 1;	/*wrk;*/
					if ((atrn=cmp_gtwd(pgwprm,&qssp,iOpt))<0) return atrn;
					if (atrn==1) {
/*
printf("cl_gx_compile:1 atrn=%d\n",atrn);
*/
						if (rc=cl_skip_to_delm(pgwprm->line,pgwprm->line_len,"()",&qssp," \t(),'",1)) return rc;
					/*
						pssp->sp = qssp.sp;
						memzcpy(word+strlen(word),pgwprm->line+isp,qssp.sp-isp);
					*/
/*
printf("cl_gx_compile:1 word=[%s]\n",word);
*/
						if ((atrn=cmp_gtwd(pgwprm,&qssp,iOpt))<0) return atrn;
/*
printf("cl_gx_compile:2 atrn=%d\n",atrn);
*/
					}
					if (atrn==2) {
						if ((atrn=cmp_gtwd(pgwprm,&qssp,iOpt))<0) return atrn;
						atrn = _name_to_func_var(atrn,qssp.wd,&tInfoParm);
/*
printf("cl_gx_compile:3 atrn=%d wd=[%s]\n",atrn,qssp.wd);
*/
						if (atrn==1 || atrn==3000 || atrn==4000 || atrn==5000) atr=6000;
						else if (atrn==61 || atrn==62 || atrn==63 || atrn==28) {
							if ((atrn=cmp_gtwd(pgwprm,&qssp,iOpt))<0) return atrn;
/*
printf("cl_gx_compile:4 atrn=%d\n",atrn);
*/
							if (atrn==1) atr=6000;	/* CAST */
						}
					}
/*
printf("cl_gx_compile:5 atr=%d\n",atr);
*/
					pssp->sp = isp;
					*(word+len) = '\0';
					if (atr==6000) {
						if (stack[sp-1]==1) {
							stack[sp-1] = 10;	/* 6;	*/	/* '(' of cast */
							i = obj[iob-1];
/*
printf("cl_gx_compile:6 obj=%d %d da=%s\n",obj[iob-2],i,da[i]);
*/
							if (obj[iob-2]==91 && *da[i]==*fa[0]) {
								iob -= 2;
								ida--;
							}
						}
					}
				}
			}
			if (atr==10001) atr = 62;
			if (atr == 10000) {
				if (rc=cl_get_def_scope(word)) {
					opt_scope = rc;
					continue;
				}
				else if (!stricmp(word,D_STR_NAME_STATIC)) {
					continue;
				}
#if 1	/* 2021.12.29 */
				else if (!strcmp(word,D_STR_MARK_INSTANCE)) {
					continue;
				}
#endif
#if 0	/* 2021.3.22 */
				if (attr0 == 29) {	/* . ͕̌ϊȂ *//* ϊȂƃ_ */
					atr = 3000;
					cl_parm_set0(&tInfoParm);
				}
				else atr = _name_to_func_var(atr,word,&tInfoParm);
				if (atr == 3000) {
#else
				if ((atr=_name_to_func_var(atr,word,&tInfoParm)) == 3000) {
#endif
					if (cl_is_yoyakugo(word)) {
						ERROROUT2(FORMAT(121),name,word);	/* %s: [%s]͗\łB */
						RETURN(-11)
					}
				}
			}
			pp = pssp->wd;
			pssp->wd += word_len + 1;	/*strlen(word)*/
			attr1 = cmp_peekwd(pgwprm,pssp,iOpt);
			pssp->wd = pp;
			if (atr==23 && 	/* 23=% */
				(attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==7 ||
				    attr0<0 ||
				    (attr0>=20 && attr0<2000))) {
					atr = 63;	/* ֐ */
			}
			else if (atr==13) {	/* new */
				if (attr1 == 1) atr = 62;
			}
DEBUGOUTL1(LVL_GXCOMPL+1,"cl_gx_compile: modified attr=%d",atr);

			if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==7 ||
			    (attr0>=21 && attr0<=2000)) {
				if ((atr>=14 && atr<=19) || atr==24 || atr==25 || atr==28 || atr==41 || atr==30 ||
				    atr==61 || atr==62 ||atr==63) ;
				else if (atr==98 && (attr0==0 || attr0==1 || attr0==3 ||
				                     attr0==5 || attr0==7 || attr0==98)) ;
				else if ((atr>=22 && atr<100) ||
				         (attr0==29 && (atr>=2 && atr<22))) {
					/* %s: [%s]̌[%s]̈ʒusłB */
					ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
					return -8;
				}
			}
			else if ((attr0==14 || attr0==15) && (atr==61 || atr==62 || atr>=3000)) {
				/* %s: [%s]̌[%s]̈ʒusłB */
				ERROROUT3(FORMAT(122),name,_atr2name(da,attr0),word);
				return -8;
			}
			if (atr==99) {
				atr=0;
			}
			else if ((attr0>=2000 && (atr==7 || atr==101 || atr>=2000)) ||
			         (((attr0>=4000 && attr0<6000) || (attr0>=7000 && attr0<8000)) && (atr==1 /*|| atr==3 || atr==7*/))) {
				/* %s: Zq܂B%s %s */
				ERROROUT3(FORMAT(123),name,
				          _atr2name(da,attr0),word);
				return -2;
			}
			else if (atr>=3000 && atr<=6000) {
				rc = 0;
				if (opt_scope) {
					if (atr==4000 || atr==5000) rc = -9;
					else if (atr==3000 && (cw=='$' || cw=='#' || cw=='%')) {
						if (cw=='$') {
							if (word_len>1 && atoi(word+1)) rc = -9;	/*strlen(word)*/
						}
						else rc = -9;
					}
				}
				if (rc) {
					/* %s: [%s]ɃANZXCq͎wł܂B */
					ERROROUT2(FORMAT(124),name,word);
					return rc;
				}
				if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
				if (!(da[ida]=cl_opt_malloc(im,strlen(word)+2+D_LEN_SCOPE_MARK)))
					return ECL_MALLOC_ERROR;
				p = da[ida];
				if (atr == 3000) {
					if (attr0 == 29) {
#if 1	/* 2021.3.15 */
						if (cl_chk_name_var(word,word_len)) {
#else
						pp = word;
						if (cw == '$') pp++;
						if (cl_chk_name(pp,strlen(pp))) {
#endif
							/* %s: o[[%s]słB */
							ERROROUT2(FORMAT(136),name,word);
							return ECL_SCRIPT_ERROR;
						}
					}
#if 0	/* 2021.7.20 */
					else if (attr0!=D_IMD_PNAME && attr1!=D_IMD_NAMED) {
						if (cw!='$' && cw!='%' && cw!='#') *p++ = '$';
					}
#endif
				}
				strcpy(p,word);
				if (atr==6000) cast0 = da[ida];
				atr += ++ida;
			}
			else if ((atr>=13 && atr<=19) || atr==21 || atr==24 || atr==25 || atr==41 || atr==30) {
				if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==6 || attr0==7 ||
				    (attr0>=21 && attr0<=2000) ||
					(atr!=21 && (attr0<=-14 && attr0>=-19) || attr0==-21 || attr0==-25 || attr0==-41 || attr0==-30)) {
					atr = -atr;
				}
			}
			else if (atr==61 || atr==62 || atr==63 || atr==28 || atr==101) {	/* 63=MOD 28=ABS */
				if (attr0==0 || attr0==1 || attr0==3 || attr0==5 || attr0==6 || attr0==7 ||
				    attr0<0 ||
				    (attr0>=20 && attr0<2000)) {
					if (atr == 101) {
						if (attr0 == -13) atr = 8000;	/* new CLASS */
						else atr = 7000;	/* CLASS */
					}
					else atr = 2000;	/* ֐ */
				}
				else if (atr==62 || atr==28) atr = 2000;
				else if (atr==61) {
					atr = 1000;	/* Zq */
					pssp->attr[1] = 61;
					pssp->wd = word;
				}
				if (attr0>=2000 && atr>=2000) {
								/* %s: Zq܂B%s %s */
					ERROROUT3(FORMAT(123),name,_atr2name(da,attr0),word);
					return -2;
				}
				if (atr==1000 || atr==2000 || atr==7000 || atr==8000) {
					if (opt_scope) {
						if (atr==2000 && (cw=='$' || cw=='#' || cw=='%')) ;
						else {
							/* %s: [%s]ɃANZXCq͎wł܂B */
							ERROROUT2(FORMAT(124),name,word);
							return -10;
						}
					}
					if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
					if (!(da[ida]=cl_opt_malloc(im,word_len+1+D_LEN_SCOPE_MARK)))	/*strlen(word)*/
						return ECL_MALLOC_ERROR;
					strcpy(da[ida],word);
					atr += ++ida;
				}
			}
			else if (atr==1 && ((attr0>=2001 && attr0<=5000) ||
			                    (attr0>=6001 && attr0<=7000) ||		/* ֐( */
			                    (attr0>=8001 && attr0<=9000))) {	/* new Class( */
				atr = 5;
			}
			else if (atr==2 && attr0>=6001 && attr0<=7000) {	/* CAST */
				atr = 20;
			}
			else if (atr == 3) {	/* [ */
				if ((attr0>=3001 && attr0<4000) ||	/* ʕϐ */
				    attr0==2 || attr0==4 || attr0==2998 || attr0==2999) atr = 6;	/* z[ */
				else if (attr0<=100 || (attr0>=1000 && attr0<2000)) ;	/* f[^ю̊Jn'[' */
				else {
					/* %s: z񖼂ȂsłB */
					ERROROUT1(FORMAT(137),name);
					return -10;
				}
			}
			else if (atr>=71 && atr<=90)
				opt1 &= ~(D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
			break;
		}

DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:          attr=%d opt_scope=%08x",atr,opt_scope);

		if (atr == 60) lvl_3kou2 = lvl_3kou1;
#if 1	/* 2022.1.25 */
		else if (atr==51 || atr==52) pGxObjExpand->index0 |= 0x10;
#endif

		i2=cmp_mkix(atr);
		for(;;) {
			if (sp<1) return ECL_SYNTAX_ERROR;
			i1=cmp_mkix(mc=stack[sp-1]);
			ac=cmp_act(i1,i2);
			if (atr==D_IMD_PNAME && mc==D_IMD_PNAME) ac = 3;
			if (mc==59 && atr==60) {
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile: lvl_3kou1=%d lvl_3kou2=%d",lvl_3kou1,lvl_3kou2);
				if (lvl_3kou1 < lvl_3kou2) ac = 2;
			}
			if (i1==24 && i2==1 && attr0==29) ac=2;

DEBUGOUTL5(LVL_GXCOMPL+1,"cl_gx_compile:cmp_act: attr=%d, mc=%d, act i1=%d, i2=%d, ac=%d",
atr,mc,i1,i2,ac);

			if (ac<0) return ECL_SYNTAX_ERROR;
			else if (ac == 99) {
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				obj[iob++]=ac;
				obj[iob]=0;
if (DEBUGOUTCHECK(LVL_GXCOMPL)) {
for (i=0;i<iob;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"obj[%2d]=%d",i,obj[i]);
}
for (i=0;i<iob0;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"obj0[%2d]=0x%08x",i,obj0[i]);
DEBUGOUT_InfoParm(LVL_GXCOMPL+5,"",obj0[i],0,0);
}
for (i=0;i<ida;i++) {
DEBUGOUTL2(LVL_GXCOMPL,"da[%2d]=[%s]",i,da[i]);
}
}
				pGxObjExpand->nobj = (iob+1) & (~0x01);
				pGxObjExpand->nda = ida;
				pGxObjExpand->nobj0 = iob0;
				return optimize_flg;
			}
			else if (ac == 1) {
				if (cl_gx_expand(&ms_stk_str,ida,&stk_str) < 0) return ECL_MALLOC_ERROR;
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				conv_flg = 1;
				if (atr<=3000 || atr>6000) {
					if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
						return ECL_MALLOC_ERROR;
					if (atr <= 3000) {	/* ֐ */
						idai = atr - 2001;
						p = da[idai];
						cl_set_parm_char(pInfoParmW,p,strlen(p));
						pInfoParmW->pi_id = D_DATA_ID_FUNCTION;
						pInfoParmW->pi_pos = tInfoParm.pi_pos;
						pInfoParmW->pi_paux = tInfoParm.pi_paux;
						pInfoParmW->pi_alen = tInfoParm.pi_alen;
						pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
						if (opt_scope) {
							pInfoParmW->pi_aux[1] |= cl_gx_get_aux1_from_opt(opt_scope);
							opt_scope = 0;
						}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:FUNCTION ",pInfoParmW,0,0);

							if (!(pp=cl_tmp_const_malloc(strlen(p)+1))) return ECL_MALLOC_ERROR;
							stk_str[sp] = pp;
							strcpy(pp,p);

DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:set stk_str[%d]=%s",sp,pp);

#if 1
						if (cl_get_optimize_kind(p)) {
#else
						if ((exopt26 & D_NOPTIMIZE_ALL)==D_NOPTIMIZE_ALL &&
						    inistr(",IIF,NVAL,NSVAL,NDEF,NULLIF,AND,OR",stradd(",",p)) > 0) {
#endif
							optimize_flg = C_DO_OPTIMIZE;
						}
					}
					else if (atr <= 7000) {	/* CAST */
						idai = atr - 6001;
						cl_set_parm_char(pInfoParmW,da[idai],strlen(da[idai]));
						pInfoParmW->pi_id = D_DATA_ID_FUNCTION;
						pInfoParmW->pi_aux[0] = FUNCCAST;
						pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:CAST ",pInfoParmW,0,0);

					}
					else if (atr <= 9000) {	/* CLASS */
						if (atr <= 8000) idai = atr - 7001;
						else idai = atr - 8001;
						cl_set_parm_char(pInfoParmW,da[idai],strlen(da[idai]));
						pInfoParmW->pi_id = tInfoParm.pi_id;
						pInfoParmW->pi_pos = tInfoParm.pi_pos;
						pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:CLASS ",pInfoParmW,0,0);

					}
				}
				else {
					if (atr <= 4000) {	/* Variable */
						idai = atr - 3001;
						p = da[idai];
#if 0	/* 2021.7.20 */
						if ((c=*p)=='$' || c=='%' || c=='#') {
							if ((c=*(p+1))=='$' || c=='%' || c=='#') conv_flg = 0;
						}
#endif
/*
printf("cl_gx_compile_gp_opt: opt_scope=%08x p=[%s]\n",opt_scope,p);
*/
						if (opt_scope) {
							pp = cl_get_scope_from_opt(opt_scope);
							if (!*pp) pp = D_STR_MARK_LOCAL;
							strnzcpy(buf,p,sizeof(buf)-1);
							strcpy(p,pp);
							strcat(p,buf);
							opt_scope = 0;
						}
						/* ʕϐ́AϊăAhXۑĂAsɂ́A
						   g悤ɂB(̍sRgɂ) */
						/* hbg̉EAsɖϊ悤ɂB
						   sXs[h͗ */
					/*	if (attr0 != 29) conv_flg = 0;	*/
					}
					else if (atr <= 5000) {	/* System Var. */
						idai = atr - 4001;
						conv_flg = 0;
					}
					else {
						idai = atr - 5001;	/* CONSTANT */
					}
/*
printf("cl_gx_compile_gp_opt: conv_flg=%d attr0=%d atr=%d idai=%d\n",conv_flg,attr0,atr,idai);
*/
					if (conv_flg) {
#if 0	/* 2021.7.20 */
						if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
							return ECL_MALLOC_ERROR;
#endif
						p = da[idai];
						/* 2021.2.3 */
						if (atr <= 4000) {
							c = *p;
							cw = *(p+1);
							if (attr0 == 29) {
								/* hbg̉Eʕϐ̂Ƃ́AϊAϐ̕f[^ƂĂ */
#if 1	/* 2021.7.20 */
								cl_set_parm_char(&tInfoParm,p,strlen(p));
								tInfoParm.pi_alen = D_AULN_NAME_DATA;
#else
								cl_set_parm_char(pInfoParmW,p,strlen(p));
								pInfoParmW->pi_alen = D_AULN_NAME_DATA;
#endif
							}
							else if ((attr0==D_IMD_PNAME || attr1==D_IMD_NAMED)
							     && atr<=4000 && !(c=='$' || c=='%' || c=='#')) {
#if 1	/* 2021.7.20 */
								cl_set_parm_char(&tInfoParm,p,strlen(p));
								tInfoParm.pi_id = D_DATA_ID_PNAME;
#else
								cl_set_parm_char(pInfoParmW,p,strlen(p));
								pInfoParmW->pi_id = D_DATA_ID_PNAME;
#endif
							}
#if 1
							/* 2021.7.18 *//* ʕϐ́Asɖϊ悤ɂAclear_var_obj~߂ */
							else if ((c=='$' || c=='%' || c=='#') &&
							         (cw=='$' || cw=='%' || cw=='#')) conv_flg = 0;	/* ] */
#if 1	/* 2022.10.18 */
							else if (c!='<' && c=='$' && cw=='_') conv_flg = 0;
#else
							else if (c!='<' && c=='$' && (cw<'0' || cw>'9')) conv_flg = 0;
#endif
#else
							else cl_parm_set0(pInfoParmW);
#endif
						}
#if 1	/* 2021.7.20 */
						if (conv_flg) {
							if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
								return ECL_MALLOC_ERROR;
							if (atr <= 4000)
								*pInfoParmW = tInfoParm;
							else {
								if (rc=_conv_arg_opt(p,pInfoParmW,opt1|opt_scope)) return rc;
								if (atr > 5000) {
									if (rc=_rep_data_memory(im,pInfoParmW)) return rc;
								}
							}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_compile:Conv da=[%s]",pInfoParmW,p,0);

						}
#else
						else if (rc=_conv_arg_opt(p,pInfoParmW,opt1|opt_scope)) return rc;
						if (atr > 5000) {
							if (rc=_rep_data_memory(im,pInfoParmW)) return rc;
						}
#endif
					}
				}
				if (conv_flg) {
					obj[iob++]=91;
					obj[iob++]=idai;
					if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
					obj0[idai]=pInfoParmW;
					iob0 = ida;
#if 1	/* 2020.10.08 */
					if (*p == M_QUOTE3) {
						word_len = strlen(p);
						word_len -= 2;
						if (word_len>=0) {
							if (!(pp=cl_tmp_const_malloc(word_len+2))) return ECL_MALLOC_ERROR;
							memzcpy(pp,p+1,word_len);
							p = pp + word_len - 1;
							if (*p != M_KUGIRI) {
								p++;
								*(p++) = M_KUGIRI;
								*p = '\0';
								word_len++;
							}
/*
printf("cl_gx_compile: word_len=%d pp=[%s]\n",word_len,pp);
*/
							cl_set_parm_char(pInfoParmW,pp,word_len);
							pInfoParmW->pi_aux[1] = D_AUX1_PROTECTED;
						}
						if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
						obj[iob++]=-50;
					}
#endif
				}
				else {
					obj[iob++]=92;
					obj[iob++]=idai;
				}
				opt_scope = 0;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:PUSH:    sp=%d, opr=[%s] iob=%d",sp,word,iob);
			}
			else if (ac == 2) {
				if (cl_gx_expand(&ms_stack,sp,&stack) < 0) return -4;
				stack[sp++]=atr;
				if (atr==1 || atr==5 || atr==3 || atr==6 || atr==7) {	/* ( func( [ { */
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=91;
					obj[iob++]=ida;
					if (atr==1) {
						fai = fa[0];
						pInfoParmW = &tInfoParmK;
					}
					else if (atr==5) {
						fai = fa[0];
						pInfoParmW = &tInfoParmF;
					}
					else if (atr==3 || atr==6) {
						fai = fa[1];
						pInfoParmW = &tInfoParmA;
					}
					else {
						fai = fa[2];
						pInfoParmW = &tInfoParmL;
					}
					if (cl_gx_expand(pGxObjExpand->ms_obj0,iob0,&obj0) < 0) return ECL_MAX_OBJ_ERROR;
					if (cl_gx_expand(pGxObjExpand->ms_da,ida,&da) < 0) return ECL_MAX_DA_ERROR;
					da[ida] = fai;
					obj0[ida++]=pInfoParmW;
					iob0 = ida;
#if 1	/* 2022.6.7 */
					if (atr==5) {
						p = stk_str[sp-1];
DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile: ac=%d atr=%d sp-1=%d p=[%s]",ac,atr,sp-1,p);
						if (p) {
#if 1
							kind = cl_get_optimize_kind(p);
							if (kind >= 6) {
#else
							if (!stricmp(p,"AND") || !stricmp(p,"OR")) {
#endif
								if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
								obj[iob++]=0;
								da[ida] = "0";
								obj[iob++]=92;
								obj[iob++]=ida;
								if (!(pInfoParmW=(tdtInfoParm *)cl_opt_malloc(im,sizeof(tdtInfoParm))))
									return ECL_MALLOC_ERROR;
								cl_set_parm_bin(pInfoParmW,0);
								obj0[ida++]=pInfoParmW;
								iob0 = ida;
							}
						}
					}
#endif
				}
				else if (atr == 59) {
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++] = atr;
					obj[iob++] = 0;
					sta_goto1[ista_goto1++] = iob;
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Push goto1: iob=%d ista_goto1=%d",iob,ista_goto1);
					obj[iob++] = 0;
					lvl_3kou1++;
				}
				if (atr==1 || atr==5 || atr==3 || atr==6 || atr==7) {	/* ( func( [ { */
					atrn = cmp_peekwd(pgwprm,pssp,iOpt);
					if (atrn == 98) {	/* , */
						/* ",,"ňȗꂽꍇ́ANULL} */
						if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
						cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
						cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
						cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d func(, or [,",
iob,atr,atrn,ida);

					}
				}
			}
			else if (ac == 3) {
				if (sp < 1) return ECL_SYNTAX_ERROR;
				sp--;
				if (mc == 60) {	/* : */
					if (ista_goto1==0 || ista_goto1!=ista_goto2) {
						ERROROUT2(FORMAT(178),name,pssp->sp);
						return ECL_SYNTAX_ERROR;
					}
					ista_goto1--;
					ista_goto2--;
					iobj_goto2 = sta_goto2[ista_goto2];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Pop goto2: iobj_goto2=%d ista_goto2=%d",iobj_goto2,ista_goto2);
					obj[iobj_goto2] = iob - iobj_goto2;
					lvl_3kou2--;
				}
				else if (mc == 59) {	/* ? */
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++] = 93;	/* GOTO */
					obj[iob] = 0;
					ista_goto2 = ista_goto1;
					sta_goto2[ista_goto2-1] = iob;
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Push goto2: iob=%d ista_goto2=%d",iob,ista_goto2);
					iob++;
					iobj_goto1 = sta_goto1[ista_goto1-1];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:Peek goto1: iobj_goto1=%d ista_goto1=%d",iobj_goto1,ista_goto1);
					obj[iobj_goto1] = iob - iobj_goto1;
					lvl_3kou1--;
				}
				else {
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=stack[sp];

DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:         sp=%d, opr=%s iob=%d",sp,pssp->wd,iob);

					if (mc==20 && !stricmp(cast0,"FUNC")) attr0 = 2001;
					if (mc>=14 && mc<=17) pGxObjExpand->index0 |= 0x02;
					if (mc == -30) pGxObjExpand->index0 |= 0x04;
				}
				continue;
			}
			else if (ac == 4) {	/* ( and ) or { and } */
				sp--;
				if (mc==1 || mc==5 || mc==7) {	/* ֐ */
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=mc;
					if (mc == 1) {
						if (attr0 == 1) atr = 5999;	/* NULL */
					/*	else atr = attr0;	*/
						else atr = 3999;	/*  */
						pGxObjExpand->index0 |= 0x01;
					}
					else atr = 2999;	/* ֐l */
				}
				else if (atr==20 || mc==10) {	/* CAST */
					if (cl_gx_expand(&ms_stack,sp,&stack) < 0) return -4;
					atr = 20;
					stack[sp++]=atr;
				}
				else if (attr0 == 3) atr = 5999;	/* NULL */
				else atr = attr0;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile:         sp=%d, opr=%s iob=%d",sp,word,iob);
			}
			else if (ac == 5) {	/* [ and ] z or f[^ю */
				sp--;
				if (cl_gx_expand(pGxObjExpand->ms_obj,iob,&obj) < 0) return ECL_MAX_OBJ_ERROR;
				obj[iob++]=mc;
DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_compile: sp=%d, opr=%s iob=%d",sp,word,iob);
				if (mc == 3) {
					if (attr0 == 3) atr = 5999;	/* NULL */
					else atr = attr0;
					pGxObjExpand->index0 |= 0x01;
				}
				else atr = 2998;	/* zl */
			}
			else if (ac == 6) {
				p = stk_str[sp-1];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_compile:get stk_str[%d]=%s",sp-1,p);
			/*	if (!p) p = "+";	*/
			  if (p) {
#if 1
				kind = cl_get_optimize_kind(p);
				if (kind>=1 && kind<=5) {
#else
				if (inistr(",IIF,NVAL,NSVAL,NDEF,NULLIF",stradd(",",p)) > 0) {
#endif
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+1,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=98;
					obj[iob++]=0;
				}
#if 1
				else if (kind >= 6) {
#else
				else if (!stricmp(p,"AND") || !stricmp(p,"OR")) {
#endif
					if (cl_gx_expand(pGxObjExpand->ms_obj,iob+2,&obj) < 0) return ECL_MAX_OBJ_ERROR;
					obj[iob++]=98;
					obj[iob++]=0;
					obj[iob++]=0;
				}
			  }
				atrn = cmp_peekwd(pgwprm,pssp,iOpt);
				if (atrn==98 || atrn==2 || atrn==4 || atrn==8) {
					/* ",,"ňȗꂽꍇ́ANULL} */
					if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
					cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
					cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
					cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"cl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d func(, or [,",
iob,atr,atrn,ida);

				}
			}
			else if (ac == 0) {
				if ((iOpt & D_GX_OPT_PARMINFO2) && atr==98 && (attr0==0 || attr0==98)) {
					if (rc=_set_null_parm(im,pGxObjExpand,&iob,&iob0,&ida)) return rc;
					cl_gx_expand(pGxObjExpand->ms_obj,-1,&obj);
					cl_gx_expand(pGxObjExpand->ms_obj0,-1,&obj0);
					cl_gx_expand(pGxObjExpand->ms_da,-1,&da);

DEBUGOUTL4(LVL_GXCOMPL+1,"ccl_gx_compile:         iob=%d atr=%d atrn=%d ida=%d ,,",
iob,atr,atrn,ida);

				}
			}
			else {
				return -6;
			}
			break;
		}
	}
}

/****************************************/
/*										*/
/****************************************/
int _ex_get_member(ppInfoParmW,opt,da,len)
tdtInfoParm **ppInfoParmW;
int opt;
char *da;
int len;
{
	tdtInfoParm *pInfoParmW,*pInfoParm;
	char *p,id;
	int rc=0;
	parmList  **parmName;
	tdtDefType *pDeftype;
	int i,ntype,n,datalen,iCASE;
	tdtArrayIndex *pIndex;

	if (!(pInfoParm = *ppInfoParmW)) return -1;
	pDeftype = (tdtDefType *)pInfoParm->pi_data;
	parmName = pDeftype->vname;
	iCASE = pInfoParm->pi_alen & D_AULN_IGN_CASE;
	for (i=0;i<pDeftype->ntype;i++) {
		if (len == parmName[i]->prmlen) {
			if (iCASE) {
				rc = akxmemicmp(da,parmName[i]->prp,len);
			}
			else {
				rc = memcmp(da,parmName[i]->prp,len);
			}
			if (!rc) {
				pInfoParmW = pDeftype->pType[i];
#if 1	/* 2021.2.23 */
				if (pInfoParmW->pi_id == 'F') pInfoParmW->pi_len = (long)pInfoParm;
#else
				if (pInfoParmW->pi_id == 'F') pInfoParmW->pi_paux = (char *)pInfoParm;
#endif

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_exGetMembe:found da=[%s]",pInfoParmW,da,0);

				*ppInfoParmW = pInfoParmW;
				return 0;
			}
		}
	}
	/* _ex_get_member: [%s] is no member. */
	ERROROUT1(FORMAT(138),da);
	return -1;
}

/****************************************/
/*										*/
/****************************************/
int _ex_conv_parm_opt(ppInfoParmW,opt,da)
tdtInfoParm **ppInfoParmW;
int opt;
char *da;
{
	static char *func_name="_ex_conv_parm_opt";
	parmList qprmL;
	tdtInfoParm *pInfoParmW,*pInfoParm;
	char c,buf[D_LEN_SCOPE_MARK+1],*cpDat,*cpKey,*name,cOpt,id;
	int rc=0,i,len,x,iDATA_NARABI,opts;
	tdtInfoParm ***pTBL,*pParmI,*pInfoP;
	tdtArrayIndex *pIndex;
	int  ParmNo,ix,iParm[4],attr,iCONST,*index,*pSize,iEROUT_NDEF,type,iTMP;
	XHASHB *xhp;
	uchar aux1;
	tdtDefType *pDeftype;

	if (!(pInfoParmW = *ppInfoParmW)) return ECL_NULL_POINTER;

DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:Enter opt=%08x da=[%s]",pInfoParmW,opt,da);

	iEROUT_NDEF = !(opt & (D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF));
	iCONST = pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED;
	if (pInfoParmW->pi_id == D_DATA_ID_UNDEFVAR) {
		if (pInfoParmW->pi_attr == DEF_ZOK_CHAR) {
			iDATA_NARABI = pInfoParmW->pi_alen & D_AULN_DATA_NARABI;
			qprmL.prp = pInfoParmW->pi_data;
			qprmL.prmlen = pInfoParmW->pi_dlen;
			if (!(rc=cl_skip_scope_mark(qprmL.prp,qprmL.prmlen,&ix))) ;
			else if (rc > 0) {
				qprmL.prp += rc;
				qprmL.prmlen -= rc;
			/*	opt |= ix;	2022.9.26 */
				opt = (opt & ~D_GX_OPT_SET_SCOPE) | ix;
			}
			else return rc;
			if (rc=cl_conv_parm_opt(&qprmL,pInfoParmW,opt)) {
				if (rc == ECL_DEFINED_ARRAY) rc = 0;
				else {
					if (rc==ECL_NDEFVAR_ERROR && (opt & D_GX_OPT_NOERROR_NDEF)) {
						cl_set_parm_char(pInfoParmW,qprmL.prp,qprmL.prmlen);
						pInfoParmW->pi_id = 'U';
						pInfoParmW->pi_alen |= iDATA_NARABI | D_AULN_HOLD_ERROR;
						rc = 0;
					}
					return rc;
				}
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:ConvParm rc=%d",pInfoParmW,rc,0);
		}
		else {
			if (!(name=(char *)pInfoParmW->pi_pos)) name = "";
			pIndex = (tdtArrayIndex *)pInfoParmW->pi_data;
			opts = opt & (D_GX_OPT_STORE_CHK | D_GX_OPT_STORE);
			iTMP = 0;
			if (pIndex->xhp) {
				xhp = (XHASHB *)pIndex->xhp;
				cpKey = (char *)pInfoParmW->pi_len;
				xhp->xha_xhix = 0;
				ix = akxs_xhash2(xhp,'r',cpKey,&cpDat);

DEBUGOUTL3(194,"_ex_conv_parm_opt: HASH: r cpKey=[%s] ix=%d opts=%08x",cpKey,ix,opts);

				if (ix<0 || !pInfoParmW) return ix;
				else if (ix > 0) memcpy(&pParmI,cpDat,sizeof(tdtInfoParm *));
				else {
/*
printf("pGlobTable->options[0]=%08x\n",pGlobTable->options[0]);
*/
					if (opts || (pGlobTable->options[0] & 0x01)) {
						if (!(pParmI=(tdtInfoParm *)Malloc(sizeof(tdtInfoParm)))) return -1;
					/*	if (pGlobTable->options[0] & 0x04) {	0x01 ON ̂Ƃ́Acl_mod_option()
							cl_parm_set0(pParmI);				0x04  OFFƂȂB
							return ECL_NO_DATA_ERROR;
						}
						else */cl_null_data(pParmI);
						attr = pIndex->uAttr[0];
						if (attr && attr!=DEF_ZOK_VARI) {
							iParm[0] = attr;
							iParm[2] = pIndex->uAttr[2];
							iParm[3] = pIndex->uAttr[3];
							iParm[1] = pIndex->size;
							if (rc=cl_set_parm_init(pParmI,iParm,0x01)) return rc;
						}
						if (opts) {		/* add if(opts) 2022.7.24 */
							ix = akxs_xhash2(xhp,'s',cpKey,&pParmI);

DEBUGOUTL2(194,"_ex_conv_parm_opt: HASH: s cpKey=[%s] ix=%d",cpKey,ix);

							if (ix <= 0) {
								if (ix == 0) ix = -12;
								cl_free_info_parm(pParmI);
								return ix;
							}
						}
					}
					else {
						if (pGlobTable->options[0] & 0x04) {
							if (iEROUT_NDEF)
								/* f[^ݒłB */
								ERROROUT1(FORMAT(203),func_name);
							return ECL_NO_DATA_ERROR;
						}
						else {
							if (!(pParmI=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm)))) return -1;
							cl_null_parm(pParmI);
						/*	cl_parm_set0(pParmI);	炪C邪Aǂ炪Ȃ*/
							iTMP = D_GX_OPT_ALC_TMP;
						}
					}
				}
			}
			else {
				pTBL   = (tdtInfoParm ***)pInfoParmW->pi_paux;
				ParmNo = pInfoParmW->pi_hlen;
				if (opts) cOpt = 's';
				else cOpt = 'r';

DEBUGOUTL3(194,"_ex_conv_parm_opt: pTBL=%08x ParmNo=%d cOpt=%c",pTBL,ParmNo,cOpt);

				if ((rc=cl_array_get_info_parm(&pParmI,pIndex,pTBL,ParmNo,cOpt)) <= 0) {
					if (!rc) rc = -13;
					return rc;
				}
			}
			if (pParmI) {
				if (opts) {
					pInfoP = pIndex->pInfoType;
					if (pInfoP && !pParmI->pi_id) {
						if (rc=cl_gx_rep_info_set(pParmI,pInfoP,1|iTMP)) return rc;
						type = pInfoP->pi_aux[0];
/*
printf("_ex_conv_parm_opt: type=%d\n",type);
*/
						if (type == D_AUX0_TYPE_STRUCT) {
							pDeftype = (tdtDefType *)pInfoP->pi_data;
							if (rc=_def_var_struct(pParmI,pDeftype,(char *)pInfoP->pi_pos,opt)) return rc;
						}
						else {
							if (type == D_AUX0_TYPE_ARRAY) {
								pInfoParmW->pi_id = 'R';
								if (rc=_def_var_array_member(pInfoParmW)) return rc;
							}
							else pInfoParmW->pi_id = 'A';
						}
					}
					cl_set_parm_long(pInfoParmW,(long)pParmI);
					pInfoParmW->pi_id   = 'S';
					pInfoParmW->pi_aux[1] = iCONST;
					if ((c=*name)=='%' || c=='#')
						pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
				}
				else
					cl_gx_copy_info(pInfoParmW, pParmI);
			}
			else {
				cl_parm_set0(pInfoParmW);
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:U:array: rc=%d",pInfoParmW,rc,0);
		}
	}
	if ((id=pInfoParmW->pi_id) == D_DATA_ID_STOREVAR) {
		if (opt & D_GX_OPT_STORE_CHK) {
			if (pInfoParmW->pi_aux[1] & D_AUX1_PROTECTED) {
#if 1	/* 2021.8.2 */
				pInfoParm = (tdtInfoParm *)pInfoParmW->pi_pos;
				if ((id=pInfoParm->pi_id) == ' ') name = FORMAT(302);
				else name = cl_gx_get_name_from_id(id);
						/* %s: %s(%s)ւ̑͂ł܂B */
				ERROROUT3(FORMAT(132),func_name,name,da);
#else
				ERROROUT2(FORMAT(126),func_name,da);	/* %s: %sւ͑͂ł܂B */
#endif
				return ECL_SCRIPT_ERROR;
			}
		}
		if (pSize=(int *)pInfoParmW->pi_paux) {
			ParmNo = pInfoParmW->pi_hlen;
/*
printf("_ex_conv_parm_opt: ParmNo=%d\n",ParmNo);
*/
			if (index=(int *)pInfoParmW->pi_len) {
/*
printf("_ex_conv_parm_opt: index=%08x index[2]=%d index[3]=%d\n",index,index[2],index[3]);
*/
				if (ParmNo > (index[2]+index[3]-1)) index[2] = ParmNo - index[3] + 1;
			}
			if (pSize != index)	/* pTBLȂ^tẑƂ́ApSize == index */
				cl_set_max_var_ent(pSize,ParmNo);
		}
		if (opt & D_GX_OPT_GET_ADDR) {
			*ppInfoParmW = pInfoParmW;
			return 0;
		}
		pInfoParmW = (tdtInfoParm *)pInfoParmW->pi_pos;
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:STOREVAR ",pInfoParmW,0,0);
		if (!pInfoParmW) return ECL_NULL_POINTER;
	}
	else if (id=='A' || id=='R' || id=='T' || id==D_DATA_ID_PNAME) ;
	else if (opt & D_GX_OPT_STORE_CHK) {
		if (id == '\0') {
			if (iEROUT_NDEF) ERROROUT2(FORMAT(127),func_name,da);	/* %s: %s̃f[^ݒłB */
			return ECL_NDEFVAR_ERROR;
		}
#if 1	/* 2022.6.14 */
		else if (cl_is_none_parm(pInfoParmW)) {
			ERROROUT2(FORMAT(76),func_name,FORMAT(590));	/* %s: %s܂B*//*  */
			return ECL_SCRIPT_ERROR;
		}
#endif
		else if ((aux1=pInfoParmW->pi_aux[1]) & D_AUX1_PROTECTED) {
#if 1	/* 2021.8.2 */
					/* %s: %s(%s)ւ̑͂ł܂B */
			ERROROUT3(FORMAT(132),func_name,cl_gx_get_name_from_info(pInfoParmW),da);
#else
			ERROROUT2(FORMAT(126),func_name,da);	/* %s: %sւ͑͂ł܂B */
#endif
			return ECL_SCRIPT_ERROR;
		}
		else if (id=='F' && pInfoParmW->pi_alen & D_AULN_DOT_NAME) {
			if (iEROUT_NDEF) ERROROUT2(FORMAT(438),func_name,da);	/* "%s: [%s]͖`łB */
			return ECL_NDEFVAR_ERROR;
		}
	}

DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_ex_conv_parm_opt:RETURN rc=%d",pInfoParmW,rc,0);

#if 1	/* 2021.3.24 */
	if (!(opt & D_GX_OPT_STORE_CHK) && ((c=pInfoParmW->pi_id)=='A' || c=='R')) {
#if 1	/* 2021.4.4 */
		if (rc = _check_gid_alive(pInfoParmW,func_name,da,iEROUT_NDEF)) return rc;
#else
		if (pInfoParmW->pi_hlen) {
			if ((ix=akxs_xhasl(pGLprocTable->pha_gid,'R',pInfoParmW->pi_hlen,0)) <= 0) {
							/* %s: ϐ(%s)̔z͖ł(gid hash ix=%d)B */
				if (iEROUT_NDEF) ERROROUT3(FORMAT(322),func_name,da,ix);
				cl_free_info_parm(pInfoParmW);
				return ECL_NDEFVAR_ERROR;
			}
		}
#endif
	}
#endif
	if (!(opt & D_GX_OPT_STORE_CHK) && iEROUT_NDEF && pInfoParmW->pi_id=='\0' && !(opt & D_GX_OPT_INFO_MODE)) {
		ERROROUT2(FORMAT(127),func_name,da);	/* %s: %s̃f[^ݒłB */
		return ECL_NO_DATA_ERROR;
	}
	*ppInfoParmW = pInfoParmW;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static tdtInfoParm *_info_parm_temp_dup(pInfoParm)
tdtInfoParm *pInfoParm;
{
	char *p;
	tdtInfoParm *pInfoParmW;
	int attr;

	if ((pInfoParm->pi_aux[0] & ~DEF_ZOK_DATA) &&
	    ((attr=pInfoParm->pi_attr)==DEF_ZOK_DECI || attr==DEF_ZOK_DATE)) {
		if (!(pInfoParmW=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
			return NULL;
		*pInfoParmW = *pInfoParm;
		if (!(p=cl_tmp_const_malloc(sizeofMPA()))) return NULL;
		memcpy(p,pInfoParm->pi_data,sizeofMPA());
		pInfoParmW->pi_data = p;
		pInfoParm = pInfoParmW;
	}
	return pInfoParm;
}

/****************************************/
/*										*/
/****************************************/
static int _mk_info_parm2(nparm,ppParm,iOpt,dastk,ipr2s,ms_pp2stk)
int nparm;
tdtInfoParm *ppParm[];
int iOpt,*ipr2s;
char *dastk[];
MCAT *ms_pp2stk;
{
	tdtInfoParm **pp2stk;
	tdtInfoParm *pInfoParm1,*pInfoParm2,*pInfoParm;
	int rc,i,len,optW,ir2s;
	char *da1,id;

	len = sizeof(tdtInfoParm)*(nparm+1);
	if (!(pInfoParm1=(tdtInfoParm *)cl_tmp_const_malloc(len))) return ECL_MALLOC_ERROR;
	pInfoParm2 = pInfoParm1 + 1;
	memset(pInfoParm1,0,sizeof(tdtInfoParm));
	pInfoParm1->pi_id = '2';
	pInfoParm1->pi_pos = nparm;
	pInfoParm1->pi_dlen = len - sizeof(tdtInfoParm);
	pInfoParm1->pi_data = (char *)pInfoParm2;
	for (i=0;i<nparm;i++,pInfoParm2++) {
		pInfoParm = ppParm[i];
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_mk_info_parm2: i=%d ",pInfoParm,i,0);
		da1 = dastk[i];
#ifdef DATA_NARABI
		optW = D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_NOERROR_NDEF | D_GX_OPT_GET_ADDR;
		if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) {
			pInfoParm1->pi_hlen = rc;
			pInfoParm1->pi_len++;
		}
#else
		optW = iOpt & D_GX_OPT_NOEROUT_NDEF;
		if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) {
			pInfoParm1->pi_hlen = rc;
			pInfoParm1->pi_len++;
		/*	return rc;	*/
		}
		else if (cl_is_undef_parm(pInfoParm)) {
			pInfoParm1->pi_hlen = ECL_NDEFVAR_ERROR;
			pInfoParm1->pi_len++;
			if (!(iOpt & D_GX_OPT_NOEROUT_NDEF))
				/* %s: %s̃f[^ݒłB */
				ERROROUT2(FORMAT(127),"_mk_info_parm2",da1);
		/*	return rc;	*/
		}
#endif
		else {
			cl_gx_copy_info(pInfoParm2,pInfoParm);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_mk_info_parm2: pInfoParm2=",pInfoParm2,0,0);
		}
	}
	ir2s = *ipr2s;
	if (cl_gx_expand(ms_pp2stk,ir2s,&pp2stk) < 0) return -1;
	pp2stk[ir2s++] = pInfoParm1;
	*ipr2s = ir2s;
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _kakko(ppmstk,irs,pW,opt,pmstk,dastk)
tdtInfoParm *pmstk,*pW,*ppmstk[];
int irs,opt;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc,iFunc,optW,iHOLD_ERROR;
	char id;

	iHOLD_ERROR = 0;
	i = irs;
	while (i >= 0) {	/* '['T[` */
		pm = ppmstk[i];
		pmW = pm;
		optW = D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;
		if (rc=_ex_conv_parm_opt(&pmW,optW,dastk[i])) {
			ERROROUT1("_kakko: _ex_conv_parm_opt rc=%d",rc);
			return rc;
		}
		if (pmW->pi_alen & D_AULN_HOLD_ERROR) iHOLD_ERROR = D_AULN_HOLD_ERROR;

DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko:search'[': i=%d iHOLD_ERROR=%d",pm,i,iHOLD_ERROR);

		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {	/* '[' */
			if (pm->pi_pos != 2) return -1;
			else {
				rc = cl_set_list(pW,irs-i,&ppmstk[i+1]);
				if (pW->pi_id == D_DATA_ID_LIST) pW->pi_id = D_DATA_ID_NARABI;
#if 1	/* 2022.1.1 */
				if (rc && !iHOLD_ERROR) i = cl_gx_conv_rc(rc, ECL_GX_FUNC_ERROR1);
#else
				if (rc) i = cl_gx_conv_rc(rc, ECL_GX_FUNC_ERROR1);
#endif
				pW->pi_alen |= iHOLD_ERROR;
				return i;
			}
		}
		i--;
	}
	ERROROUT2(FORMAT(76),"_kakko","[");	/* %s: %s܂B */
	return i;
}

/****************************************/
/*										*/
/****************************************/
int _kakko_tenkai(mcat,tInfoParm2,pInfoParm)
MCAT *mcat;
tdtInfoParm tInfoParm2[],*pInfoParm;
{
	static MCAT tmcat={'M','C',256,0,0,0,NULL,0};
	int  i,rc,len,nparm;
	char *p;
	tdtInfoParm tInfoParm,*pInfoParmW,*pInfoParm1,*pW,*pInfo;
	tdtRbCtl *pCt;

DEBUGOUTL2(120,"_kakko_tenkai:Enter: mcat=%08x tInfoParm2=%08x",mcat,tInfoParm2);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_kakko_tenkai: pInfoParm=",pInfoParm,0,0);
	if (!mcat) {
		mcat = &tmcat;
		mcat->mc_ipos = 0;
	}
	if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
		pInfoParm1 = pInfoParm + 1;
		if (nparm=pInfoParm1->pi_pos) {
			pInfo = (tdtInfoParm *)pInfoParm1->pi_data;
			for (i=0;i<nparm;i++,pInfo++) {
				pW = pInfo;
				if (rc=_ex_conv_parm_opt(&pW,0,"?")) return rc;
				if (pW->pi_alen & D_AULN_PARMINFO2) {
					if ((rc=_kakko_tenkai(mcat,NULL,pW)) < 0) return rc;
				}
				else {
					if ((rc=akxtmcat(mcat,pW,sizeof(tdtInfoParm))) < 0) return rc;
				}
			}
		}
	}
	if (tInfoParm2) {
		pInfoParmW = tInfoParm2;
		len = mcat->mc_ipos;
		if (len > 0) {
			if (!(p=cl_tmp_const_malloc(len))) return ECL_MALLOC_ERROR;
			pInfoParm1 = pInfoParmW + 1;
			memset(pInfoParm1,0,sizeof(tdtInfoParm));
			nparm = len/sizeof(tdtInfoParm);
			pInfoParm1->pi_id = '2';
			pInfoParm1->pi_pos = nparm;
			pInfoParm1->pi_dlen = len;
			pInfoParm1->pi_data = p;
			pW = (tdtInfoParm *)mcat->mc_bufp;
			pInfoParm1 = (tdtInfoParm *)p;
			for (i=0;i<nparm;i++,pW++,pInfoParm1++) {
				cl_gx_copy_info(pInfoParm1,pW);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_kakko_tenkai: i=%d pInfoParm1=",pInfoParm1,i,0);
			}
			pInfoParm1 = (tdtInfoParm *)p;
			cl_gx_copy_info(pInfoParmW, &pInfoParm1[nparm-1]);
			pInfoParmW->pi_alen |= D_AULN_PARMINFO2;
		}
		else {
			memset(pInfoParmW,0,sizeof(tdtInfoParm));
		}
	}
DEBUGOUTL(120,"_kakko_tenkai:Exit:");
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _kakko2(ppmstk,irs,pW)
tdtInfoParm *ppmstk[],*pW;
int irs;
{
	tdtInfoParm *pm;
	int i,rc;

	cl_gx_copy_info(pW, ppmstk[irs]);
	i = irs;
	while (i >= 0) {	/* '('T[` */
		pm = ppmstk[i];
DEBUGOUT_InfoParm(LVL_GXEXOBJ+2,"_kakko2:search'(': i=%d ",pm,i,0);
		if (pm->pi_aux[1]==D_AUX1_FUNC_ARRY) {	/* '(' */
			if (pm->pi_pos) return -1;
			if (pW->pi_aux[1]==D_AUX1_FUNC_ARRY && !pW->pi_pos) {
				cl_none_parm(pW);
				pW->pi_aux[1] |= D_AUX1_PROTECTED;
			}
/*
printf("_kakko2: Exit i=%d\n",i);
*/
			return i;
		}
		i--;
	}
	ERROROUT2(FORMAT(76),"_kakko2","(");	/* %s: %s܂B */
	return i;
}

/****************************************/
/*										*/
/****************************************/
void _reset_addr(ppmstk,pmstk,irs)
tdtInfoParm *pmstk,*ppmstk[];
int irs;
{
	int i;
/*
printf("_reset_addr: irs=%d\n",irs);
*/
	for (i=0;i<=irs;i++,pmstk++,ppmstk++) *ppmstk = pmstk;
}

/****************************************/
/*										*/
/****************************************/
static int _new_class(ppmstk,irs,pW,dastk)
tdtInfoParm *pW,*ppmstk[];
int irs;
char *dastk[];
{
	tdtInfoParm *pm,*pmW;
	int i,rc;

	i = cl_get_data_long(pW);
/*
printf("_new_class: irs=%d i=%d\n",irs,i);
*/
	ppmstk[i+1] = ppmstk[i];
	dastk[i+1] = dastk[i];
	rc = cl_func_new(pW,irs-i,&ppmstk[i+1]);
	if (!rc) rc = i;
	return rc;
}

/********1*********2*********3*********4*********5*********6*********7***/
/* @\ : ͈͓WJꂽf[^̊Jnf[^̃X^bN̈ʒu	*/
/*		  QZł̓X^bN̍ŏʂɍPƍQ邱ƂɂȂ	*/
/*		  B̍QȏɓWJꂽꍇÃf[^̈ʒu	*/
/*		  肵AWJXbLvKvB					*/
/*		  WJf[^̊JnƏIɂ͈󂪕tĂB					*/
/*  : pInfoParm2 : ͈͓WJꂽ\̂f[^(pmstk̍ŏ)	*/
/*		  irs		 : T[`JnʒuB݂̃X^bNʒu(pmstk̍ŏ)*/
/*					   ͈͓WJĂȂƂ́AύXs				*/
/*		  ppmstk[]	 : |C^zX^bN̐擪AhX				*/
/*		  offset	 : T[`JnʒúAWJf[^̏IʒûPO	*/
/*					   邱ƂOƂĂBāAirsWJ	*/
/*					   f[^̏IʒuɂƂ́A1w肷B		*/
/* ԋp : offset==0 ̂ƂAWJf[^̏IʒûPO				*/
/*				==1 ̂ƂAWJf[^̏Iʒu						*/
/************************************************************************/
static int _srch_range_flag(pInfoParm2,irs,ppmstk,offset)
tdtInfoParm *pInfoParm2;
int irs,offset;
tdtInfoParm *ppmstk[];
{
	tdtInfoParm *pInfoParm;
	ushort alen;
	int found;
/*
printf("_srch_range_flag:Enter irs=%d offset=%d alen=%08x\n",irs,offset,pInfoParm2->pi_alen);
*/
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_srch_range_flag: irs=%d offset=%d",pInfoParm2,irs,offset);

	if (irs>=1 && !((alen=pInfoParm2->pi_alen) & D_AULN_RANGE_DATA) && (alen & D_AULN_RANGE_INTVAL)) {
		pInfoParm2->pi_alen &= ~D_AULN_RANGE_INTVAL;
		irs -= offset;
		found = 0;
		while (irs >= 0) {
			pInfoParm = ppmstk[irs];
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_srch_range_flag: irs=%d",pInfoParm,irs,0);
/*
printf("_srch_range_flag: irs=%d alen=%08x\n",irs,pInfoParm->pi_alen);
*/			irs--;
			if (!((alen=pInfoParm->pi_alen) & D_AULN_RANGE_DATA) && (alen & D_AULN_RANGE_INTVAL)) {
				found = 1;
				break;
			}
		}
		if (found) {
			pInfoParm->pi_alen &= ~D_AULN_RANGE_INTVAL;
			irs += offset;
		}
	}
/*
printf("_srch_range_flag:Exit irs=%d\n",irs);
*/
DEBUGOUTL1(LVL_GXEXOBJ,"_srch_range_flag:Exit irs=%d",irs);
	return irs;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*  : irs : ϐPUSHĂʒuB						*/
/*				̊֐ł́AύXȂ̂ŁÂ܂ܕԂB			*/
/*				(_rep_info_set()A̕ԋpl̂܂ܕԂ)		*/
/* ԋp : >=0 : irs														*/
/*		  < 0 : G[R[h											*/
/************************************************************************/
static int _rep_info_set3(mc,ppInfoParm1,pInfoParm2,opt,dastk,irs,ppmstk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *dastk[];
int irs;
tdtInfoParm *ppmstk[];
{
	int rc,i,i1,n1,n2,optW,m,iPARMINFO2;
	tdtInfoParm *pInfoParm1,*pInfo1,*pInfo2,*pW1,*pW2,*pInfoParm,*pInfoParmW;
	tdtRbCtl *pCt1,*pCt2,*pCtW;
	char *da1;

	da1 = dastk[irs];
	pInfoParm1 = *ppInfoParm1;
	pCt1 = (tdtRbCtl *)pInfoParm1->pi_data;
	n1 = akxs_rb_used(pCt1);
	if (iPARMINFO2 = (pInfoParm2->pi_alen & D_AULN_PARMINFO2)) {
		pInfo2 = pInfoParm2 + 1;
		n2 = pInfo2->pi_pos;
		pInfo2 = (tdtInfoParm *)pInfo2->pi_data;
		pInfo2--;
	}
	else {
		pCt2 = (tdtRbCtl *)pInfoParm2->pi_data;
		n2 = akxs_rb_used(pCt2);
		akxs_rb_read(pCt2,0);
	}
	optW = opt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
	optW |= D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set3:n1=%d n2=%d",n1,n2);
	pInfoParmW = NULL;
	akxs_rb_read(pCt1,0);
	for (i=0;i<n1;i++) {
		if (i < n1) pInfo1 = (tdtInfoParm *)akxs_rb_read(pCt1,1);
		if (i < n2) {
			if (iPARMINFO2) pInfo2++;
			else pInfo2 = (tdtInfoParm *)akxs_rb_read(pCt2,1);
		}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pInfo1:",pInfo1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pInfo2:",pInfo2,0,0);
		pW1 = pInfo1;
		pW2 = pInfo2;
		if (rc=_ex_conv_parm_opt(&pW1,optW,da1)) return rc;
		if (rc=_ex_conv_parm_opt(&pW2,0,da1)) return rc;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW1:",pW1,0,0);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set3:pW2:",pW2,0,0);
#if 1	/* 2021.10.27 */
		if (rc = cl_gx_rep_info_als_name(pW1,pW2,1|D_REP_OPT_ASIGN,da1)) return rc;
#else
		if (rc = cl_gx_rep_info_set_name(pW1,pW2,1,da1)) return rc;
#endif
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set3:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
		if (!pInfoParmW) {
			if (!(pInfoParmW=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
				return ECL_MALLOC_ERROR;
			if ((rc=cl_set_list(pInfoParmW,1,&pW1)) < 0) return rc;
			pInfoParmW->pi_id = pInfoParm1->pi_id;
			pCtW = (tdtRbCtl *)pInfoParmW->pi_data;
		}
		else {
			if (!cl_tmp_rbset_n(pCtW,pW1)) return ECL_MALLOC_ERROR;
		}
	}
	*ppInfoParm1 = pInfoParmW;
	return irs;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*  : irs : ϐPUSHĂʒuB						*/
/* ԋp : >=0 : irs														*/
/*				݂́AirśAύXȂAύXĂǂ悤	*/
/*				^[lŕԂB										*/
/*		  < 0 : G[R[h											*/
/************************************************************************/
static int _rep_info_set2(mc,ppInfoParm1,pInfoParm2,opt,dastk,irs,ppmstk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *dastk[];
int irs;
tdtInfoParm *ppmstk[];
{
	int rc,i,nparm,optW,type;
	tdtInfoParm *pm,*pInfoParm,*pInfoParm1,*pmW,*pInfoParmW;
	tdtRbCtl *pCt,*pCtW;
	char id,*p,*da1;
	uchar aux1_scope;
	ushort alen;

	pInfoParm1 = *ppInfoParm1;
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set2:Enter mc=%d irs=%d",pInfoParm1,mc,irs);
	if (pInfoParm1->pi_id == 'N') {
		pInfoParmW = NULL;
		pCt = (tdtRbCtl *)pInfoParm1->pi_data;
		if (akxs_rb_used(pCt)) {
			akxs_rb_read(pCt,0);
			while (pmW=(tdtInfoParm *)akxs_rb_read(pCt,1)) {
				irs = _rep_info_set2(mc,&pmW,pInfoParm2,opt,dastk,irs,ppmstk);
				if (irs < 0) return irs;
				if (!pInfoParmW) {
					if (!(pInfoParmW=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
						return ECL_MALLOC_ERROR;
					if ((rc=cl_set_list(pInfoParmW,1,&pmW)) < 0) return rc;
					pInfoParmW->pi_id = pInfoParm1->pi_id;
					pCtW = (tdtRbCtl *)pInfoParmW->pi_data;
				}
				else {
					if (!cl_tmp_rbset_n(pCtW,pmW)) return ECL_MALLOC_ERROR;
				}
			}
		}
		else {
			ERROROUT1(FORMAT(435),"_rep_info_set2");	/* %s: ϐ܂B*/
			return ECL_SCRIPT_ERROR;
		}
		*ppInfoParm1 = pInfoParmW;
	}
	else {
		da1 = dastk[irs];
#if 0	/* 2021.6.7 *//* X^bNoƂɁA_srch_range_flag()sƂŁAł͕svƎv */
		/* Z̉EӂQȏɓWJĂꍇApInfoParm1pInfoParm2ɂ́AWJꂽf[^
		   QԖڂƂPԖڂĂBŁAX^bNT[`ApInfoParm1ݒ肵B
		   irśAQԖڂ̈ʒuwĂBPԖڂɂ́AWJf[^̊Jn̈󂪕tĂB */
		if (!((alen=pInfoParm2->pi_alen) & D_AULN_RANGE_DATA) && (alen & D_AULN_RANGE_INTVAL)) {
#if 1
			irs = _srch_range_flag(pInfoParm2,irs,ppmstk,0);
#else
			pInfoParm2->pi_alen &= ~D_AULN_RANGE_INTVAL;
			while (irs >= 0) {
				pInfoParm = ppmstk[irs];
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set2: irs=%d",pInfoParm,irs,0);
				if ((id=pInfoParm->pi_id)=='S' || id=='U') break;	/* WJ͂Qȏ̏ꍇAɂȂ邱Ƃ͂ȂÔ */
				irs--;
				if (!((alen=pInfoParm->pi_alen) & D_AULN_RANGE_DATA) && (alen & D_AULN_RANGE_INTVAL)) break;
			}
#endif
			if (irs < 0) return irs;
			pInfoParm1 = ppmstk[irs];
			da1 = dastk[irs];
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set2: irs=%d da1=[%s]",pInfoParm1,irs,da1);
			if ((id=pInfoParm1->pi_id)!='S' && id!='U') return -1;
		}
#endif
		optW = opt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL);
		optW |= D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
		if (rc=_ex_conv_parm_opt(&pInfoParm1,optW,da1)) return rc;
#if 1	/* 2021.3.29 */
		type = pInfoParm1->pi_aux[0] & 0x07;
		if (((((id=pInfoParm1->pi_id)=='A' || id=='R') && (type>0 && type<7)) || (id=='T')) &&
		    (pInfoParm1->pi_scale & D_DATA_INDEX_FREE)) {
			/* 2021.8.3 */
			if (pInfoParm1->pi_aux[0] & 0x07) p = FORMAT(330);	/* 2021.9.9 */
			else p = cl_gx_get_name_from_id(id);
					/* %s: %s(%s)ւ̑͂ł܂B */
			ERROROUT3(FORMAT(132),"_rep_info_set2",p,(char *)pInfoParm1->pi_pos);
			return ECL_SCRIPT_ERROR;
		}
#endif
		aux1_scope = pInfoParm1->pi_aux[1] & D_AUX1_VAR_SCOPE;
#if 1	/* 2021.10.27 */
		if (rc = cl_gx_rep_info_als_name(pInfoParm1,pInfoParm2,1 | D_REP_CHK_UNDEF_IN | D_REP_OPT_ASIGN,da1)) return rc;
#else
		if (rc = cl_gx_rep_info_set_name(pInfoParm1,pInfoParm2,1 | D_REP_CHK_UNDEF_IN,da1)) return rc;
#endif
DEBUGOUTL2(LVL_GXEXOBJ,"_rep_info_set2:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
		if (*da1=='<') {
			if (rc = cl_gx_clear_var90(pInfoParm1,da1)) return rc;
		}
		pInfoParm1->pi_aux[1] |= aux1_scope;
		*ppInfoParm1 = pInfoParm1;
	}
	return irs;
}

/********1*********2*********3*********4*********5*********6*********7***/
/*  : irs : ϐPUSHĂʒuB						*/
/*				ꂽϐPUSHB						*/
/* ԋp : >=0 : irs														*/
/*				݂́AirśAύXȂAύXĂǂ悤	*/
/*				^[lŕԂB										*/
/*		  < 0 : G[R[h											*/
/************************************************************************/
static int _rep_info_set(mc,ppInfoParm1,pInfoParm2,opt,dastk,irs,ppmstk)
int mc;
tdtInfoParm **ppInfoParm1,*pInfoParm2;
int opt;
char *dastk[];
int irs;
tdtInfoParm *ppmstk[];
{
	int rc,i,nparm,optW;
	tdtInfoParm *pm,*pInfoParm,*pInfoParm1,*pmW;
	char *da1;

	pInfoParm1 = *ppInfoParm1;
	/* pInfoParm1Xgϐ܂̓f[^ѕϐ̂Ƃ́A(pInfoParm1->pi_id=='S'ŗ */
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set:Enter mc=%d irs=%d pInfoParm1=",pInfoParm1,mc,irs);
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_rep_info_set:pInfoParm2=",pInfoParm2,0,0);
	if ((pInfoParm1->pi_id=='N') &&
	    ((pInfoParm2->pi_id=='N') || (pInfoParm2->pi_alen & D_AULN_PARMINFO2))) {
		rc = _rep_info_set3(mc,ppInfoParm1,pInfoParm2,opt,dastk,irs,ppmstk);
		/* rc >=0 : irsԂ */
	}
	else if (pInfoParm1->pi_id == 'L') {
		da1 = dastk[irs];
		ERROROUT2(FORMAT(126),"_rep_info_set",da1);
		rc = ECL_EX_LET;
	}
	else {
		rc = _rep_info_set2(mc,ppInfoParm1,pInfoParm2,opt,dastk,irs,ppmstk);
		/* rc >=0 : irsԂ */
	}
	if (rc == ECL_NDEFVAR_ERROR) ERROROUT1(FORMAT(610),"_rep_info_set");	/* "%s: `ϐ܂ł܂B */
	return rc;
}

/****************************************/
/*										*/
/****************************************/
#if 1	/* 2021.11.1 */
char **_mk_obj_stack(nobj)
int nobj;
{
	int im,cnt;
	char **stack;

	if (nobj <= 0) return NULL;

	im = D_OPT_ALC_TMP;
	cnt = (nobj+3)/2 & ~0x01;
	if (!(stack = (char **)cl_opt_malloc(im,6*sizeof(char *)))) return NULL;
	if (!(stack[0] = cl_opt_malloc(im,cnt*(
	/* pp2stk,"P2" */	  sizeof(tdtInfoParm *)
	/* ppmstk,"PM" */	+ sizeof(tdtInfoParm *)
	/* pmstk,"MS" */	+ sizeof(tdtInfoParm)
	/* ppmstack,"PS" */	+ sizeof(tdtInfoParm *)
	/* stack,"ST" */	+ sizeof(short)
	/* dastk,"DS" */	+ sizeof(char *))))) return NULL;
	stack[1] = stack[0] + cnt*sizeof(tdtInfoParm *);
	stack[2] = stack[1] + cnt*sizeof(tdtInfoParm *);
	stack[3] = stack[2] + cnt*sizeof(tdtInfoParm);
	stack[4] = stack[3] + cnt*sizeof(tdtInfoParm *);
	stack[5] = stack[4] + cnt*sizeof(short);
	return stack;
}
#else
int _mk_obj_stack(pbxObj)
GXObject *pbxObj;
{
	int im,cnt;

	if (!pbxObj) return -1;
	if (pbxObj->nobj <= 0) return 0;

	im = D_OPT_ALC_TMP;
	cnt = (pbxObj->nobj+3)/2 & ~0x01;
	if (!(pbxObj->stack = (char **)cl_opt_malloc(im,6*sizeof(char *)))) return ECL_MALLOC_ERROR;
	if (!(pbxObj->stack[0] = cl_opt_malloc(im,cnt*(
	/* pp2stk,"P2" */	  sizeof(tdtInfoParm *)
	/* ppmstk,"PM" */	+ sizeof(tdtInfoParm *)
	/* pmstk,"MS" */	+ sizeof(tdtInfoParm)
	/* ppmstack,"PS" */	+ sizeof(tdtInfoParm *)
	/* stack,"ST" */	+ sizeof(short)
	/* dastk,"DS" */	+ sizeof(char *))))) return ECL_MALLOC_ERROR;
	pbxObj->stack[1] = pbxObj->stack[0] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[2] = pbxObj->stack[1] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[3] = pbxObj->stack[2] + cnt*sizeof(tdtInfoParm);
	pbxObj->stack[4] = pbxObj->stack[3] + cnt*sizeof(tdtInfoParm *);
	pbxObj->stack[5] = pbxObj->stack[4] + cnt*sizeof(short);
	return 0;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_gx_ex_obj(pObj0,pGxObj,pInfoParmW,iOpt)
tdtInfoParm **pObj0;
GXObject *pGxObj;
tdtInfoParm *pInfoParmW;
int iOpt;
{
	static char *name="cl_gx_ex_obj";
	static MCAT mcat={'M','C',256,0,0,0,NULL,0};
	short *obj,*stack;
	int iob,iMAX_PMSTK,iMAX_STACK;
	MCAT Ms_ppmstk,Ms_pmstk,Ms_ppmstack,Ms_stack,Ms_dastk,*Msa[7];
	tdtInfoParm **ppmstk,*pmstk,**ppmstack,InfoParmW2[2];
	char **obj_stack,**dastk;

	if (!pGxObj) return -1;
	iob = pGxObj->nobj;
DEBUGOUTL3(110,"cl_gx_ex_obj: *** start nobj=%d iOpt=%08x pInfoParmW=%08x",iob,iOpt,pInfoParmW);
	if (iob<1) return 100;
	obj = pGxObj->obj;
	if (iob>=1 && obj[0]==99) return 100;

	iMAX_PMSTK = (iob+1)/2;
	iMAX_STACK = iMAX_PMSTK;
#if 1	/* 2021.11.1 */
	if (!(obj_stack = _mk_obj_stack(pGxObj->nobj))) return ECL_MALLOC_ERROR;
#else
	if (rc=_mk_obj_stack(pGxObj)) return rc;
	obj_stack = pGxObj->stack;
#endif
/*	pp2stk = (tdtInfoParm **)obj_stack[0];	*/
	ppmstk = (tdtInfoParm **)obj_stack[1];
	pmstk = (tdtInfoParm *)obj_stack[2];
	ppmstack = (tdtInfoParm **)obj_stack[3];
	stack = (short *)obj_stack[4];
	dastk = (char **)obj_stack[5];
DEBUGOUTL2(120,"cl_gx_ex_obj: pGxObj->index0=%08x dastk=%08x",pGxObj->index0,dastk);
/*	if (pGxObj->index0) {
		if (pGxObj->index0 & 0x01)	*/
		/*	cl_gx_init_set_expand(&Ms_pp2stk,"P2",sizeof(tdtInfoParm *),iMAX_PMSTK,pp2stk);	*/
	/*	if (pGxObj->index0 & 0x02) {	*/
			cl_gx_init_set_expand(&Ms_ppmstack,"PS",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstack);
			cl_gx_init_set_expand(&Ms_stack,"ST",sizeof(short),iMAX_STACK,stack);
	/*	}
		if (pGxObj->index0 & 0x04) {	*/
			cl_gx_init_set_expand(&Ms_ppmstk,"PM",sizeof(tdtInfoParm *),iMAX_PMSTK,ppmstk);
			cl_gx_init_set_expand(&Ms_pmstk,"MS",sizeof(tdtInfoParm),iMAX_PMSTK,pmstk);
			cl_gx_init_set_expand(&Ms_dastk,"DS",sizeof(char *),iMAX_PMSTK,dastk);
	/*	}
	}	*/
/*	Msa[0] = &Ms_pp2stk;	*/
	Msa[1] = &Ms_ppmstk;
	Msa[2] = &Ms_pmstk;
	Msa[3] = &Ms_ppmstack;
	Msa[4] = &Ms_stack;
	Msa[5] = &Ms_dastk;
	Msa[6] = &mcat;

	if (!pInfoParmW) pInfoParmW = InfoParmW2;
	memset(pInfoParmW,0,sizeof(tdtInfoParm));
	if (iOpt & D_GX_OPT_PARMINFO2) memset(pInfoParmW+1,0,sizeof(tdtInfoParm));
	return cl_gx_ex_obj_sub(pObj0,pGxObj,pInfoParmW,iOpt,Msa,NULL);
}

/****************************************/
/*	iSTATUS:1/2							*/
/****************************************/
static int _pop_pmstk(pInfoParm2,mc,irs,pmstk,ppmstk,dastk,pda2,iSTATUS)
tdtInfoParm *pInfoParm2,*pmstk,**ppmstk;
int mc,irs,iSTATUS;
char *dastk[],**pda2;
{
	char *da2;

DEBUGOUTL3(LVL_GXEXOBJ,"_pop_pmstk:Enter pos%d mc=%d irs=%d",iSTATUS,mc,irs);

	cl_gx_copy_info(pInfoParm2,&pmstk[--irs]);
	da2 = dastk[irs];
	*pda2 = da2;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"_pop_pmstk: irs=%d da=[%s]",pInfoParm2,irs,da2);

#if 1	/* 2021.6.8 */
	if ((irs=_srch_range_flag(pInfoParm2,irs,ppmstk,1)) < 0) return irs;
#endif
	if (pInfoParm2->pi_id==D_DATA_ID_PNAME && pInfoParm2->pi_attr==2 && mc!=D_IMD_PNAME) {
		if ((iSTATUS==2 && mc!=90) || iSTATUS!=2)
			pInfoParm2->pi_id = D_DATA_ID_STOREVAR;

DEBUGOUTL3(LVL_GXEXOBJ,"_pop_pmstk: changed id=[%c] irs=%d da=[%s]",pInfoParm2->pi_id,irs,da2);

	}
	return irs;
}

/****************************************/
/*										*/
/****************************************/
static int _gx_ex_obj_end_narabi(pInfoParmW,iOpt,iDEF_ZOK_DATA,ppmstk,irs,mcat)
tdtInfoParm *pInfoParmW,**ppmstk;
int iOpt,iDEF_ZOK_DATA,irs;
MCAT *mcat;
{
	static char *name="_gx_ex_obj_end_narabi";
	int rc,i,i1,optW,aux1;
	char *da1,c,*p;
	tdtInfoParm *pInfoParm,*pInfoParm1,*pInfoParm2;

					pInfoParm1 = pInfoParmW + 1;
					memset(pInfoParm1,0,sizeof(tdtInfoParm));
/*
printf("cl_gx_ex_obj: irs=%d\n",irs);
*/
					if (irs>=1 || (pInfoParmW->pi_alen & D_AULN_DATA_NARABI)) {
						mcat->mc_ipos = 0;
						for (i=irs;i>=0;i--) {
							pInfoParm = ppmstk[i];
							akxtmcat(mcat,pInfoParm,sizeof(tdtInfoParm));
/*
printf("cl_gx_ex_obj: i=%d da1=[%s] pi_hlen=%d\n",i,da1,pInfoParm1->pi_hlen);
*/
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:end: i=%d",pInfoParm,i,0);
						}
						i1 = mcat->mc_ipos;
						if (!(p=cl_tmp_const_malloc(i1))) {
							pInfoParm1->pi_hlen = ECL_MALLOC_ERROR;
							rc = 0;
							return rc;
						}
						irs = i1/sizeof(tdtInfoParm);
						pInfoParm1->pi_id = '2';
						pInfoParm1->pi_pos = irs;
						pInfoParm1->pi_dlen = i1;
						pInfoParm1->pi_data = p;
						pInfoParm1->pi_aux[0] |= iDEF_ZOK_DATA;
						pInfoParm2 = (tdtInfoParm *)p;
						p = mcat->mc_bufp + i1 - sizeof(tdtInfoParm);
						optW = iOpt & (D_GX_OPT_STORE | D_GX_OPT_GET_ADDR | D_GX_OPT_NOEROUT_NDEF);
						if (iOpt & D_GX_OPT_GET_ADDR) optW |= D_GX_OPT_STORE | D_GX_OPT_SET_ADDR;
						for (i=0;i<irs;i++,pInfoParm2++) {
							pInfoParm = (tdtInfoParm *)p;
						/*	optW = iOpt & D_GX_OPT_NOEROUT_NDEF;	*/
							if (rc=_ex_conv_parm_opt(&pInfoParm,optW,"?")) {
								pInfoParm1->pi_hlen = rc;
								pInfoParm1->pi_len++;
							}
							else if (cl_is_undef_parm(pInfoParm)) {
								pInfoParm1->pi_hlen = ECL_NDEFVAR_ERROR;
								pInfoParm1->pi_len++;
												/* %s: f[^ݒłB */
								if (iEROUT_NDEF) ERROROUT1(FORMAT(203),name);
							}
							else {
								cl_gx_copy_info(pInfoParm2,pInfoParm);
								pInfoParm2->pi_aux[0] |= iDEF_ZOK_DATA;
							}
							p -= sizeof(tdtInfoParm);
						}
						pInfoParmW->pi_alen |= D_AULN_PARMINFO2;
		}
	return 0;
}

/****************************************/
/*										*/
/****************************************/
static int _gx_ex_obj_end(pInfoParmW,iOpt,ppmstk,ppmstack,dastk,stack,irs,sp,mcat)
tdtInfoParm *pInfoParmW,**ppmstk,**ppmstack;
char **dastk;
short *stack;
int iOpt,irs,sp;
MCAT *mcat;
{
	static char *name="_gx_ex_obj_end";
	int rc,i,i1,optW,aux1,iDEF_ZOK_DATA;
	char *da1,c,*p;
	tdtInfoParm *pInfoParm,*pInfoParm1;

			if (irs<0) return -5;
			else if (irs>=1) {
				pInfoParm = ppmstk[--irs];
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:end: irs=%d",pInfoParm,irs,0);
				if (pInfoParm->pi_alen & D_AULN_HOLD_ERROR) {
					rc = ECL_NDEFVAR_ERROR;
					ERROROUT(pGlobTable->err_hist[1].par);
					pGlobTable->err_hist[1].parlen = 0;
					return rc;
				}
				iDEF_ZOK_DATA = pInfoParm->pi_aux[0] & DEF_ZOK_DATA;
				if ((iOpt & D_GX_OPT_GET_ADDR) && (pInfoParm->pi_id==D_DATA_ID_STOREVAR)) {
					cl_gx_copy_info(pInfoParmW,pInfoParm);
				}
				else {
					da1 = dastk[irs];
					optW = iOpt & (D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_STORE | D_GX_OPT_GET_ADDR | D_GX_OPT_INFO_MODE);
					if (iOpt & D_GX_OPT_GET_ADDR) optW |= D_GX_OPT_SET_ADDR;
					aux1 = pInfoParm->pi_aux[1] & D_AUX1_PROTECTED;
					if (rc=_ex_conv_parm_opt(&pInfoParm,optW,da1)) return rc;
				/*	pInfoParm->pi_scale &= ~D_DATA_MALLOC;	*//* add 2021.3.12 *//* del 2021.3.25 */
					cl_gx_copy_info(pInfoParmW,pInfoParm);
					if ((c=pInfoParm->pi_id) == '\0') {
						if (iOpt & D_GX_OPT_INFO_MODE) rc = 0;
						else {
											/* %s: %s̃f[^ݒłB */
							if (iEROUT_NDEF) ERROROUT2(FORMAT(127),name,da1);
							rc = ECL_NO_DATA_ERROR;
						}
						return rc;
					}
					if (c=='F' && pInfoParm->pi_alen & D_AULN_DOT_NAME) {
						if (_name_to_func_var(10000,pInfoParm->pi_data,pInfoParm) == 3000) {
							ERROROUT2(FORMAT(438),name,da1);	/* "%s: [%s]͖`łB */
							return -1;
						}
					}
					if (pInfoParm->pi_alen & D_AULN_PARMINFO2) {
						memcpy(pInfoParmW,pInfoParm,sizeof(tdtInfoParm)*2);
					}
					else cl_gx_copy_info(pInfoParmW,pInfoParm);

					if (pInfoParmW->pi_scale & D_DATA_ARRAY_INDEX) {
						/* %s: [%s]indexw肪܂B */
						ERROROUT2(FORMAT(129),name,da1);
						return ECL_EX_LET;
					}
				/* 2021.4.13
					pInfoParm->pi_aux[1] |= aux1;
					pInfoParm->pi_aux[0] |=iDEF_ZOK_DATA;
				*/
					pInfoParmW->pi_scale &= ~D_DATA_MALLOC;	/* add 2021.3.25 */
				}
/*
printf("cl_gx_ex_obj: iOpt=%08x pInfoParmW->pi_alen=%08x\n",iOpt,pInfoParmW->pi_alen);
*/
				if (pInfoParmW->pi_alen & D_AULN_PARMINFO2) ;
				else if (iOpt & D_GX_OPT_PARMINFO2) {
					if ((rc=_gx_ex_obj_end_narabi(pInfoParmW,iOpt,iDEF_ZOK_DATA,ppmstk,irs,mcat)) < 0) return rc;
				}
			}
			else {
				memset(pInfoParmW,0,sizeof(tdtInfoParm));
				if (iOpt & D_GX_OPT_PARMINFO2)
					memset(pInfoParmW+1,0,sizeof(tdtInfoParm));
			}
			pGlobTable->err_hist[1].parlen = 0;	/* add 2021.8.28 */

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:exit:",pInfoParmW,0,0);

			for (i=0;i<sp;i++) {
#if 1	/* 2022.6.11 */
				pInfoParm1 = ppmstack[i];
				if (pInfoParm1->pi_id == D_DATA_ID_UNDEFVAR) {
					optW = D_GX_OPT_STORE;
					if ((rc=_ex_conv_parm_opt(&pInfoParm1,optW,"")) < 0) return rc;
				}
				if (rc = cl_gx_let_ppmm(stack[i],pInfoParm1)) return rc;
#else
				if (rc = cl_gx_let_ppmm(stack[i],ppmstack[i])) return rc;
#endif
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"LAST cl_gx_let_ppmm:rc=%d",ppmstack[i],rc,0);
			}
DEBUGOUTL(110,"cl_gx_ex_obj:Exit normaly");
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_ex_obj_sub(pObj0,pGxObj,pInfoParmW,iOpt,Msa,iva)
tdtInfoParm **pObj0;
GXObject *pGxObj;
tdtInfoParm *pInfoParmW;
int iOpt,iva[];
MCAT *Msa[];
{
	static char *name="cl_gx_ex_obj_sub";
	int ida;
	char **da,**obj_stack;
	short *obj;
	int iob;
	int irs,ir2s,irs_max;
	MCAT *Ms_pp2stk,*Ms_ppmstk,*Ms_pmstk,*Ms_ppmstack,*Ms_stack,*Ms_dastk,*mcat;
	tdtInfoParm **pp2stk;
	tdtInfoParm **ppmstk;
	tdtInfoParm *pmstk,**ppmstack;
	short *stack;
	char **dastk;
	char *da1,*da2,*da3,id,id2,*p1,*p2;
	int i,scale,rc,opt0,optW,opt1,im,val,opt2,val1,val0,ret,exopt;
	char pOperator[32], *pWork, *p, c;
	tdtInfoParm InfoParm1,*pInfoParm1,InfoParmW2[2];
	tdtInfoParm InfoParm2,*pInfoParm2,*pInfoParm,**obj0;
	tdtInfoParm InfoParm3,*pInfoParm3;
	parmList  *prmL, qprmL;
	int sp,atr,attr0,i1,i2,amc,mc,atrn,len,len1,len2,aux1,type;
	int iFN_level,iAR_level,iDEF_ZOK_DATA,iUNDEF,iFN_skip;
	int ib,ib0,ib1,kind;
	tdtArrayIndex *pIndex;

	if (iva) {
		if (!(mc = iva[0])) return 0;	/* NOP */
	}
	obj = pGxObj->obj;
	da  = pGxObj->da;
	obj0 = pObj0;

#if 1	/* 2022.10.06 */
	iOpt != D_GX_OPT_GET_ADDR;
#endif
	im = (iOpt & D_GX_OPT_ALC_MASK)>>12;
	iEROUT_NDEF = !(iOpt & D_GX_OPT_NOEROUT_NDEF);
	opt0 = iOpt | D_GX_OPT_STORE;
	opt1 = D_GX_OPT_SET_ADDR | D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_INFO_MODE |
	       (iOpt & (D_GX_OPT_STORE | D_GX_OPT_GET_ADDR));
	opt1 |= D_GX_OPT_NOHOLD_NDEF;	/* add 2021.8.28 */
	opt2 = opt0;	/*iOpt;*/

	Ms_pp2stk = Msa[0];
	Ms_ppmstk = Msa[1];
	Ms_pmstk  = Msa[2];
	Ms_ppmstack = Msa[3];
	Ms_stack = Msa[4];
	Ms_dastk = Msa[5];
	mcat = Msa[6];
/*	cl_gx_expand(Ms_pp2stk,-1,&pp2stk);	*/
	cl_gx_expand(Ms_ppmstk,-1,&ppmstk);
	cl_gx_expand(Ms_pmstk,-1,&pmstk);
	cl_gx_expand(Ms_ppmstack,-1,&ppmstack);
	cl_gx_expand(Ms_stack,-1,&stack);
	cl_gx_expand(Ms_dastk,-1,&dastk);
/*
DEBUGOUTL1(120,"cl_gx_ex_obj_sub: dastk=%08x",dastk);
*/
	if (iva) {
		ib  = iva[1];	/* R}h̎wĂ */
		ida = iva[2];
		irs = iva[3];
		ir2s =iva[4];
		sp  = iva[5];
		iFN_level = iva[6];
		iAR_level = iva[7];
	}
	else {
		iob = pGxObj->nobj;
		stack[0]=0;
		sp=0;
		ir2s=0;
		atr=0;
		ida=0;
		ib0=ib=irs=iFN_level=iAR_level=iFN_skip=0;
	}
	iFN_skip = 0;
	rc = 0;
DEBUGOUTL3(120,"cl_gx_ex_obj_sub: mc=%d ib=%d irs=%d",mc,ib,irs);
  for (;;) {
	while (rc >= 0) {
		if (!iva) {
			if (ib >= iob) return -6;
			mc = obj[ib++];
			if (!mc) break;		/* NOP */
		}
DEBUGOUTL2(120,"cl_gx_ex_obj:ib+1=%d,mc=%d",ib,mc);
		if (mc==99) {

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:sp=%d, irs=%d",sp,irs);

			/* 2022.10.06 */
			return _gx_ex_obj_end(pInfoParmW,iOpt,ppmstk,ppmstack,dastk,stack,irs,sp,mcat);
		}
		else if (mc == 91) {
			ida = obj[ib++];
			dastk[irs] = da[ida];
			ib0 = ida;
			if (!(pInfoParm=(tdtInfoParm *)obj0[ib0])) {
				rc = -7;
				break;
			}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 91:1:ida=%d da=[%s]",pInfoParm,ida,da[ida]);
			if ((c=pInfoParm->pi_id)=='S' && !pInfoParm->pi_pos) {
				optW = opt1;
				if (rc=_conv_arg_opt(da[ida],pInfoParm,optW)) break;
			}
			else if (!c) {
				if (rc=_conv_arg_opt(da[ida],pInfoParm,opt1)) break;
			}
			if (pInfoParm->pi_aux[1] == D_AUX1_FUNC_ARRY) {
				if ((i=pInfoParm->pi_pos) == 2) iAR_level++;
				else if (i) iFN_level++;
			}
			ib0++;
			cl_gx_copy_info(pInfoParmW,pInfoParm);
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			pInfoParm = &pmstk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 91:2:ida=%d da=[%s]",pInfoParm,ida,da[ida]);

			ppmstk[irs++] = pInfoParm;

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:irs=%d, attr=%d",irs,pInfoParm->pi_attr);

		}
		else if (mc == 92) {
			ida = obj[ib++];
			if (rc=_conv_arg_opt(da[ida],pInfoParmW,opt1)) break;
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			pInfoParm = &pmstk[irs];
			dastk[irs] = da[ida];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:PUSH 92:ida=%d da=[%s]",pInfoParm,ida,da[ida]);

			ppmstk[irs++] = pInfoParm;
		}
		else if (mc==53 || mc==-53) {	/* SET */
			irs--;
			cl_gx_rep_info_set_ign(&pmstk[irs],pInfoParmW,0);
			ppmstk[irs] = &pmstk[irs];
			dastk[irs] = "SET";
			irs++;
		}
		else if (mc == 6) {	/* z */

DEBUGOUTL4(LVL_GXEXOBJ,"cl_gx_ex_obj: mc=%d, irs=%d, attr=%d opt2=%08x",
mc,irs,pInfoParmW->pi_attr,opt2);

			irs=cl_gx_array3(ppmstk,--irs,pInfoParmW,opt2,pmstk,dastk);
			if (irs < 0) return irs;
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
			da1 = dastk[irs];
			da2 = "[]";
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(da2)+1)))
				return ECL_MALLOC_ERROR;
			strcpy(p,da1);
			strcat(p,da2);
			dastk[irs] = p;
			irs++;
			iAR_level--;
		}
		else if (mc==1 || mc==3) {	/* () [f[^] */
			da1 = dastk[irs-1];
			if (mc==1)
				irs = _kakko2(ppmstk,--irs,pInfoParmW);
			else
				irs = _kakko(ppmstk,--irs,pInfoParmW,opt0,pmstk,dastk);
			if (irs < 0) return irs;
			else if (pInfoParmW->pi_id) {
				cl_gx_copy_info(&pmstk[irs],pInfoParmW);
				ppmstk[irs] = &pmstk[irs];
				if ((c=*da1)=='(' || c=='[') da1 = "";
				dastk[irs] = da1;
				irs++;
			}
/*
printf("cl_gx_ex_obj: irs=%d\n",irs);
*/
		}
		else if (mc==5 || mc==7) {	/* ֐ {} */

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj:mc=%d, irs=%d, attr=%d",mc,irs,pInfoParmW->pi_attr);

#ifdef CANCEL_WHEN_EOF	/* 2022.6.24 */
			if (iFN_skip) opt0 |= D_GX_OPT_SET_IMPORT;	/* D_GX_OPT_SET_IMPORTiFN_skipƂĎgp */
#endif
			rc = cl_gx_func(ppmstk,--irs,pInfoParmW,opt0,pmstk,dastk,&ret);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_func rc=%d ret=%d",rc,ret);

#ifdef CANCEL_WHEN_EOF	/* 2022.6.24 */
			if (ret==ECL_END_OF_FILE || ret==ECL_IN_ERROR) {
				if ((exopt=cl_get_option(7,0)) & 0x20) iFN_skip = 1;
				else if (exopt & 0x40) {
					ib = iob - 1;
					if (obj[ib] != 99) ib--;
					rc = 0;
					cl_null_data(pInfoParmW);
				}
			}
			else if (ret < 0) return ret;	/* ret̔Arc ͎̔else if */
			else
#endif
			if (rc < 0) return rc;
			else if (rc == ECL_FUNC_CLASS) {
				rc = -1;
				if (ib<iob) {
					mc = obj[ib++];
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:func_class:ib+1=%d,mc=%d",ib,mc);
					if (mc == -13) {
						rc = _new_class(ppmstk,irs,pInfoParmW,dastk);
						if (rc < 0) return rc;
					}
				}
				if (rc < 0) {
					/* %s: New܂B */
					ERROROUT1(FORMAT(167),name);
					return ECL_SCRIPT_ERROR;
				}
			}
			irs = rc;
			if (mc==5 && pInfoParmW->pi_id=='\0' && (cl_get_option(1,0) & 0x08))
				cl_null_data(pInfoParmW);
			cl_gx_copy_info(&pmstk[irs], pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
			da1 = dastk[irs];
			if (mc == 5) da2 = FORMAT(131);	/* ֐(%s)̖߂l */
			else da2 = FORMAT(328);	/* f[^Xg */
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(da2)+1)))
				return ECL_MALLOC_ERROR;
			sprintf(p,da2,da1);
			dastk[irs] = p;
			irs++;
			iFN_level--;
		}
		else if (mc == 60) {	/* : */
			rc = 0;
			break;
		}
		else if (mc == 93) {	/* GOTO */
			ib += obj[ib];
			if (ib <= 0) {
				rc = -6;
			}
			else rc = 0;
			break;
		}
		else if (mc == D_IMD_RANGE) {	/* .. */

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj:mc=%d, irs=%d, attr=%d",mc,irs,pInfoParmW->pi_attr);

			optW = opt0;
			if (iAR_level+iFN_level) optW |= D_GX_OPT_GET_RANGE;
			irs=cl_gx_range(ppmstk,--irs,pInfoParmW,optW,dastk);
			if (irs < 0) return irs;
			pInfoParmW->pi_aux[1] |= D_AUX1_PROTECTED;
			cl_gx_copy_info(&pmstk[irs],pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
			dastk[irs] = FORMAT(134);	/* ͈͎w */
			irs++;
		}
		else if (mc == 98) {	/* , */
			ib++;
		}
		else {

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: mc=%d, irs=%d, attr=%d",
mc,irs,pInfoParmW->pi_attr);

			amc = X_ABS(mc);
			if (amc <= 100) {
				if (!(p=_atr2ope(amc))) return -4;
			}
			else p = da[amc-1001];
			strcpy(pOperator,p);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj: sp=%d, opr=%s",sp,pOperator);

			if (irs<=0) return -5;
			/****************/
			/*     pop2     */
			/****************/
			pInfoParm2 = &InfoParm2;
#if 1	/* 2022.6.8 */
			if ((irs=_pop_pmstk(pInfoParm2,mc,irs,pmstk,ppmstk,dastk,&da2,2)) < 0) return irs;
#else
			cl_gx_copy_info(pInfoParm2,&pmstk[--irs]);
			da2 = dastk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:pop2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

#if 1	/* 2021.6.8 */
			if ((irs=_srch_range_flag(pInfoParm2,irs,ppmstk,1)) < 0) return irs;
#endif
			if (pInfoParm2->pi_id==D_DATA_ID_PNAME && pInfoParm2->pi_attr==2 &&
			    mc!=90 && mc!=D_IMD_PNAME) {
				pInfoParm2->pi_id = D_DATA_ID_STOREVAR;

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: changed id=[%c] irs=%d da2=[%s]",pInfoParm2->pi_id,irs,da2);

			}
#endif
			if (mc < 0 ||
			    mc==28 ||						/* ABS */
		/*	    mc==36 ||	*/					/* != */
			    mc==59 ||						/* ? */
			    mc==79 || (mc>=14 && mc<=17)) {	/* ~= ++ -- || ~~*/
				pInfoParm1 = &InfoParm1;
				cl_none_parm(pInfoParm1);
				da1 = "";
			}
			else {
				if (irs<=0) return -5;
				/****************/
				/*     pop1     */
				/****************/
				pInfoParm1 = &InfoParm1;
#if 1	/* 2022.6.8 */
				if ((irs=_pop_pmstk(pInfoParm1,mc,irs,pmstk,ppmstk,dastk,&da1,1)) < 0) return irs;
#else
				cl_gx_copy_info(pInfoParm1,&pmstk[--irs]);
				da1 = dastk[irs];

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:pop1: irs=%d da1=[%s]",pInfoParm1,irs,da1);

#if 1	/* 2021.6.8 */
				if ((irs=_srch_range_flag(pInfoParm1,irs,ppmstk,1)) < 0) return irs;
#endif
				if (pInfoParm1->pi_id==D_DATA_ID_PNAME && pInfoParm1->pi_attr==2 &&
				    mc!=D_IMD_NAMED) {
					pInfoParm1->pi_id = D_DATA_ID_STOREVAR;

DEBUGOUTL3(LVL_GXEXOBJ,"cl_gx_ex_obj: changed id=[%c] irs=%d da2=[%s]",pInfoParm1->pi_id,irs,da1);

				}
#endif
				optW = iOpt & (D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_SET_LOCAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_GLOBAL| D_GX_OPT_INFO_MODE);
				if (mc>=71 && mc<=90) {
					optW |= D_GX_OPT_STORE_CHK;
					if (mc==90) optW |= D_GX_OPT_STORE;
				}
				else if (mc == 29) {
					optW |= D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF | D_GX_OPT_INFO_MODE;
					if (pInfoParm1->pi_id==D_DATA_ID_UNDEFVAR && pInfoParm1->pi_attr!=DEF_ZOK_CHAR) {
						pIndex = (tdtArrayIndex *)pInfoParm1->pi_data;

DEBUGOUTL1(LVL_GXEXOBJ,"cl_gx_ex_obj: pIndex->pInfoType=%08x",pIndex->pInfoType);

						if (pIndex->pInfoType) optW |= D_GX_OPT_STORE;
					}
				}
#if 1	/* 2021.8.11 */
				if (mc==D_IMD_PNAME || mc==D_IMD_NAMED) {	/* <== ==> */
					optW |= D_GX_OPT_GET_ADDR;
				}
#endif
#ifdef DATA_NARABI
			  if (mc != 90)
#endif
				if (rc=_ex_conv_parm_opt(&pInfoParm1,optW,da1)) return rc;
			}

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:1: irs=%d da1=[%s]",pInfoParm1,irs,da1);

#if 1	/* 2021.8.13 */
			if ((mc>=71 && mc<=90) || (amc>=14 && amc<=17)) {
#else
			if ((mc>=71 && mc<=90) || (amc>=14 && amc<=17) ||
			    mc==D_IMD_PNAME || mc==D_IMD_NAMED) {
#endif
				if (mc==79 || mc<0)
					optW = D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
				if (mc>=14 && mc<=17)
					optW = D_GX_OPT_STORE_CHK | D_GX_OPT_NOERROR_NDEF | D_GX_OPT_NOEROUT_NDEF;
				else optW = 0;
				if (rc=_ex_conv_parm_opt(&pInfoParm2,optW,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				if (optW) pInfoParm = pInfoParm2;
				else pInfoParm = pInfoParm1;
#if 1	/* 2021.3.29 */
				if (pInfoParm->pi_id == 'S') pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				type = pInfoParm->pi_aux[0] & 0x07;
				if (((((c=pInfoParm->pi_id)=='A' || c=='R') && (type>0 && type<7)) || (c=='T')) &&
				    (pInfoParm->pi_scale & D_DATA_INDEX_FREE)) {
					/* 2021.9.9 */
					if (c!='T' && type) p = FORMAT(330);
					else p = cl_gx_get_name_from_id(c);
					if (c == 'T') p = strtmp2(FORMAT(643),p);
							/* %s: %s(%s)ւ̑͂ł܂B */
					ERROROUT3(FORMAT(132),name,p,(char *)pInfoParm->pi_pos);
					return ECL_SCRIPT_ERROR;
				}
#else
				if (((c=pInfoParm->pi_id)=='A' || c=='R') &&
				    (pInfoParm->pi_scale & D_DATA_INDEX_FREE)) {
					p = (char *)pInfoParm->pi_pos;
							/* %s: %s(%s)ւ̑͂ł܂B */
					ERROROUT3(FORMAT(132),name,FORMAT(150),p);
					return ECL_EX_LET;
				}
#endif
				if (mc>=71 && mc<=89) {
					pOperator[strlen(pOperator)-1] = '\0';	/* '='폜 */
					if (rc = cl_gx_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,0,NULL)) {
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:mc=%d rc=%d",mc,rc);
						return rc;
					}
					if (mc == 79) pInfoParm1 = pInfoParm2;
					rc = cl_gx_rep_info_set(pInfoParm1,pInfoParmW,1);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_rep_info_set:mc=%d rc=%d",mc,rc);
				}
				else if (mc == 90) {
#ifdef DATA_NARABI
					rc = _rep_info_set(mc,&pInfoParm1,pInfoParm2,iOpt,dastk,irs,ppmstk);
					if (rc >= 0) {
						if (rc != irs) da1 = dastk[rc];
						irs = rc;
						rc = 0;
					}
#else
					rc = cl_gx_rep_info_set_name(pInfoParm1,pInfoParm2,1,da1);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_rep_info_set_name:mc=%d rc=%d",mc,rc);
					if (!rc && *da1=='<') rc = cl_gx_clear_var90(pInfoParm1,da1);
#endif
				}
				else if (mc<=-14 && mc>=-17) {
					rc = cl_gx_let_ppmm(mc,pInfoParm2);
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_let_ppmm:mc=%d rc=%d",mc,rc);
					pInfoParm1 = pInfoParm2;
				}
				else if (mc>=14 && mc<=17) {
					if (cl_gx_expand(Ms_ppmstack,sp,&ppmstack) < 0) return -3;
					if (cl_gx_expand(Ms_stack,sp,&stack) < 0) return -3;
#if 1	/* 2022.6.11 */
					if (iUNDEF=cl_is_undef_parm(pInfoParm2)) {
						pInfoParm1 = (tdtInfoParm *)clmemdup(pInfoParm2,sizeof(tdtInfoParm),D_OPT_ALC_TMP);
						if (pInfoParm2->pi_id == D_DATA_ID_UNDEFVAR) {
							cl_gx_copy_info(pInfoParm1, pInfoParm2);
						}
						else {
							len = strlen(da2);
							cl_set_parm_char(pInfoParm1,clmemdup(da2,len,D_OPT_ALC_TMP),len);
							pInfoParm1->pi_id = D_DATA_ID_UNDEFVAR;
						}
					}
					else pInfoParm1 = _info_parm_temp_dup(pInfoParm2);
					ppmstack[sp] = pInfoParm1;
#else
					ppmstack[sp] = _info_parm_temp_dup(pInfoParm2);
#endif
					stack[sp++] = mc;
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:ppmstack:mc=%d sp=%d",mc,sp);
					pInfoParm1 = pInfoParm2;
				}
#if 1	/* 2021.8.13 */
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:1=: mc=%d",pInfoParm1,mc,0);
#if 1	/* 2022.6.12 */
				if (mc>=14 && mc<=17) {
					if (iUNDEF) {
						cl_gx_copy_info(pInfoParmW, pInfoParm1);
					}
					else {
						pInfoParm = pInfoParm1;
						cl_set_parm_long(pInfoParmW,(long)pInfoParm);
						pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
					}
				}
				else if (mc>=71 && mc<=90) {
					pInfoParm = pInfoParm1;
					cl_set_parm_long(pInfoParmW,(long)pInfoParm);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
				else {
					pInfoParm = (tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm));
					cl_gx_copy_info(pInfoParm, pInfoParm1);
					cl_set_parm_long(pInfoParmW,(long)pInfoParm);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
				pInfoParmW->pi_aux[1] = pInfoParm1->pi_aux[1];
#else
				if (mc>=14 && mc<=17) {
					pInfoParm = pInfoParm1;
				}
				else {
					pInfoParm = (tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm));
					cl_gx_copy_info(pInfoParm, pInfoParm1);
				}
				cl_set_parm_long(pInfoParmW,(long)pInfoParm);
				pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
#endif
			}
			else if (mc==D_IMD_PNAME || mc==D_IMD_NAMED) {	/* <== ==> */
				optW = 0;
				if (rc=_ex_conv_parm_opt(&pInfoParm2,optW,da2)) return rc;
#else
				if (mc==D_IMD_PNAME || mc==D_IMD_NAMED) {	/* <== ==> */
#endif
					if (mc == D_IMD_NAMED) {
						pInfoParm = pInfoParm2;
						pInfoParm2 = pInfoParm1;
						pInfoParm1 = pInfoParm;
						da3 = da1;
					}
					else da3 = da2;
					if ((atr=pInfoParm2->pi_attr) == 1) {
						rc = cl_chk_pname_name(pInfoParm2->pi_data);
					}
					else rc = -1;
					if (rc) {
						ERROROUT3(FORMAT(168),name,da3,atr);
						return ECL_SCRIPT_ERROR;
					}
					if (!(pInfoParm=(tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm))))
						return ECL_MALLOC_ERROR;
					rc = cl_gx_rep_info_set_ign(pInfoParm,pInfoParm1,1);
					cl_set_parm_long(pInfoParmW,(long)pInfoParm);
					pInfoParmW->pi_id = D_DATA_ID_PNAME;
					pInfoParmW->pi_paux = pInfoParm2->pi_data;
				}
#if 0	/* 2021.8.13 */
				else {
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:1=: mc=%d",pInfoParm1,mc,0);
					cl_set_parm_long(pInfoParmW,(long)pInfoParm1);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
			}
#endif
			else if (mc == 59) {	/* ? */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				val = 0;
				kind = obj[ib++];
DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:kind=%d ib=%d",kind,ib);
				if (kind<=1 || kind>=6)	{	/* IIF, AND, OR */
					val0 = val = cl_is_true(pInfoParm2);
					if (kind == 6) val = !val;
				}
				else if (kind == 2)		/* NVAL, NULLIF */
					val = cl_is_null_chk_null_parm(pInfoParm2);
				else if (kind == 3) {	/* NSVAL */
					val = cl_is_null_chk_null_parm(pInfoParm2);
					if (!val) val = cl_is_spaces(pInfoParm2);
				}
				else {	/* NDEF */
					val = cl_is_ndef(pInfoParm2);
					if (kind == 5) {
						if (irs<=0) return -5;
						/****************/
						/*     pop1     */
						/****************/
						pInfoParm1 = &InfoParm1;
						if ((irs=_pop_pmstk(pInfoParm1,mc,irs,pmstk,ppmstk,dastk,&da1,1)) < 0) return irs;
						if (rc=cl_get_parm_bin(pInfoParm1,&val1,"cl_gx_ex_obj:ndef:")) return rc;
						if (val1) {
							cl_set_parm_bin(pInfoParm2,val);
							val = 0;
						}
					}
				}
				if (iva) iva[8] = val;
				if (val < 0) return val;
				else if (kind <= 5) {
					if (!val) {
						ib += obj[ib];
						if (ib <= 0) {
							return -6;
						}
						if (kind  <= 1) break;	/* continue */
						cl_gx_copy_info_opt(pInfoParmW,pInfoParm2,1);
					}
					else {
						ib++;
						if (kind > 0) ib += 3;
						rc = 0;
						break;	/* continue */
					}
				}
				else {	/* AND, OR */
					if (cl_is_null_parm(pInfoParm2)) {
						ib++;
						break;
					}
					ib1 = obj[ib++];
DEBUGOUTL5(LVL_GXEXOBJ,"cl_gx_ex_obj: kind=%d ib=%d ib1=%d val=%d val0=%d",kind,ib,ib1,val,val0);
					/* ib1==-99 ̂Ƃ́AȂȂ̂ŁApop2pop1̑ɂȂ */
					if (ib1 > 0) {
						/****************/
						/*     pop1     */
						/****************/
						pInfoParm1 = &InfoParm1;
						if ((irs=_pop_pmstk(pInfoParm1,mc,irs,pmstk,ppmstk,dastk,&da1,1)) < 0) return irs;
					}
					else if (ib1!=-99) return -6;
					cl_set_parm_bin(pInfoParmW,val0);
					if (ib1 == -99) ;
					else if (val) ib += ib1 - 1;	/* ib+1Ă̂-1 */
					else {
						/* pop1ppush  */
						cl_set_parm_bin(&pmstk[irs],val0);
						ppmstk[irs] = &pmstk[irs];
						dastk[irs++] = da1;
						break;
					}
				}
			}
			else if (mc == 20) {	/* CAST */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				if (rc = cl_gx_cast(pInfoParmW,pInfoParm1,pInfoParm2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:CAST: mc=%d",pInfoParmW,mc,rc);

			}
			else if (mc == -21) {	/* *name */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: mc=%d irs=%d",pInfoParm2,mc,irs);

				id = pInfoParm2->pi_id;
				if (id==' ' && (pInfoParm2->pi_alen & D_AULN_RANGE_DATA) &&
				              !(pInfoParm2->pi_alen & D_AULN_COMPLEX_DATA)) ;
				else if (id=='A' || id=='R' || id=='T' || id=='L' || id=='N') ;
				else if (id=='S') ;
				else {
					/* %s: %s'%s'͎wł܂B */
					ERROROUT3(FORMAT(140),name,da2,"*");
					return ECL_EX_LET;
				}
				cl_gx_copy_info(pInfoParmW,pInfoParm2);
				pInfoParmW->pi_aux[0] |= DEF_ZOK_DATA;
			}
#if 1	/* 2021.6.7 */
			else if (mc == -30) {	/* **name */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: mc=%d irs=%d",pInfoParm2,mc,irs);

				id = pInfoParm2->pi_id;
				if (id==' ' && (pInfoParm2->pi_alen & D_AULN_RANGE_DATA)) {
					cl_gx_copy_info(pInfoParmW,pInfoParm2);
					pInfoParmW->pi_aux[0] |= DEF_ZOK_DATA; 
					optW = opt0;
					irs=cl_gx_range_tenkai(ppmstk,irs,pInfoParmW,optW,pmstk,dastk,
					                Ms_ppmstk,Ms_pmstk,Ms_dastk);
					if (irs < 0) return irs;
					cl_gx_expand(Ms_dastk,-1,&dastk);
					cl_gx_expand(Ms_pmstk,-1,&pmstk);
					cl_gx_expand(Ms_ppmstk,-1,&ppmstk);
					rc = 0;
					break;
				}
				else {
					/* %s: %s'%s'͎wł܂B */
					ERROROUT3(FORMAT(140),name,da2,"**");
					return ECL_EX_LET;
				}
			}
#endif
			else if (mc == -41) {	/* &name */
				pInfoParm = pInfoParm2;
				if (rc=_ex_conv_parm_opt(&pInfoParm,0,da2)) return rc;
				id = pInfoParm->pi_id;
				if (id!=' ' || (pInfoParm->pi_aux[1] & D_AUX1_PROTECTED)) {
					/* %s: %s'%s'͎wł܂B */
					ERROROUT3(FORMAT(140),name,da2,"&");
					return ECL_EX_LET;
				}
				pInfoParm = (tdtInfoParm *)cl_tmp_const_malloc(sizeof(tdtInfoParm));
				cl_gx_copy_info(pInfoParm, pInfoParm2);
				cl_set_parm_long(pInfoParmW,(long)pInfoParm);
				pInfoParmW->pi_id = 'S';
			}
			else if (mc == 29) {	/* .name */
				id  = pInfoParm1->pi_id;
				id2 = pInfoParm2->pi_id;
/*
printf("cl_gx_ex_obj: da1=[%s] id1=[%c] da2=[%s] id2=[%c]\n",da1,id,da2,id2);
*/
				p2 = da2;
#if 1	/* 2021.3.15 */
				c = *p2;
				if (pInfoParm2->pi_alen & D_AULN_NAME_DATA) {
					if (id2==' ' && (c=='$' || c=='%' || c=='#')) {
						pInfoParm2 = &InfoParm2;
						if (rc=_conv_arg_opt(p2,pInfoParm2,D_GX_OPT_NOEROUT_NDEF)) return rc;
						id2 = pInfoParm2->pi_id;
						p2 = pInfoParm2->pi_data;
						len2 = pInfoParm2->pi_dlen;
						c = *p2;
					}
					else len2 = strlen(p2);
				}
				else {
					if (id2 == 'S') pInfoParm2 = (tdtInfoParm *)pInfoParm2->pi_pos;
					id2 = pInfoParm2->pi_id;
					if (pInfoParm2->pi_attr == DEF_ZOK_CHAR) {
						p2 = pInfoParm2->pi_data;
						len2 = pInfoParm2->pi_dlen;
					}
				}
#else
				if ((c=*p2) == '$') p2++;
				len2 = strlen(p2);
#endif
/*
printf("cl_gx_ex_obj: id2=[%c] attr=%d len2=%d p2=[%s]\n",id2,pInfoParm2->pi_attr,len2,p2);
*/
				if ((id=pInfoParm1->pi_id)=='T') {
					if (id2=='C' || id2=='F' ||id2=='O') ;
					else if (id2!=' ' || pInfoParm2->pi_attr!=DEF_ZOK_CHAR) {
								/* %s: [%s]Ă܂B*/
						ERROROUT2(FORMAT(125),name,da2);
						return ECL_SCRIPT_ERROR;
					}
					optW = D_GX_OPT_STORE_CHK | D_GX_OPT_STORE;
					if (rc=_ex_get_member(&pInfoParm1,optW,p2,len2)) return rc;
					cl_set_parm_long(pInfoParmW,(long)pInfoParm1);
					pInfoParmW->pi_id = D_DATA_ID_STOREVAR;
				}
				else if ((id=='F' || id=='M' || id=='O' || id=='U')&&
				         (id2=='F' || id2=='C' || id2=='O' || id2=='U' || id2==' ')) {
					len1 = pInfoParm1->pi_dlen;
					len = len1 + len2 + 1;
					if (!(p=cl_tmp_const_malloc(len+1))) return ECL_MALLOC_ERROR;
					p1 = pInfoParm1->pi_data;
					if (*p1 == '$') {
						p1++;
						len1--;
					}
					memcpy(p,p1,len1);
					memcpy(p+len1,".",1);
					memzcpy(p+len1+1,p2,len2);
					cl_set_parm_char(pInfoParmW,p,len1+len2+1);
				 	if (id2=='U' || id2==' ') pInfoParmW->pi_id = 'F';
				 	else pInfoParmW->pi_id = id2;
					pInfoParmW->pi_alen |= D_AULN_DOT_NAME;
				}
				else if ((id==' ' || id=='A' || id=='R' || id=='L' || id=='N') && id2=='F') {
					if (rc=cl_set_system_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else if (id=='I') {
					if (rc=cl_set_instance_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else if (id=='C') {
					if (rc=cl_set_class_method(pInfoParmW,pInfoParm1,pInfoParm2,optW,p2,len2)) return rc;
				}
				else {
					if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;
					if (rc=cl_gx_str_pos(pInfoParmW,pInfoParm1,optW,pInfoParm2)) {
						if (rc == ECL_SYNTAX_ERROR) {
							/* %s: [%s]Ă܂B*/
							ERROROUT2(FORMAT(125),name,da2);
							rc = ECL_SCRIPT_ERROR;
						}
						return rc;
					}
				}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:.name: mc=%d",pInfoParmW,mc,rc);
			}
			else if (mc == -13) {	/* new */
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: irs=%d da2=[%s]",pInfoParm2,irs,da2);

				id = pInfoParm2->pi_id;
				if (id != 'C') {
					/* %s: ϐ[%s]%sł͂܂B */
					ERROROUT3(FORMAT(431),name,da2,FORMAT(120));	/* NX */
					return ECL_EX_LET;
				}
				if (rc = cl_func_new(pInfoParmW,1,&pInfoParm2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:NEW: mc=%d",pInfoParmW,mc,rc);

			}
			else if (mc == -50) {	/* `xxxxxxx` */
				if (rc = cl_gx_ex_cmd(pInfoParmW,pInfoParm2)) return rc;
			}
			else {
				if (rc=_ex_conv_parm_opt(&pInfoParm2,0,da2)) return rc;

DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:2: mc=%d irs=%d",pInfoParm2,mc,irs);

				rc = cl_gx_bexp(pInfoParmW,pInfoParm1,pOperator,pInfoParm2,0,NULL);

DEBUGOUTL2(LVL_GXEXOBJ,"cl_gx_ex_obj:cl_gx_bexp:mc=%d rc=%d",mc,rc);

			}
#if 1	/* 2021.6.14 */
			if (rc < 0) return (rc);
			else if (rc > 0) {
				ERROROUT2(FORMAT(620),name,rc);	/* %s: (W)^[R[h(%d)łB*/
				rc = 0;
			}
#else
			if (rc) return (rc);
#endif
			cl_gx_copy_info(&pmstk[irs],pInfoParmW);
			ppmstk[irs] = &pmstk[irs];
			if (!(p=cl_tmp_const_malloc(strlen(da1)+strlen(pOperator)+strlen(da2)+3)))
				return ECL_MALLOC_ERROR;
			sprintf(p,"%s %s %s",da1,pOperator,da2);
			dastk[irs] = p;
			irs++;
/*
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:push W: irs=%d",ppmstk[irs-1],irs,0);
*/
		}
DEBUGOUT_InfoParm(LVL_GXEXOBJ,"cl_gx_ex_obj:push W: irs=%d dastk=[%]",ppmstk[irs-1],irs,dastk[irs-1]);
/*
printf("cl_gx_ex_obj:push W: irs=%d\n",irs);
*/
		rc = 0;
		break;
	}
	if (iva) {
		if (!rc) {
			iva[1] = ib;
			iva[2] = ida;
			iva[3] = irs;
			iva[4] = ir2s;
			iva[5] = sp;
			iva[6] = iFN_level;
			iva[7] = iAR_level;
		}
		break;
	}
	else if (rc) break;
  }
/*
printf("cl_gx_ex_obj_sub: Exit rc=%d\n",rc);
*/
	return rc;
}

/************************************/
/*									*/
/************************************/
int cl_gx_set_scr_obj(scrprct)
ScrPrCT *scrprct;
{
	int i,count;

	if (!scrprct) return -1;
	if (scrprct->Obj) return 0;

	if (!(scrprct->Obj=cl_mk_obj0(cl_get_obj0_used(NULL,scrprct),0))) return -1;
	return 0;
}

/************************************/
/*									*/
/************************************/
tdtObjHead *cl_gx_get_scr_obj()
{
	ScrPrCT *scrct;

	if (scrct=cl_search_src_ct()) return scrct->Obj;
	return NULL;
}

/************************************/
/*									*/
/************************************/
tdtObjHead *cl_gx_get_proc_obj()
{
	ProcCT *proc;

	if (proc=cl_search_proc_ct()) return proc->Obj;
	return NULL;
}

/************************************/
/*									*/
/************************************/
tdtObjHead *cl_gx_get_obj()
{
	tdtObjHead *pObj;

	if (!(pObj=cl_gx_get_proc_obj())) pObj = cl_gx_get_scr_obj();
	return pObj;
}
/*
int _clear_obj_addr(pGxObj,pInfoParm0,obj0)
GXObject *pGxObj;
tdtInfoParm *pInfoParm0,**obj0;
{
	return 0;
}
*/
#if 1	/* 2021.7.18 */
int cl_gx_clear_var_obj(leaf,curleaf,varnam,Obj,scope)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
{
	return 0;
}

int cl_gx_clear_var90(pInfoParm,da)
tdtInfoParm *pInfoParm;
char *da;
{
	return 0;
}

int cl_gx_clear_var_define(scrct,proc,varnam,opt)
ScrPrCT *scrct;
ProcCT  *proc;
char *varnam;
int opt;
{
	return 0;
}

int cl_gx_clear_var_obj_all(scrpt,curleaf,varnam,scope)
ScrPrCT *scrpt;
Leaf *curleaf;
char *varnam;
int scope;
{
	return 0;
}

/****************************************/
/*										*/
/****************************************/
int _clear_obj_addr(pGxObj,pInfoParm0,obj0)
GXObject *pGxObj;
tdtInfoParm *pInfoParm0,**obj0;
{
	int n,atr,len;
	short *obj;
	int nob,ib,mc,ida,ib0;
	char **da,c,*pd;
	tdtInfoParm *p,*pInfoParm=pInfoParm0,*pParmW,tParmW;
	uchar pi_aux;

	nob = pGxObj->nobj;
	obj = pGxObj->obj;
	da  = pGxObj->da;
	n = ib0 = ib = 0;

DEBUGOUTL5(LVL_GXEXOBJ+1,"_clear_obj_addr: pGxObj=0x%08x pInfoParm0=0x%08x nobj0=%d obj0=0x%08x option=0x%08x",
pGxObj,pInfoParm0,pGxObj->nobj0,obj0,pGxObj->option);
/*
printf("_clear_obj_addr: nobj0=%d obj0=0x%08x\n",pGxObj->nobj0,obj0);
*/
	while (ib<nob) {
		mc = obj[ib++];
/*
printf("_clear_obj_addr: ib=%d obj=%d\n",ib-1,mc);
*/
		if (mc==99) break;
		else if (mc == 91) {
			ida = obj[ib++];
/*
printf("_clear_obj_addr: ida=%d da=[%s]\n",ida,da[ida]);
*/
			ib0 = ida;
			pd = da[ida];
			len = strlen(pd);
#if 1	/* 2021.7.22 */
			if (pParmW = obj0[ib0]) tParmW = *pParmW;
			else cl_parm_set0(&tParmW);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: pParmW ",pParmW,0,0);
			if (pInfoParm) {
				obj0[ib0] = pInfoParm;
DEBUGOUTL3(LVL_GXEXOBJ+1,"_clear_obj_addr: c=%c ib0=%d pInfoParm=%08x",c,ib0,pInfoParm);
				pInfoParm++;
				n++;
			}
			else if (!(pGxObj->option & D_GX_OPT_SET_PROC_OBJ)) {
				if (pParmW = obj0[ib0]) {
					if (pParmW->pi_id == 'S') {
						pi_aux = pParmW->pi_aux[1];
						if (p=(tdtInfoParm *)pParmW->pi_pos) {

DEBUGOUTL2(LVL_GXEXOBJ+1,"_clear_obj_addr: pi_aux=%02x pi_aux[1]=%02x",pi_aux,p->pi_aux[1]);

							if (pi_aux & D_AUX1_PROTECTED) ;
							else if ((pi_aux | p->pi_aux[1]) & D_AUX1_LOCAL_VAR) {
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: *** CLEAR p ",p,0,0);
/*
printf("_clear_obj_addr: *** CLEAR da=[%s] ucAux1=%02x pi_aux[1]=%02x scope=%08x\n",nval1(pd),ucAux1,p->pi_aux[1],scope);
*/
								cl_parm_set0(pParmW);
							}
						}
					}
				}
			}
#else
			if (pParmW = obj0[ib0]) tParmW = *pParmW;
			else cl_parm_set0(&tParmW);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: pParmW ",pParmW,0,0);
			if (len>1 && ((c=*da[ida])=='$' || c=='%' || c=='#' || c=='<')) {
				if (pInfoParm) {
					obj0[ib0] = pInfoParm;
DEBUGOUTL3(LVL_GXEXOBJ+1,"_clear_obj_addr: c=%c ib0=%d pInfoParm=%08x",c,ib0,pInfoParm);
					pInfoParm++;
					n++;
				}
				if (!(pGxObj->option & D_GX_OPT_SET_PROC_OBJ)) {
					if ((p=obj0[ib0]) && !(p->pi_alen & D_AULN_NAME_DATA)) {
						if (tParmW.pi_id == 'S') {
							*p = tParmW;
							p->pi_pos = 0;
							p->pi_aux[1] = 0;
						}
						else cl_parm_set0(p);
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_obj_addr: p ",p,0,0);
					}
				}
			}
#endif
		}
		else if (mc == 92) ib++;
	}
	if (n > 0) pGxObj->option |= D_GX_OPT_SET_PROC_OBJ;
	return n;
}

/****************************************/
/*										*/
/****************************************/
static int _clear_var_obj(varnam,pGxObj,Obj,scope)
char *varnam;
GXObject *pGxObj;
tdtObjHead *Obj;
int scope;
{
	int n,atr,len,k,ix;
	short *obj;
	int nob,ib,mc,ida,ib0;
	char **da,c,*pd;
	tdtInfoParm **obj0,*p,*pParmW,**Obj0;
	uchar ucAux1;

	nob = pGxObj->nobj;
	obj = pGxObj->obj;
	da  = pGxObj->da;
#if 1	/* 2021.7.26 */
	if (Obj) {
		return 0;
#else
	if (pGxObj->maxobj0 > 0) {	/* 2021.7.21 add */
		Obj0 = Obj->Obj0;
		ix = pGxObj->maxobj0 - 1;	/* 2021.4.1 add -1 */
#endif
	}
	else {
		Obj0 = pGxObj->obj0;
		ix = 0;
	}
	obj0 = &Obj0[ix];
	n = ib0 = ib = 0;

DEBUGOUTL5(LVL_GXEXOBJ+1,"_clear_var_obj: varnam=[%s] pGxObj=0x%08x nobj0=%d obj0=0x%08x scope=0x%08x",
varnam,pGxObj,pGxObj->nobj0,obj0,scope);
/*
printf("_clear_var_obj: nobj0=%d ix=%d obj0=0x%08x\n",pGxObj->nobj0,ix,obj0);
*/
	while (ib<nob) {
		mc = obj[ib++];
/*
printf("_clear_var_obj: ib=%d obj=%d\n",ib-1,mc);
*/
		if (mc==99) break;
		else if (mc == 91) {
			ida = obj[ib++];
/*
printf("_clear_var_obj: ida=%d da=[%s]\n",ida,da[ida]);
*/
			ib0 = ida;
			pd = da[ida];
			if (*pd == '<') pd += 3;
			if (varnam) k = !strcmp(varnam,pd);
			else k = 1;
			if (k) {
DEBUGOUTL2(LVL_GXEXOBJ+1,"_clear_var_obj: ida=%d da=[%s]",ida,da[ida]);
				if (pParmW=obj0[ib0]) {
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_var_obj: pParmW ",pParmW,0,0);

					if (pParmW->pi_id == 'S') {
						ucAux1 = pParmW->pi_aux[1];
						if (p=(tdtInfoParm *)pParmW->pi_pos) {

DEBUGOUTL2(LVL_GXEXOBJ+1,"_clear_var_obj: pi_aux[1]=%08x scope=%08x",p->pi_aux[1],scope);

#if 1	/* 2021.7.22 */
							if (ucAux1 & D_AUX1_PROTECTED) ;
							else if ((ucAux1 | p->pi_aux[1]) & scope) {
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_var_obj: *** CLEAR p ",p,0,0);
/*
printf("_clear_var_obj: *** CLEAR da=[%s] ucAux1=%02x pi_aux[1]=%02x scope=%08x\n",nval1(pd),ucAux1,p->pi_aux[1],scope);
*/
								cl_parm_set0(pParmW);
							}
#else
							if ((ucAux1 | p->pi_aux[1]) & scope) {
/*
printf("_clear_var_obj: *** CLEAR da=[%s] ucAux1=%02x pi_aux[1]=%02x scope=%08x\n",nval1(pd),ucAux1,p->pi_aux[1],scope);
*/
								pParmW->pi_pos = 0;
								pParmW->pi_aux[1] = 0;
							}
#endif
						}
DEBUGOUT_InfoParm(LVL_GXEXOBJ+1,"_clear_var_obj: p ",p,0,0);
					}
				}
			}
		}
		else if (mc == 92) ib++;
	}
	return 0;
}
#else
/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj(leaf,curleaf,varnam,Obj,scope)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
{
	return cl_gx_clear_var_obj_sub(leaf,curleaf,varnam,Obj,scope,1);
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj2(leaf,curleaf,varnam,Obj,scope)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
{
	return cl_gx_clear_var_obj_sub(leaf,curleaf,varnam,Obj,scope,1);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj_sub(leaf,curleaf,varnam,Obj,scope,right_flg)
Leaf *leaf,*curleaf;
char *varnam;
tdtObjHead *Obj;
int scope;
int right_flg;
{
	int i,k,rc,scopew,cmdid,flg;
	parmList **prmp,*parmp;
	GXObject *pbxObj;
	Leaf *leafw;
	ScrPrCT *scrpt;
	ProcCT *proc;
/*
printf("cl_gx_clear_var_obj: leaf=%08x curleaf=%08x\n",leaf,curleaf);
printf("               varnam=[%s] scope=%08x right_flg=%d node=[%s]\n",
varnam,scope,right_flg,cl_gets_cmd_name(leaf->cmd.cid));
*/
	if (!leaf) return 0;
/*	if (!Obj) return 0;	*/

DEBUGOUTL4(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_sub: varnam=[%s] Obj=0x%08x right_flg=%d cmd=%s",
varnam,Obj,right_flg,cl_gets_cmd_name(leaf->cmd.cid));
	if (!curleaf || (curleaf && leaf!=curleaf)) {
		prmp = leaf->cmd.prmp;
/*
printf("cl_gx_clear_var_obj: prmnum=%d\n",leaf->cmd.prmnum);
*/
		for (i=0;i<leaf->cmd.prmnum;i++) {
			parmp = *prmp++;
/*
printf("cl_gx_clear_var_obj: i=%d parmp->bxobj=%08x\n",i,parmp->bxobj);
*/
			if (pbxObj=parmp->bxobj) {
/*
printf("cl_gx_clear_var_obj: pbxObj->nobj0=%d\n",pbxObj->nobj0);
*/
				if (pbxObj->nobj0) {
					if ((rc=_clear_var_obj(varnam,pbxObj,Obj,scope)) < 0) return rc;
				}
			}
		}
	}

	if (leafw=leaf->leftleaf)  {
		if ((rc=cl_gx_clear_var_obj_sub(leafw,curleaf,varnam,Obj,scope,1)) < 0) return rc;
	}
	if (right_flg) {
		if (leafw=leaf->rightleaf) {
			if ((rc=cl_gx_clear_var_obj_sub(leafw,curleaf,varnam,Obj,scope,1)) < 0) return rc;
		}
	}
	return 0;
}
#if 0
/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var90(pInfoParm,da)
tdtInfoParm *pInfoParm;
char *da;
{
	int vnlen,scope,opt;
	char *varnam,buf[10];
	ProcCT  *proc;
	ScrPrCT *scrct;
	Leaf *topleaf,*procleaf;
	tdtObjHead *pObj;

	if (!(scrct=cl_search_src_ct())) return 0;
	pObj = scrct->Obj;
/*
printf("cl_gx_clear_var90: da=[%s]\n",da);
*/
	varnam = da + D_LEN_SCOPE_MARK;
	vnlen = strlen(varnam);
	if (*(varnam+vnlen-1) == ']') return 0;

	topleaf = scrct->TreeTop;

	memzcpy(buf,da,D_LEN_SCOPE_MARK);
	if (!(opt=cl_get_def_scope(buf))) {
		/* cl_gx_clear_var90: Invalid scope name[%s] */
		ERROROUT2(FORMAT(135),"cl_gx_clear_var90",buf);
		return -1;
	}
	if (opt & D_GX_OPT_SET_GLOBAL)
		return 0;
	else if (opt & D_GX_OPT_SET_PUBLIC)
		scope = D_AUX1_GLOBAL_VAR;
	else if (opt & D_GX_OPT_SET_PRIVATE)
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
	else /*if (opt & D_GX_OPT_SET_LOCAL)*/ {
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
		if (!(proc=cl_search_proc_ct())) return -1;
		topleaf = proc->ProcTop->leftleaf;
		pObj = proc->Obj;
		return cl_gx_clear_var_obj(topleaf,NULL,varnam,pObj,scope);
	}
/*
printf("cl_gx_clear_var90: scope=%08x topleaf=%08x\n",scope,topleaf);
*/
	return cl_gx_clear_var_obj_all(scrct,NULL,varnam,scope);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_define(scrct,proc,varnam,opt)
ScrPrCT *scrct;
ProcCT  *proc;
char *varnam;
int opt;
{
	int scope;
	char c,*p,buf[Var_NM_MAX+2];
	Leaf *topleaf;
	tdtObjHead *pObj;

	if (!scrct) return 0;
	pObj = scrct->Obj;

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define: varnam=[%s] opt=%08x",varnam,opt);

	if ((c=*varnam)!='$' && c!='%' && c!='#') {
		p = buf;
		*buf = '$';
		strnzcpy(buf+1,varnam,sizeof(buf)-2);
	}
	else p = varnam;

	topleaf = scrct->TreeTop;

	opt &= D_GX_OPT_SET_GLOBAL | D_GX_OPT_SET_PUBLIC | D_GX_OPT_SET_PRIVATE | D_GX_OPT_SET_LOCAL;
	if (opt & D_GX_OPT_SET_GLOBAL)
		return 0;
	else if (opt & D_GX_OPT_SET_PUBLIC)
		scope = D_AUX1_GLOBAL_VAR;
	else if (!opt || (opt & D_GX_OPT_SET_PRIVATE))
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR;
	else /*if (opt & D_GX_OPT_SET_LOCAL)*/ {
		scope = D_AUX1_GLOBAL_VAR | D_AUX1_PUBLIC_VAR | D_AUX1_PRIVATE_VAR;
		if (!proc) return -1;
		topleaf = proc->ProcTop->leftleaf;
		pObj = proc->Obj;

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define:LOCAL: scope=%08x topleaf=%08x",scope,topleaf);

		return cl_gx_clear_var_obj(topleaf,NULL,p,pObj,scope);
	}

DEBUGOUTL2(LVL_GXEXOBJ+1,"cl_gx_clear_var_define: scope=%08x topleaf=%08x",scope,topleaf);

	return cl_gx_clear_var_obj_all(scrct,NULL,p,scope);
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_clear_var_obj_all(scrpt,curleaf,varnam,scope)
ScrPrCT *scrpt;
Leaf *curleaf;
char *varnam;
int scope;
{
	Leaf *leaf;
	tdtObjHead *Obj;
	int rc;
	ProcCT *proc;

DEBUGOUTL3(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_all: scrpt=%08x varnam=[%s] scope=%08x",scrpt,varnam,scope);

	if (!scrpt) return -1;
	proc = scrpt->ProCT;
	while (proc) {

DEBUGOUTL1(LVL_GXEXOBJ+1,"cl_gx_clear_var_obj_all: while: ProcNM=[%s]",proc->ProcNM);

		leaf = proc->ProcTop;
		Obj = proc->Obj;
		if ((rc=cl_gx_clear_var_obj(leaf,curleaf,varnam,Obj,scope)) < 0) return rc;
		proc = proc->nextPCT;
	}
	return 0;
}
#endif
/****************************************/
/*										*/
/****************************************/
int cl_gx_iif_optimize(obj,nob,obj0)
short obj[];
tdtInfoParm *obj0[];
int   nob;
{
	tdtInfoParm *pInfoParm;
	int i,mc,kind,ib0,k;
	char *p,c;

DEBUGOUTL1(LVL_GXCOMPL+1,"cl_gx_iif_optimize:Enter nob=%d",nob);
	i = 0;
	while (i < nob) {
		mc = obj[i++];
DEBUGOUTL2(LVL_GXCOMPL+1,"cl_gx_iif_optimize: mc=%d i=%d",mc,i);
		if (mc == 91) {
			ib0 = obj[i];
			pInfoParm = obj0[ib0];
			c = pInfoParm->pi_id;
			if (c == 'S') {
				pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				c = pInfoParm->pi_id;
			}
			if (c=='F') {
				i = cl_gx_iif_optimize_chk_sub(obj,nob,obj0,i,pInfoParm);
				if (i < 0) break;
			}
			else i++;
		}
		else if (mc==92 || mc==93)
			i++;
		else if (mc==98 || mc==5) {
			i = ECL_OPTIMIZE_ERROR;
			break;
		}
		else if (mc==59) {
			kind = obj[i++];
			if (!kind) i += 2; 
			else i += 4;
		}
		else if (mc == 99) {
			break;
		}
	}
/*
for (k=0;k<nob;k++) {
printf("cl_gx_iif_optimize: obj[%2d]=%d\n",k,obj[k]);
}
*/
DEBUGOUTL1(LVL_GXCOMPL+1,"cl_gx_iif_optimize:Exit i=%d",i);
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_gx_iif_optimize_sub(obj,nob,obj0,i0,nam)
short obj[];
tdtInfoParm *obj0[];
int   nob,i0;
char *nam;
{
	static char *_fn_="cl_gx_iif_optimize_sub";
	tdtInfoParm *pInfoParm;
	int ret,i,mc,disp,kind,i1,i2,i3,i_true,i_false,i_end,i_goto,ib0,n,kind1,nopt;
	char *p,c;

DEBUGOUTL4(LVL_GXCOMPL+1,"%s:Enter nob=%d i0=%d nam=[%s]",_fn_,nob,i0,nam);
	ret = kind = disp = 0;
#if 1	/* 2022.6.8 */
	kind = cl_get_optimize_kind(nam);
	if (kind >= 6) return cl_gx_iif_optimize_sub2(obj,nob,obj0,i0,kind);
#else
	nopt = cl_get_option(26,0);
	if (!(nopt & D_NOPTIMIZE_IIF) && !stricmp(nam,"IIF")) kind = 1;
	else if (!(nopt & D_NOPTIMIZE_NVAL) && !stricmp(nam,"NVAL")) kind = 2;
	else if (!(nopt & D_NOPTIMIZE_NULLIF) && !stricmp(nam,"NULLIF")) kind = 2;
	else if (!(nopt & D_NOPTIMIZE_NSVAL) && !stricmp(nam,"NSVAL")) kind = 3;
	else if (!(nopt & D_NOPTIMIZE_NDEF) && !stricmp(nam,"NDEF")) kind = 4;	/* p[^3̂Ƃ́Akind=5 ɂȂ */
#if 1	/* 2022.6.5 */
	else {
		if (!(nopt & D_NOPTIMIZE_AND) && !stricmp(nam,"AND")) kind = 6;
		else if (!(nopt & D_NOPTIMIZE_OR) && !stricmp(nam,"OR")) kind = 7;
		if (kind) return cl_gx_iif_optimize_sub2(obj,nob,obj0,i0,kind);
	}
#endif
#endif
	i = i0;
	i1 = i;
	i3 = i + 4;
	i++;
	i++;
DEBUGOUTL5(LVL_GXCOMPL+1,"%s: i1=%d i3=%d i=%d kind=%d",_fn_,i1,i3,i,kind);
	if (kind) disp = 1;
	i_false = i_goto = 0;
	while (i < nob) {
		mc = obj[i++];
DEBUGOUTL4(LVL_GXCOMPL+1,"%s: mc=%d i=%d disp=%d",_fn_,mc,i,disp);
		if (mc == 91) {
			ib0 = obj[i];
			pInfoParm = obj0[ib0];
			c = pInfoParm->pi_id;
			if (c == 'S') {
				pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				c = pInfoParm->pi_id;
			}
			if (c=='F') {
				i = cl_gx_iif_optimize_chk_sub(obj,nob,obj0,i,pInfoParm);
				if (i < 0) break;
			}
			else i++;
		}
		else if (mc==92 || mc==93)
			i++;
		else if (mc == 98) {
			i--;
			if (disp == 1) {
				i2 = i;
				disp = 2;
DEBUGOUTL3(LVL_GXCOMPL+1,"%s: i2=%d disp=%d",_fn_,i2,disp);
			}
			else if (disp == 2) {
				if (kind==2 || kind==3) {
					i = ECL_TOO_PARAMETER;
					break;
				}
				disp = 3;
				i_goto = i;
				i_false = i + 2;
DEBUGOUTL4(LVL_GXCOMPL+1,"%s: disp=%d i_false=%d i_goto=%d",_fn_,disp,i_false,i_goto);
			}
			else if (disp == 3) {
				i = ECL_TOO_PARAMETER;
				break;
			}
			else if (!disp) ;
			else {
				i = ECL_OPTIMIZE_ERROR;
				break;
			}
			i += 2;
		}
	/*	else if (mc==1 || mc==6 || mc==7 || mc==20)
			break;	*/
		else if (mc==5) {
			if (disp > 0) {
DEBUGOUTL5(LVL_GXCOMPL+1,"%s: disp=%d i1=%d i3=%d i2=%d",_fn_,disp,i1,i3,i2);
				if (disp==1 || (disp==2 && kind==1)) break;
				if (disp==3 && kind==4) {
					n = akxs_ins_shseq_array(obj,i1,i_goto,obj,i_false,i-i_false-1,0);
					i1 += n;
					i2 += n;
					i3 += n;
					i_false += n;
					i_goto += n;
					kind = 5;
				}
				memcpy(obj+i1,obj+i3, (i2-i3)*sizeof(short));
				i_end = i;
				if (!i_false) i_false = i_end;
				i3 = i1 + i2 - i3;
DEBUGOUTL5(LVL_GXCOMPL+1,"%s: i3=%d i_false=%d i_end=%d i_goto=%d",_fn_,i3,i_false,i_end,i_goto);
				obj[i3]   = 59;
				obj[i3+1] = kind;
				obj[i3+2] = i_false - (i3+2);
				obj[i3+3] = i_end   - (i3+3);
				obj[i3+4] = 0;
				obj[i3+5] = 0;
				obj[i-1] = 0;
				if (i_goto > 0) {
					obj[i_goto++] = 93;
					obj[i_goto] = i_end - i_goto;
				}
			}
			break;
		}
		else if (mc==59) {
			kind1 = obj[i++];
			if (!kind1) i += 2; 
			else if (kind1 < 6) i += 4;
			else i += 2;
		}
		else if (mc == 99) {
			break;
		}
	}
DEBUGOUTL2(LVL_GXCOMPL+1,"%s:Exit i=%d",_fn_,i);
	return i;
}

/****************************************/
/*	AND,OR p							*/
/*		kind = 6 : AND					*/
/*		kind = 7 : OR					*/
/****************************************/
int cl_gx_iif_optimize_sub2(obj,nob,obj0,i0,kind)
short obj[];
tdtInfoParm *obj0[];
int   nob,i0,kind;
{
	static char *_fn_="cl_gx_iif_optimize_sub2";
	tdtInfoParm *pInfoParm;
	int ret,i,mc,disp,i1,i2,i3,k,ib0,n,offset;
	int stack[256];
	char *p,c;

DEBUGOUTL4(LVL_GXCOMPL+1,"%s:Enter nob=%d i0=%d kind=%d",_fn_,nob,i0,kind);
	ret = 0;
	i = i0;
	i1 = i;
	i++;
	i++;
	n = 0;
	offset = 5;
	while (i < nob) {
		mc = obj[i++];
DEBUGOUTL4(LVL_GXCOMPL+1,"%s: mc=%d i=%d disp=%d",_fn_,mc,i,disp);
		if (mc == 91) {
			ib0 = obj[i];
			pInfoParm = obj0[ib0];
			c = pInfoParm->pi_id;
			if (c == 'S') {
				pInfoParm = (tdtInfoParm *)pInfoParm->pi_pos;
				c = pInfoParm->pi_id;
			}
			if (c=='F') {
				i = cl_gx_iif_optimize_chk_sub(obj,nob,obj0,i,pInfoParm);
				if (i < 0) break;
			}
			else i++;
		}
		else if (mc==92 || mc==93)
			i++;
		else if (mc == 98) {
			stack[n++] = i - 1;
			i += 2;
DEBUGOUTL3(LVL_GXCOMPL+1,"%s: n=%d i=%d",_fn_,n,i);
		}
		else if (mc==5) {
			i2 = i - 1;
			memcpy(obj+i1,obj+i1+offset,(i2-(i1+offset))*sizeof(short));
			for (k=0;k<n;k++) {
				i3 = stack[k] - offset;
DEBUGOUTL3(LVL_GXCOMPL+1,"%s: k=%d i3=%d",_fn_,k,i3);
				obj[i3]   = 59;
				obj[i3+1] = kind;
				obj[i3+2] = i2 - (i3+1);
			}
			i3 = i2 - offset;
			obj[i3]   = 59;
			obj[i3+1] = kind;
			obj[i3+2] = i2 - (i3+1);
			obj[i3+3] = 59;
			obj[i3+4] = kind;
			obj[i3+5] = -99;
			break;
		}
		else if (mc==59) {
			kind = obj[i++];
			if (!kind) i += 2; 
			else if (kind < 6) i += 4;
			else i += 2;
		}
		else if (mc == 99) {
			break;
		}
	}
DEBUGOUTL2(LVL_GXCOMPL+1,"%s:Exit i=%d",_fn_,i);
	return i;
}

/****************************************/
/*										*/
/* 2019.9.28							*/
/****************************************/
int cl_gx_iif_optimize_chk_sub(obj,nob,obj0,i,pInfoParm)
short obj[];
tdtInfoParm *obj0[],*pInfoParm;
int   nob,i;
{
	tdtInfoParm tInfo,*pInfo;
	int ib0,i_s;
	char *p;

	p = pInfoParm->pi_data;

DEBUGOUTL3(LVL_GXCOMPL+1,"cl_gx_iif_optimize_chk_sub:Enter nob=%d i=%d nam=[%s]",nob,i,p);

	i_s = 0;
	if (!memicmp(p,"FF",pInfoParm->pi_dlen)) {
		/* FF̂Ƃ́AʒuɂFFȊO̊֐邱Ƃɂ */
		i_s = i;
		ib0 = obj[i];
		tInfo = *obj0[ib0];
		i -= 4;
		pInfoParm->pi_data = p = "XX";
	}
	else {	/* (CDEC(5,2))%1CDEC͊֐ɂȂ('F','(',ƂȂ)̂ŁAcl_gx_iif_optimize_sub()ĂԂA
			   (CBIN)%1͊֐ɂȂȂ('F'̎'('Ȃ)̂ŁÂ܂܎ǂނ悤ɂ */
		if (obj[i+1] == 91) {
			ib0 = obj[i+2];
			pInfo = obj0[ib0];
			if (pInfo->pi_id==' ' && pInfo->pi_pos==1 && pInfo->pi_aux[1]==D_AUX1_FUNC_ARRY) ;
			else return i+1;
		}
	}
	i = cl_gx_iif_optimize_sub(obj,nob,obj0,i-1,p);
	if (i_s) {
		*obj0[ib0] = tInfo;
	}
	return i;
}

/****************************************/
/*										*/
/****************************************/
int cl_get_optimize_kind(p)
char *p;
{
	static int nopta[]={
		 D_NOPTIMIZE_IIF		/* 0x01 IIF()		*/
		,D_NOPTIMIZE_NVAL		/* 0x02 NVAL()		*/
		,D_NOPTIMIZE_NULLIF		/* 0x04 NULLIF()	*/
		,D_NOPTIMIZE_NSVAL		/* 0x08 NSVAL()		*/
		,D_NOPTIMIZE_NDEF		/* 0x10 NDEF()		*/
		,D_NOPTIMIZE_AND		/* 0x20 AND()		*/
		,D_NOPTIMIZE_OR};		/* 0x40 OR()		*/
	static int optimize_kind[]={1,2,2,3,4,6,7,0};
	static char *optimize_func[]={"IIF","NVAL","NULLIF","NSVAL","NDEF","AND","OR",NULL};
	int i,kind,opt26,nopt;
	char *pp,**func;

	opt26 = cl_get_option(26,0);
	nopt = 1;
#if 1
	kind = 0;
	i = akxs_seqr_str(optimize_func,-1,p,1);
/*
printf("cl_get_optimize_kind: i=%d\n",i);
*/
	if (i > 0) {
		i--;
		if (!(opt26 & nopta[i])) kind = optimize_kind[i];
	}
#else
	func = optimize_func;
	kind = i = 0;
	while (pp=*func) {
		if (!(opt26 & nopt) && !stricmp(p,pp)) {
			kind = optimize_kind[i];
			break;
		}
		i++;
		func++;
		nopt += nopt;
	}
#endif
/*
printf("cl_get_optimize_kind: p=[%s] pp=[%s] kind=%d\n",p,nval1(pp),kind);
*/
	return kind;
}
